/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.algorithm;

import java.util.Iterator;

class CircularIterator<T> {
    private Iterator<T> iterator = null;
    private final Iterable<T> iterable;
    private T startElem = null;
    private T nextElem = null;
    private T firstElem = null;

    CircularIterator(T first, Iterator<T> iter, Iterable<T> iterable) {
        this.firstElem = first;
        this.iterable = iterable;
        this.iterator = !iter.hasNext() ? this.iterable.iterator() : iter;
        this.startElem = this.iterator.next();
        this.nextElem = this.startElem;
    }

    boolean hasNext() {
        if (this.nextElem != null || this.firstElem != null) {
            return true;
        }
        if (this.iterator.hasNext()) {
            T next = this.iterator.next();
            if (this.startElem.equals(next)) {
                return false;
            }
            this.nextElem = next;
            return true;
        }
        this.iterator = this.iterable.iterator();
        this.nextElem = this.iterator.next();
        return !this.startElem.equals(this.nextElem);
    }

    T next() {
        T retVal;
        if (this.firstElem != null) {
            retVal = this.firstElem;
            this.firstElem = null;
        } else if (this.nextElem != null) {
            retVal = this.nextElem;
            this.nextElem = null;
        } else {
            retVal = this.iterator.next();
        }
        return retVal;
    }
}

