/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class LeafQueueTemplateInfo {
    private ArrayList<ConfItem> property = new ArrayList();

    public LeafQueueTemplateInfo() {
    }

    public LeafQueueTemplateInfo(Configuration conf, String queuePath) {
        String configPrefix = CapacitySchedulerConfiguration.getQueuePrefix(queuePath) + "leaf-queue-template" + ".";
        conf.forEach(entry -> {
            if (((String)entry.getKey()).startsWith(configPrefix)) {
                String name = (String)entry.getKey();
                int start = name.lastIndexOf("leaf-queue-template.");
                this.add(new ConfItem(name.substring(start), (String)entry.getValue()));
            }
        });
    }

    public void add(ConfItem confItem) {
        this.property.add(confItem);
    }

    public ArrayList<ConfItem> getItems() {
        return this.property;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class ConfItem {
        private String name;
        private String value;

        public ConfItem() {
        }

        public ConfItem(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getKey() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

