/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.ReservationACL;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;

public class ReservationsACLsManager {
    private boolean isReservationACLsEnable;
    private Map<String, Map<ReservationACL, AccessControlList>> reservationAcls;

    public ReservationsACLsManager(ResourceScheduler scheduler, Configuration conf) throws YarnException {
        block3: {
            block2: {
                this.reservationAcls = new HashMap<String, Map<ReservationACL, AccessControlList>>();
                boolean bl = this.isReservationACLsEnable = conf.getBoolean("yarn.acl.reservation-enable", false) && conf.getBoolean("yarn.acl.enable", false);
                if (!(scheduler instanceof CapacityScheduler)) break block2;
                CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration(conf);
                for (String planQueue : scheduler.getPlanQueues()) {
                    CSQueue queue = ((CapacityScheduler)scheduler).getQueue(planQueue);
                    this.reservationAcls.put(planQueue, csConf.getReservationAcls(queue.getQueuePath()));
                }
                break block3;
            }
            if (!(scheduler instanceof FairScheduler)) break block3;
            AllocationConfiguration aConf = ((FairScheduler)scheduler).getAllocationConfiguration();
            for (String planQueue : scheduler.getPlanQueues()) {
                this.reservationAcls.put(planQueue, aConf.getReservationAcls(planQueue));
            }
        }
    }

    public boolean checkAccess(UserGroupInformation callerUGI, ReservationACL acl, String queueName) {
        if (!this.isReservationACLsEnable) {
            return true;
        }
        if (this.reservationAcls.containsKey(queueName)) {
            Map<ReservationACL, AccessControlList> acls = this.reservationAcls.get(queueName);
            if (acls.containsKey(acl)) {
                return acls.get(acl).isUserAllowed(callerUGI);
            }
            return true;
        }
        return false;
    }
}

