/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.yarn.conf.ConfigurationProvider;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.server.resourcemanager.AdminService;
import org.apache.hadoop.yarn.server.resourcemanager.EmbeddedElector;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.RMApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsPublisher;
import org.apache.hadoop.yarn.server.resourcemanager.timelineservice.RMTimelineCollectorManager;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RMServiceContext {
    private Dispatcher rmDispatcher;
    private boolean isHAEnabled;
    private HAServiceProtocol.HAServiceState haServiceState = HAServiceProtocol.HAServiceState.INITIALIZING;
    private AdminService adminService;
    private ConfigurationProvider configurationProvider;
    private Configuration yarnConfiguration;
    private RMApplicationHistoryWriter rmApplicationHistoryWriter;
    private SystemMetricsPublisher systemMetricsPublisher;
    private EmbeddedElector elector;
    private final Object haServiceStateLock = new Object();
    private ResourceManager resourceManager;
    private RMTimelineCollectorManager timelineCollectorManager;

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void setResourceManager(ResourceManager rm) {
        this.resourceManager = rm;
    }

    public ConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    public void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
    }

    public Dispatcher getDispatcher() {
        return this.rmDispatcher;
    }

    void setDispatcher(Dispatcher dispatcher) {
        this.rmDispatcher = dispatcher;
    }

    public EmbeddedElector getLeaderElectorService() {
        return this.elector;
    }

    public void setLeaderElectorService(EmbeddedElector embeddedElector) {
        this.elector = embeddedElector;
    }

    public AdminService getRMAdminService() {
        return this.adminService;
    }

    void setRMAdminService(AdminService service) {
        this.adminService = service;
    }

    void setHAEnabled(boolean rmHAEnabled) {
        this.isHAEnabled = rmHAEnabled;
    }

    public boolean isHAEnabled() {
        return this.isHAEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HAServiceProtocol.HAServiceState getHAServiceState() {
        Object object = this.haServiceStateLock;
        synchronized (object) {
            return this.haServiceState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setHAServiceState(HAServiceProtocol.HAServiceState serviceState) {
        Object object = this.haServiceStateLock;
        synchronized (object) {
            this.haServiceState = serviceState;
        }
    }

    public RMApplicationHistoryWriter getRMApplicationHistoryWriter() {
        return this.rmApplicationHistoryWriter;
    }

    public void setRMApplicationHistoryWriter(RMApplicationHistoryWriter applicationHistoryWriter) {
        this.rmApplicationHistoryWriter = applicationHistoryWriter;
    }

    public void setSystemMetricsPublisher(SystemMetricsPublisher metricsPublisher) {
        this.systemMetricsPublisher = metricsPublisher;
    }

    public SystemMetricsPublisher getSystemMetricsPublisher() {
        return this.systemMetricsPublisher;
    }

    public Configuration getYarnConfiguration() {
        return this.yarnConfiguration;
    }

    public void setYarnConfiguration(Configuration yarnConfiguration) {
        this.yarnConfiguration = yarnConfiguration;
    }

    public RMTimelineCollectorManager getRMTimelineCollectorManager() {
        return this.timelineCollectorManager;
    }

    public void setRMTimelineCollectorManager(RMTimelineCollectorManager collectorManager) {
        this.timelineCollectorManager = collectorManager;
    }

    public String getHAZookeeperConnectionState() {
        if (this.elector == null) {
            return "Could not find leader elector. Verify both HA and automatic failover are enabled.";
        }
        return this.elector.getZookeeperConnectionState();
    }
}

