/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies;

import java.util.Collection;
import java.util.Comparator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceType;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceWeights;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.ComputeFairShares;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DominantResourceFairnessPolicy
extends SchedulingPolicy {
    public static final String NAME = "DRF";
    private static final DominantResourceFairnessComparator COMPARATOR = new DominantResourceFairnessComparator();
    private static final DominantResourceCalculator CALCULATOR = new DominantResourceCalculator();

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte getApplicableDepth() {
        return 7;
    }

    @Override
    public Comparator<Schedulable> getComparator() {
        return COMPARATOR;
    }

    @Override
    public ResourceCalculator getResourceCalculator() {
        return CALCULATOR;
    }

    @Override
    public void computeShares(Collection<? extends Schedulable> schedulables, Resource totalResources) {
        for (ResourceType type : ResourceType.values()) {
            ComputeFairShares.computeShares(schedulables, totalResources, type);
        }
    }

    @Override
    public void computeSteadyShares(Collection<? extends FSQueue> queues, Resource totalResources) {
        for (ResourceType type : ResourceType.values()) {
            ComputeFairShares.computeSteadyShares(queues, totalResources, type);
        }
    }

    @Override
    public boolean checkIfUsageOverFairShare(Resource usage, Resource fairShare) {
        return !Resources.fitsIn((Resource)usage, (Resource)fairShare);
    }

    @Override
    public boolean checkIfAMResourceUsageOverLimit(Resource usage, Resource maxAMResource) {
        return !Resources.fitsIn((Resource)usage, (Resource)maxAMResource);
    }

    @Override
    public Resource getHeadroom(Resource queueFairShare, Resource queueUsage, Resource maxAvailable) {
        long queueAvailableMemory = Math.max(queueFairShare.getMemorySize() - queueUsage.getMemorySize(), 0L);
        int queueAvailableCPU = Math.max(queueFairShare.getVirtualCores() - queueUsage.getVirtualCores(), 0);
        Resource headroom = Resources.createResource((long)Math.min(maxAvailable.getMemorySize(), queueAvailableMemory), (int)Math.min(maxAvailable.getVirtualCores(), queueAvailableCPU));
        return headroom;
    }

    @Override
    public void initialize(Resource clusterCapacity) {
        COMPARATOR.setClusterCapacity(clusterCapacity);
    }

    public static class DominantResourceFairnessComparator
    implements Comparator<Schedulable> {
        private static final int NUM_RESOURCES = ResourceType.values().length;
        private Resource clusterCapacity;

        public void setClusterCapacity(Resource clusterCapacity) {
            this.clusterCapacity = clusterCapacity;
        }

        @Override
        public int compare(Schedulable s1, Schedulable s2) {
            ResourceWeights sharesOfCluster1 = new ResourceWeights();
            ResourceWeights sharesOfCluster2 = new ResourceWeights();
            ResourceWeights sharesOfMinShare1 = new ResourceWeights();
            ResourceWeights sharesOfMinShare2 = new ResourceWeights();
            ResourceType[] resourceOrder1 = new ResourceType[NUM_RESOURCES];
            ResourceType[] resourceOrder2 = new ResourceType[NUM_RESOURCES];
            this.calculateShares(s1.getResourceUsage(), this.clusterCapacity, sharesOfCluster1, resourceOrder1, s1.getWeights());
            this.calculateShares(s1.getResourceUsage(), s1.getMinShare(), sharesOfMinShare1, null, ResourceWeights.NEUTRAL);
            this.calculateShares(s2.getResourceUsage(), this.clusterCapacity, sharesOfCluster2, resourceOrder2, s2.getWeights());
            this.calculateShares(s2.getResourceUsage(), s2.getMinShare(), sharesOfMinShare2, null, ResourceWeights.NEUTRAL);
            boolean s1Needy = sharesOfMinShare1.getWeight(resourceOrder1[0]) < 1.0f;
            boolean s2Needy = sharesOfMinShare2.getWeight(resourceOrder2[0]) < 1.0f;
            int res = 0;
            res = !s2Needy && !s1Needy ? this.compareShares(sharesOfCluster1, sharesOfCluster2, resourceOrder1, resourceOrder2) : (s1Needy && !s2Needy ? -1 : (s2Needy && !s1Needy ? 1 : this.compareShares(sharesOfMinShare1, sharesOfMinShare2, resourceOrder1, resourceOrder2)));
            if (res == 0) {
                res = (int)(s1.getStartTime() - s2.getStartTime());
            }
            return res;
        }

        void calculateShares(Resource resource, Resource pool, ResourceWeights shares, ResourceType[] resourceOrder, ResourceWeights weights) {
            shares.setWeight(ResourceType.MEMORY, (float)resource.getMemorySize() / ((float)pool.getMemorySize() * weights.getWeight(ResourceType.MEMORY)));
            shares.setWeight(ResourceType.CPU, (float)resource.getVirtualCores() / ((float)pool.getVirtualCores() * weights.getWeight(ResourceType.CPU)));
            if (resourceOrder != null) {
                if (shares.getWeight(ResourceType.MEMORY) > shares.getWeight(ResourceType.CPU)) {
                    resourceOrder[0] = ResourceType.MEMORY;
                    resourceOrder[1] = ResourceType.CPU;
                } else {
                    resourceOrder[0] = ResourceType.CPU;
                    resourceOrder[1] = ResourceType.MEMORY;
                }
            }
        }

        private int compareShares(ResourceWeights shares1, ResourceWeights shares2, ResourceType[] resourceOrder1, ResourceType[] resourceOrder2) {
            for (int i = 0; i < resourceOrder1.length; ++i) {
                int ret = (int)Math.signum(shares1.getWeight(resourceOrder1[i]) - shares2.getWeight(resourceOrder2[i]));
                if (ret == 0) continue;
                return ret;
            }
            return 0;
        }
    }
}

