/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityHeadroomProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.allocator.AbstractContainerAllocator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.allocator.ContainerAllocator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FiCaSchedulerApp
extends SchedulerApplicationAttempt {
    private static final Log LOG = LogFactory.getLog(FiCaSchedulerApp.class);
    private final Set<ContainerId> containersToPreempt = new HashSet<ContainerId>();
    private CapacityHeadroomProvider headroomProvider;
    private ResourceCalculator rc = new DefaultResourceCalculator();
    private ResourceScheduler scheduler;
    private AbstractContainerAllocator containerAllocator;
    private String appSkipNodeDiagnostics;
    private CapacitySchedulerContext capacitySchedulerContext;

    public FiCaSchedulerApp(ApplicationAttemptId applicationAttemptId, String user, Queue queue, ActiveUsersManager activeUsersManager, RMContext rmContext) {
        this(applicationAttemptId, user, queue, activeUsersManager, rmContext, Priority.newInstance((int)0), false);
    }

    public FiCaSchedulerApp(ApplicationAttemptId applicationAttemptId, String user, Queue queue, ActiveUsersManager activeUsersManager, RMContext rmContext, Priority appPriority, boolean isAttemptRecovering) {
        super(applicationAttemptId, user, queue, activeUsersManager, rmContext);
        String partition;
        Resource amResource;
        RMApp rmApp = (RMApp)rmContext.getRMApps().get(this.getApplicationId());
        if (rmApp == null || rmApp.getAMResourceRequest() == null) {
            amResource = rmContext.getScheduler().getMinimumResourceCapability();
            partition = "";
        } else {
            amResource = rmApp.getAMResourceRequest().getCapability();
            partition = rmApp.getAMResourceRequest().getNodeLabelExpression() == null ? "" : rmApp.getAMResourceRequest().getNodeLabelExpression();
        }
        this.setAppAMNodePartitionName(partition);
        this.setAMResource(partition, amResource);
        this.setPriority(appPriority);
        this.setAttemptRecovering(isAttemptRecovering);
        this.scheduler = rmContext.getScheduler();
        if (this.scheduler.getResourceCalculator() != null) {
            this.rc = this.scheduler.getResourceCalculator();
        }
        this.containerAllocator = new ContainerAllocator(this, this.rc, rmContext);
        if (this.scheduler instanceof CapacityScheduler) {
            this.capacitySchedulerContext = (CapacitySchedulerContext)((Object)this.scheduler);
        }
    }

    public synchronized boolean containerCompleted(RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event, String partition) {
        ContainerId containerId = rmContainer.getContainerId();
        if (null == this.liveContainers.remove(containerId)) {
            return false;
        }
        this.newlyAllocatedContainers.remove(rmContainer);
        rmContainer.handle((Event)new RMContainerFinishedEvent(containerId, containerStatus, event));
        this.containersToPreempt.remove(containerId);
        RMAuditLogger.logSuccess(this.getUser(), "AM Released Container", "SchedulerApp", this.getApplicationId(), containerId);
        Resource containerResource = rmContainer.getContainer().getResource();
        this.queue.getMetrics().releaseResources(partition, this.getUser(), 1, containerResource);
        this.attemptResourceUsage.decUsed(partition, containerResource);
        this.lastMemoryAggregateAllocationUpdateTime = -1L;
        return true;
    }

    public synchronized RMContainer allocate(NodeType type, FiCaSchedulerNode node, Priority priority, ResourceRequest request, Container container) {
        if (this.isStopped) {
            return null;
        }
        if (this.getTotalRequiredResources(priority) <= 0) {
            return null;
        }
        RMContainerImpl rmContainer = new RMContainerImpl(container, this.getApplicationAttemptId(), node.getNodeID(), this.appSchedulingInfo.getUser(), this.rmContext, request.getNodeLabelExpression());
        rmContainer.setQueueName(this.getQueueName());
        this.updateAMContainerDiagnostics(SchedulerApplicationAttempt.AMState.ASSIGNED, null);
        this.newlyAllocatedContainers.add(rmContainer);
        ContainerId containerId = container.getId();
        this.liveContainers.put(containerId, rmContainer);
        List<ResourceRequest> resourceRequestList = this.appSchedulingInfo.allocate(type, node, priority, request, container);
        this.attemptResourceUsage.incUsed(node.getPartition(), container.getResource());
        rmContainer.setResourceRequests(resourceRequestList);
        rmContainer.handle((Event)new RMContainerEvent(containerId, RMContainerEventType.START));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("allocate: applicationAttemptId=" + containerId.getApplicationAttemptId() + " container=" + containerId + " host=" + container.getNodeId().getHost() + " type=" + (Object)((Object)type)));
        }
        RMAuditLogger.logSuccess(this.getUser(), "AM Allocated Container", "SchedulerApp", this.getApplicationId(), containerId);
        return rmContainer;
    }

    public synchronized boolean unreserve(Priority priority, FiCaSchedulerNode node, RMContainer rmContainer) {
        rmContainer.cancelIncreaseReservation();
        if (this.internalUnreserve(node, priority)) {
            node.unreserveResource(this);
            this.queue.getMetrics().unreserveResource(node.getPartition(), this.getUser(), rmContainer.getReservedResource());
            this.queue.decReservedResource(node.getPartition(), rmContainer.getReservedResource());
            return true;
        }
        return false;
    }

    private boolean internalUnreserve(FiCaSchedulerNode node, Priority priority) {
        RMContainer reservedContainer;
        Map reservedContainers = (Map)this.reservedContainers.get(priority);
        if (reservedContainers != null && (reservedContainer = (RMContainer)reservedContainers.remove(node.getNodeID())) != null && reservedContainer.getContainer() != null && reservedContainer.getContainer().getResource() != null) {
            if (reservedContainers.isEmpty()) {
                this.reservedContainers.remove(priority);
            }
            this.resetReReservations(priority);
            Resource resource = reservedContainer.getReservedResource();
            this.attemptResourceUsage.decReserved(node.getPartition(), resource);
            LOG.info((Object)("Application " + this.getApplicationId() + " unreserved " + " on node " + node + ", currently has " + reservedContainers.size() + " at priority " + priority + "; currentReservation " + this.attemptResourceUsage.getReserved() + " on node-label=" + node.getPartition()));
            return true;
        }
        return false;
    }

    public synchronized float getLocalityWaitFactor(Priority priority, int clusterNodes) {
        int requiredResources = Math.max(this.getResourceRequests(priority).size() - 1, 0);
        return Math.min((float)requiredResources / (float)clusterNodes, 1.0f);
    }

    public synchronized Resource getTotalPendingRequests() {
        Resource ret = Resource.newInstance((int)0, (int)0);
        for (ResourceRequest rr : this.appSchedulingInfo.getAllResourceRequests()) {
            if (!ResourceRequest.isAnyLocation((String)rr.getResourceName())) continue;
            Resources.addTo((Resource)ret, (Resource)Resources.multiply((Resource)rr.getCapability(), (double)rr.getNumContainers()));
        }
        return ret;
    }

    public synchronized Map<String, Resource> getTotalPendingRequestsPerPartition() {
        HashMap<String, Resource> ret = new HashMap<String, Resource>();
        Resource res = null;
        for (Priority priority : this.appSchedulingInfo.getPriorities()) {
            ResourceRequest rr = this.appSchedulingInfo.getResourceRequest(priority, "*");
            res = (Resource)ret.get(rr.getNodeLabelExpression());
            if (res == null) {
                res = Resources.createResource((int)0, (int)0);
                ret.put(rr.getNodeLabelExpression(), res);
            }
            Resources.addTo((Resource)res, (Resource)Resources.multiply((Resource)rr.getCapability(), (double)rr.getNumContainers()));
        }
        return ret;
    }

    public synchronized void markContainerForPreemption(ContainerId cont) {
        if (this.liveContainers.containsKey(cont)) {
            this.containersToPreempt.add(cont);
        }
    }

    public synchronized Allocation getAllocation(ResourceCalculator rc, Resource clusterResource, Resource minimumAllocation) {
        Set<ContainerId> currentContPreemption = Collections.unmodifiableSet(new HashSet<ContainerId>(this.containersToPreempt));
        this.containersToPreempt.clear();
        Resource tot = Resource.newInstance((int)0, (int)0);
        for (ContainerId c : currentContPreemption) {
            Resources.addTo((Resource)tot, (Resource)((RMContainer)this.liveContainers.get(c)).getContainer().getResource());
        }
        int numCont = (int)Math.ceil(Resources.divide((ResourceCalculator)rc, (Resource)clusterResource, (Resource)tot, (Resource)minimumAllocation));
        ResourceRequest rr = ResourceRequest.newInstance((Priority)Priority.UNDEFINED, (String)"*", (Resource)minimumAllocation, (int)numCont);
        List<Container> newlyAllocatedContainers = this.pullNewlyAllocatedContainers();
        List<Container> newlyIncreasedContainers = this.pullNewlyIncreasedContainers();
        List<Container> newlyDecreasedContainers = this.pullNewlyDecreasedContainers();
        List<NMToken> updatedNMTokens = this.pullUpdatedNMTokens();
        Resource headroom = this.getHeadroom();
        this.setApplicationHeadroomForMetrics(headroom);
        return new Allocation(newlyAllocatedContainers, headroom, null, currentContPreemption, Collections.singletonList(rr), updatedNMTokens, newlyIncreasedContainers, newlyDecreasedContainers);
    }

    public synchronized NodeId getNodeIdToUnreserve(Priority priority, Resource resourceNeedUnreserve, ResourceCalculator rc, Resource clusterResource) {
        Map reservedContainers = (Map)this.reservedContainers.get(priority);
        if (reservedContainers != null && !reservedContainers.isEmpty()) {
            for (Map.Entry entry : reservedContainers.entrySet()) {
                Resource reservedResource;
                NodeId nodeId = (NodeId)entry.getKey();
                RMContainer reservedContainer = (RMContainer)entry.getValue();
                if (reservedContainer.hasIncreaseReservation() || !Resources.fitsIn((ResourceCalculator)rc, (Resource)clusterResource, (Resource)resourceNeedUnreserve, (Resource)(reservedResource = reservedContainer.getReservedResource()))) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("unreserving node with reservation size: " + reservedResource + " in order to allocate container with size: " + resourceNeedUnreserve));
                }
                return nodeId;
            }
        }
        return null;
    }

    public synchronized void setHeadroomProvider(CapacityHeadroomProvider headroomProvider) {
        this.headroomProvider = headroomProvider;
    }

    public synchronized CapacityHeadroomProvider getHeadroomProvider() {
        return this.headroomProvider;
    }

    @Override
    public synchronized Resource getHeadroom() {
        if (this.headroomProvider != null) {
            return this.headroomProvider.getHeadroom();
        }
        return super.getHeadroom();
    }

    @Override
    public synchronized void transferStateFromPreviousAttempt(SchedulerApplicationAttempt appAttempt) {
        super.transferStateFromPreviousAttempt(appAttempt);
        this.headroomProvider = ((FiCaSchedulerApp)appAttempt).getHeadroomProvider();
    }

    public boolean reserveIncreasedContainer(Priority priority, FiCaSchedulerNode node, RMContainer rmContainer, Resource reservedResource) {
        if (super.reserveIncreasedContainer(node, priority, rmContainer, reservedResource)) {
            this.queue.getMetrics().reserveResource(node.getPartition(), this.getUser(), reservedResource);
            node.reserveResource(this, priority, rmContainer);
            return true;
        }
        return false;
    }

    public void reserve(Priority priority, FiCaSchedulerNode node, RMContainer rmContainer, Container container) {
        if (rmContainer == null) {
            this.queue.getMetrics().reserveResource(node.getPartition(), this.getUser(), container.getResource());
        }
        rmContainer = super.reserve(node, priority, rmContainer, container);
        node.reserveResource(this, priority, rmContainer);
    }

    @VisibleForTesting
    public RMContainer findNodeToUnreserve(Resource clusterResource, FiCaSchedulerNode node, Priority priority, Resource minimumUnreservedResource) {
        NodeId idToUnreserve = this.getNodeIdToUnreserve(priority, minimumUnreservedResource, this.rc, clusterResource);
        if (idToUnreserve == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"checked to see if could unreserve for app but nothing reserved that matches for this app");
            }
            return null;
        }
        FiCaSchedulerNode nodeToUnreserve = ((CapacityScheduler)this.scheduler).getNode(idToUnreserve);
        if (nodeToUnreserve == null) {
            LOG.error((Object)("node to unreserve doesn't exist, nodeid: " + idToUnreserve));
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("unreserving for app: " + this.getApplicationId() + " on nodeId: " + idToUnreserve + " in order to replace reserved application and place it on node: " + node.getNodeID() + " needing: " + minimumUnreservedResource));
        }
        Resources.addTo((Resource)this.getHeadroom(), (Resource)nodeToUnreserve.getReservedContainer().getReservedResource());
        return nodeToUnreserve.getReservedContainer();
    }

    public LeafQueue getCSLeafQueue() {
        return (LeafQueue)this.queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSAssignment assignContainers(Resource clusterResource, FiCaSchedulerNode node, ResourceLimits currentResourceLimits, SchedulingMode schedulingMode, RMContainer reservedContainer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("pre-assignContainers for application " + this.getApplicationId()));
            this.showRequests();
        }
        FiCaSchedulerApp fiCaSchedulerApp = this;
        synchronized (fiCaSchedulerApp) {
            return this.containerAllocator.assignContainers(clusterResource, node, schedulingMode, currentResourceLimits, reservedContainer);
        }
    }

    public void nodePartitionUpdated(RMContainer rmContainer, String oldPartition, String newPartition) {
        Resource containerResource = rmContainer.getAllocatedResource();
        this.attemptResourceUsage.decUsed(oldPartition, containerResource);
        this.attemptResourceUsage.incUsed(newPartition, containerResource);
        this.getCSLeafQueue().decUsedResource(oldPartition, containerResource, this);
        this.getCSLeafQueue().incUsedResource(newPartition, containerResource, this);
        if (rmContainer.isAMContainer()) {
            this.setAppAMNodePartitionName(newPartition);
            this.attemptResourceUsage.decAMUsed(oldPartition, containerResource);
            this.attemptResourceUsage.incAMUsed(newPartition, containerResource);
            this.getCSLeafQueue().decAMUsedResource(oldPartition, containerResource, this);
            this.getCSLeafQueue().incAMUsedResource(newPartition, containerResource, this);
        }
    }

    @Override
    protected void getPendingAppDiagnosticMessage(StringBuilder diagnosticMessage) {
        LeafQueue queue = this.getCSLeafQueue();
        diagnosticMessage.append(" Details : AM Partition = ");
        diagnosticMessage.append(this.appAMNodePartitionName.isEmpty() ? "<DEFAULT_PARTITION>" : this.appAMNodePartitionName);
        diagnosticMessage.append("; ");
        diagnosticMessage.append("AM Resource Request = ");
        diagnosticMessage.append(this.getAMResource(this.appAMNodePartitionName));
        diagnosticMessage.append("; ");
        diagnosticMessage.append("Queue Resource Limit for AM = ");
        diagnosticMessage.append(queue.getAMResourceLimitPerPartition(this.appAMNodePartitionName));
        diagnosticMessage.append("; ");
        diagnosticMessage.append("User AM Resource Limit of the queue = ");
        diagnosticMessage.append(queue.getUserAMResourceLimitPerPartition(this.appAMNodePartitionName, this.getUser()));
        diagnosticMessage.append("; ");
        diagnosticMessage.append("Queue AM Resource Usage = ");
        diagnosticMessage.append(queue.getQueueResourceUsage().getAMUsed(this.appAMNodePartitionName));
        diagnosticMessage.append("; ");
    }

    @Override
    protected void getActivedAppDiagnosticMessage(StringBuilder diagnosticMessage) {
        LeafQueue queue = this.getCSLeafQueue();
        QueueCapacities queueCapacities = queue.getQueueCapacities();
        diagnosticMessage.append(" Details : AM Partition = ");
        diagnosticMessage.append(this.appAMNodePartitionName.isEmpty() ? "<DEFAULT_PARTITION>" : this.appAMNodePartitionName);
        diagnosticMessage.append(" ; ");
        diagnosticMessage.append("Partition Resource = ");
        diagnosticMessage.append(this.rmContext.getNodeLabelManager().getResourceByLabel(this.appAMNodePartitionName, Resources.none()));
        diagnosticMessage.append(" ; ");
        diagnosticMessage.append("Queue's Absolute capacity = ");
        diagnosticMessage.append(queueCapacities.getAbsoluteCapacity(this.appAMNodePartitionName) * 100.0f);
        diagnosticMessage.append(" % ; ");
        diagnosticMessage.append("Queue's Absolute used capacity = ");
        diagnosticMessage.append(queueCapacities.getAbsoluteUsedCapacity(this.appAMNodePartitionName) * 100.0f);
        diagnosticMessage.append(" % ; ");
        diagnosticMessage.append("Queue's Absolute max capacity = ");
        diagnosticMessage.append(queueCapacities.getAbsoluteMaximumCapacity(this.appAMNodePartitionName) * 100.0f);
        diagnosticMessage.append(" % ; ");
    }

    public void updateAppSkipNodeDiagnostics(String message) {
        this.appSkipNodeDiagnostics = message;
    }

    public void updateNodeInfoForAMDiagnostics(FiCaSchedulerNode node) {
        if (this.isWaitingForAMContainer()) {
            StringBuilder diagnosticMessageBldr = new StringBuilder();
            if (this.appSkipNodeDiagnostics != null) {
                diagnosticMessageBldr.append(this.appSkipNodeDiagnostics);
                this.appSkipNodeDiagnostics = null;
            }
            diagnosticMessageBldr.append(" Last Node which was processed for the application : ");
            diagnosticMessageBldr.append(node.getNodeID());
            diagnosticMessageBldr.append(" ( Partition : ");
            diagnosticMessageBldr.append(node.getLabels());
            diagnosticMessageBldr.append(", Total resource : ");
            diagnosticMessageBldr.append(node.getTotalResource());
            diagnosticMessageBldr.append(", Available resource : ");
            diagnosticMessageBldr.append(node.getAvailableResource());
            diagnosticMessageBldr.append(" ).");
            this.updateAMContainerDiagnostics(SchedulerApplicationAttempt.AMState.ACTIVATED, diagnosticMessageBldr.toString());
        }
    }

    @Override
    public synchronized ApplicationResourceUsageReport getResourceUsageReport() {
        ApplicationResourceUsageReport report = super.getResourceUsageReport();
        Resource cluster = this.rmContext.getScheduler().getClusterResource();
        Resource totalPartitionRes = this.rmContext.getNodeLabelManager().getResourceByLabel(this.getAppAMNodePartitionName(), cluster);
        ResourceCalculator calc = this.rmContext.getScheduler().getResourceCalculator();
        if (!calc.isInvalidDivisor(totalPartitionRes)) {
            float queueAbsMaxCapPerPartition = ((AbstractCSQueue)this.getQueue()).getQueueCapacities().getAbsoluteCapacity(this.getAppAMNodePartitionName());
            float queueUsagePerc = calc.divide(totalPartitionRes, report.getUsedResources(), Resources.multiply((Resource)totalPartitionRes, (double)queueAbsMaxCapPerPartition)) * 100.0f;
            report.setQueueUsagePercentage(queueUsagePerc);
        }
        return report;
    }
}

