/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.QueueStatistics;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.security.AccessType;
import org.apache.hadoop.yarn.security.PrivilegedEntity;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public abstract class AbstractCSQueue
implements CSQueue {
    private static final Log LOG = LogFactory.getLog(AbstractCSQueue.class);
    CSQueue parent;
    final String queueName;
    private final String queuePath;
    volatile int numContainers;
    final Resource minimumAllocation;
    volatile Resource maximumAllocation;
    QueueState state;
    final CSQueueMetrics metrics;
    protected final PrivilegedEntity queueEntity;
    final ResourceCalculator resourceCalculator;
    Set<String> accessibleLabels;
    RMNodeLabelsManager labelManager;
    String defaultLabelExpression;
    Map<AccessType, AccessControlList> acls = new HashMap<AccessType, AccessControlList>();
    volatile boolean reservationsContinueLooking;
    private boolean preemptionDisabled;
    private boolean intraQueuePreemptionDisabledInHierarchy;
    volatile ResourceUsage queueUsage;
    QueueCapacities queueCapacities;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    protected CapacitySchedulerContext csContext;
    protected YarnAuthorizationProvider authorizer = null;
    private Map<String, Float> userWeights = new HashMap<String, Float>();

    public AbstractCSQueue(CapacitySchedulerContext cs, String queueName, CSQueue parent, CSQueue old) throws IOException {
        this.labelManager = cs.getRMContext().getNodeLabelManager();
        this.parent = parent;
        this.queueName = queueName;
        this.queuePath = (parent == null ? "" : parent.getQueuePath() + ".") + this.queueName;
        this.resourceCalculator = cs.getResourceCalculator();
        this.metrics = old != null ? (CSQueueMetrics)old.getMetrics() : CSQueueMetrics.forQueue(this.getQueuePath(), parent, cs.getConfiguration().getEnableUserMetrics(), cs.getConf());
        this.csContext = cs;
        this.minimumAllocation = this.csContext.getMinimumResourceCapability();
        this.queueUsage = new ResourceUsage();
        this.queueEntity = new PrivilegedEntity(PrivilegedEntity.EntityType.QUEUE, this.getQueuePath());
        this.queueCapacities = new QueueCapacities(parent == null);
    }

    protected void setupConfigurableCapacities() {
        CSQueueUtils.loadUpdateAndCheckCapacities(this.getQueuePath(), this.csContext.getConfiguration(), this.queueCapacities, this.parent == null ? null : this.parent.getQueueCapacities());
    }

    @Override
    public String getQueuePath() {
        return this.queuePath;
    }

    @Override
    public synchronized float getCapacity() {
        return this.queueCapacities.getCapacity();
    }

    @Override
    public synchronized float getAbsoluteCapacity() {
        return this.queueCapacities.getAbsoluteCapacity();
    }

    @Override
    public float getAbsoluteMaximumCapacity() {
        return this.queueCapacities.getAbsoluteMaximumCapacity();
    }

    @Override
    public float getAbsoluteUsedCapacity() {
        return this.queueCapacities.getAbsoluteUsedCapacity();
    }

    @Override
    public float getMaximumCapacity() {
        return this.queueCapacities.getMaximumCapacity();
    }

    @Override
    public float getUsedCapacity() {
        return this.queueCapacities.getUsedCapacity();
    }

    @Override
    public Resource getUsedResources() {
        return this.queueUsage.getUsed();
    }

    public int getNumContainers() {
        return this.numContainers;
    }

    @Override
    public synchronized QueueState getState() {
        return this.state;
    }

    @Override
    public CSQueueMetrics getMetrics() {
        return this.metrics;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    public PrivilegedEntity getPrivilegedEntity() {
        return this.queueEntity;
    }

    @Override
    public synchronized CSQueue getParent() {
        return this.parent;
    }

    @Override
    public synchronized void setParent(CSQueue newParentQueue) {
        this.parent = (ParentQueue)newParentQueue;
    }

    @Override
    public Set<String> getAccessibleNodeLabels() {
        return this.accessibleLabels;
    }

    @Override
    public boolean hasAccess(QueueACL acl, UserGroupInformation user) {
        return this.authorizer.checkPermission(SchedulerUtils.toAccessType(acl), this.queueEntity, user);
    }

    @Override
    public void setUsedCapacity(float usedCapacity) {
        this.queueCapacities.setUsedCapacity(usedCapacity);
    }

    @Override
    public void setAbsoluteUsedCapacity(float absUsedCapacity) {
        this.queueCapacities.setAbsoluteUsedCapacity(absUsedCapacity);
    }

    synchronized void setMaxCapacity(float maximumCapacity) {
        CSQueueUtils.checkMaxCapacity(this.getQueueName(), this.queueCapacities.getCapacity(), maximumCapacity);
        float absMaxCapacity = CSQueueUtils.computeAbsoluteMaximumCapacity(maximumCapacity, this.parent);
        CSQueueUtils.checkAbsoluteCapacity(this.getQueueName(), this.queueCapacities.getAbsoluteCapacity(), absMaxCapacity);
        this.queueCapacities.setMaximumCapacity(maximumCapacity);
        this.queueCapacities.setAbsoluteMaximumCapacity(absMaxCapacity);
    }

    @Override
    public String getDefaultNodeLabelExpression() {
        return this.defaultLabelExpression;
    }

    synchronized void setupQueueConfigs(Resource clusterResource) throws IOException {
        this.accessibleLabels = this.csContext.getConfiguration().getAccessibleNodeLabels(this.getQueuePath());
        this.defaultLabelExpression = this.csContext.getConfiguration().getDefaultNodeLabelExpression(this.getQueuePath());
        if (this.accessibleLabels == null && this.parent != null) {
            this.accessibleLabels = this.parent.getAccessibleNodeLabels();
        }
        if (this.defaultLabelExpression == null && this.parent != null && this.accessibleLabels.containsAll(this.parent.getAccessibleNodeLabels())) {
            this.defaultLabelExpression = this.parent.getDefaultNodeLabelExpression();
        }
        this.setupConfigurableCapacities();
        this.maximumAllocation = this.csContext.getConfiguration().getMaximumAllocationPerQueue(this.getQueuePath());
        this.authorizer = YarnAuthorizationProvider.getInstance((Configuration)this.csContext.getConf());
        this.state = this.csContext.getConfiguration().getState(this.getQueuePath());
        this.acls = this.csContext.getConfiguration().getAcls(this.getQueuePath());
        CSQueueUtils.updateQueueStatistics(this.resourceCalculator, clusterResource, this.minimumAllocation, this, this.labelManager, null);
        if (this.parent != null && this.parent.getParent() != null && this.parent.getAccessibleNodeLabels() != null && !this.parent.getAccessibleNodeLabels().contains("*")) {
            if (this.getAccessibleNodeLabels().contains("*")) {
                throw new IOException("Parent's accessible queue is not ANY(*), but child's accessible queue is *");
            }
            Sets.SetView diff = Sets.difference(this.getAccessibleNodeLabels(), this.parent.getAccessibleNodeLabels());
            if (!diff.isEmpty()) {
                throw new IOException("Some labels of child queue is not a subset of parent queue, these labels=[" + StringUtils.join((Collection)diff, (String)",") + "]");
            }
        }
        this.reservationsContinueLooking = this.csContext.getConfiguration().getReservationContinueLook();
        this.preemptionDisabled = this.isQueueHierarchyPreemptionDisabled(this);
        this.intraQueuePreemptionDisabledInHierarchy = this.isIntraQueueHierarchyPreemptionDisabled(this);
        this.userWeights = this.getUserWeightsFromHierarchy();
    }

    private Map<String, Float> getUserWeightsFromHierarchy() throws IOException {
        HashMap<String, Float> unionInheritedWeights = new HashMap<String, Float>();
        CSQueue parentQ = this.getParent();
        if (parentQ != null) {
            unionInheritedWeights.putAll(parentQ.getUserWeights());
        }
        CapacitySchedulerConfiguration csConf = this.csContext.getConfiguration();
        unionInheritedWeights.putAll(csConf.getAllUserWeightsForQueue(this.getQueuePath()));
        return unionInheritedWeights;
    }

    protected QueueInfo getQueueInfo() {
        QueueInfo queueInfo = (QueueInfo)this.recordFactory.newRecordInstance(QueueInfo.class);
        queueInfo.setQueueName(this.queueName);
        queueInfo.setAccessibleNodeLabels(this.accessibleLabels);
        queueInfo.setCapacity(this.queueCapacities.getCapacity());
        queueInfo.setMaximumCapacity(this.queueCapacities.getMaximumCapacity());
        queueInfo.setQueueState(this.state);
        queueInfo.setDefaultNodeLabelExpression(this.defaultLabelExpression);
        queueInfo.setCurrentCapacity(this.getUsedCapacity());
        queueInfo.setQueueStatistics(this.getQueueStatistics());
        queueInfo.setPreemptionDisabled(this.preemptionDisabled);
        queueInfo.setIntraQueuePreemptionDisabled(this.getIntraQueuePreemptionDisabled());
        return queueInfo;
    }

    public QueueStatistics getQueueStatistics() {
        QueueStatistics stats = (QueueStatistics)this.recordFactory.newRecordInstance(QueueStatistics.class);
        stats.setNumAppsSubmitted((long)this.getMetrics().getAppsSubmitted());
        stats.setNumAppsRunning((long)this.getMetrics().getAppsRunning());
        stats.setNumAppsPending((long)this.getMetrics().getAppsPending());
        stats.setNumAppsCompleted((long)this.getMetrics().getAppsCompleted());
        stats.setNumAppsKilled((long)this.getMetrics().getAppsKilled());
        stats.setNumAppsFailed((long)this.getMetrics().getAppsFailed());
        stats.setNumActiveUsers((long)this.getMetrics().getActiveUsers());
        stats.setAvailableMemoryMB(this.getMetrics().getAvailableMB());
        stats.setAllocatedMemoryMB(this.getMetrics().getAllocatedMB());
        stats.setPendingMemoryMB(this.getMetrics().getPendingMB());
        stats.setReservedMemoryMB(this.getMetrics().getReservedMB());
        stats.setAvailableVCores((long)this.getMetrics().getAvailableVirtualCores());
        stats.setAllocatedVCores((long)this.getMetrics().getAllocatedVirtualCores());
        stats.setPendingVCores((long)this.getMetrics().getPendingVirtualCores());
        stats.setReservedVCores((long)this.getMetrics().getReservedVirtualCores());
        stats.setPendingContainers((long)this.getMetrics().getPendingContainers());
        stats.setAllocatedContainers((long)this.getMetrics().getAllocatedContainers());
        stats.setReservedContainers((long)this.getMetrics().getReservedContainers());
        return stats;
    }

    @InterfaceAudience.Private
    public Resource getMaximumAllocation() {
        return this.maximumAllocation;
    }

    @InterfaceAudience.Private
    public Resource getMinimumAllocation() {
        return this.minimumAllocation;
    }

    synchronized void allocateResource(Resource clusterResource, Resource resource, String nodePartition, boolean changeContainerResource) {
        this.queueUsage.incUsed(nodePartition, resource);
        if (!changeContainerResource) {
            ++this.numContainers;
        }
        CSQueueUtils.updateQueueStatistics(this.resourceCalculator, clusterResource, this.minimumAllocation, this, this.labelManager, nodePartition);
    }

    protected synchronized void releaseResource(Resource clusterResource, Resource resource, String nodePartition, boolean changeContainerResource) {
        this.queueUsage.decUsed(nodePartition, resource);
        CSQueueUtils.updateQueueStatistics(this.resourceCalculator, clusterResource, this.minimumAllocation, this, this.labelManager, nodePartition);
        if (!changeContainerResource) {
            --this.numContainers;
        }
    }

    @InterfaceAudience.Private
    public boolean getReservationContinueLooking() {
        return this.reservationsContinueLooking;
    }

    @InterfaceAudience.Private
    public Map<AccessType, AccessControlList> getACLs() {
        return this.acls;
    }

    @Override
    @InterfaceAudience.Private
    public boolean getPreemptionDisabled() {
        return this.preemptionDisabled;
    }

    @Override
    @InterfaceAudience.Private
    public boolean getIntraQueuePreemptionDisabled() {
        return this.intraQueuePreemptionDisabledInHierarchy || this.preemptionDisabled;
    }

    @Override
    @InterfaceAudience.Private
    public boolean getIntraQueuePreemptionDisabledInHierarchy() {
        return this.intraQueuePreemptionDisabledInHierarchy;
    }

    @Override
    @InterfaceAudience.Private
    public QueueCapacities getQueueCapacities() {
        return this.queueCapacities;
    }

    @Override
    @InterfaceAudience.Private
    public ResourceUsage getQueueResourceUsage() {
        return this.queueUsage;
    }

    private boolean isQueueHierarchyPreemptionDisabled(CSQueue q) {
        CapacitySchedulerConfiguration csConf = this.csContext.getConfiguration();
        boolean systemWidePreemption = csConf.getBoolean("yarn.resourcemanager.scheduler.monitor.enable", false);
        CSQueue parentQ = q.getParent();
        if (!systemWidePreemption) {
            return true;
        }
        if (parentQ == null) {
            return csConf.getPreemptionDisabled(q.getQueuePath(), false);
        }
        return csConf.getPreemptionDisabled(q.getQueuePath(), parentQ.getPreemptionDisabled());
    }

    private boolean isIntraQueueHierarchyPreemptionDisabled(CSQueue q) {
        CapacitySchedulerConfiguration csConf = this.csContext.getConfiguration();
        boolean systemWideIntraQueuePreemption = csConf.getBoolean("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.enabled", false);
        if (!systemWideIntraQueuePreemption) {
            return true;
        }
        CSQueue parentQ = q.getParent();
        if (parentQ == null) {
            return csConf.getIntraQueuePreemptionDisabled(q.getQueuePath(), false);
        }
        return csConf.getIntraQueuePreemptionDisabled(q.getQueuePath(), parentQ.getIntraQueuePreemptionDisabledInHierarchy());
    }

    private Resource getCurrentLimitResource(String nodePartition, Resource clusterResource, ResourceLimits currentResourceLimits, SchedulingMode schedulingMode) {
        if (schedulingMode == SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY) {
            Resource queueMaxResource = this.getQueueMaxResource(nodePartition, clusterResource);
            return Resources.min((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)queueMaxResource, (Resource)currentResourceLimits.getLimit());
        }
        if (schedulingMode == SchedulingMode.IGNORE_PARTITION_EXCLUSIVITY) {
            return this.labelManager.getResourceByLabel(nodePartition, clusterResource);
        }
        return Resources.none();
    }

    Resource getQueueMaxResource(String nodePartition, Resource clusterResource) {
        return Resources.multiplyAndNormalizeDown((ResourceCalculator)this.resourceCalculator, (Resource)this.labelManager.getResourceByLabel(nodePartition, clusterResource), (double)this.queueCapacities.getAbsoluteMaximumCapacity(nodePartition), (Resource)this.minimumAllocation);
    }

    public boolean hasChildQueues() {
        List<CSQueue> childQueues = this.getChildQueues();
        return childQueues != null && !childQueues.isEmpty();
    }

    synchronized boolean canAssignToThisQueue(Resource clusterResource, String nodePartition, ResourceLimits currentResourceLimits, Resource resourceCouldBeUnreserved, SchedulingMode schedulingMode) {
        Resource nowTotalUsed;
        Resource currentLimitResource = this.getCurrentLimitResource(nodePartition, clusterResource, currentResourceLimits, schedulingMode);
        Resource usedExceptKillable = nowTotalUsed = this.queueUsage.getUsed(nodePartition);
        if (this.hasChildQueues()) {
            usedExceptKillable = Resources.subtract((Resource)nowTotalUsed, (Resource)this.getTotalKillableResource(nodePartition));
        }
        currentResourceLimits.setHeadroom(Resources.subtract((Resource)currentLimitResource, (Resource)usedExceptKillable));
        if (Resources.greaterThanOrEqual((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)usedExceptKillable, (Resource)currentLimitResource)) {
            Resource newTotalWithoutReservedResource;
            if (this.reservationsContinueLooking && nodePartition.equals("") && Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)resourceCouldBeUnreserved, (Resource)Resources.none()) && Resources.lessThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)(newTotalWithoutReservedResource = Resources.subtract((Resource)usedExceptKillable, (Resource)resourceCouldBeUnreserved)), (Resource)currentLimitResource)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("try to use reserved: " + this.getQueueName() + " usedResources: " + this.queueUsage.getUsed() + ", clusterResources: " + clusterResource + ", reservedResources: " + resourceCouldBeUnreserved + ", capacity-without-reserved: " + newTotalWithoutReservedResource + ", maxLimitCapacity: " + currentLimitResource));
                }
                return true;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getQueueName() + "Check assign to queue, nodePartition=" + nodePartition + " usedResources: " + this.queueUsage.getUsed(nodePartition) + " clusterResources: " + clusterResource + " currentUsedCapacity " + Resources.divide((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)this.queueUsage.getUsed(nodePartition), (Resource)this.labelManager.getResourceByLabel(nodePartition, clusterResource)) + " max-capacity: " + this.queueCapacities.getAbsoluteMaximumCapacity(nodePartition) + ")"));
            }
            return false;
        }
        return true;
    }

    @Override
    public void incReservedResource(String partition, Resource reservedRes) {
        if (partition == null) {
            partition = "";
        }
        this.queueUsage.incReserved(partition, reservedRes);
        if (null != this.parent) {
            this.parent.incReservedResource(partition, reservedRes);
        }
    }

    @Override
    public void decReservedResource(String partition, Resource reservedRes) {
        if (partition == null) {
            partition = "";
        }
        this.queueUsage.decReserved(partition, reservedRes);
        if (null != this.parent) {
            this.parent.decReservedResource(partition, reservedRes);
        }
    }

    @Override
    public void incPendingResource(String nodeLabel, Resource resourceToInc) {
        if (nodeLabel == null) {
            nodeLabel = "";
        }
        this.queueUsage.incPending(nodeLabel, resourceToInc);
        if (null != this.parent) {
            this.parent.incPendingResource(nodeLabel, resourceToInc);
        }
    }

    @Override
    public void decPendingResource(String nodeLabel, Resource resourceToDec) {
        if (nodeLabel == null) {
            nodeLabel = "";
        }
        this.queueUsage.decPending(nodeLabel, resourceToDec);
        if (null != this.parent) {
            this.parent.decPendingResource(nodeLabel, resourceToDec);
        }
    }

    @Override
    public void incUsedResource(String nodeLabel, Resource resourceToInc, SchedulerApplicationAttempt application) {
        if (nodeLabel == null) {
            nodeLabel = "";
        }
        this.queueUsage.incUsed(nodeLabel, resourceToInc);
        CSQueueUtils.updateUsedCapacity(this.resourceCalculator, this.labelManager.getResourceByLabel(nodeLabel, Resources.none()), this.minimumAllocation, this.queueUsage, this.queueCapacities, nodeLabel);
        if (null != this.parent) {
            this.parent.incUsedResource(nodeLabel, resourceToInc, null);
        }
    }

    @Override
    public void decUsedResource(String nodeLabel, Resource resourceToDec, SchedulerApplicationAttempt application) {
        if (nodeLabel == null) {
            nodeLabel = "";
        }
        this.queueUsage.decUsed(nodeLabel, resourceToDec);
        CSQueueUtils.updateUsedCapacity(this.resourceCalculator, this.labelManager.getResourceByLabel(nodeLabel, Resources.none()), this.minimumAllocation, this.queueUsage, this.queueCapacities, nodeLabel);
        if (null != this.parent) {
            this.parent.decUsedResource(nodeLabel, resourceToDec, null);
        }
    }

    boolean hasPendingResourceRequest(String nodePartition, Resource cluster, SchedulingMode schedulingMode) {
        return SchedulerUtils.hasPendingResourceRequest(this.resourceCalculator, this.queueUsage, nodePartition, cluster, schedulingMode);
    }

    public boolean accessibleToPartition(String nodePartition) {
        if (this.accessibleLabels != null && this.accessibleLabels.contains("*")) {
            return true;
        }
        if (nodePartition == null || nodePartition.equals("")) {
            return true;
        }
        return this.accessibleLabels != null && this.accessibleLabels.contains(nodePartition);
    }

    @Override
    public Priority getDefaultApplicationPriority() {
        return null;
    }

    @Override
    public Set<String> getNodeLabelsForQueue() {
        HashSet<String> nodeLabels = new HashSet<String>();
        if (this.getAccessibleNodeLabels() != null && this.getAccessibleNodeLabels().contains("*")) {
            nodeLabels.addAll((Collection<String>)Sets.union(this.getQueueCapacities().getNodePartitionsSet(), this.getQueueResourceUsage().getNodePartitionsSet()));
        } else {
            nodeLabels.addAll(this.getAccessibleNodeLabels());
        }
        if (!nodeLabels.contains("")) {
            nodeLabels.add("");
        }
        return nodeLabels;
    }

    public Resource getTotalKillableResource(String partition) {
        return this.csContext.getPreemptionManager().getKillableResource(this.queueName, partition);
    }

    public Iterator<RMContainer> getKillableContainers(String partition) {
        return this.csContext.getPreemptionManager().getKillableContainers(this.queueName, partition);
    }

    @Override
    public Map<String, Float> getUserWeights() {
        return this.userWeights;
    }
}

