/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import java.util.Collection;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.ApplicationBaseProtocol;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppAttemptInfo;
import org.apache.hadoop.yarn.server.webapp.AppBlock;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

public class RMAppBlock
extends AppBlock {
    private final ResourceManager rm;
    private final Configuration conf;

    @Inject
    RMAppBlock(View.ViewContext ctx, Configuration conf, ResourceManager rm) {
        super((ApplicationBaseProtocol)rm.getClientRMService(), ctx, conf);
        this.rm = rm;
        this.conf = conf;
    }

    protected void render(HtmlBlock.Block html) {
        super.render(html);
    }

    protected void createApplicationMetricsTable(HtmlBlock.Block html) {
        RMApp rmApp = (RMApp)this.rm.getRMContext().getRMApps().get(this.appID);
        RMAppMetrics appMetrics = rmApp == null ? null : rmApp.getRMAppMetrics();
        RMAppAttemptMetrics attemptMetrics = rmApp == null || null == rmApp.getCurrentAppAttempt() ? null : rmApp.getCurrentAppAttempt().getRMAppAttemptMetrics();
        Resource attemptResourcePreempted = attemptMetrics == null ? Resources.none() : attemptMetrics.getResourcePreempted();
        int attemptNumNonAMContainerPreempted = attemptMetrics == null ? 0 : attemptMetrics.getNumNonAMContainersPreempted();
        Hamlet.DIV pdiv = html._(InfoBlock.class).div(".info-wrap.ui-widget-content.ui-corner-bottom");
        this.info("Application Overview").clear();
        this.info("Application Metrics")._("Total Resource Preempted:", (Object)(appMetrics == null ? "N/A" : appMetrics.getResourcePreempted()))._("Total Number of Non-AM Containers Preempted:", appMetrics == null ? "N/A" : Integer.valueOf(appMetrics.getNumNonAMContainersPreempted()))._("Total Number of AM Containers Preempted:", appMetrics == null ? "N/A" : Integer.valueOf(appMetrics.getNumAMContainersPreempted()))._("Resource Preempted from Current Attempt:", (Object)attemptResourcePreempted)._("Number of Non-AM Containers Preempted from Current Attempt:", (Object)attemptNumNonAMContainerPreempted)._("Aggregate Resource Allocation:", (Object)String.format("%d MB-seconds, %d vcore-seconds", appMetrics == null ? "N/A" : Long.valueOf(appMetrics.getMemorySeconds()), appMetrics == null ? "N/A" : Long.valueOf(appMetrics.getVcoreSeconds())));
        pdiv._();
    }

    protected void createApplicationAttemptTable(HtmlBlock.Block html, Collection<ApplicationAttemptReport> attempts) {
        Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.table("#attempts").thead().tr().th(".id", "Attempt ID").th(".started", "Started").th(".node", "Node").th(".logs", "Logs")._())._()).tbody();
        RMApp rmApp = (RMApp)this.rm.getRMContext().getRMApps().get(this.appID);
        if (rmApp == null) {
            return;
        }
        StringBuilder attemptsTableData = new StringBuilder("[\n");
        for (ApplicationAttemptReport appAttemptReport : attempts) {
            RMAppAttempt rmAppAttempt = rmApp.getRMAppAttempt(appAttemptReport.getApplicationAttemptId());
            if (rmAppAttempt == null) continue;
            AppAttemptInfo attemptInfo = new AppAttemptInfo(rmAppAttempt, rmApp.getUser());
            String nodeLink = attemptInfo.getNodeHttpAddress();
            if (nodeLink != null) {
                nodeLink = WebAppUtils.getHttpSchemePrefix((Configuration)this.conf) + nodeLink;
            }
            String logsLink = attemptInfo.getLogsLink();
            attemptsTableData.append("[\"<a href='").append(this.url(new String[]{"appattempt", rmAppAttempt.getAppAttemptId().toString()})).append("'>").append(String.valueOf(rmAppAttempt.getAppAttemptId())).append("</a>\",\"").append(attemptInfo.getStartTime()).append("\",\"<a ").append(nodeLink == null ? "#" : "href='" + nodeLink).append("'>").append(nodeLink == null ? "N/A" : StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)nodeLink))).append("</a>\",\"<a ").append(logsLink == null ? "#" : "href='" + logsLink).append("'>").append(logsLink == null ? "N/A" : "Logs").append("</a>\"],\n");
        }
        if (attemptsTableData.charAt(attemptsTableData.length() - 2) == ',') {
            attemptsTableData.delete(attemptsTableData.length() - 2, attemptsTableData.length() - 1);
        }
        attemptsTableData.append("]");
        html.script().$type("text/javascript")._(new Object[]{"var attemptsTableData=" + attemptsTableData})._();
        ((Hamlet.TABLE)tbody._())._();
    }
}

