/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableRate;

@InterfaceAudience.Private
@InterfaceStability.Unstable
@Metrics(context="fairscheduler-op-durations")
public class FSOpDurations
implements MetricsSource {
    @Metric(value={"Duration for a continuous scheduling run"})
    MutableRate continuousSchedulingRun;
    @Metric(value={"Duration to handle a node update"})
    MutableRate nodeUpdateCall;
    @Metric(value={"Duration for a update thread run"})
    MutableRate updateThreadRun;
    @Metric(value={"Duration for an update call"})
    MutableRate updateCall;
    @Metric(value={"Duration for a preempt call"})
    MutableRate preemptCall;
    private static final MetricsInfo RECORD_INFO = Interns.info((String)"FSOpDurations", (String)"Durations of FairScheduler calls or thread-runs");
    private final MetricsRegistry registry = new MetricsRegistry(RECORD_INFO);
    private boolean isExtended = false;
    private static final FSOpDurations INSTANCE = new FSOpDurations();

    public static FSOpDurations getInstance(boolean isExtended) {
        INSTANCE.setExtended(isExtended);
        return INSTANCE;
    }

    private FSOpDurations() {
        this.registry.tag(RECORD_INFO, "FSOpDurations");
        MetricsSystem ms = DefaultMetricsSystem.instance();
        if (ms != null) {
            ms.register(RECORD_INFO.name(), RECORD_INFO.description(), (Object)this);
        }
    }

    private synchronized void setExtended(boolean isExtended) {
        if (isExtended == FSOpDurations.INSTANCE.isExtended) {
            return;
        }
        this.continuousSchedulingRun.setExtended(isExtended);
        this.nodeUpdateCall.setExtended(isExtended);
        this.updateThreadRun.setExtended(isExtended);
        this.updateCall.setExtended(isExtended);
        this.preemptCall.setExtended(isExtended);
        FSOpDurations.INSTANCE.isExtended = isExtended;
    }

    public synchronized void getMetrics(MetricsCollector collector, boolean all) {
        this.registry.snapshot(collector.addRecord(this.registry.info()), all);
    }

    public void addContinuousSchedulingRunDuration(long value) {
        this.continuousSchedulingRun.add(value);
    }

    public void addNodeUpdateDuration(long value) {
        this.nodeUpdateCall.add(value);
    }

    public void addUpdateThreadRunDuration(long value) {
        this.updateThreadRun.add(value);
    }

    public void addUpdateCallDuration(long value) {
        this.updateCall.add(value);
    }

    public void addPreemptCallDuration(long value) {
        this.preemptCall.add(value);
    }
}

