/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.util.YarnVersionInfo;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ClusterInfo {
    protected long id;
    protected long startedOn;
    protected Service.STATE state;
    protected String resourceManagerVersion;
    protected String resourceManagerBuildVersion;
    protected String resourceManagerVersionBuiltOn;
    protected String hadoopVersion;
    protected String hadoopBuildVersion;
    protected String hadoopVersionBuiltOn;

    public ClusterInfo() {
    }

    public ClusterInfo(ResourceManager rm) {
        long ts;
        this.id = ts = ResourceManager.clusterTimeStamp;
        this.state = rm.getServiceState();
        this.startedOn = ts;
        this.resourceManagerVersion = YarnVersionInfo.getVersion();
        this.resourceManagerBuildVersion = YarnVersionInfo.getBuildVersion();
        this.resourceManagerVersionBuiltOn = YarnVersionInfo.getDate();
        this.hadoopVersion = VersionInfo.getVersion();
        this.hadoopBuildVersion = VersionInfo.getBuildVersion();
        this.hadoopVersionBuiltOn = VersionInfo.getDate();
    }

    public String getState() {
        return this.state.toString();
    }

    public String getRMVersion() {
        return this.resourceManagerVersion;
    }

    public String getRMBuildVersion() {
        return this.resourceManagerBuildVersion;
    }

    public String getRMVersionBuiltOn() {
        return this.resourceManagerVersionBuiltOn;
    }

    public String getHadoopVersion() {
        return this.hadoopVersion;
    }

    public String getHadoopBuildVersion() {
        return this.hadoopBuildVersion;
    }

    public String getHadoopVersionBuiltOn() {
        return this.hadoopVersionBuiltOn;
    }

    public long getClusterId() {
        return this.id;
    }

    public long getStartedOn() {
        return this.startedOn;
    }
}

