/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.log4j.Category;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class FairSchedulerEventLog {
    private static final Log LOG = LogFactory.getLog((String)FairSchedulerEventLog.class.getName());
    private boolean logDisabled = true;
    private String logDir;
    private String logFile;
    private DailyRollingFileAppender appender;

    FairSchedulerEventLog() {
    }

    boolean init(FairSchedulerConfiguration conf) {
        if (conf.isEventLogEnabled()) {
            try {
                this.logDir = conf.getEventlogDir();
                File logDirFile = new File(this.logDir);
                if (!logDirFile.exists() && !logDirFile.mkdirs()) {
                    throw new IOException("Mkdirs failed to create " + logDirFile.toString());
                }
                String username = System.getProperty("user.name");
                this.logFile = String.format("%s%shadoop-%s-fairscheduler.log", this.logDir, File.separator, username);
                this.logDisabled = false;
                PatternLayout layout = new PatternLayout("%d{ISO8601}\t%m%n");
                this.appender = new DailyRollingFileAppender((Layout)layout, this.logFile, "'.'yyyy-MM-dd");
                this.appender.activateOptions();
                LOG.info((Object)("Initialized fair scheduler event log, logging to " + this.logFile));
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to initialize fair scheduler event log. Disabling it.", (Throwable)e);
                this.logDisabled = true;
            }
        } else {
            this.logDisabled = true;
        }
        return !this.logDisabled;
    }

    synchronized void log(String eventType, Object ... params) {
        try {
            if (this.logDisabled) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(eventType);
            for (Object param : params) {
                buffer.append("\t");
                buffer.append(param);
            }
            String message = buffer.toString();
            Logger logger = Logger.getLogger(this.getClass());
            this.appender.append(new LoggingEvent("", (Category)logger, (Priority)Level.INFO, (Object)message, null));
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to append to fair scheduler event log", (Throwable)e);
            this.logDisabled = true;
        }
    }

    synchronized void shutdown() {
        try {
            if (this.appender != null) {
                this.appender.close();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to close fair scheduler event log", (Throwable)e);
            this.logDisabled = true;
        }
    }

    synchronized boolean isEnabled() {
        return !this.logDisabled;
    }

    public String getLogFile() {
        return this.logFile;
    }
}

