/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp.dao;

import java.util.ArrayList;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;

@XmlRootElement(name="app")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AppInfo {
    protected String id;
    protected String state;
    protected String user;
    protected ArrayList<String> containerids;

    public AppInfo() {
    }

    public AppInfo(Application app) {
        this.id = app.getAppId().toString();
        this.state = app.getApplicationState().toString();
        this.user = app.getUser();
        this.containerids = new ArrayList();
        Map<ContainerId, Container> appContainers = app.getContainers();
        for (ContainerId containerId : appContainers.keySet()) {
            String containerIdStr = containerId.toString();
            this.containerids.add(containerIdStr);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getUser() {
        return this.user;
    }

    public String getState() {
        return this.state;
    }

    public ArrayList<String> getContainers() {
        return this.containerids;
    }
}

