/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.fpga;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;

public class FpgaResourceAllocator {
    static final Log LOG = LogFactory.getLog(FpgaResourceAllocator.class);
    private List<FpgaDevice> allowedFpgas = new LinkedList<FpgaDevice>();
    private LinkedHashMap<String, List<FpgaDevice>> availableFpga = new LinkedHashMap();
    private LinkedHashMap<String, List<FpgaDevice>> usedFpgaByRequestor = new LinkedHashMap();
    private Context nmContext;

    @VisibleForTesting
    public HashMap<String, List<FpgaDevice>> getAvailableFpga() {
        return this.availableFpga;
    }

    @VisibleForTesting
    public List<FpgaDevice> getAllowedFpga() {
        return this.allowedFpgas;
    }

    public FpgaResourceAllocator(Context ctx) {
        this.nmContext = ctx;
    }

    @VisibleForTesting
    public int getAvailableFpgaCount() {
        int count = 0;
        for (List<FpgaDevice> l : this.availableFpga.values()) {
            count += l.size();
        }
        return count;
    }

    @VisibleForTesting
    public HashMap<String, List<FpgaDevice>> getUsedFpga() {
        return this.usedFpgaByRequestor;
    }

    @VisibleForTesting
    public int getUsedFpgaCount() {
        int count = 0;
        for (List<FpgaDevice> l : this.usedFpgaByRequestor.values()) {
            count += l.size();
        }
        return count;
    }

    public synchronized void addFpga(String type, List<FpgaDevice> list) {
        this.availableFpga.putIfAbsent(type, new LinkedList());
        for (FpgaDevice device : list) {
            if (this.allowedFpgas.contains(device)) continue;
            this.allowedFpgas.add(device);
            this.availableFpga.get(type).add(device);
        }
        LOG.info((Object)("Add a list of FPGA Devices: " + list));
    }

    public synchronized void updateFpga(String requestor, FpgaDevice device, String newIPID) {
        List<FpgaDevice> usedFpgas = this.usedFpgaByRequestor.get(requestor);
        int index = this.findMatchedFpga(usedFpgas, device);
        if (-1 != index) {
            usedFpgas.get(index).setIPID(newIPID);
        } else {
            LOG.warn((Object)("Failed to update FPGA due to unknown reason that no record for this allocated device:" + device));
        }
        LOG.info((Object)("Update IPID to " + newIPID + " for this allocated device:" + device));
    }

    private synchronized int findMatchedFpga(List<FpgaDevice> devices, FpgaDevice item) {
        for (int i = 0; i < devices.size(); ++i) {
            if (devices.get(i) != item) continue;
            return i;
        }
        return -1;
    }

    public synchronized FpgaAllocation assignFpga(String type, long count, Container container, String IPIDPreference) throws ResourceHandlerException {
        List<FpgaDevice> currentAvailableFpga = this.availableFpga.get(type);
        String requestor = container.getContainerId().toString();
        if (null == currentAvailableFpga) {
            throw new ResourceHandlerException("No such type of FPGA resource available: " + type);
        }
        if (count < 0L || count > (long)currentAvailableFpga.size()) {
            throw new ResourceHandlerException("Invalid FPGA request count or not enough, requested:" + count + ", available:" + this.getAvailableFpgaCount());
        }
        if (count > 0L) {
            LinkedList<FpgaDevice> assignedFpgas = new LinkedList<FpgaDevice>();
            int matchIPCount = 0;
            for (int i = 0; i < currentAvailableFpga.size(); ++i) {
                if (null == currentAvailableFpga.get(i).getIPID() || !currentAvailableFpga.get(i).getIPID().equalsIgnoreCase(IPIDPreference)) continue;
                assignedFpgas.add(currentAvailableFpga.get(i));
                currentAvailableFpga.remove(i);
                ++matchIPCount;
            }
            for (int remaining = (int)count - matchIPCount; remaining > 0; --remaining) {
                assignedFpgas.add(currentAvailableFpga.remove(0));
            }
            if (!assignedFpgas.isEmpty()) {
                try {
                    this.nmContext.getNMStateStore().storeAssignedResources(container, "yarn.io/fpga", new LinkedList<Serializable>(assignedFpgas));
                }
                catch (IOException e) {
                    currentAvailableFpga.addAll(assignedFpgas);
                    throw new ResourceHandlerException(e);
                }
                this.usedFpgaByRequestor.putIfAbsent(requestor, new LinkedList());
                this.usedFpgaByRequestor.get(requestor).addAll(assignedFpgas);
            }
            return new FpgaAllocation(assignedFpgas, currentAvailableFpga);
        }
        return new FpgaAllocation(null, this.allowedFpgas);
    }

    public synchronized void recoverAssignedFpgas(ContainerId containerId) throws ResourceHandlerException {
        Container c = (Container)this.nmContext.getContainers().get(containerId);
        if (null == c) {
            throw new ResourceHandlerException("This shouldn't happen, cannot find container with id=" + containerId);
        }
        for (Serializable fpgaDevice : c.getResourceMappings().getAssignedResources("yarn.io/fpga")) {
            if (!(fpgaDevice instanceof FpgaDevice)) {
                throw new ResourceHandlerException("Trying to recover allocated FPGA devices, however it is not FpgaDevice type, this shouldn't happen");
            }
            if (!this.allowedFpgas.contains(fpgaDevice)) {
                throw new ResourceHandlerException("Try to recover FpgaDevice = " + fpgaDevice + " however it is not in allowed device list:" + StringUtils.join((CharSequence)";", this.allowedFpgas));
            }
            Iterator<Map.Entry<String, List<FpgaDevice>>> iterator = this.getUsedFpga().entrySet().iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().getValue().contains(fpgaDevice)) continue;
                throw new ResourceHandlerException("Try to recover FpgaDevice = " + fpgaDevice + " however it is already assigned to others");
            }
            this.getUsedFpga().putIfAbsent(containerId.toString(), new LinkedList());
            this.getUsedFpga().get(containerId.toString()).add((FpgaDevice)fpgaDevice);
            this.getAvailableFpga().get(((FpgaDevice)fpgaDevice).getType()).remove(fpgaDevice);
        }
    }

    public synchronized void cleanupAssignFpgas(String requestor) {
        List<FpgaDevice> usedFpgas = this.usedFpgaByRequestor.get(requestor);
        if (usedFpgas != null) {
            for (FpgaDevice device : usedFpgas) {
                this.availableFpga.get(device.getType()).add(device);
            }
            this.usedFpgaByRequestor.remove(requestor);
        }
    }

    public static class FpgaDevice
    implements Comparable<FpgaDevice>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String type;
        private Integer major;
        private Integer minor;
        private String IPID;
        private String devName;
        private String aliasDevName;
        private String busNum;
        private String temperature;
        private String cardPowerUsage;

        public String getType() {
            return this.type;
        }

        public Integer getMajor() {
            return this.major;
        }

        public Integer getMinor() {
            return this.minor;
        }

        public String getIPID() {
            return this.IPID;
        }

        public void setIPID(String IPID) {
            this.IPID = IPID;
        }

        public String getDevName() {
            return this.devName;
        }

        public void setDevName(String devName) {
            this.devName = devName;
        }

        public String getAliasDevName() {
            return this.aliasDevName;
        }

        public void setAliasDevName(String aliasDevName) {
            this.aliasDevName = aliasDevName;
        }

        public String getBusNum() {
            return this.busNum;
        }

        public void setBusNum(String busNum) {
            this.busNum = busNum;
        }

        public String getTemperature() {
            return this.temperature;
        }

        public String getCardPowerUsage() {
            return this.cardPowerUsage;
        }

        public FpgaDevice(String type, Integer major, Integer minor, String IPID) {
            this.type = type;
            this.major = major;
            this.minor = minor;
            this.IPID = IPID;
        }

        public FpgaDevice(String type, Integer major, Integer minor, String IPID, String devName, String aliasDevName, String busNum, String temperature, String cardPowerUsage) {
            this.type = type;
            this.major = major;
            this.minor = minor;
            this.IPID = IPID;
            this.devName = devName;
            this.aliasDevName = aliasDevName;
            this.busNum = busNum;
            this.temperature = temperature;
            this.cardPowerUsage = cardPowerUsage;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof FpgaDevice)) {
                return false;
            }
            FpgaDevice other = (FpgaDevice)obj;
            return other.getType().equals(this.type) && other.getMajor().equals(this.major) && other.getMinor().equals(this.minor);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 31 * result + (this.major == null ? 0 : this.major.hashCode());
            result = 31 * result + (this.minor == null ? 0 : this.minor.hashCode());
            return result;
        }

        @Override
        public int compareTo(FpgaDevice o) {
            return 0;
        }

        public String toString() {
            return "FPGA Device:(Type: " + this.type + ", Major: " + this.major + ", Minor: " + this.minor + ", IPID: " + this.IPID + ")";
        }
    }

    public static class FpgaAllocation {
        private List<FpgaDevice> allowed = Collections.emptyList();
        private List<FpgaDevice> denied = Collections.emptyList();

        FpgaAllocation(List<FpgaDevice> allowed, List<FpgaDevice> denied) {
            if (allowed != null) {
                this.allowed = ImmutableList.copyOf(allowed);
            }
            if (denied != null) {
                this.denied = ImmutableList.copyOf(denied);
            }
        }

        public List<FpgaDevice> getAllowed() {
            return this.allowed;
        }

        public List<FpgaDevice> getDenied() {
            return this.denied;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("\nFpgaAllocation\n\tAllowed:\n");
            for (FpgaDevice device : this.allowed) {
                sb.append("\t\t");
                sb.append(device + "\n");
            }
            sb.append("\tDenied\n");
            for (FpgaDevice device : this.denied) {
                sb.append("\t\t");
                sb.append(device + "\n");
            }
            return sb.toString();
        }
    }
}

