/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.nodelabels;

import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.nodelabels.CommonNodeLabelsManager;
import org.apache.hadoop.yarn.server.nodemanager.nodelabels.NodeLabelsProvider;

public abstract class AbstractNodeLabelsProvider
extends AbstractService
implements NodeLabelsProvider {
    public static final long DISABLE_NODE_LABELS_PROVIDER_FETCH_TIMER = -1L;
    protected long intervalTime;
    protected Timer nodeLabelsScheduler;
    public static final String NODE_LABELS_SEPRATOR = ",";
    protected Lock readLock = null;
    protected Lock writeLock = null;
    protected TimerTask timerTask;
    protected Set<NodeLabel> nodeLabels = CommonNodeLabelsManager.EMPTY_NODELABEL_SET;

    public AbstractNodeLabelsProvider(String name) {
        super(name);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.intervalTime = conf.getLong("yarn.nodemanager.node-labels.provider.fetch-interval-ms", 600000L);
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        this.timerTask = this.createTimerTask();
        this.timerTask.run();
        if (this.intervalTime != -1L) {
            this.nodeLabelsScheduler = new Timer("DistributedNodeLabelsRunner-Timer", true);
            this.nodeLabelsScheduler.scheduleAtFixedRate(this.timerTask, this.intervalTime, this.intervalTime);
        }
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.nodeLabelsScheduler != null) {
            this.nodeLabelsScheduler.cancel();
        }
        this.cleanUp();
        super.serviceStop();
    }

    protected abstract void cleanUp() throws Exception;

    @Override
    public Set<NodeLabel> getNodeLabels() {
        this.readLock.lock();
        try {
            Set<NodeLabel> set = this.nodeLabels;
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected void setNodeLabels(Set<NodeLabel> nodeLabelsSet) {
        this.writeLock.lock();
        try {
            this.nodeLabels = nodeLabelsSet;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    static Set<NodeLabel> convertToNodeLabelSet(String partitionNodeLabel) {
        if (null == partitionNodeLabel) {
            return null;
        }
        HashSet<NodeLabel> labels = new HashSet<NodeLabel>();
        labels.add(NodeLabel.newInstance((String)partitionNodeLabel));
        return labels;
    }

    TimerTask getTimerTask() {
        return this.timerTask;
    }

    public abstract TimerTask createTimerTask();
}

