/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.sql;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.security.client.YARNDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.federation.store.records.RouterStoreToken;
import org.apache.hadoop.yarn.server.federation.store.sql.FederationSQLOutParameter;
import org.apache.hadoop.yarn.server.federation.store.sql.ResultSetHandler;
import org.apache.hadoop.yarn.server.federation.store.utils.FederationStateStoreUtils;
import org.apache.hadoop.yarn.util.Records;

public class RouterStoreTokenHandler
implements ResultSetHandler<RouterStoreToken> {
    private static final String TOKENIDENT_OUT = "tokenIdent_OUT";
    private static final String TOKEN_OUT = "token_OUT";
    private static final String RENEWDATE_OUT = "renewDate_OUT";

    @Override
    public RouterStoreToken handle(Object ... params) throws SQLException {
        RouterStoreToken storeToken = (RouterStoreToken)Records.newRecord(RouterStoreToken.class);
        for (Object param : params) {
            if (!(param instanceof FederationSQLOutParameter)) continue;
            FederationSQLOutParameter parameter = (FederationSQLOutParameter)param;
            String paramName = parameter.getParamName();
            Object parmaValue = parameter.getValue();
            if (StringUtils.equalsIgnoreCase((String)paramName, (String)TOKENIDENT_OUT)) {
                YARNDelegationTokenIdentifier identifier = this.getYARNDelegationTokenIdentifier(parmaValue);
                storeToken.setIdentifier(identifier);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)paramName, (String)TOKEN_OUT)) {
                String tokenInfo = this.getTokenInfo(parmaValue);
                storeToken.setTokenInfo(tokenInfo);
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((String)paramName, (String)RENEWDATE_OUT)) continue;
            Long renewDate = this.getRenewDate(parmaValue);
            storeToken.setRenewDate(renewDate);
        }
        return storeToken;
    }

    private YARNDelegationTokenIdentifier getYARNDelegationTokenIdentifier(Object tokenIdent) throws SQLException {
        try {
            YARNDelegationTokenIdentifier resultIdentifier = (YARNDelegationTokenIdentifier)Records.newRecord(YARNDelegationTokenIdentifier.class);
            FederationStateStoreUtils.decodeWritable((Writable)resultIdentifier, String.valueOf(tokenIdent));
            return resultIdentifier;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    private String getTokenInfo(Object tokenInfo) {
        return String.valueOf(tokenInfo);
    }

    private Long getRenewDate(Object renewDate) {
        return Long.parseLong(String.valueOf(renewDate));
    }
}

