/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.yarn.client.RMProxy;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.api.DistributedSchedulingAMProtocol;
import org.apache.hadoop.yarn.server.api.ResourceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerRMProxy<T>
extends RMProxy<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ServerRMProxy.class);

    private ServerRMProxy() {
    }

    public static <T> T createRMProxy(Configuration configuration, Class<T> protocol) throws IOException {
        long rmConnectWait = configuration.getLong("yarn.resourcemanager.connect.max-wait.ms", 900000L);
        long rmRetryInterval = configuration.getLong("yarn.resourcemanager.connect.retry-interval.ms", 30000L);
        long nmRmConnectWait = configuration.getLong("yarn.nodemanager.resourcemanager.connect.max-wait.ms", rmConnectWait);
        long nmRmRetryInterval = configuration.getLong("yarn.nodemanager.resourcemanager.connect.retry-interval.ms", rmRetryInterval);
        ServerRMProxy<T> serverRMProxy = new ServerRMProxy<T>();
        return (T)ServerRMProxy.createRMProxy((Configuration)configuration, protocol, serverRMProxy, (long)nmRmConnectWait, (long)nmRmRetryInterval);
    }

    @InterfaceAudience.Private
    public InetSocketAddress getRMAddress(YarnConfiguration conf, Class<?> protocol) {
        if (protocol == ResourceTracker.class) {
            return conf.getSocketAddr("yarn.resourcemanager.resource-tracker.address", "0.0.0.0:8031", 8031);
        }
        if (protocol == DistributedSchedulingAMProtocol.class) {
            return conf.getSocketAddr("yarn.resourcemanager.scheduler.address", "0.0.0.0:8030", 8030);
        }
        String message = "Unsupported protocol found when creating the proxy connection to ResourceManager: " + (protocol != null ? protocol.getClass().getName() : "null");
        LOG.error(message);
        throw new IllegalStateException(message);
    }

    @InterfaceAudience.Private
    public void checkAllowedProtocols(Class<?> protocol) {
        Preconditions.checkArgument((boolean)protocol.isAssignableFrom(ServerRMProtocols.class), (Object)"ResourceManager does not support this protocol");
    }

    private static interface ServerRMProtocols
    extends DistributedSchedulingAMProtocol,
    ResourceTracker {
    }
}

