/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.router;

import java.util.Map;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.server.federation.policies.AbstractConfigurableFederationPolicy;
import org.apache.hadoop.yarn.server.federation.policies.dao.WeightedPolicyInfo;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyException;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.policies.router.FederationRouterPolicy;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;

public abstract class AbstractRouterPolicy
extends AbstractConfigurableFederationPolicy
implements FederationRouterPolicy {
    @Override
    public void validate(WeightedPolicyInfo newPolicyInfo) throws FederationPolicyInitializationException {
        super.validate(newPolicyInfo);
        Map<SubClusterIdInfo, Float> newWeights = newPolicyInfo.getRouterPolicyWeights();
        if (newWeights == null || newWeights.size() < 1) {
            throw new FederationPolicyInitializationException("Weight vector cannot be null/empty.");
        }
    }

    public void validate(ApplicationSubmissionContext appSubmissionContext) throws FederationPolicyException {
        if (appSubmissionContext == null) {
            throw new FederationPolicyException("Cannot route an application with null context.");
        }
        String queue = appSubmissionContext.getQueue();
        if (queue == null) {
            appSubmissionContext.setQueue("default");
        }
    }
}

