/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webapp;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import org.apache.commons.lang3.Range;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationBaseProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.exceptions.ApplicationAttemptNotFoundException;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.ContainerNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.webapp.AppInfoProvider;
import org.apache.hadoop.yarn.server.webapp.BasicAppInfo;
import org.apache.hadoop.yarn.server.webapp.dao.AppAttemptInfo;
import org.apache.hadoop.yarn.server.webapp.dao.AppAttemptsInfo;
import org.apache.hadoop.yarn.server.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.webapp.dao.AppsInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainersInfo;
import org.apache.hadoop.yarn.webapp.BadRequestException;
import org.apache.hadoop.yarn.webapp.ForbiddenException;
import org.apache.hadoop.yarn.webapp.NotFoundException;

public class WebServices
implements AppInfoProvider {
    protected ApplicationBaseProtocol appBaseProt;

    public WebServices(ApplicationBaseProtocol appBaseProt) {
        this.appBaseProt = appBaseProt;
    }

    public AppsInfo getApps(HttpServletRequest req, HttpServletResponse res, String stateQuery, Set<String> statesQuery, String finalStatusQuery, String userQuery, String queueQuery, String count, String startedBegin, String startedEnd, String finishBegin, String finishEnd, Set<String> applicationTypes) {
        Set<String> appStates;
        UserGroupInformation callerUGI = WebServices.getUser(req);
        boolean checkEnd = false;
        boolean checkAppTypes = false;
        boolean checkAppStates = false;
        long countNum = Long.MAX_VALUE;
        long sBegin = 0L;
        long sEnd = Long.MAX_VALUE;
        long fBegin = 0L;
        long fEnd = Long.MAX_VALUE;
        if (count != null && !count.isEmpty() && (countNum = Long.parseLong(count)) <= 0L) {
            throw new BadRequestException("limit value must be greater then 0");
        }
        if (startedBegin != null && !startedBegin.isEmpty() && (sBegin = Long.parseLong(startedBegin)) < 0L) {
            throw new BadRequestException("startedTimeBegin must be greater than 0");
        }
        if (startedEnd != null && !startedEnd.isEmpty() && (sEnd = Long.parseLong(startedEnd)) < 0L) {
            throw new BadRequestException("startedTimeEnd must be greater than 0");
        }
        if (sBegin > sEnd) {
            throw new BadRequestException("startedTimeEnd must be greater than startTimeBegin");
        }
        if (finishBegin != null && !finishBegin.isEmpty()) {
            checkEnd = true;
            fBegin = Long.parseLong(finishBegin);
            if (fBegin < 0L) {
                throw new BadRequestException("finishTimeBegin must be greater than 0");
            }
        }
        if (finishEnd != null && !finishEnd.isEmpty()) {
            checkEnd = true;
            fEnd = Long.parseLong(finishEnd);
            if (fEnd < 0L) {
                throw new BadRequestException("finishTimeEnd must be greater than 0");
            }
        }
        if (fBegin > fEnd) {
            throw new BadRequestException("finishTimeEnd must be greater than finishTimeBegin");
        }
        Set<String> appTypes = WebServices.parseQueries(applicationTypes, false);
        if (!appTypes.isEmpty()) {
            checkAppTypes = true;
        }
        if (stateQuery != null && !stateQuery.isEmpty()) {
            statesQuery.add(stateQuery);
        }
        if (!(appStates = WebServices.parseQueries(statesQuery, true)).isEmpty()) {
            checkAppStates = true;
        }
        AppsInfo allApps = new AppsInfo();
        Collection<Object> appReports = null;
        final GetApplicationsRequest request = GetApplicationsRequest.newInstance();
        request.setLimit(countNum);
        request.setStartRange(Range.between((Comparable)Long.valueOf(sBegin), (Comparable)Long.valueOf(sEnd)));
        try {
            appReports = callerUGI == null ? this.getApplicationsReport(request) : (Collection)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Collection<ApplicationReport>>(){

                @Override
                public Collection<ApplicationReport> run() throws Exception {
                    return WebServices.this.getApplicationsReport(request);
                }
            });
        }
        catch (Exception e) {
            WebServices.rewrapAndThrowException(e);
        }
        if (appReports == null) {
            return allApps;
        }
        for (ApplicationReport appReport : appReports) {
            if (checkAppStates && !appStates.contains(StringUtils.toLowerCase((String)appReport.getYarnApplicationState().toString()))) continue;
            if (finalStatusQuery != null && !finalStatusQuery.isEmpty()) {
                FinalApplicationStatus.valueOf((String)finalStatusQuery);
                if (!appReport.getFinalApplicationStatus().toString().equalsIgnoreCase(finalStatusQuery)) continue;
            }
            if (userQuery != null && !userQuery.isEmpty() && !appReport.getUser().equals(userQuery) || queueQuery != null && !queueQuery.isEmpty() && (appReport.getQueue() == null || !appReport.getQueue().equals(queueQuery)) || checkAppTypes && !appTypes.contains(StringUtils.toLowerCase((String)appReport.getApplicationType().trim())) || checkEnd && (appReport.getFinishTime() < fBegin || appReport.getFinishTime() > fEnd)) continue;
            AppInfo app = new AppInfo(appReport);
            allApps.add(app);
        }
        return allApps;
    }

    public AppInfo getApp(HttpServletRequest req, HttpServletResponse res, String appId) {
        return this.getApp(req, appId);
    }

    @Override
    public BasicAppInfo getApp(HttpServletRequest req, String appId, String clusterId) {
        return BasicAppInfo.fromAppInfo(this.getApp(req, appId));
    }

    public AppInfo getApp(HttpServletRequest req, String appId) {
        UserGroupInformation callerUGI = WebServices.getUser(req);
        final ApplicationId id = WebServices.parseApplicationId(appId);
        ApplicationReport app = null;
        try {
            if (callerUGI == null) {
                GetApplicationReportRequest request = GetApplicationReportRequest.newInstance((ApplicationId)id);
                app = this.getApplicationReport(request);
            } else {
                app = (ApplicationReport)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ApplicationReport>(){

                    @Override
                    public ApplicationReport run() throws Exception {
                        GetApplicationReportRequest request = GetApplicationReportRequest.newInstance((ApplicationId)id);
                        return WebServices.this.getApplicationReport(request);
                    }
                });
            }
        }
        catch (Exception e) {
            WebServices.rewrapAndThrowException(e);
        }
        if (app == null) {
            throw new NotFoundException("app with id: " + appId + " not found");
        }
        return new AppInfo(app);
    }

    public AppAttemptsInfo getAppAttempts(HttpServletRequest req, HttpServletResponse res, String appId) {
        UserGroupInformation callerUGI = WebServices.getUser(req);
        final ApplicationId id = WebServices.parseApplicationId(appId);
        Collection<Object> appAttemptReports = null;
        try {
            if (callerUGI == null) {
                GetApplicationAttemptsRequest request = GetApplicationAttemptsRequest.newInstance((ApplicationId)id);
                appAttemptReports = this.getApplicationAttemptsReport(request);
            } else {
                appAttemptReports = (Collection)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Collection<ApplicationAttemptReport>>(){

                    @Override
                    public Collection<ApplicationAttemptReport> run() throws Exception {
                        GetApplicationAttemptsRequest request = GetApplicationAttemptsRequest.newInstance((ApplicationId)id);
                        return WebServices.this.getApplicationAttemptsReport(request);
                    }
                });
            }
        }
        catch (Exception e) {
            WebServices.rewrapAndThrowException(e);
        }
        AppAttemptsInfo appAttemptsInfo = new AppAttemptsInfo();
        if (appAttemptReports == null) {
            return appAttemptsInfo;
        }
        for (ApplicationAttemptReport applicationAttemptReport : appAttemptReports) {
            AppAttemptInfo appAttemptInfo = new AppAttemptInfo(applicationAttemptReport);
            appAttemptsInfo.add(appAttemptInfo);
        }
        return appAttemptsInfo;
    }

    public AppAttemptInfo getAppAttempt(HttpServletRequest req, HttpServletResponse res, String appId, String appAttemptId) {
        UserGroupInformation callerUGI = WebServices.getUser(req);
        ApplicationId aid = WebServices.parseApplicationId(appId);
        final ApplicationAttemptId aaid = WebServices.parseApplicationAttemptId(appAttemptId);
        this.validateIds(aid, aaid, null);
        ApplicationAttemptReport appAttempt = null;
        try {
            if (callerUGI == null) {
                GetApplicationAttemptReportRequest request = GetApplicationAttemptReportRequest.newInstance((ApplicationAttemptId)aaid);
                appAttempt = this.getApplicationAttemptReport(request);
            } else {
                appAttempt = (ApplicationAttemptReport)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ApplicationAttemptReport>(){

                    @Override
                    public ApplicationAttemptReport run() throws Exception {
                        GetApplicationAttemptReportRequest request = GetApplicationAttemptReportRequest.newInstance((ApplicationAttemptId)aaid);
                        return WebServices.this.getApplicationAttemptReport(request);
                    }
                });
            }
        }
        catch (Exception e) {
            WebServices.rewrapAndThrowException(e);
        }
        if (appAttempt == null) {
            throw new NotFoundException("app attempt with id: " + appAttemptId + " not found");
        }
        return new AppAttemptInfo(appAttempt);
    }

    public ContainersInfo getContainers(HttpServletRequest req, HttpServletResponse res, String appId, String appAttemptId) {
        UserGroupInformation callerUGI = WebServices.getUser(req);
        ApplicationId aid = WebServices.parseApplicationId(appId);
        final ApplicationAttemptId aaid = WebServices.parseApplicationAttemptId(appAttemptId);
        this.validateIds(aid, aaid, null);
        Collection<Object> containerReports = null;
        try {
            if (callerUGI == null) {
                GetContainersRequest request = GetContainersRequest.newInstance((ApplicationAttemptId)aaid);
                containerReports = this.getContainersReport(request);
            } else {
                containerReports = (Collection)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Collection<ContainerReport>>(){

                    @Override
                    public Collection<ContainerReport> run() throws Exception {
                        GetContainersRequest request = GetContainersRequest.newInstance((ApplicationAttemptId)aaid);
                        return WebServices.this.getContainersReport(request);
                    }
                });
            }
        }
        catch (Exception e) {
            WebServices.rewrapAndThrowException(e);
        }
        ContainersInfo containersInfo = new ContainersInfo();
        if (containerReports == null) {
            return containersInfo;
        }
        for (ContainerReport containerReport : containerReports) {
            ContainerInfo containerInfo = new ContainerInfo(containerReport);
            containersInfo.add(containerInfo);
        }
        return containersInfo;
    }

    @Override
    public String getNodeHttpAddress(HttpServletRequest req, String appId, String appAttemptId, String containerId, String clusterId) {
        ContainerInfo containerInfo = this.getContainer(req, appId, appAttemptId, containerId);
        return containerInfo.getNodeHttpAddress();
    }

    public ContainerInfo getContainer(HttpServletRequest req, String appId, String appAttemptId, String containerId) {
        UserGroupInformation callerUGI = WebServices.getUser(req);
        ApplicationId aid = WebServices.parseApplicationId(appId);
        ApplicationAttemptId aaid = WebServices.parseApplicationAttemptId(appAttemptId);
        final ContainerId cid = WebServices.parseContainerId(containerId);
        this.validateIds(aid, aaid, cid);
        ContainerReport container = null;
        try {
            if (callerUGI == null) {
                GetContainerReportRequest request = GetContainerReportRequest.newInstance((ContainerId)cid);
                container = this.getContainerReport(request);
            } else {
                container = (ContainerReport)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ContainerReport>(){

                    @Override
                    public ContainerReport run() throws Exception {
                        GetContainerReportRequest request = GetContainerReportRequest.newInstance((ContainerId)cid);
                        return WebServices.this.getContainerReport(request);
                    }
                });
            }
        }
        catch (Exception e) {
            WebServices.rewrapAndThrowException(e);
        }
        if (container == null) {
            throw new NotFoundException("container with id: " + containerId + " not found");
        }
        return new ContainerInfo(container);
    }

    public ContainerInfo getContainer(HttpServletRequest req, HttpServletResponse res, String appId, String appAttemptId, String containerId) {
        return this.getContainer(req, appId, appAttemptId, containerId);
    }

    protected void initForReadableEndpoints(HttpServletResponse response) {
        response.setContentType(null);
    }

    public static Set<String> parseQueries(Set<String> queries, boolean isState) {
        HashSet<String> params = new HashSet<String>();
        if (!queries.isEmpty()) {
            for (String query : queries) {
                String[] paramStrs;
                if (query == null || query.trim().isEmpty()) continue;
                for (String paramStr : paramStrs = query.split(",")) {
                    if (paramStr == null || paramStr.trim().isEmpty()) continue;
                    if (isState) {
                        try {
                            YarnApplicationState.valueOf((String)StringUtils.toUpperCase((String)paramStr.trim()));
                        }
                        catch (RuntimeException e) {
                            Object[] stateArray = YarnApplicationState.values();
                            String allAppStates = Arrays.toString(stateArray);
                            throw new BadRequestException("Invalid application-state " + paramStr.trim() + " specified. It should be one of " + allAppStates);
                        }
                    }
                    params.add(StringUtils.toLowerCase((String)paramStr.trim()));
                }
            }
        }
        return params;
    }

    protected static ApplicationId parseApplicationId(String appId) {
        if (appId == null || appId.isEmpty()) {
            throw new NotFoundException("appId, " + appId + ", is empty or null");
        }
        ApplicationId aid = null;
        try {
            aid = ApplicationId.fromString((String)appId);
        }
        catch (Exception e) {
            throw new BadRequestException((Throwable)e);
        }
        if (aid == null) {
            throw new NotFoundException("appId is null");
        }
        return aid;
    }

    protected static ApplicationAttemptId parseApplicationAttemptId(String appAttemptId) {
        if (appAttemptId == null || appAttemptId.isEmpty()) {
            throw new NotFoundException("appAttemptId, " + appAttemptId + ", is empty or null");
        }
        ApplicationAttemptId aaid = null;
        try {
            aaid = ApplicationAttemptId.fromString((String)appAttemptId);
        }
        catch (Exception e) {
            throw new BadRequestException((Throwable)e);
        }
        if (aaid == null) {
            throw new NotFoundException("appAttemptId is null");
        }
        return aaid;
    }

    protected static ContainerId parseContainerId(String containerId) {
        if (containerId == null || containerId.isEmpty()) {
            throw new NotFoundException("containerId, " + containerId + ", is empty or null");
        }
        ContainerId cid = null;
        try {
            cid = ContainerId.fromString((String)containerId);
        }
        catch (Exception e) {
            throw new BadRequestException((Throwable)e);
        }
        if (cid == null) {
            throw new NotFoundException("containerId is null");
        }
        return cid;
    }

    protected void validateIds(ApplicationId appId, ApplicationAttemptId appAttemptId, ContainerId containerId) {
        if (!appAttemptId.getApplicationId().equals((Object)appId)) {
            throw new NotFoundException("appId and appAttemptId don't match");
        }
        if (containerId != null && !containerId.getApplicationAttemptId().equals((Object)appAttemptId)) {
            throw new NotFoundException("appAttemptId and containerId don't match");
        }
    }

    protected static UserGroupInformation getUser(HttpServletRequest req) {
        String remoteUser = req.getRemoteUser();
        UserGroupInformation callerUGI = null;
        if (remoteUser != null) {
            callerUGI = UserGroupInformation.createRemoteUser((String)remoteUser);
        }
        return callerUGI;
    }

    private static void rewrapAndThrowException(Exception e) {
        if (e instanceof UndeclaredThrowableException) {
            WebServices.rewrapAndThrowThrowable(e.getCause());
        } else {
            WebServices.rewrapAndThrowThrowable(e);
        }
    }

    private static void rewrapAndThrowThrowable(Throwable t) {
        if (t instanceof AuthorizationException) {
            throw new ForbiddenException(t);
        }
        if (t instanceof ApplicationNotFoundException || t instanceof ApplicationAttemptNotFoundException || t instanceof ContainerNotFoundException) {
            throw new NotFoundException(t);
        }
        throw new WebApplicationException(t);
    }

    protected ApplicationReport getApplicationReport(GetApplicationReportRequest request) throws YarnException, IOException {
        return this.appBaseProt.getApplicationReport(request).getApplicationReport();
    }

    protected List<ApplicationReport> getApplicationsReport(GetApplicationsRequest request) throws YarnException, IOException {
        return this.appBaseProt.getApplications(request).getApplicationList();
    }

    protected ApplicationAttemptReport getApplicationAttemptReport(GetApplicationAttemptReportRequest request) throws YarnException, IOException {
        return this.appBaseProt.getApplicationAttemptReport(request).getApplicationAttemptReport();
    }

    protected List<ApplicationAttemptReport> getApplicationAttemptsReport(GetApplicationAttemptsRequest request) throws YarnException, IOException {
        return this.appBaseProt.getApplicationAttempts(request).getApplicationAttemptList();
    }

    protected ContainerReport getContainerReport(GetContainerReportRequest request) throws YarnException, IOException {
        return this.appBaseProt.getContainerReport(request).getContainerReport();
    }

    protected List<ContainerReport> getContainersReport(GetContainersRequest request) throws YarnException, IOException {
        return this.appBaseProt.getContainers(request).getContainerList();
    }
}

