/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.amrmproxy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyInitializationContext;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyInitializationContextValidator;
import org.apache.hadoop.yarn.server.federation.policies.amrmproxy.AbstractAMRMProxyPolicy;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyException;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;

public class HomeAMRMProxyPolicy
extends AbstractAMRMProxyPolicy {
    private SubClusterId homeSubcluster;

    @Override
    public void reinitialize(FederationPolicyInitializationContext policyContext) throws FederationPolicyInitializationException {
        FederationPolicyInitializationContextValidator.validate(policyContext, this.getClass().getCanonicalName());
        this.setPolicyContext(policyContext);
        this.homeSubcluster = policyContext.getHomeSubcluster();
    }

    @Override
    public Map<SubClusterId, List<ResourceRequest>> splitResourceRequests(List<ResourceRequest> resourceRequests) throws YarnException {
        if (this.homeSubcluster == null) {
            throw new FederationPolicyException("No home subcluster available");
        }
        Map<SubClusterId, SubClusterInfo> active = this.getActiveSubclusters();
        if (!active.containsKey(this.homeSubcluster)) {
            throw new FederationPolicyException("The local subcluster " + this.homeSubcluster + " is not active");
        }
        ArrayList<ResourceRequest> resourceRequestsCopy = new ArrayList<ResourceRequest>(resourceRequests);
        return Collections.singletonMap(this.homeSubcluster, resourceRequestsCopy);
    }
}

