/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.security;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.token.delegation.web.KerberosDelegationTokenAuthenticationHandler;
import org.apache.hadoop.security.token.delegation.web.PseudoDelegationTokenAuthenticationHandler;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.timeline.security.TimelineAuthenticationFilter;

public class TimelineAuthenticationFilterInitializer
extends FilterInitializer {
    public static final String PREFIX = "yarn.timeline-service.http-authentication.";
    @VisibleForTesting
    Map<String, String> filterConfig;

    public void initFilter(FilterContainer container, Configuration conf) {
        String value;
        String name;
        this.filterConfig = new HashMap<String, String>();
        this.filterConfig.put("cookie.path", "/");
        for (Map.Entry entry : conf) {
            name = (String)entry.getKey();
            if (!name.startsWith("hadoop.proxyuser")) continue;
            value = conf.get(name);
            name = name.substring("hadoop.".length());
            this.filterConfig.put(name, value);
        }
        for (Map.Entry entry : conf) {
            name = (String)entry.getKey();
            if (!name.startsWith(PREFIX)) continue;
            value = conf.get(name);
            name = name.substring(PREFIX.length());
            this.filterConfig.put(name, value);
        }
        String authType = this.filterConfig.get("type");
        if (authType.equals("simple")) {
            this.filterConfig.put("type", PseudoDelegationTokenAuthenticationHandler.class.getName());
        } else if (authType.equals("kerberos")) {
            this.filterConfig.put("type", KerberosDelegationTokenAuthenticationHandler.class.getName());
            String bindAddress = conf.get("bind.address");
            String principal = this.filterConfig.get("kerberos.principal");
            if (principal != null) {
                try {
                    principal = SecurityUtil.getServerPrincipal((String)principal, (String)bindAddress);
                }
                catch (IOException ex) {
                    throw new RuntimeException("Could not resolve Kerberos principal name: " + ex.toString(), ex);
                }
                this.filterConfig.put("kerberos.principal", principal);
            }
        }
        this.filterConfig.put("delegation-token.token-kind", TimelineDelegationTokenIdentifier.KIND_NAME.toString());
        container.addGlobalFilter("Timeline Authentication Filter", TimelineAuthenticationFilter.class.getName(), this.filterConfig);
    }
}

