/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.nodelabels;

import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.resource.Resources;

public abstract class AbstractLabel {
    private Resource resource;
    private int numActiveNMs;
    private String labelName;

    public AbstractLabel() {
    }

    public AbstractLabel(String labelName) {
        this(labelName, Resource.newInstance((int)0, (int)0), 0);
    }

    public AbstractLabel(String labelName, Resource resource, int numActiveNMs) {
        this.resource = resource;
        this.numActiveNMs = numActiveNMs;
        this.labelName = labelName;
    }

    public void addNode(Resource nodeRes) {
        Resources.addTo(this.resource, nodeRes);
        ++this.numActiveNMs;
    }

    public void removeNode(Resource nodeRes) {
        Resources.subtractFrom(this.resource, nodeRes);
        --this.numActiveNMs;
    }

    public Resource getResource() {
        return Resource.newInstance((Resource)this.resource);
    }

    public int getNumActiveNMs() {
        return this.numActiveNMs;
    }

    public String getLabelName() {
        return this.labelName;
    }
}

