/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceAllocationRequest;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ResourceAllocationRequestPBImpl
extends ResourceAllocationRequest {
    private YarnProtos.ResourceAllocationRequestProto proto = YarnProtos.ResourceAllocationRequestProto.getDefaultInstance();
    private YarnProtos.ResourceAllocationRequestProto.Builder builder = null;
    private boolean viaProto = false;
    private Resource capability = null;

    public ResourceAllocationRequestPBImpl() {
        this.builder = YarnProtos.ResourceAllocationRequestProto.newBuilder();
    }

    public ResourceAllocationRequestPBImpl(YarnProtos.ResourceAllocationRequestProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnProtos.ResourceAllocationRequestProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ResourceAllocationRequestProto.newBuilder((YarnProtos.ResourceAllocationRequestProto)this.proto);
        }
        this.viaProto = false;
    }

    public Resource getCapability() {
        YarnProtos.ResourceAllocationRequestProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.capability != null) {
            return this.capability;
        }
        if (!p.hasResource()) {
            return null;
        }
        this.capability = this.convertFromProtoFormat(p.getResource());
        return this.capability;
    }

    public void setCapability(Resource newCapability) {
        this.maybeInitBuilder();
        if (newCapability == null) {
            this.builder.clearResource();
            return;
        }
        this.capability = newCapability;
    }

    public long getStartTime() {
        YarnProtos.ResourceAllocationRequestProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasStartTime()) {
            return 0L;
        }
        return p.getStartTime();
    }

    public void setStartTime(long startTime) {
        this.maybeInitBuilder();
        if (startTime <= 0L) {
            this.builder.clearStartTime();
            return;
        }
        this.builder.setStartTime(startTime);
    }

    public long getEndTime() {
        YarnProtos.ResourceAllocationRequestProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasEndTime()) {
            return 0L;
        }
        return p.getEndTime();
    }

    public void setEndTime(long endTime) {
        this.maybeInitBuilder();
        if (endTime <= 0L) {
            this.builder.clearEndTime();
            return;
        }
        this.builder.setEndTime(endTime);
    }

    private ResourcePBImpl convertFromProtoFormat(YarnProtos.ResourceProto p) {
        return new ResourcePBImpl(p);
    }

    private YarnProtos.ResourceProto convertToProtoFormat(Resource p) {
        return ProtoUtils.convertToProtoFormat(p);
    }

    private void mergeLocalToBuilder() {
        if (this.capability != null) {
            this.builder.setResource(this.convertToProtoFormat(this.capability));
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    public String toString() {
        return "{Resource: " + this.getCapability() + ", # Start Time: " + this.getStartTime() + ", End Time: " + this.getEndTime() + "}";
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this.getProto().equals((Object)((ResourceAllocationRequestPBImpl)((Object)((Object)((Object)this)).getClass().cast(other))).getProto());
        }
        return false;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }
}

