/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import java.util.HashMap;
import org.apache.hadoop.yarn.api.records.ResourceUtilization;
import org.junit.Assert;
import org.junit.Test;

public class TestResourceUtilization {
    @Test
    public void testResourceUtilization() {
        ResourceUtilization u1 = ResourceUtilization.newInstance((int)10, (int)20, (float)0.5f);
        ResourceUtilization u2 = ResourceUtilization.newInstance((ResourceUtilization)u1);
        ResourceUtilization u3 = ResourceUtilization.newInstance((int)10, (int)20, (float)0.5f);
        ResourceUtilization u4 = ResourceUtilization.newInstance((int)20, (int)20, (float)0.5f);
        ResourceUtilization u5 = ResourceUtilization.newInstance((int)30, (int)40, (float)0.8f);
        Assert.assertEquals((Object)u1, (Object)u2);
        Assert.assertEquals((Object)u1, (Object)u3);
        Assert.assertNotEquals((Object)u1, (Object)u4);
        Assert.assertNotEquals((Object)u2, (Object)u5);
        Assert.assertNotEquals((Object)u4, (Object)u5);
        Assert.assertTrue((u1.hashCode() == u2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((u1.hashCode() == u3.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((u1.hashCode() == u4.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((u2.hashCode() == u5.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((u4.hashCode() == u5.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((u1.getPhysicalMemory() == 10 ? 1 : 0) != 0);
        Assert.assertFalse((u1.getVirtualMemory() == 10 ? 1 : 0) != 0);
        Assert.assertTrue((u1.getCPU() == 0.5f ? 1 : 0) != 0);
        Assert.assertEquals((Object)("<pmem:10, vmem:" + u1.getVirtualMemory() + ", vCores:0.5>"), (Object)u1.toString());
        u1.addTo(10, 0, 0.0f);
        Assert.assertNotEquals((Object)u1, (Object)u2);
        Assert.assertEquals((Object)u1, (Object)u4);
        u1.addTo(10, 20, 0.3f);
        Assert.assertEquals((Object)u1, (Object)u5);
        u1.subtractFrom(10, 20, 0.3f);
        Assert.assertEquals((Object)u1, (Object)u4);
        u1.subtractFrom(10, 0, 0.0f);
        Assert.assertEquals((Object)u1, (Object)u3);
    }

    @Test
    public void testResourceUtilizationWithCustomResource() {
        HashMap<String, Float> customResources = new HashMap<String, Float>();
        customResources.put("yarn.io/gpu", Float.valueOf(5.0f));
        ResourceUtilization u1 = ResourceUtilization.newInstance((int)10, (int)20, (float)0.5f, customResources);
        ResourceUtilization u2 = ResourceUtilization.newInstance((ResourceUtilization)u1);
        ResourceUtilization u3 = ResourceUtilization.newInstance((int)10, (int)20, (float)0.5f, customResources);
        ResourceUtilization u4 = ResourceUtilization.newInstance((int)20, (int)20, (float)0.5f, customResources);
        ResourceUtilization u5 = ResourceUtilization.newInstance((int)30, (int)40, (float)0.8f, customResources);
        Assert.assertEquals((Object)u1, (Object)u2);
        Assert.assertEquals((Object)u1, (Object)u3);
        Assert.assertNotEquals((Object)u1, (Object)u4);
        Assert.assertNotEquals((Object)u2, (Object)u5);
        Assert.assertNotEquals((Object)u4, (Object)u5);
        Assert.assertTrue((u1.hashCode() == u2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((u1.hashCode() == u3.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((u1.hashCode() == u4.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((u2.hashCode() == u5.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((u4.hashCode() == u5.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((u1.getPhysicalMemory() == 10 ? 1 : 0) != 0);
        Assert.assertFalse((u1.getVirtualMemory() == 10 ? 1 : 0) != 0);
        Assert.assertTrue((u1.getCPU() == 0.5f ? 1 : 0) != 0);
        Assert.assertTrue((u1.getCustomResource("yarn.io/gpu") == 5.0f ? 1 : 0) != 0);
        Assert.assertEquals((Object)("<pmem:10, vmem:" + u1.getVirtualMemory() + ", vCores:0.5, yarn.io/gpu:5.0>"), (Object)u1.toString());
        u1.addTo(10, 0, 0.0f);
        Assert.assertNotEquals((Object)u1, (Object)u2);
        Assert.assertEquals((Object)u1, (Object)u4);
        u1.addTo(10, 20, 0.3f);
        Assert.assertEquals((Object)u1, (Object)u5);
        u1.subtractFrom(10, 20, 0.3f);
        Assert.assertEquals((Object)u1, (Object)u4);
        u1.subtractFrom(10, 0, 0.0f);
        Assert.assertEquals((Object)u1, (Object)u3);
    }
}

