/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.util.DockerClientConfigHandler;
import org.apache.hadoop.yarn.util.DockerClientCredentialProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadConfigFileDockerClientCredentialProvider
implements DockerClientCredentialProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ReadConfigFileDockerClientCredentialProvider.class);
    private static final String CONFIG_AUTHS_KEY = "auths";
    private static final String CONFIG_AUTH_KEY = "auth";
    private String clientConfig;
    private Configuration conf;
    private String applicationId;

    @Override
    public void init(Configuration conf, String clientConfig, Path nmApplicationPrivateDir, String imageName, String applicationId) {
        this.clientConfig = clientConfig;
        this.conf = conf;
        this.applicationId = applicationId;
    }

    @Override
    public Credentials getCredential() throws IOException {
        if (this.clientConfig == null || this.clientConfig.isEmpty()) {
            return null;
        }
        Path configFile = new Path(this.clientConfig);
        return DockerClientConfigHandler.readCredentialsFromConfigFile(configFile, this.conf, this.applicationId);
    }
}

