/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import com.google.gson.Gson;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.client.api.impl.YarnTimelineServerDirectLogs;

public class FileSystemTimelineWriterForYarnDirectLogs {
    private static final Log LOG = LogFactory.getLog(FileSystemTimelineWriterForYarnDirectLogs.class);
    private FileSystem fs;
    private Path writerPath;
    private String yarnEntityLogPrefix;

    public FileSystemTimelineWriterForYarnDirectLogs(FileSystem fs, Path path) {
        this.fs = fs;
        this.writerPath = path;
        this.yarnEntityLogPrefix = "yarn-direct-logs.";
    }

    public void store(YarnTimelineServerDirectLogs logInfo) throws IOException {
        if (logInfo == null) {
            LOG.warn((Object)"logInfo is null.");
            return;
        }
        if (StringUtils.isBlank((CharSequence)logInfo.getUser())) {
            throw new IllegalArgumentException("Invalid User.");
        }
        String logInfoStr = new Gson().toJson((Object)logInfo);
        this.write(logInfoStr);
    }

    private synchronized void write(String str) throws IOException {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return;
        }
        Path logToCreatePath = new Path(this.writerPath, this.yarnEntityLogPrefix + new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        FSDataOutputStream outputStream = this.fs.exists(logToCreatePath) ? this.fs.append(logToCreatePath) : this.fs.create(logToCreatePath);
        outputStream.writeBytes(str + System.lineSeparator());
        if (outputStream != null) {
            outputStream.close();
        }
    }
}

