/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.maven.plugin.versioninfo;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.hadoop.maven.plugin.util.Exec;
import org.apache.hadoop.maven.plugin.util.FileSetUtils;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@org.apache.maven.plugins.annotations.Mojo(name="version-info")
public class VersionInfoMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(required=true)
    private FileSet source;
    @Parameter(defaultValue="version-info.build.time")
    private String buildTimeProperty;
    @Parameter(defaultValue="version-info.source.md5")
    private String md5Property;
    @Parameter(defaultValue="version-info.scm.uri")
    private String scmUriProperty;
    @Parameter(defaultValue="version-info.scm.branch")
    private String scmBranchProperty;
    @Parameter(defaultValue="version-info.scm.commit")
    private String scmCommitProperty;
    @Parameter(defaultValue="git")
    private String gitCommand;
    @Parameter(defaultValue="svn")
    private String svnCommand;
    private List<String> scmOut;

    public void execute() throws MojoExecutionException {
        try {
            SCM scm = this.determineSCM();
            this.project.getProperties().setProperty(this.buildTimeProperty, this.getBuildTime());
            this.project.getProperties().setProperty(this.scmUriProperty, this.getSCMUri(scm));
            this.project.getProperties().setProperty(this.scmBranchProperty, this.getSCMBranch(scm));
            this.project.getProperties().setProperty(this.scmCommitProperty, this.getSCMCommit(scm));
            this.project.getProperties().setProperty(this.md5Property, this.computeMD5());
        }
        catch (Throwable ex) {
            throw new MojoExecutionException(ex.toString(), ex);
        }
    }

    private String getBuildTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(new Date());
    }

    private SCM determineSCM() throws Exception {
        Exec exec = new Exec((Mojo)this);
        SCM scm = SCM.NONE;
        this.scmOut = new ArrayList<String>();
        int ret = exec.run(Arrays.asList(this.svnCommand, "info"), this.scmOut);
        if (ret == 0) {
            scm = SCM.SVN;
        } else {
            ret = exec.run(Arrays.asList(this.gitCommand, "branch"), this.scmOut);
            if (ret == 0) {
                ret = exec.run(Arrays.asList(this.gitCommand, "remote", "-v"), this.scmOut);
                if (ret != 0) {
                    scm = SCM.NONE;
                    this.scmOut = null;
                } else {
                    ret = exec.run(Arrays.asList(this.gitCommand, "log", "-n", "1"), this.scmOut);
                    if (ret != 0) {
                        scm = SCM.NONE;
                        this.scmOut = null;
                    } else {
                        scm = SCM.GIT;
                    }
                }
            }
        }
        if (this.scmOut != null) {
            this.getLog().debug((CharSequence)this.scmOut.toString());
        }
        this.getLog().info((CharSequence)("SCM: " + (Object)((Object)scm)));
        return scm;
    }

    private String[] getSvnUriInfo(String str) {
        String[] res = new String[]{"Unknown", "Unknown"};
        try {
            String path = str;
            int index = path.indexOf("trunk");
            if (index > -1) {
                res[0] = path.substring(0, index - 1);
                res[1] = "trunk";
            } else {
                index = path.indexOf("branches");
                if (index > -1) {
                    res[0] = path.substring(0, index - 1);
                    int branchIndex = index + "branches".length() + 1;
                    res[1] = (index = path.indexOf("/", branchIndex)) > -1 ? path.substring(branchIndex, index) : path.substring(branchIndex);
                }
            }
        }
        catch (Exception ex) {
            this.getLog().warn((CharSequence)("Could not determine URI & branch from SVN URI: " + str));
        }
        return res;
    }

    private String getSCMUri(SCM scm) {
        String uri = "Unknown";
        block0 : switch (scm) {
            case SVN: {
                for (String s : this.scmOut) {
                    if (!s.startsWith("URL:")) continue;
                    uri = s.substring(4).trim();
                    uri = this.getSvnUriInfo(uri)[0];
                    break block0;
                }
                break;
            }
            case GIT: {
                for (String s : this.scmOut) {
                    if (!s.startsWith("origin") || !s.endsWith("(fetch)")) continue;
                    uri = s.substring("origin".length());
                    uri = uri.substring(0, uri.length() - "(fetch)".length());
                    break block0;
                }
                break;
            }
        }
        return uri.trim();
    }

    private String getSCMCommit(SCM scm) {
        String commit = "Unknown";
        block0 : switch (scm) {
            case SVN: {
                for (String s : this.scmOut) {
                    if (!s.startsWith("Revision:")) continue;
                    commit = s.substring("Revision:".length());
                    break block0;
                }
                break;
            }
            case GIT: {
                for (String s : this.scmOut) {
                    if (!s.startsWith("commit")) continue;
                    commit = s.substring("commit".length());
                    break block0;
                }
                break;
            }
        }
        return commit.trim();
    }

    private String getSCMBranch(SCM scm) {
        String branch = "Unknown";
        block0 : switch (scm) {
            case SVN: {
                for (String s : this.scmOut) {
                    if (!s.startsWith("URL:")) continue;
                    branch = s.substring(4).trim();
                    branch = this.getSvnUriInfo(branch)[1];
                    break block0;
                }
                break;
            }
            case GIT: {
                for (String s : this.scmOut) {
                    if (!s.startsWith("*")) continue;
                    branch = s.substring("*".length());
                    break block0;
                }
                break;
            }
        }
        return branch.trim();
    }

    private byte[] readFile(File file) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        byte[] buffer = new byte[(int)raf.length()];
        raf.readFully(buffer);
        raf.close();
        return buffer;
    }

    private byte[] computeMD5(List<File> files) throws IOException, NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        for (File file : files) {
            this.getLog().debug((CharSequence)("Computing MD5 for: " + file));
            md5.update(this.readFile(file));
        }
        return md5.digest();
    }

    private String byteArrayToString(byte[] array) {
        StringBuilder sb = new StringBuilder();
        for (byte b : array) {
            sb.append(Integer.toHexString(0xFF & b));
        }
        return sb.toString();
    }

    private String computeMD5() throws Exception {
        List<File> files = FileSetUtils.convertFileSetToFiles(this.source);
        Collections.sort(files, new Comparator<File>(){

            @Override
            public int compare(File lhs, File rhs) {
                return this.normalizePath(lhs).compareTo(this.normalizePath(rhs));
            }

            private String normalizePath(File file) {
                return file.getPath().toUpperCase(Locale.ENGLISH).replaceAll("\\\\", "/");
            }
        });
        byte[] md5 = this.computeMD5(files);
        String md5str = this.byteArrayToString(md5);
        this.getLog().info((CharSequence)("Computed MD5: " + md5str));
        return md5str;
    }

    private static enum SCM {
        NONE,
        SVN,
        GIT;

    }
}

