/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.examples.WordMean;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class WordMean
extends Configured
implements Tool {
    private double mean = 0.0;
    private static final Text COUNT = new Text("count");
    private static final Text LENGTH = new Text("length");
    private static final LongWritable ONE = new LongWritable(1L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double readAndCalcMean(Path path, Configuration conf) throws IOException {
        Path file;
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (!fs.exists(file = new Path(path, "part-r-00000"))) {
            throw new IOException("Output not found!");
        }
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader((InputStream)fs.open(file)));
            long count = 0L;
            long length = 0L;
            while ((line = br.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line);
                String type = st.nextToken();
                if (type.equals(COUNT.toString())) {
                    String countLit = st.nextToken();
                    count = Long.parseLong(countLit);
                    continue;
                }
                if (!type.equals(LENGTH.toString())) continue;
                String lengthLit = st.nextToken();
                length = Long.parseLong(lengthLit);
            }
            double theMean = (double)length / (double)count;
            System.out.println("The mean is: " + theMean);
            double d = theMean;
            return d;
        }
        finally {
            br.close();
        }
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)new Configuration(), (Tool)new WordMean(), (String[])args);
    }

    public int run(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: wordmean <in> <out>");
            return 0;
        }
        Configuration conf = this.getConf();
        Job job = new Job(conf, "word mean");
        job.setJarByClass(WordMean.class);
        job.setMapperClass(WordMeanMapper.class);
        job.setCombinerClass(WordMeanReducer.class);
        job.setReducerClass(WordMeanReducer.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(LongWritable.class);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(args[0]));
        Path outputpath = new Path(args[1]);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputpath);
        boolean result = job.waitForCompletion(true);
        this.mean = this.readAndCalcMean(outputpath, conf);
        return result ? 0 : 1;
    }

    public double getMean() {
        return this.mean;
    }

    static /* synthetic */ Text access$000() {
        return LENGTH;
    }

    static /* synthetic */ Text access$100() {
        return COUNT;
    }

    static /* synthetic */ LongWritable access$200() {
        return ONE;
    }
}

