/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.pi;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.examples.pi.DistSum;
import org.apache.hadoop.examples.pi.SummationWritable;
import org.apache.hadoop.examples.pi.TaskResult;
import org.apache.hadoop.examples.pi.Util;
import org.apache.hadoop.examples.pi.math.Summation;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

/*
 * Exception performing whole class analysis ignored.
 */
public final class DistSum
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(DistSum.class);
    private static final String NAME = DistSum.class.getSimpleName();
    private static final String N_PARTS = "mapreduce.pi." + NAME + ".nParts";
    private final Util.Timer timer = new Util.Timer(true);
    private Parameters parameters;

    Parameters getParameters() {
        return this.parameters;
    }

    void setParameters(Parameters p) {
        this.parameters = p;
    }

    private Job createJob(String name, Summation sigma) throws IOException {
        Job job = new Job(this.getConf(), this.parameters.remoteDir + "/" + name);
        Configuration jobconf = job.getConfiguration();
        job.setJarByClass(DistSum.class);
        jobconf.setInt(N_PARTS, this.parameters.nParts);
        SummationWritable.write((Summation)sigma, DistSum.class, (Configuration)jobconf);
        jobconf.setLong("mapreduce.task.timeout", 0L);
        jobconf.setBoolean("mapreduce.map.speculative", false);
        jobconf.setBoolean("mapreduce.reduce.speculative", false);
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compute(String name, Summation sigma) throws IOException {
        Summation s;
        Path dir;
        if (sigma.getValue() != null) {
            throw new IOException("sigma.getValue() != null, sigma=" + sigma);
        }
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        if (!Util.createNonexistingDirectory((FileSystem)fs, (Path)(dir = fs.makeQualified(new Path(this.parameters.remoteDir, name))))) {
            return;
        }
        Job job = this.createJob(name, sigma);
        Path outdir = new Path(dir, "out");
        FileOutputFormat.setOutputPath((Job)job, (Path)outdir);
        String startmessage = "steps/parts = " + sigma.E.getSteps() + "/" + this.parameters.nParts + " = " + Util.long2string((long)(sigma.E.getSteps() / (long)this.parameters.nParts));
        Util.runJob((String)name, (Job)job, (Machine)this.parameters.machine, (String)startmessage, (Util.Timer)this.timer);
        List results = Util.readJobOutputs((FileSystem)fs, (Path)outdir);
        Util.writeResults((String)name, (List)results, (FileSystem)fs, (String)this.parameters.remoteDir);
        fs.delete(dir, true);
        List combined = Util.combine((Collection)results);
        PrintWriter out = Util.createWriter((File)this.parameters.localDir, (String)name);
        try {
            for (TaskResult r : combined) {
                String s2 = DistSum.taskResult2string((String)name, (TaskResult)r);
                out.println(s2);
                out.flush();
                Util.out.println(s2);
            }
        }
        finally {
            out.close();
        }
        if (combined.size() == 1 && sigma.contains(s = ((TaskResult)combined.get(0)).getElement()) && s.contains(sigma)) {
            sigma.setValue(s.getValue().doubleValue());
        }
    }

    public static String taskResult2string(String name, TaskResult result) {
        return NAME + " " + name + "> " + result;
    }

    public static Map.Entry<String, TaskResult> string2TaskResult(String s) {
        int j = s.indexOf(NAME);
        if (j == 0) {
            int i = j + NAME.length() + 1;
            j = s.indexOf("> ", i);
            String key = s.substring(i, j);
            TaskResult value = TaskResult.valueOf((String)s.substring(j + 2));
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        return null;
    }

    private Summation execute(String name, Summation sigma) {
        Summation[] summations = sigma.partition(this.parameters.nJobs);
        ArrayList<Computation> computations = new ArrayList<Computation>();
        for (int i = 0; i < summations.length; ++i) {
            computations.add(new Computation(this, i, name, summations[i]));
        }
        try {
            Util.execute((int)this.parameters.nThreads, computations);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        List combined = Util.combine(Arrays.asList(summations));
        return combined.size() == 1 ? (Summation)combined.get(0) : null;
    }

    public int run(String[] args) throws Exception {
        if (args.length != 8) {
            return Util.printUsage((String[])args, (String)(this.getClass().getName() + " <name> <sigma> " + "<nThreads> <nJobs> <type> <nPart> <remoteDir> <localDir>" + "\n  <name> The name." + "\n  <sigma> The summation." + "\n  <nThreads> The number of working threads.\n  <nJobs> The number of jobs per sum.\n  <type> 'm' for map side job, 'r' for reduce side job, 'x' for mix type.\n  <nPart> The number of parts per job.\n  <remoteDir> Remote directory for submitting jobs.\n  <localDir> Local directory for storing output files."));
        }
        int i = 0;
        String name = args[i++];
        Summation sigma = Summation.valueOf((String)args[i++]);
        this.setParameters(Parameters.parse((String[])args, (int)i));
        Util.out.println();
        Util.out.println("name  = " + name);
        Util.out.println("sigma = " + sigma);
        Util.out.println(this.parameters);
        Util.out.println();
        Summation result = this.execute(name, sigma);
        if (result.equals((Object)sigma)) {
            sigma.setValue(result.getValue().doubleValue());
            this.timer.tick("\n\nDONE\n\nsigma=" + sigma);
            return 0;
        }
        this.timer.tick("\n\nDONE WITH ERROR\n\nresult=" + result);
        return 1;
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run(null, (Tool)new DistSum(), (String[])args));
    }

    static /* synthetic */ Log access$300() {
        return LOG;
    }

    static /* synthetic */ String access$400() {
        return N_PARTS;
    }

    static /* synthetic */ void access$600(DistSum x0, String x1, Summation x2) throws IOException {
        x0.compute(x1, x2);
    }
}

