/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.ReadaheadPool;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.ShuffleHandler;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.api.ApplicationInitializationContext;
import org.apache.hadoop.yarn.server.api.ApplicationTerminationContext;
import org.apache.hadoop.yarn.server.api.AuxiliaryService;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ShuffleHandler
extends AuxiliaryService {
    private static final Log LOG = LogFactory.getLog(ShuffleHandler.class);
    public static final String SHUFFLE_MANAGE_OS_CACHE = "mapreduce.shuffle.manage.os.cache";
    public static final boolean DEFAULT_SHUFFLE_MANAGE_OS_CACHE = true;
    public static final String SHUFFLE_READAHEAD_BYTES = "mapreduce.shuffle.readahead.bytes";
    public static final int DEFAULT_SHUFFLE_READAHEAD_BYTES = 0x400000;
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection.*reset|connection.*closed|broken.*pipe).*$", 2);
    private int port;
    private ChannelFactory selector;
    private final ChannelGroup accepted = new DefaultChannelGroup();
    protected HttpPipelineFactory pipelineFact;
    private int sslFileBufferSize;
    private boolean manageOsCache;
    private int readaheadLength;
    private int maxShuffleConnections;
    private int shuffleBufferSize;
    private boolean shuffleTransferToAllowed;
    private ReadaheadPool readaheadPool = ReadaheadPool.getInstance();
    public static final String MAPREDUCE_SHUFFLE_SERVICEID = "mapreduce_shuffle";
    private static final Map<String, String> userRsrc = new ConcurrentHashMap();
    private static final JobTokenSecretManager secretManager = new JobTokenSecretManager();
    public static final String SHUFFLE_PORT_CONFIG_KEY = "mapreduce.shuffle.port";
    public static final int DEFAULT_SHUFFLE_PORT = 13562;
    public static final String SHUFFLE_CONNECTION_KEEP_ALIVE_ENABLED = "mapreduce.shuffle.connection-keep-alive.enable";
    public static final boolean DEFAULT_SHUFFLE_CONNECTION_KEEP_ALIVE_ENABLED = false;
    public static final String SHUFFLE_CONNECTION_KEEP_ALIVE_TIME_OUT = "mapreduce.shuffle.connection-keep-alive.timeout";
    public static final int DEFAULT_SHUFFLE_CONNECTION_KEEP_ALIVE_TIME_OUT = 5;
    public static final String SHUFFLE_MAPOUTPUT_META_INFO_CACHE_SIZE = "mapreduce.shuffle.mapoutput-info.meta.cache.size";
    public static final int DEFAULT_SHUFFLE_MAPOUTPUT_META_INFO_CACHE_SIZE = 1000;
    public static final String CONNECTION_CLOSE = "close";
    public static final String SUFFLE_SSL_FILE_BUFFER_SIZE_KEY = "mapreduce.shuffle.ssl.file.buffer.size";
    public static final int DEFAULT_SUFFLE_SSL_FILE_BUFFER_SIZE = 61440;
    public static final String MAX_SHUFFLE_CONNECTIONS = "mapreduce.shuffle.max.connections";
    public static final int DEFAULT_MAX_SHUFFLE_CONNECTIONS = 0;
    public static final String MAX_SHUFFLE_THREADS = "mapreduce.shuffle.max.threads";
    public static final int DEFAULT_MAX_SHUFFLE_THREADS = 0;
    public static final String SHUFFLE_BUFFER_SIZE = "mapreduce.shuffle.transfer.buffer.size";
    public static final int DEFAULT_SHUFFLE_BUFFER_SIZE = 131072;
    public static final String SHUFFLE_TRANSFERTO_ALLOWED = "mapreduce.shuffle.transferTo.allowed";
    public static final boolean DEFAULT_SHUFFLE_TRANSFERTO_ALLOWED = true;
    public static final boolean WINDOWS_DEFAULT_SHUFFLE_TRANSFERTO_ALLOWED = false;
    boolean connectionKeepAliveEnabled = false;
    int connectionKeepAliveTimeOut;
    int mapOutputMetaInfoCacheSize;
    final ShuffleMetrics metrics;

    ShuffleHandler(MetricsSystem ms) {
        super("httpshuffle");
        this.metrics = (ShuffleMetrics)ms.register((Object)new ShuffleMetrics());
    }

    public ShuffleHandler() {
        this(DefaultMetricsSystem.instance());
    }

    public static ByteBuffer serializeMetaData(int port) throws IOException {
        DataOutputBuffer port_dob = new DataOutputBuffer();
        port_dob.writeInt(port);
        return ByteBuffer.wrap(port_dob.getData(), 0, port_dob.getLength());
    }

    public static int deserializeMetaData(ByteBuffer meta) throws IOException {
        DataInputByteBuffer in = new DataInputByteBuffer();
        in.reset(new ByteBuffer[]{meta});
        int port = in.readInt();
        return port;
    }

    public static ByteBuffer serializeServiceData(Token<JobTokenIdentifier> jobToken) throws IOException {
        DataOutputBuffer jobToken_dob = new DataOutputBuffer();
        jobToken.write((DataOutput)jobToken_dob);
        return ByteBuffer.wrap(jobToken_dob.getData(), 0, jobToken_dob.getLength());
    }

    static Token<JobTokenIdentifier> deserializeServiceData(ByteBuffer secret) throws IOException {
        DataInputByteBuffer in = new DataInputByteBuffer();
        in.reset(new ByteBuffer[]{secret});
        Token jt = new Token();
        jt.readFields((DataInput)in);
        return jt;
    }

    public void initializeApplication(ApplicationInitializationContext context) {
        String user = context.getUser();
        ApplicationId appId = context.getApplicationId();
        ByteBuffer secret = context.getApplicationDataForService();
        try {
            Token jt = ShuffleHandler.deserializeServiceData((ByteBuffer)secret);
            JobID jobId = new JobID(Long.toString(appId.getClusterTimestamp()), appId.getId());
            userRsrc.put(jobId.toString(), user);
            LOG.info((Object)("Added token for " + jobId.toString()));
            secretManager.addTokenForJob(jobId.toString(), jt);
        }
        catch (IOException e) {
            LOG.error((Object)"Error during initApp", (Throwable)e);
        }
    }

    public void stopApplication(ApplicationTerminationContext context) {
        ApplicationId appId = context.getApplicationId();
        JobID jobId = new JobID(Long.toString(appId.getClusterTimestamp()), appId.getId());
        secretManager.removeTokenForJob(jobId.toString());
        userRsrc.remove(jobId.toString());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.manageOsCache = conf.getBoolean("mapreduce.shuffle.manage.os.cache", true);
        this.readaheadLength = conf.getInt("mapreduce.shuffle.readahead.bytes", 0x400000);
        this.maxShuffleConnections = conf.getInt("mapreduce.shuffle.max.connections", 0);
        int maxShuffleThreads = conf.getInt("mapreduce.shuffle.max.threads", 0);
        if (maxShuffleThreads == 0) {
            maxShuffleThreads = 2 * Runtime.getRuntime().availableProcessors();
        }
        this.shuffleBufferSize = conf.getInt("mapreduce.shuffle.transfer.buffer.size", 131072);
        this.shuffleTransferToAllowed = conf.getBoolean("mapreduce.shuffle.transferTo.allowed", !Shell.WINDOWS);
        ThreadFactory bossFactory = new ThreadFactoryBuilder().setNameFormat("ShuffleHandler Netty Boss #%d").build();
        ThreadFactory workerFactory = new ThreadFactoryBuilder().setNameFormat("ShuffleHandler Netty Worker #%d").build();
        this.selector = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(bossFactory), (Executor)Executors.newCachedThreadPool(workerFactory), maxShuffleThreads);
        super.serviceInit(new Configuration(conf));
    }

    protected void serviceStart() throws Exception {
        Configuration conf = this.getConfig();
        ServerBootstrap bootstrap = new ServerBootstrap(this.selector);
        try {
            this.pipelineFact = new HttpPipelineFactory(this, conf);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        bootstrap.setPipelineFactory((ChannelPipelineFactory)this.pipelineFact);
        this.port = conf.getInt("mapreduce.shuffle.port", 13562);
        Channel ch = bootstrap.bind((SocketAddress)new InetSocketAddress(this.port));
        this.accepted.add((Object)ch);
        this.port = ((InetSocketAddress)ch.getLocalAddress()).getPort();
        conf.set("mapreduce.shuffle.port", Integer.toString(this.port));
        this.pipelineFact.SHUFFLE.setPort(this.port);
        LOG.info((Object)(this.getName() + " listening on port " + this.port));
        super.serviceStart();
        this.sslFileBufferSize = conf.getInt("mapreduce.shuffle.ssl.file.buffer.size", 61440);
        this.connectionKeepAliveEnabled = conf.getBoolean("mapreduce.shuffle.connection-keep-alive.enable", false);
        this.connectionKeepAliveTimeOut = Math.max(1, conf.getInt("mapreduce.shuffle.connection-keep-alive.timeout", 5));
        this.mapOutputMetaInfoCacheSize = Math.max(1, conf.getInt("mapreduce.shuffle.mapoutput-info.meta.cache.size", 1000));
    }

    protected void serviceStop() throws Exception {
        this.accepted.close().awaitUninterruptibly(10L, TimeUnit.SECONDS);
        if (this.selector != null) {
            ServerBootstrap bootstrap = new ServerBootstrap(this.selector);
            bootstrap.releaseExternalResources();
        }
        if (this.pipelineFact != null) {
            this.pipelineFact.destroy();
        }
        super.serviceStop();
    }

    public synchronized ByteBuffer getMetaData() {
        try {
            return ShuffleHandler.serializeMetaData((int)this.port);
        }
        catch (IOException e) {
            LOG.error((Object)"Error during getMeta", (Throwable)e);
            return null;
        }
    }

    protected Shuffle getShuffle(Configuration conf) {
        return new Shuffle(this, conf);
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }

    static /* synthetic */ int access$100(ShuffleHandler x0) {
        return x0.maxShuffleConnections;
    }

    static /* synthetic */ ChannelGroup access$200(ShuffleHandler x0) {
        return x0.accepted;
    }

    static /* synthetic */ Map access$300() {
        return userRsrc;
    }

    static /* synthetic */ JobTokenSecretManager access$400() {
        return secretManager;
    }

    static /* synthetic */ boolean access$500(ShuffleHandler x0) {
        return x0.manageOsCache;
    }

    static /* synthetic */ int access$600(ShuffleHandler x0) {
        return x0.readaheadLength;
    }

    static /* synthetic */ ReadaheadPool access$700(ShuffleHandler x0) {
        return x0.readaheadPool;
    }

    static /* synthetic */ int access$800(ShuffleHandler x0) {
        return x0.shuffleBufferSize;
    }

    static /* synthetic */ boolean access$900(ShuffleHandler x0) {
        return x0.shuffleTransferToAllowed;
    }

    static /* synthetic */ int access$1000(ShuffleHandler x0) {
        return x0.sslFileBufferSize;
    }

    static /* synthetic */ Pattern access$1100() {
        return IGNORABLE_ERROR_MESSAGE;
    }
}

