/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.nio.ByteBuffer;
import org.apache.hadoop.mapred.ShuffleHandler;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.hadoop.test.MockitoMaker;
import org.jboss.netty.channel.ChannelFuture;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestShuffleHandler {
    static final long MiB = 0x100000L;

    @Test
    public void testSerializeMeta() throws Exception {
        Assert.assertEquals((long)1L, (long)ShuffleHandler.deserializeMetaData((ByteBuffer)ShuffleHandler.serializeMetaData((int)1)));
        Assert.assertEquals((long)-1L, (long)ShuffleHandler.deserializeMetaData((ByteBuffer)ShuffleHandler.serializeMetaData((int)-1)));
        Assert.assertEquals((long)8080L, (long)ShuffleHandler.deserializeMetaData((ByteBuffer)ShuffleHandler.serializeMetaData((int)8080)));
    }

    @Test
    public void testShuffleMetrics() throws Exception {
        MetricsSystemImpl ms = new MetricsSystemImpl();
        ShuffleHandler sh = new ShuffleHandler((MetricsSystem)ms);
        ChannelFuture cf = (ChannelFuture)MockitoMaker.make((Object)((ChannelFuture)MockitoMaker.stub(ChannelFuture.class).returning((Object)Boolean.valueOf((boolean)true), (Object[])new Object[]{Boolean.valueOf((boolean)false)}).from).isSuccess());
        sh.metrics.shuffleConnections.incr();
        sh.metrics.shuffleOutputBytes.incr(0x100000L);
        sh.metrics.shuffleConnections.incr();
        sh.metrics.shuffleOutputBytes.incr(0x200000L);
        TestShuffleHandler.checkShuffleMetrics((MetricsSystem)ms, (long)0x300000L, (int)0, (int)0, (int)2);
        sh.metrics.operationComplete(cf);
        sh.metrics.operationComplete(cf);
        TestShuffleHandler.checkShuffleMetrics((MetricsSystem)ms, (long)0x300000L, (int)1, (int)1, (int)0);
    }

    static void checkShuffleMetrics(MetricsSystem ms, long bytes, int failed, int succeeded, int connections) {
        MetricsSource source = ms.getSource("ShuffleMetrics");
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((MetricsSource)source);
        MetricsAsserts.assertCounter((String)"ShuffleOutputBytes", (long)bytes, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"ShuffleOutputsFailed", (int)failed, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"ShuffleOutputsOK", (int)succeeded, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"ShuffleConnections", (int)connections, (MetricsRecordBuilder)rb);
    }
}

