/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.ShuffleHandler;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServices;
import org.apache.hadoop.yarn.service.AbstractService;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ShuffleHandler
extends AbstractService
implements AuxServices.AuxiliaryService {
    private static final Log LOG = LogFactory.getLog(ShuffleHandler.class);
    private int port;
    private ChannelFactory selector;
    private final ChannelGroup accepted = new DefaultChannelGroup();
    public static final String MAPREDUCE_SHUFFLE_SERVICEID = "mapreduce.shuffle";
    private static final Map<String, String> userRsrc = new ConcurrentHashMap();
    private static final JobTokenSecretManager secretManager = new JobTokenSecretManager();
    public static final String SHUFFLE_PORT_CONFIG_KEY = "mapreduce.shuffle.port";
    public static final int DEFAULT_SHUFFLE_PORT = 8080;
    final ShuffleMetrics metrics;

    ShuffleHandler(MetricsSystem ms) {
        super("httpshuffle");
        this.metrics = (ShuffleMetrics)ms.register((Object)new ShuffleMetrics());
    }

    public ShuffleHandler() {
        this(DefaultMetricsSystem.instance());
    }

    public static ByteBuffer serializeMetaData(int port) throws IOException {
        DataOutputBuffer port_dob = new DataOutputBuffer();
        port_dob.writeInt(port);
        return ByteBuffer.wrap(port_dob.getData(), 0, port_dob.getLength());
    }

    public static int deserializeMetaData(ByteBuffer meta) throws IOException {
        DataInputByteBuffer in = new DataInputByteBuffer();
        in.reset(new ByteBuffer[]{meta});
        int port = in.readInt();
        return port;
    }

    public static ByteBuffer serializeServiceData(Token<JobTokenIdentifier> jobToken) throws IOException {
        DataOutputBuffer jobToken_dob = new DataOutputBuffer();
        jobToken.write((DataOutput)jobToken_dob);
        return ByteBuffer.wrap(jobToken_dob.getData(), 0, jobToken_dob.getLength());
    }

    static Token<JobTokenIdentifier> deserializeServiceData(ByteBuffer secret) throws IOException {
        DataInputByteBuffer in = new DataInputByteBuffer();
        in.reset(new ByteBuffer[]{secret});
        Token jt = new Token();
        jt.readFields((DataInput)in);
        return jt;
    }

    public void initApp(String user, ApplicationId appId, ByteBuffer secret) {
        try {
            Token jt = ShuffleHandler.deserializeServiceData((ByteBuffer)secret);
            JobID jobId = new JobID(Long.toString(appId.getClusterTimestamp()), appId.getId());
            userRsrc.put(jobId.toString(), user);
            LOG.info((Object)("Added token for " + jobId.toString()));
            secretManager.addTokenForJob(jobId.toString(), jt);
        }
        catch (IOException e) {
            LOG.error((Object)"Error during initApp", (Throwable)e);
        }
    }

    public void stopApp(ApplicationId appId) {
        JobID jobId = new JobID(Long.toString(appId.getClusterTimestamp()), appId.getId());
        secretManager.removeTokenForJob(jobId.toString());
        userRsrc.remove(jobId.toString());
    }

    public synchronized void init(Configuration conf) {
        ThreadFactory bossFactory = new ThreadFactoryBuilder().setNameFormat("ShuffleHandler Netty Boss #%d").build();
        ThreadFactory workerFactory = new ThreadFactoryBuilder().setNameFormat("ShuffleHandler Netty Worker #%d").build();
        this.selector = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(bossFactory), (Executor)Executors.newCachedThreadPool(workerFactory));
        super.init(new Configuration(conf));
    }

    public synchronized void start() {
        Configuration conf = this.getConfig();
        ServerBootstrap bootstrap = new ServerBootstrap(this.selector);
        HttpPipelineFactory pipelineFact = new HttpPipelineFactory(this, conf);
        bootstrap.setPipelineFactory((ChannelPipelineFactory)pipelineFact);
        this.port = conf.getInt("mapreduce.shuffle.port", 8080);
        Channel ch = bootstrap.bind((SocketAddress)new InetSocketAddress(this.port));
        this.accepted.add((Object)ch);
        this.port = ((InetSocketAddress)ch.getLocalAddress()).getPort();
        conf.set("mapreduce.shuffle.port", Integer.toString(this.port));
        pipelineFact.SHUFFLE.setPort(this.port);
        LOG.info((Object)(this.getName() + " listening on port " + this.port));
        super.start();
    }

    public synchronized void stop() {
        this.accepted.close().awaitUninterruptibly(10L, TimeUnit.SECONDS);
        ServerBootstrap bootstrap = new ServerBootstrap(this.selector);
        bootstrap.releaseExternalResources();
        super.stop();
    }

    public synchronized ByteBuffer getMeta() {
        try {
            return ShuffleHandler.serializeMetaData((int)this.port);
        }
        catch (IOException e) {
            LOG.error((Object)"Error during getMeta", (Throwable)e);
            return null;
        }
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }

    static /* synthetic */ Map access$100() {
        return userRsrc;
    }

    static /* synthetic */ JobTokenSecretManager access$200() {
        return secretManager;
    }
}

