/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobHistoryFileReplayMapperV1;
import org.apache.hadoop.mapreduce.JobHistoryFileReplayMapperV2;
import org.apache.hadoop.mapreduce.SimpleEntityWriterV1;
import org.apache.hadoop.mapreduce.SimpleEntityWriterV2;
import org.apache.hadoop.mapreduce.SleepJob;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TimelineServicePerformance
extends Configured
implements Tool {
    static final int NUM_MAPS_DEFAULT = 1;
    static final int SIMPLE_ENTITY_WRITER = 1;
    static final int JOB_HISTORY_FILE_REPLAY_MAPPER = 2;
    static int mapperType = 1;
    static final int TIMELINE_SERVICE_VERSION_1 = 1;
    static final int TIMELINE_SERVICE_VERSION_2 = 2;
    static int timeline_service_version = 1;

    protected static int printUsage() {
        System.err.println("Usage: [-m <maps>] number of mappers (default: 1)\n     [-v] timeline service version (default: 1)\n          1. version 1.x\n          2. version 2.x\n     [-mtype <mapper type in integer>] (default: 1)\n          1. simple entity write mapper\n          2. jobhistory files replay mapper\n     [-s <(KBs)test>] number of KB per put (mtype=1, default: 1 KB)\n     [-t] package sending iterations per mapper (mtype=1, default: 100)\n     [-d <path>] hdfs root path of job history files (mtype=2)\n     [-r <replay mode>] (mtype=2)\n          1. write all entities for a job in one put (default)\n          2. write one entity at a time\n");
        GenericOptionsParser.printGenericCommandUsage((PrintStream)System.err);
        return -1;
    }

    public static boolean parseArgs(String[] args, Job job) throws IOException {
        Configuration conf = job.getConfiguration();
        conf.setInt("mapreduce.job.maps", 1);
        for (int i = 0; i < args.length; ++i) {
            if (args.length == i + 1) {
                System.out.println("ERROR: Required parameter missing from " + args[i]);
                return TimelineServicePerformance.printUsage() == 0;
            }
            try {
                if ("-v".equals(args[i])) {
                    timeline_service_version = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-m".equals(args[i])) {
                    if (Integer.parseInt(args[++i]) > 0) {
                        job.getConfiguration().setInt("mapreduce.job.maps", Integer.parseInt(args[i]));
                    }
                    continue;
                }
                if ("-mtype".equals(args[i])) {
                    mapperType = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-s".equals(args[i])) {
                    if (Integer.parseInt(args[++i]) > 0) {
                        conf.setInt("kbs sent", Integer.parseInt(args[i]));
                    }
                    continue;
                }
                if ("-t".equals(args[i])) {
                    if (Integer.parseInt(args[++i]) > 0) {
                        conf.setInt("testtimes", Integer.parseInt(args[i]));
                    }
                    continue;
                }
                if ("-d".equals(args[i])) {
                    conf.set("processing path", args[++i]);
                    continue;
                }
                if ("-r".equals(args[i])) {
                    conf.setInt("replay mode", Integer.parseInt(args[++i]));
                    continue;
                }
                System.out.println("Unexpected argument: " + args[i]);
                return TimelineServicePerformance.printUsage() == 0;
            }
            catch (NumberFormatException except) {
                System.out.println("ERROR: Integer expected instead of " + args[i]);
                return TimelineServicePerformance.printUsage() == 0;
            }
            catch (Exception e) {
                throw (IOException)new IOException().initCause(e);
            }
        }
        block1 : switch (mapperType) {
            case 2: {
                String processingPath = conf.get("processing path");
                if (processingPath == null || processingPath.isEmpty()) {
                    System.out.println("processing path is missing while mtype = 2");
                    return TimelineServicePerformance.printUsage() == 0;
                }
                switch (timeline_service_version) {
                    case 2: {
                        job.setMapperClass(JobHistoryFileReplayMapperV2.class);
                        break block1;
                    }
                }
                job.setMapperClass(JobHistoryFileReplayMapperV1.class);
                break;
            }
            default: {
                conf.setLong("timeline.server.performance.run.id", System.currentTimeMillis());
                switch (timeline_service_version) {
                    case 2: {
                        job.setMapperClass(SimpleEntityWriterV2.class);
                        break block1;
                    }
                }
                job.setMapperClass(SimpleEntityWriterV1.class);
            }
        }
        return true;
    }

    public int run(String[] args) throws Exception {
        int ret;
        Job job = Job.getInstance((Configuration)this.getConf());
        job.setJarByClass(TimelineServicePerformance.class);
        job.setMapperClass(SimpleEntityWriterV1.class);
        job.setInputFormatClass(SleepJob.SleepInputFormat.class);
        job.setOutputFormatClass(NullOutputFormat.class);
        job.setNumReduceTasks(0);
        if (!TimelineServicePerformance.parseArgs(args, job)) {
            return -1;
        }
        Date startTime = new Date();
        System.out.println("Job started: " + startTime);
        int n = ret = job.waitForCompletion(true) ? 0 : 1;
        if (job.isSuccessful()) {
            Counters counters = job.getCounters();
            long writecounts = counters.findCounter((Enum)PerfCounters.TIMELINE_SERVICE_WRITE_COUNTER).getValue();
            long writefailures = counters.findCounter((Enum)PerfCounters.TIMELINE_SERVICE_WRITE_FAILURES).getValue();
            if (writefailures > 0L && writefailures == writecounts) {
                System.out.println("Job failed: all writes failed!");
            } else {
                long writetime = counters.findCounter((Enum)PerfCounters.TIMELINE_SERVICE_WRITE_TIME).getValue();
                long writesize = counters.findCounter((Enum)PerfCounters.TIMELINE_SERVICE_WRITE_KBS).getValue();
                if (writetime == 0L) {
                    System.out.println("Job failed: write time is 0!");
                } else {
                    double transacrate = (double)(writecounts * 1000L) / (double)writetime;
                    double iorate = (double)(writesize * 1000L) / (double)writetime;
                    int numMaps = Integer.parseInt(job.getConfiguration().get("mapreduce.job.maps"));
                    System.out.println("TRANSACTION RATE (per mapper): " + transacrate + " ops/s");
                    System.out.println("IO RATE (per mapper): " + iorate + " KB/s");
                    System.out.println("TRANSACTION RATE (total): " + transacrate * (double)numMaps + " ops/s");
                    System.out.println("IO RATE (total): " + iorate * (double)numMaps + " KB/s");
                }
            }
        } else {
            System.out.println("Job failed: " + job.getStatus().getFailureInfo());
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new TimelineServicePerformance(), (String[])args);
        System.exit(res);
    }

    static enum PerfCounters {
        TIMELINE_SERVICE_WRITE_TIME,
        TIMELINE_SERVICE_WRITE_COUNTER,
        TIMELINE_SERVICE_WRITE_FAILURES,
        TIMELINE_SERVICE_WRITE_KBS;

    }
}

