/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.BitSet;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.CombineFileSplit;
import org.apache.hadoop.mapred.lib.CombineSequenceFileInputFormat;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCombineSequenceFileInputFormat {
    private static final Logger LOG = LoggerFactory.getLogger(TestCombineSequenceFileInputFormat.class);
    private static Configuration conf = new Configuration();
    private static FileSystem localFs = null;
    private static Path workDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testFormat() throws Exception {
        JobConf job = new JobConf(conf);
        Reporter reporter = Reporter.NULL;
        Random random = new Random();
        long seed = random.nextLong();
        LOG.info("seed = " + seed);
        random.setSeed(seed);
        localFs.delete(workDir, true);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{workDir});
        int length = 10000;
        int numFiles = 10;
        TestCombineSequenceFileInputFormat.createFiles(10000, 10, random);
        CombineSequenceFileInputFormat format = new CombineSequenceFileInputFormat();
        IntWritable key = new IntWritable();
        BytesWritable value = new BytesWritable();
        for (int i = 0; i < 3; ++i) {
            int numSplits = random.nextInt(1) + 1;
            LOG.info("splitting: requesting = " + numSplits);
            InputSplit[] splits = format.getSplits(job, numSplits);
            LOG.info("splitting: got =        " + splits.length);
            Assert.assertEquals((String)"We got more than one splits!", (long)1L, (long)splits.length);
            InputSplit split = splits[0];
            Assert.assertEquals((String)"It should be CombineFileSplit", CombineFileSplit.class, split.getClass());
            BitSet bits = new BitSet(10000);
            try (RecordReader reader = format.getRecordReader(split, job, reporter);){
                while (reader.next((Object)key, (Object)value)) {
                    Assert.assertFalse((String)"Key in multiple partitions.", (boolean)bits.get(key.get()));
                    bits.set(key.get());
                }
            }
            Assert.assertEquals((String)"Some keys in no partition.", (long)10000L, (long)bits.cardinality());
        }
    }

    private static Range[] createRanges(int length, int numFiles, Random random) {
        Range[] ranges = new Range[numFiles];
        for (int i = 0; i < numFiles; ++i) {
            int start = i == 0 ? 0 : ranges[i - 1].end;
            int end = i == numFiles - 1 ? length : length / numFiles * (2 * i + 1) / 2 + random.nextInt(length / numFiles) + 1;
            ranges[i] = new Range(start, end);
        }
        return ranges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createFiles(int length, int numFiles, Random random) throws IOException {
        Range[] ranges = TestCombineSequenceFileInputFormat.createRanges(length, numFiles, random);
        for (int i = 0; i < numFiles; ++i) {
            Path file = new Path(workDir, "test_" + i + ".seq");
            Range range = ranges[i];
            try (SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)localFs, (Configuration)conf, (Path)file, IntWritable.class, BytesWritable.class);){
                for (int j = range.start; j < range.end; ++j) {
                    IntWritable key = new IntWritable(j);
                    byte[] data = new byte[random.nextInt(10)];
                    random.nextBytes(data);
                    BytesWritable value = new BytesWritable(data);
                    writer.append((Writable)key, (Writable)value);
                }
                continue;
            }
        }
    }

    static {
        try {
            conf.set("fs.defaultFS", "file:///");
            localFs = FileSystem.getLocal((Configuration)conf);
        }
        catch (IOException e) {
            throw new RuntimeException("init failure", e);
        }
        workDir = localFs.makeQualified(new Path(System.getProperty("test.build.data", "/tmp"), "TestCombineSequenceFileInputFormat"));
    }

    private static class Range {
        private final int start;
        private final int end;

        Range(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return "(" + this.start + ", " + this.end + ")";
        }
    }
}

