/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.FixedLengthInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FixedLengthRecordReader;
import org.apache.hadoop.mapreduce.task.MapContextImpl;
import org.apache.hadoop.util.ReflectionUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestFixedLengthInputFormat {
    private static Log LOG;
    private static Configuration defaultConf;
    private static FileSystem localFs;
    private static Path workDir;
    private static char[] chars;
    private static Random charRand;

    @BeforeClass
    public static void onlyOnce() {
        try {
            LOG = LogFactory.getLog((String)TestFixedLengthInputFormat.class.getName());
            defaultConf = new Configuration();
            defaultConf.set("fs.defaultFS", "file:///");
            localFs = FileSystem.getLocal((Configuration)defaultConf);
            chars = "abcdefghijklmnopqrstuvABCDEFGHIJKLMN OPQRSTUVWXYZ1234567890)(*&^%$#@!-=><?:\"{}][';/.,']".toCharArray();
            workDir = new Path(new Path(System.getProperty("test.build.data", "."), "data"), "TestKeyValueFixedLengthInputFormat");
            charRand = new Random();
        }
        catch (IOException e) {
            throw new RuntimeException("init failure", e);
        }
    }

    @Test(timeout=500000L)
    public void testFormat() throws Exception {
        this.runRandomTests(null);
    }

    @Test(timeout=500000L)
    public void testFormatCompressedIn() throws Exception {
        this.runRandomTests((CompressionCodec)new GzipCodec());
    }

    @Test(timeout=5000L)
    public void testNoRecordLength() throws Exception {
        localFs.delete(workDir, true);
        Path file = new Path(workDir, new String("testFormat.txt"));
        this.createFile(file, null, 10, 10);
        Job job = Job.getInstance((Configuration)defaultConf);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{workDir});
        FixedLengthInputFormat format = new FixedLengthInputFormat();
        List splits = format.getSplits((JobContext)job);
        boolean exceptionThrown = false;
        for (InputSplit split : splits) {
            try {
                TaskAttemptContext context = MapReduceTestUtil.createDummyMapTaskAttemptContext(job.getConfiguration());
                RecordReader reader = format.createRecordReader(split, context);
                MapContextImpl mcontext = new MapContextImpl(job.getConfiguration(), context.getTaskAttemptID(), reader, null, null, MapReduceTestUtil.createDummyReporter(), split);
                reader.initialize(split, (TaskAttemptContext)mcontext);
            }
            catch (IOException ioe) {
                exceptionThrown = true;
                LOG.info((Object)("Exception message:" + ioe.getMessage()));
            }
        }
        Assert.assertTrue((String)"Exception for not setting record length:", (boolean)exceptionThrown);
    }

    @Test(timeout=5000L)
    public void testZeroRecordLength() throws Exception {
        localFs.delete(workDir, true);
        Path file = new Path(workDir, new String("testFormat.txt"));
        this.createFile(file, null, 10, 10);
        Job job = Job.getInstance((Configuration)defaultConf);
        FixedLengthInputFormat format = new FixedLengthInputFormat();
        FixedLengthInputFormat.setRecordLength((Configuration)job.getConfiguration(), (int)0);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{workDir});
        List splits = format.getSplits((JobContext)job);
        boolean exceptionThrown = false;
        for (InputSplit split : splits) {
            try {
                TaskAttemptContext context = MapReduceTestUtil.createDummyMapTaskAttemptContext(job.getConfiguration());
                RecordReader reader = format.createRecordReader(split, context);
                MapContextImpl mcontext = new MapContextImpl(job.getConfiguration(), context.getTaskAttemptID(), reader, null, null, MapReduceTestUtil.createDummyReporter(), split);
                reader.initialize(split, (TaskAttemptContext)mcontext);
            }
            catch (IOException ioe) {
                exceptionThrown = true;
                LOG.info((Object)("Exception message:" + ioe.getMessage()));
            }
        }
        Assert.assertTrue((String)"Exception for zero record length:", (boolean)exceptionThrown);
    }

    @Test(timeout=5000L)
    public void testNegativeRecordLength() throws Exception {
        localFs.delete(workDir, true);
        Path file = new Path(workDir, new String("testFormat.txt"));
        this.createFile(file, null, 10, 10);
        Job job = Job.getInstance((Configuration)defaultConf);
        FixedLengthInputFormat format = new FixedLengthInputFormat();
        FixedLengthInputFormat.setRecordLength((Configuration)job.getConfiguration(), (int)-10);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{workDir});
        List splits = format.getSplits((JobContext)job);
        boolean exceptionThrown = false;
        for (InputSplit split : splits) {
            try {
                TaskAttemptContext context = MapReduceTestUtil.createDummyMapTaskAttemptContext(job.getConfiguration());
                RecordReader reader = format.createRecordReader(split, context);
                MapContextImpl mcontext = new MapContextImpl(job.getConfiguration(), context.getTaskAttemptID(), reader, null, null, MapReduceTestUtil.createDummyReporter(), split);
                reader.initialize(split, (TaskAttemptContext)mcontext);
            }
            catch (IOException ioe) {
                exceptionThrown = true;
                LOG.info((Object)("Exception message:" + ioe.getMessage()));
            }
        }
        Assert.assertTrue((String)"Exception for negative record length:", (boolean)exceptionThrown);
    }

    @Test(timeout=5000L)
    public void testPartialRecordCompressedIn() throws Exception {
        GzipCodec gzip = new GzipCodec();
        this.runPartialRecordTest((CompressionCodec)gzip);
    }

    @Test(timeout=5000L)
    public void testPartialRecordUncompressedIn() throws Exception {
        this.runPartialRecordTest(null);
    }

    @Test(timeout=5000L)
    public void testGzipWithTwoInputs() throws Exception {
        GzipCodec gzip = new GzipCodec();
        localFs.delete(workDir, true);
        Job job = Job.getInstance((Configuration)defaultConf);
        FixedLengthInputFormat format = new FixedLengthInputFormat();
        FixedLengthInputFormat.setRecordLength((Configuration)job.getConfiguration(), (int)5);
        ReflectionUtils.setConf((Object)gzip, (Configuration)job.getConfiguration());
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{workDir});
        TestFixedLengthInputFormat.writeFile(localFs, new Path(workDir, "part1.txt.gz"), (CompressionCodec)gzip, "one  two  threefour five six  seveneightnine ten  ");
        TestFixedLengthInputFormat.writeFile(localFs, new Path(workDir, "part2.txt.gz"), (CompressionCodec)gzip, "ten  nine eightsevensix  five four threetwo  one  ");
        List splits = format.getSplits((JobContext)job);
        Assert.assertEquals((String)"compressed splits == 2", (long)2L, (long)splits.size());
        FileSplit tmp = (FileSplit)splits.get(0);
        if (tmp.getPath().getName().equals("part2.txt.gz")) {
            splits.set(0, splits.get(1));
            splits.set(1, tmp);
        }
        List<String> results = TestFixedLengthInputFormat.readSplit(format, (InputSplit)splits.get(0), job);
        Assert.assertEquals((String)"splits[0] length", (long)10L, (long)results.size());
        Assert.assertEquals((String)"splits[0][5]", (Object)"six  ", (Object)results.get(5));
        results = TestFixedLengthInputFormat.readSplit(format, (InputSplit)splits.get(1), job);
        Assert.assertEquals((String)"splits[1] length", (long)10L, (long)results.size());
        Assert.assertEquals((String)"splits[1][0]", (Object)"ten  ", (Object)results.get(0));
        Assert.assertEquals((String)"splits[1][1]", (Object)"nine ", (Object)results.get(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> createFile(Path targetFile, CompressionCodec codec, int recordLen, int numRecords) throws IOException {
        ArrayList<String> recordList = new ArrayList<String>(numRecords);
        FSDataOutputStream ostream = localFs.create(targetFile);
        if (codec != null) {
            ostream = codec.createOutputStream((OutputStream)ostream);
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)ostream);
        try {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < numRecords; ++i) {
                for (int j = 0; j < recordLen; ++j) {
                    sb.append(chars[charRand.nextInt(chars.length)]);
                }
                String recordData = sb.toString();
                recordList.add(recordData);
                writer.write(recordData);
                sb.setLength(0);
            }
        }
        finally {
            ((Writer)writer).close();
        }
        return recordList;
    }

    private void runRandomTests(CompressionCodec codec) throws Exception {
        StringBuilder fileName = new StringBuilder("testFormat.txt");
        if (codec != null) {
            fileName.append(".gz");
        }
        localFs.delete(workDir, true);
        Path file = new Path(workDir, fileName.toString());
        int seed = new Random().nextInt();
        LOG.info((Object)("Seed = " + seed));
        Random random = new Random(seed);
        int MAX_TESTS = 20;
        for (int i = 0; i < MAX_TESTS; ++i) {
            LOG.info((Object)"----------------------------------------------------------");
            int totalRecords = random.nextInt(999) + 1;
            if (i == 8) {
                totalRecords = 0;
            }
            int recordLength = random.nextInt(102400) + 1;
            if (i == 10) {
                recordLength = 1;
            }
            int fileSize = totalRecords * recordLength;
            LOG.info((Object)("totalRecords=" + totalRecords + " recordLength=" + recordLength));
            Job job = Job.getInstance((Configuration)defaultConf);
            if (codec != null) {
                ReflectionUtils.setConf((Object)codec, (Configuration)job.getConfiguration());
            }
            ArrayList<String> recordList = this.createFile(file, codec, recordLength, totalRecords);
            Assert.assertTrue((boolean)localFs.exists(file));
            FixedLengthInputFormat.setRecordLength((Configuration)job.getConfiguration(), (int)recordLength);
            int numSplits = 1;
            if (i > 0) {
                numSplits = i == MAX_TESTS - 1 ? (int)((double)fileSize / Math.floor(recordLength / 2)) : (MAX_TESTS % i == 0 ? fileSize / (fileSize - random.nextInt(fileSize)) : Math.max(1, fileSize / random.nextInt(Integer.MAX_VALUE)));
                LOG.info((Object)("Number of splits set to: " + numSplits));
            }
            job.getConfiguration().setLong("mapreduce.input.fileinputformat.split.maxsize", (long)(fileSize / numSplits));
            FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{workDir});
            FixedLengthInputFormat format = new FixedLengthInputFormat();
            List splits = format.getSplits((JobContext)job);
            LOG.info((Object)("Actual number of splits = " + splits.size()));
            long recordOffset = 0L;
            int recordNumber = 0;
            for (InputSplit split : splits) {
                TaskAttemptContext context = MapReduceTestUtil.createDummyMapTaskAttemptContext(job.getConfiguration());
                RecordReader reader = format.createRecordReader(split, context);
                MapContextImpl mcontext = new MapContextImpl(job.getConfiguration(), context.getTaskAttemptID(), reader, null, null, MapReduceTestUtil.createDummyReporter(), split);
                reader.initialize(split, (TaskAttemptContext)mcontext);
                Class<?> clazz = reader.getClass();
                Assert.assertEquals((String)"RecordReader class should be FixedLengthRecordReader:", FixedLengthRecordReader.class, clazz);
                while (reader.nextKeyValue()) {
                    LongWritable key = (LongWritable)reader.getCurrentKey();
                    BytesWritable value = (BytesWritable)reader.getCurrentValue();
                    Assert.assertEquals((String)"Checking key", (long)(recordNumber * recordLength), (long)key.get());
                    String valueString = new String(value.getBytes(), 0, value.getLength());
                    Assert.assertEquals((String)"Checking record length:", (long)recordLength, (long)value.getLength());
                    Assert.assertTrue((String)"Checking for more records than expected:", (recordNumber < totalRecords ? 1 : 0) != 0);
                    String origRecord = recordList.get(recordNumber);
                    Assert.assertEquals((String)"Checking record content:", (Object)origRecord, (Object)valueString);
                    ++recordNumber;
                }
                reader.close();
            }
            Assert.assertEquals((String)"Total original records should be total read records:", (long)recordList.size(), (long)recordNumber);
        }
    }

    private static void writeFile(FileSystem fs, Path name, CompressionCodec codec, String contents) throws IOException {
        Object stm = codec == null ? fs.create(name) : codec.createOutputStream((OutputStream)fs.create(name));
        stm.write(contents.getBytes());
        stm.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readSplit(FixedLengthInputFormat format, InputSplit split, Job job) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        TaskAttemptContext context = MapReduceTestUtil.createDummyMapTaskAttemptContext(job.getConfiguration());
        RecordReader reader = format.createRecordReader(split, context);
        MapContextImpl mcontext = new MapContextImpl(job.getConfiguration(), context.getTaskAttemptID(), reader, null, null, MapReduceTestUtil.createDummyReporter(), split);
        try {
            reader.initialize(split, (TaskAttemptContext)mcontext);
            while (reader.nextKeyValue()) {
                LongWritable key = (LongWritable)reader.getCurrentKey();
                BytesWritable value = (BytesWritable)reader.getCurrentValue();
                result.add(new String(value.getBytes(), 0, value.getLength()));
            }
        }
        finally {
            reader.close();
        }
        return result;
    }

    private void runPartialRecordTest(CompressionCodec codec) throws Exception {
        localFs.delete(workDir, true);
        Job job = Job.getInstance((Configuration)defaultConf);
        StringBuilder fileName = new StringBuilder("testFormat.txt");
        if (codec != null) {
            fileName.append(".gz");
            ReflectionUtils.setConf((Object)codec, (Configuration)job.getConfiguration());
        }
        TestFixedLengthInputFormat.writeFile(localFs, new Path(workDir, fileName.toString()), codec, "one  two  threefour five six  seveneightnine ten");
        FixedLengthInputFormat format = new FixedLengthInputFormat();
        FixedLengthInputFormat.setRecordLength((Configuration)job.getConfiguration(), (int)5);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{workDir});
        List splits = format.getSplits((JobContext)job);
        if (codec != null) {
            Assert.assertEquals((String)"compressed splits == 1", (long)1L, (long)splits.size());
        }
        boolean exceptionThrown = false;
        for (InputSplit split : splits) {
            try {
                List<String> results = TestFixedLengthInputFormat.readSplit(format, split, job);
            }
            catch (IOException ioe) {
                exceptionThrown = true;
                LOG.info((Object)("Exception message:" + ioe.getMessage()));
            }
        }
        Assert.assertTrue((String)"Exception for partial record:", (boolean)exceptionThrown);
    }
}

