/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.chain;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.chain.ChainMapper;
import org.apache.hadoop.mapreduce.lib.chain.ChainReducer;

public class TestMapReduceChain
extends HadoopTestCase {
    private static String localPathRoot = System.getProperty("test.build.data", "/tmp");
    private static Path flagDir = new Path(localPathRoot, "testing/chain/flags");

    private static void cleanFlags(Configuration conf) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(flagDir, true);
        fs.mkdirs(flagDir);
    }

    private static void writeFlag(Configuration conf, String flag) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (TestMapReduceChain.getFlag(conf, flag)) {
            TestMapReduceChain.fail((String)("Flag " + flag + " already exists"));
        }
        FSDataOutputStream file = fs.create(new Path(flagDir, flag));
        file.close();
    }

    private static boolean getFlag(Configuration conf, String flag) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        return fs.exists(new Path(flagDir, flag));
    }

    public TestMapReduceChain() throws IOException {
        super(1, 4, 1, 1);
    }

    public void testChain() throws Exception {
        Path inDir = new Path(localPathRoot, "testing/chain/input");
        Path outDir = new Path(localPathRoot, "testing/chain/output");
        String input = "1\n2\n";
        String expectedOutput = "0\t1ABCRDEF\n2\t2ABCRDEF\n";
        JobConf conf = this.createJobConf();
        TestMapReduceChain.cleanFlags((Configuration)conf);
        conf.set("a", "X");
        Job job = MapReduceTestUtil.createJob((Configuration)conf, inDir, outDir, 1, 1, input);
        job.setJobName("chain");
        Configuration mapAConf = new Configuration(false);
        mapAConf.set("a", "A");
        ChainMapper.addMapper((Job)job, AMap.class, LongWritable.class, Text.class, LongWritable.class, Text.class, (Configuration)mapAConf);
        ChainMapper.addMapper((Job)job, BMap.class, LongWritable.class, Text.class, LongWritable.class, Text.class, null);
        ChainMapper.addMapper((Job)job, CMap.class, LongWritable.class, Text.class, LongWritable.class, Text.class, null);
        Configuration reduceConf = new Configuration(false);
        reduceConf.set("a", "C");
        ChainReducer.setReducer((Job)job, RReduce.class, LongWritable.class, Text.class, LongWritable.class, Text.class, (Configuration)reduceConf);
        ChainReducer.addMapper((Job)job, DMap.class, LongWritable.class, Text.class, LongWritable.class, Text.class, null);
        Configuration mapEConf = new Configuration(false);
        mapEConf.set("a", "E");
        ChainReducer.addMapper((Job)job, EMap.class, LongWritable.class, Text.class, LongWritable.class, Text.class, (Configuration)mapEConf);
        ChainReducer.addMapper((Job)job, FMap.class, LongWritable.class, Text.class, LongWritable.class, Text.class, null);
        job.waitForCompletion(true);
        TestMapReduceChain.assertTrue((String)"Job failed", (boolean)job.isSuccessful());
        String str = "flag not set";
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.setup.A"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.setup.B"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.setup.C"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, "reduce.setup.R"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.setup.D"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.setup.E"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.setup.F"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.A.value.1"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.A.value.2"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.B.value.1A"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.B.value.2A"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.C.value.1AB"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.C.value.2AB"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, "reduce.R.value.1ABC"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, "reduce.R.value.2ABC"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.D.value.1ABCR"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.D.value.2ABCR"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.E.value.1ABCRD"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.E.value.2ABCRD"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.F.value.1ABCRDE"));
        TestMapReduceChain.assertTrue((String)str, (boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.F.value.2ABCRDE"));
        TestMapReduceChain.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.cleanup.A"));
        TestMapReduceChain.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.cleanup.B"));
        TestMapReduceChain.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.cleanup.C"));
        TestMapReduceChain.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "reduce.cleanup.R"));
        TestMapReduceChain.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.cleanup.D"));
        TestMapReduceChain.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.cleanup.E"));
        TestMapReduceChain.assertTrue((boolean)TestMapReduceChain.getFlag((Configuration)conf, "map.cleanup.F"));
        TestMapReduceChain.assertEquals((String)"Outputs doesn't match", (String)expectedOutput, (String)MapReduceTestUtil.readOutput(outDir, (Configuration)conf));
    }

    public static class IDReduce
    extends Reducer<LongWritable, Text, LongWritable, Text> {
        private String name;
        private String prop;

        public IDReduce(String name, String prop) {
            this.name = name;
            this.prop = prop;
        }

        public void setup(Reducer.Context context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            TestCase.assertEquals((String)this.prop, (String)conf.get("a"));
            TestMapReduceChain.writeFlag(conf, "reduce.setup." + this.name);
        }

        public void reduce(LongWritable key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
            for (Text value : values) {
                TestMapReduceChain.writeFlag(context.getConfiguration(), "reduce." + this.name + ".value." + value);
                context.write((Object)key, (Object)new Text(value + this.name));
            }
        }

        public void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            TestMapReduceChain.writeFlag(context.getConfiguration(), "reduce.cleanup." + this.name);
        }
    }

    public static class IDMap
    extends Mapper<LongWritable, Text, LongWritable, Text> {
        private String name;
        private String prop;

        public IDMap(String name, String prop) {
            this.name = name;
            this.prop = prop;
        }

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            TestCase.assertEquals((String)this.prop, (String)conf.get("a"));
            TestMapReduceChain.writeFlag(conf, "map.setup." + this.name);
        }

        public void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            TestMapReduceChain.writeFlag(context.getConfiguration(), "map." + this.name + ".value." + value);
            context.write((Object)key, (Object)new Text(value + this.name));
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            TestMapReduceChain.writeFlag(context.getConfiguration(), "map.cleanup." + this.name);
        }
    }

    public static class FMap
    extends IDMap {
        public FMap() {
            super("F", "X");
        }
    }

    public static class EMap
    extends IDMap {
        public EMap() {
            super("E", "E");
        }
    }

    public static class DMap
    extends IDMap {
        public DMap() {
            super("D", "X");
        }
    }

    public static class RReduce
    extends IDReduce {
        public RReduce() {
            super("R", "C");
        }
    }

    public static class CMap
    extends IDMap {
        public CMap() {
            super("C", "X");
        }
    }

    public static class BMap
    extends IDMap {
        public BMap() {
            super("B", "X");
        }
    }

    public static class AMap
    extends IDMap {
        public AMap() {
            super("A", "A");
        }
    }
}

