/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.Iterator;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.lib.HashPartitioner;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class SortValidator
extends Configured
implements Tool {
    private static final IntWritable sortInput = new IntWritable(1);
    private static final IntWritable sortOutput = new IntWritable(2);
    public static String SORT_REDUCES = "mapreduce.sortvalidator.sort.reduce.tasks";
    public static String MAPS_PER_HOST = "mapreduce.sortvalidator.mapsperhost";
    public static String REDUCES_PER_HOST = "mapreduce.sortvalidator.reducesperhost";
    private static final PathFilter sortPathsFilter = new PathFilter(){

        public boolean accept(Path path) {
            return path.getName().startsWith("part-");
        }
    };

    static void printUsage() {
        System.err.println("sortvalidate [-m <maps>] [-r <reduces>] [-deep] -sortInput <sort-input-dir> -sortOutput <sort-output-dir>");
        System.exit(1);
    }

    private static IntWritable deduceInputFile(JobConf job) {
        Path[] inputPaths = FileInputFormat.getInputPaths((JobConf)job);
        Path inputFile = new Path(job.get("mapreduce.map.input.file"));
        return inputFile.getParent().equals((Object)inputPaths[0]) ? sortInput : sortOutput;
    }

    private static byte[] pair(BytesWritable a, BytesWritable b) {
        byte[] pairData = new byte[a.getLength() + b.getLength()];
        System.arraycopy(a.getBytes(), 0, pairData, 0, a.getLength());
        System.arraycopy(b.getBytes(), 0, pairData, a.getLength(), b.getLength());
        return pairData;
    }

    public int run(String[] args) throws Exception {
        Configuration defaults = this.getConf();
        int noMaps = -1;
        int noReduces = -1;
        Path sortInput = null;
        Path sortOutput = null;
        boolean deepTest = false;
        for (int i = 0; i < args.length; ++i) {
            try {
                if ("-m".equals(args[i])) {
                    noMaps = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-r".equals(args[i])) {
                    noReduces = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-sortInput".equals(args[i])) {
                    sortInput = new Path(args[++i]);
                    continue;
                }
                if ("-sortOutput".equals(args[i])) {
                    sortOutput = new Path(args[++i]);
                    continue;
                }
                if ("-deep".equals(args[i])) {
                    deepTest = true;
                    continue;
                }
                SortValidator.printUsage();
                return -1;
            }
            catch (NumberFormatException except) {
                System.err.println("ERROR: Integer expected instead of " + args[i]);
                SortValidator.printUsage();
                return -1;
            }
            catch (ArrayIndexOutOfBoundsException except) {
                System.err.println("ERROR: Required parameter missing from " + args[i - 1]);
                SortValidator.printUsage();
                return -1;
            }
        }
        if (sortInput == null || sortOutput == null) {
            SortValidator.printUsage();
            return -2;
        }
        RecordStatsChecker.checkRecords(defaults, sortInput, sortOutput);
        if (deepTest) {
            RecordChecker.checkRecords(defaults, noMaps, noReduces, sortInput, sortOutput);
        }
        System.out.println("\nSUCCESS! Validated the MapReduce framework's 'sort' successfully.");
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new SortValidator(), (String[])args);
        System.exit(res);
    }

    public static class RecordChecker {
        static void checkRecords(Configuration defaults, int noMaps, int noReduces, Path sortInput, Path sortOutput) throws IOException {
            JobConf jobConf = new JobConf(defaults, RecordChecker.class);
            jobConf.setJobName("sortvalidate-record-checker");
            jobConf.setInputFormat(SequenceFileInputFormat.class);
            jobConf.setOutputFormat(SequenceFileOutputFormat.class);
            jobConf.setOutputKeyClass(BytesWritable.class);
            jobConf.setOutputValueClass(IntWritable.class);
            jobConf.setMapperClass(Map.class);
            jobConf.setReducerClass(Reduce.class);
            JobClient client = new JobClient(jobConf);
            ClusterStatus cluster = client.getClusterStatus();
            if (noMaps == -1) {
                noMaps = cluster.getTaskTrackers() * jobConf.getInt(MAPS_PER_HOST, 10);
            }
            if (noReduces == -1) {
                noReduces = (int)((double)cluster.getMaxReduceTasks() * 0.9);
                String sortReduces = jobConf.get(REDUCES_PER_HOST);
                if (sortReduces != null) {
                    noReduces = cluster.getTaskTrackers() * Integer.parseInt(sortReduces);
                }
            }
            jobConf.setNumMapTasks(noMaps);
            jobConf.setNumReduceTasks(noReduces);
            FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{sortInput});
            FileInputFormat.addInputPath((JobConf)jobConf, (Path)sortOutput);
            Path outputPath = new Path("/tmp/sortvalidate/recordchecker");
            FileSystem fs = FileSystem.get((Configuration)defaults);
            if (fs.exists(outputPath)) {
                fs.delete(outputPath, true);
            }
            FileOutputFormat.setOutputPath((JobConf)jobConf, (Path)outputPath);
            Path[] inputPaths = FileInputFormat.getInputPaths((JobConf)jobConf);
            System.out.println("\nSortValidator.RecordChecker: Running on " + cluster.getTaskTrackers() + " nodes to validate sort from " + inputPaths[0] + ", " + inputPaths[1] + " into " + FileOutputFormat.getOutputPath((JobConf)jobConf) + " with " + noReduces + " reduces.");
            Date startTime = new Date();
            System.out.println("Job started: " + startTime);
            JobClient.runJob((JobConf)jobConf);
            Date end_time = new Date();
            System.out.println("Job ended: " + end_time);
            System.out.println("The job took " + (end_time.getTime() - startTime.getTime()) / 1000L + " seconds.");
        }

        public static class Reduce
        extends MapReduceBase
        implements Reducer<BytesWritable, IntWritable, BytesWritable, IntWritable> {
            public void reduce(BytesWritable key, Iterator<IntWritable> values, OutputCollector<BytesWritable, IntWritable> output, Reporter reporter) throws IOException {
                int ones = 0;
                int twos = 0;
                while (values.hasNext()) {
                    IntWritable count = values.next();
                    if (count.equals((Object)sortInput)) {
                        ++ones;
                        continue;
                    }
                    if (count.equals((Object)sortOutput)) {
                        ++twos;
                        continue;
                    }
                    throw new IOException("Invalid 'value' of " + count.get() + " for (key,value): " + key.toString());
                }
                if (ones != twos) {
                    throw new IOException("Illegal ('one', 'two'): (" + ones + ", " + twos + ") for (key, value): " + key.toString());
                }
            }
        }

        public static class Map
        extends MapReduceBase
        implements Mapper<BytesWritable, BytesWritable, BytesWritable, IntWritable> {
            private IntWritable value = null;

            public void configure(JobConf job) {
                this.value = SortValidator.deduceInputFile(job);
            }

            public void map(BytesWritable key, BytesWritable value, OutputCollector<BytesWritable, IntWritable> output, Reporter reporter) throws IOException {
                BytesWritable keyValue = new BytesWritable(SortValidator.pair(key, value));
                output.collect((Object)keyValue, (Object)this.value);
            }
        }
    }

    public static class RecordStatsChecker {
        private static Raw createRaw(Class rawClass) {
            if (rawClass == Text.class) {
                return new RawText();
            }
            if (rawClass == BytesWritable.class) {
                System.err.println("Returning " + RawBytesWritable.class);
                return new RawBytesWritable();
            }
            return new Raw();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void checkRecords(Configuration defaults, Path sortInput, Path sortOutput) throws IOException {
            FileSystem inputfs = sortInput.getFileSystem(defaults);
            FileSystem outputfs = sortOutput.getFileSystem(defaults);
            FileSystem defaultfs = FileSystem.get((Configuration)defaults);
            JobConf jobConf = new JobConf(defaults, RecordStatsChecker.class);
            jobConf.setJobName("sortvalidate-recordstats-checker");
            int noSortReduceTasks = outputfs.listStatus(sortOutput, sortPathsFilter).length;
            jobConf.setInt(SORT_REDUCES, noSortReduceTasks);
            int noSortInputpaths = inputfs.listStatus(sortInput).length;
            jobConf.setInputFormat(NonSplitableSequenceFileInputFormat.class);
            jobConf.setOutputFormat(SequenceFileOutputFormat.class);
            jobConf.setOutputKeyClass(IntWritable.class);
            jobConf.setOutputValueClass(RecordStatsWritable.class);
            jobConf.setMapperClass(Map.class);
            jobConf.setCombinerClass(Reduce.class);
            jobConf.setReducerClass(Reduce.class);
            jobConf.setNumMapTasks(noSortReduceTasks);
            jobConf.setNumReduceTasks(1);
            FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{sortInput});
            FileInputFormat.addInputPath((JobConf)jobConf, (Path)sortOutput);
            Path outputPath = new Path(new Path("/tmp", "sortvalidate"), UUID.randomUUID().toString());
            if (defaultfs.exists(outputPath)) {
                defaultfs.delete(outputPath, true);
            }
            FileOutputFormat.setOutputPath((JobConf)jobConf, (Path)outputPath);
            Path[] inputPaths = FileInputFormat.getInputPaths((JobConf)jobConf);
            System.out.println("\nSortValidator.RecordStatsChecker: Validate sort from " + inputPaths[0] + " (" + noSortInputpaths + " files), " + inputPaths[1] + " (" + noSortReduceTasks + " files) into " + FileOutputFormat.getOutputPath((JobConf)jobConf) + " with 1 reducer.");
            Date startTime = new Date();
            System.out.println("Job started: " + startTime);
            JobClient.runJob((JobConf)jobConf);
            try {
                Date end_time = new Date();
                System.out.println("Job ended: " + end_time);
                System.out.println("The job took " + (end_time.getTime() - startTime.getTime()) / 1000L + " seconds.");
                SequenceFile.Reader stats = new SequenceFile.Reader(defaultfs, new Path(outputPath, "part-00000"), defaults);
                try {
                    IntWritable k1 = new IntWritable();
                    IntWritable k2 = new IntWritable();
                    RecordStatsWritable v1 = new RecordStatsWritable();
                    RecordStatsWritable v2 = new RecordStatsWritable();
                    if (!stats.next((Writable)k1, (Writable)v1)) {
                        throw new IOException("Failed to read record #1 from reduce's output");
                    }
                    if (!stats.next((Writable)k2, (Writable)v2)) {
                        throw new IOException("Failed to read record #2 from reduce's output");
                    }
                    if (v1.getBytes() != v2.getBytes() || v1.getRecords() != v2.getRecords() || v1.getChecksum() != v2.getChecksum()) {
                        throw new IOException("(" + v1.getBytes() + ", " + v1.getRecords() + ", " + v1.getChecksum() + ") v/s (" + v2.getBytes() + ", " + v2.getRecords() + ", " + v2.getChecksum() + ")");
                    }
                }
                finally {
                    stats.close();
                }
            }
            finally {
                defaultfs.delete(outputPath, true);
            }
        }

        public static class NonSplitableSequenceFileInputFormat
        extends SequenceFileInputFormat {
            protected boolean isSplitable(FileSystem fs, Path filename) {
                return false;
            }
        }

        public static class Reduce
        extends MapReduceBase
        implements Reducer<IntWritable, RecordStatsWritable, IntWritable, RecordStatsWritable> {
            public void reduce(IntWritable key, Iterator<RecordStatsWritable> values, OutputCollector<IntWritable, RecordStatsWritable> output, Reporter reporter) throws IOException {
                long bytes = 0L;
                long records = 0L;
                int xor = 0;
                while (values.hasNext()) {
                    RecordStatsWritable stats = values.next();
                    bytes += stats.getBytes();
                    records += stats.getRecords();
                    xor ^= stats.getChecksum();
                }
                output.collect((Object)key, (Object)new RecordStatsWritable(bytes, records, xor));
            }
        }

        public static class Map
        extends MapReduceBase
        implements Mapper<WritableComparable, Writable, IntWritable, RecordStatsWritable> {
            private IntWritable key = null;
            private WritableComparable prevKey = null;
            private Class<? extends WritableComparable> keyClass;
            private Partitioner<WritableComparable, Writable> partitioner = null;
            private int partition = -1;
            private int noSortReducers = -1;
            private long recordId = -1L;
            private Raw rawKey;
            private Raw rawValue;

            public void configure(JobConf job) {
                this.key = SortValidator.deduceInputFile(job);
                if (this.key == sortOutput) {
                    this.partitioner = new HashPartitioner();
                    try {
                        URI inputURI = new URI(job.get("mapreduce.map.input.file"));
                        String inputFile = inputURI.getPath();
                        this.partition = Integer.valueOf(inputFile.substring(inputFile.lastIndexOf("part") + 7));
                        this.noSortReducers = job.getInt(SORT_REDUCES, -1);
                    }
                    catch (Exception e) {
                        System.err.println("Caught: " + e);
                        System.exit(-1);
                    }
                }
            }

            public void map(WritableComparable key, Writable value, OutputCollector<IntWritable, RecordStatsWritable> output, Reporter reporter) throws IOException {
                if (this.recordId == -1L) {
                    this.rawKey = RecordStatsChecker.createRaw(key.getClass());
                    this.rawValue = RecordStatsChecker.createRaw(value.getClass());
                }
                ++this.recordId;
                if (this.key == sortOutput) {
                    if (this.prevKey == null) {
                        this.prevKey = key;
                        this.keyClass = this.prevKey.getClass();
                    } else {
                        if (this.keyClass != key.getClass()) {
                            throw new IOException("Type mismatch in key: expected " + this.keyClass.getName() + ", received " + key.getClass().getName());
                        }
                        if (this.prevKey.compareTo((Object)key) > 0) {
                            throw new IOException("The 'map-reduce' framework wrongly classifed (" + this.prevKey + ") > (" + key + ") " + "for record# " + this.recordId);
                        }
                        this.prevKey = key;
                    }
                    int keyPartition = this.partitioner.getPartition((Object)key, (Object)value, this.noSortReducers);
                    if (this.partition != keyPartition) {
                        throw new IOException("Partitions do not match for record# " + this.recordId + " ! - '" + this.partition + "' v/s '" + keyPartition + "'");
                    }
                }
                byte[] keyBytes = this.rawKey.getRawBytes((Writable)key);
                int keyBytesLen = this.rawKey.getRawBytesLength((Writable)key);
                byte[] valueBytes = this.rawValue.getRawBytes(value);
                int valueBytesLen = this.rawValue.getRawBytesLength(value);
                int keyValueChecksum = WritableComparator.hashBytes((byte[])keyBytes, (int)keyBytesLen) ^ WritableComparator.hashBytes((byte[])valueBytes, (int)valueBytesLen);
                output.collect((Object)this.key, (Object)new RecordStatsWritable(keyBytesLen + valueBytesLen, 1L, keyValueChecksum));
            }
        }

        public static class RecordStatsWritable
        implements Writable {
            private long bytes = 0L;
            private long records = 0L;
            private int checksum = 0;

            public RecordStatsWritable() {
            }

            public RecordStatsWritable(long bytes, long records, int checksum) {
                this.bytes = bytes;
                this.records = records;
                this.checksum = checksum;
            }

            public void write(DataOutput out) throws IOException {
                WritableUtils.writeVLong((DataOutput)out, (long)this.bytes);
                WritableUtils.writeVLong((DataOutput)out, (long)this.records);
                WritableUtils.writeVInt((DataOutput)out, (int)this.checksum);
            }

            public void readFields(DataInput in) throws IOException {
                this.bytes = WritableUtils.readVLong((DataInput)in);
                this.records = WritableUtils.readVLong((DataInput)in);
                this.checksum = WritableUtils.readVInt((DataInput)in);
            }

            public long getBytes() {
                return this.bytes;
            }

            public long getRecords() {
                return this.records;
            }

            public int getChecksum() {
                return this.checksum;
            }
        }

        static class RawText
        extends Raw {
            RawText() {
            }

            @Override
            public byte[] getRawBytes(Writable text) {
                return ((Text)text).getBytes();
            }

            @Override
            public int getRawBytesLength(Writable text) {
                return ((Text)text).getLength();
            }
        }

        static class RawBytesWritable
        extends Raw {
            RawBytesWritable() {
            }

            @Override
            public byte[] getRawBytes(Writable bw) {
                return ((BytesWritable)bw).getBytes();
            }

            @Override
            public int getRawBytesLength(Writable bw) {
                return ((BytesWritable)bw).getLength();
            }
        }

        static class Raw {
            Raw() {
            }

            public byte[] getRawBytes(Writable writable) {
                return writable.toString().getBytes();
            }

            public int getRawBytesLength(Writable writable) {
                return writable.toString().getBytes().length;
            }
        }
    }
}

