/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessControlException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskAttemptRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskAttemptResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.impl.pb.KillTaskAttemptRequestPBImpl;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.client.MRClientService;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.AMAttemptInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.AMAttemptsInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.AppInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.BlacklistedNodesInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.ConfInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.JobCounterInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.JobInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.JobTaskAttemptCounterInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.JobTaskAttemptState;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.JobTaskCounterInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.JobsInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.ReduceTaskAttemptInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.TaskAttemptInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.TaskAttemptsInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.TaskInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.TasksInfo;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.webapp.BadRequestException;
import org.apache.hadoop.yarn.webapp.NotFoundException;

@Path(value="/ws/v1/mapreduce")
public class AMWebServices {
    private final AppContext appCtx;
    private final App app;
    private final MRClientService service;
    @Context
    private HttpServletResponse response;

    @Inject
    public AMWebServices(App app, AppContext context) {
        this.appCtx = context;
        this.app = app;
        this.service = new MRClientService(context);
    }

    Boolean hasAccess(Job job, HttpServletRequest request) {
        String remoteUser = request.getRemoteUser();
        UserGroupInformation callerUGI = null;
        if (remoteUser != null) {
            callerUGI = UserGroupInformation.createRemoteUser((String)remoteUser);
        }
        if (callerUGI != null && !job.checkAccess(callerUGI, JobACL.VIEW_JOB)) {
            return false;
        }
        return true;
    }

    private void init() {
        this.response.setContentType(null);
    }

    public static Job getJobFromJobIdString(String jid, AppContext appCtx) throws NotFoundException {
        JobId jobId;
        try {
            jobId = MRApps.toJobID((String)jid);
        }
        catch (YarnRuntimeException e) {
            throw new NotFoundException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new NotFoundException(e.getMessage());
        }
        if (jobId == null) {
            throw new NotFoundException("job, " + jid + ", is not found");
        }
        Job job = appCtx.getJob(jobId);
        if (job == null) {
            throw new NotFoundException("job, " + jid + ", is not found");
        }
        return job;
    }

    public static Task getTaskFromTaskIdString(String tid, Job job) throws NotFoundException {
        TaskId taskID;
        try {
            taskID = MRApps.toTaskID((String)tid);
        }
        catch (YarnRuntimeException e) {
            throw new NotFoundException(e.getMessage());
        }
        catch (NumberFormatException ne) {
            throw new NotFoundException(ne.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new NotFoundException(e.getMessage());
        }
        if (taskID == null) {
            throw new NotFoundException("taskid " + tid + " not found or invalid");
        }
        Task task = job.getTask(taskID);
        if (task == null) {
            throw new NotFoundException("task not found with id " + tid);
        }
        return task;
    }

    public static TaskAttempt getTaskAttemptFromTaskAttemptString(String attId, Task task) throws NotFoundException {
        TaskAttemptId attemptId;
        try {
            attemptId = MRApps.toTaskAttemptID((String)attId);
        }
        catch (YarnRuntimeException e) {
            throw new NotFoundException(e.getMessage());
        }
        catch (NumberFormatException ne) {
            throw new NotFoundException(ne.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new NotFoundException(e.getMessage());
        }
        if (attemptId == null) {
            throw new NotFoundException("task attempt id " + attId + " not found or invalid");
        }
        TaskAttempt ta = task.getAttempt(attemptId);
        if (ta == null) {
            throw new NotFoundException("Error getting info on task attempt id " + attId);
        }
        return ta;
    }

    void checkAccess(Job job, HttpServletRequest request) {
        if (!this.hasAccess(job, request).booleanValue()) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
    }

    @GET
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppInfo get() {
        return this.getAppInfo();
    }

    @GET
    @Path(value="/info")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppInfo getAppInfo() {
        this.init();
        return new AppInfo(this.app, this.app.context);
    }

    @GET
    @Path(value="/blacklistednodes")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public BlacklistedNodesInfo getBlacklistedNodes() {
        this.init();
        return new BlacklistedNodesInfo(this.app.context);
    }

    @GET
    @Path(value="/jobs")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public JobsInfo getJobs(@Context HttpServletRequest hsr) {
        this.init();
        JobsInfo allJobs = new JobsInfo();
        for (Job job : this.appCtx.getAllJobs().values()) {
            Job fullJob = this.appCtx.getJob(job.getID());
            if (fullJob == null) continue;
            allJobs.add(new JobInfo(fullJob, this.hasAccess(fullJob, hsr)));
        }
        return allJobs;
    }

    @GET
    @Path(value="/jobs/{jobid}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public JobInfo getJob(@Context HttpServletRequest hsr, @PathParam(value="jobid") String jid) {
        this.init();
        Job job = AMWebServices.getJobFromJobIdString(jid, this.appCtx);
        return new JobInfo(job, this.hasAccess(job, hsr));
    }

    @GET
    @Path(value="/jobs/{jobid}/jobattempts")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AMAttemptsInfo getJobAttempts(@PathParam(value="jobid") String jid) {
        this.init();
        Job job = AMWebServices.getJobFromJobIdString(jid, this.appCtx);
        AMAttemptsInfo amAttempts = new AMAttemptsInfo();
        for (AMInfo amInfo : job.getAMInfos()) {
            AMAttemptInfo attempt = new AMAttemptInfo(amInfo, MRApps.toString((JobId)job.getID()), job.getUserName());
            amAttempts.add(attempt);
        }
        return amAttempts;
    }

    @GET
    @Path(value="/jobs/{jobid}/counters")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public JobCounterInfo getJobCounters(@Context HttpServletRequest hsr, @PathParam(value="jobid") String jid) {
        this.init();
        Job job = AMWebServices.getJobFromJobIdString(jid, this.appCtx);
        this.checkAccess(job, hsr);
        return new JobCounterInfo(this.appCtx, job);
    }

    @GET
    @Path(value="/jobs/{jobid}/conf")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public ConfInfo getJobConf(@Context HttpServletRequest hsr, @PathParam(value="jobid") String jid) {
        ConfInfo info;
        this.init();
        Job job = AMWebServices.getJobFromJobIdString(jid, this.appCtx);
        this.checkAccess(job, hsr);
        try {
            info = new ConfInfo(job);
        }
        catch (IOException e) {
            throw new NotFoundException("unable to load configuration for job: " + jid);
        }
        return info;
    }

    @GET
    @Path(value="/jobs/{jobid}/tasks")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public TasksInfo getJobTasks(@Context HttpServletRequest hsr, @PathParam(value="jobid") String jid, @QueryParam(value="type") String type) {
        this.init();
        Job job = AMWebServices.getJobFromJobIdString(jid, this.appCtx);
        this.checkAccess(job, hsr);
        TasksInfo allTasks = new TasksInfo();
        for (Task task : job.getTasks().values()) {
            TaskType ttype = null;
            if (type != null && !type.isEmpty()) {
                try {
                    ttype = MRApps.taskType((String)type);
                }
                catch (YarnRuntimeException e) {
                    throw new BadRequestException("tasktype must be either m or r");
                }
            }
            if (ttype != null && task.getType() != ttype) continue;
            allTasks.add(new TaskInfo(task));
        }
        return allTasks;
    }

    @GET
    @Path(value="/jobs/{jobid}/tasks/{taskid}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public TaskInfo getJobTask(@Context HttpServletRequest hsr, @PathParam(value="jobid") String jid, @PathParam(value="taskid") String tid) {
        this.init();
        Job job = AMWebServices.getJobFromJobIdString(jid, this.appCtx);
        this.checkAccess(job, hsr);
        Task task = AMWebServices.getTaskFromTaskIdString(tid, job);
        return new TaskInfo(task);
    }

    @GET
    @Path(value="/jobs/{jobid}/tasks/{taskid}/counters")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public JobTaskCounterInfo getSingleTaskCounters(@Context HttpServletRequest hsr, @PathParam(value="jobid") String jid, @PathParam(value="taskid") String tid) {
        this.init();
        Job job = AMWebServices.getJobFromJobIdString(jid, this.appCtx);
        this.checkAccess(job, hsr);
        Task task = AMWebServices.getTaskFromTaskIdString(tid, job);
        return new JobTaskCounterInfo(task);
    }

    @GET
    @Path(value="/jobs/{jobid}/tasks/{taskid}/attempts")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public TaskAttemptsInfo getJobTaskAttempts(@Context HttpServletRequest hsr, @PathParam(value="jobid") String jid, @PathParam(value="taskid") String tid) {
        this.init();
        TaskAttemptsInfo attempts = new TaskAttemptsInfo();
        Job job = AMWebServices.getJobFromJobIdString(jid, this.appCtx);
        this.checkAccess(job, hsr);
        Task task = AMWebServices.getTaskFromTaskIdString(tid, job);
        for (TaskAttempt ta : task.getAttempts().values()) {
            if (ta == null) continue;
            if (task.getType() == TaskType.REDUCE) {
                attempts.add(new ReduceTaskAttemptInfo(ta, task.getType()));
                continue;
            }
            attempts.add(new TaskAttemptInfo(ta, task.getType(), true));
        }
        return attempts;
    }

    @GET
    @Path(value="/jobs/{jobid}/tasks/{taskid}/attempts/{attemptid}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public TaskAttemptInfo getJobTaskAttemptId(@Context HttpServletRequest hsr, @PathParam(value="jobid") String jid, @PathParam(value="taskid") String tid, @PathParam(value="attemptid") String attId) {
        this.init();
        Job job = AMWebServices.getJobFromJobIdString(jid, this.appCtx);
        this.checkAccess(job, hsr);
        Task task = AMWebServices.getTaskFromTaskIdString(tid, job);
        TaskAttempt ta = AMWebServices.getTaskAttemptFromTaskAttemptString(attId, task);
        if (task.getType() == TaskType.REDUCE) {
            return new ReduceTaskAttemptInfo(ta, task.getType());
        }
        return new TaskAttemptInfo(ta, task.getType(), true);
    }

    @GET
    @Path(value="/jobs/{jobid}/tasks/{taskid}/attempts/{attemptid}/state")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public JobTaskAttemptState getJobTaskAttemptState(@Context HttpServletRequest hsr, @PathParam(value="jobid") String jid, @PathParam(value="taskid") String tid, @PathParam(value="attemptid") String attId) throws IOException, InterruptedException {
        this.init();
        Job job = AMWebServices.getJobFromJobIdString(jid, this.appCtx);
        this.checkAccess(job, hsr);
        Task task = AMWebServices.getTaskFromTaskIdString(tid, job);
        TaskAttempt ta = AMWebServices.getTaskAttemptFromTaskAttemptString(attId, task);
        return new JobTaskAttemptState(ta.getState().toString());
    }

    @PUT
    @Path(value="/jobs/{jobid}/tasks/{taskid}/attempts/{attemptid}/state")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    @Consumes(value={"application/json", "application/xml"})
    public Response updateJobTaskAttemptState(JobTaskAttemptState targetState, @Context HttpServletRequest hsr, @PathParam(value="jobid") String jid, @PathParam(value="taskid") String tid, @PathParam(value="attemptid") String attId) throws IOException, InterruptedException {
        Task task;
        TaskAttempt ta;
        this.init();
        Job job = AMWebServices.getJobFromJobIdString(jid, this.appCtx);
        this.checkAccess(job, hsr);
        String remoteUser = hsr.getRemoteUser();
        UserGroupInformation callerUGI = null;
        if (remoteUser != null) {
            callerUGI = UserGroupInformation.createRemoteUser((String)remoteUser);
        }
        if (!(ta = AMWebServices.getTaskAttemptFromTaskAttemptString(attId, task = AMWebServices.getTaskFromTaskIdString(tid, job))).getState().toString().equals(targetState.getState())) {
            if (targetState.getState().equals(TaskAttemptState.KILLED.toString())) {
                return this.killJobTaskAttempt(ta, callerUGI, hsr);
            }
            throw new BadRequestException("Only '" + TaskAttemptState.KILLED.toString() + "' is allowed as a target state.");
        }
        JobTaskAttemptState ret = new JobTaskAttemptState();
        ret.setState(ta.getState().toString());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)ret).build();
    }

    @GET
    @Path(value="/jobs/{jobid}/tasks/{taskid}/attempts/{attemptid}/counters")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public JobTaskAttemptCounterInfo getJobTaskAttemptIdCounters(@Context HttpServletRequest hsr, @PathParam(value="jobid") String jid, @PathParam(value="taskid") String tid, @PathParam(value="attemptid") String attId) {
        this.init();
        Job job = AMWebServices.getJobFromJobIdString(jid, this.appCtx);
        this.checkAccess(job, hsr);
        Task task = AMWebServices.getTaskFromTaskIdString(tid, job);
        TaskAttempt ta = AMWebServices.getTaskAttemptFromTaskAttemptString(attId, task);
        return new JobTaskAttemptCounterInfo(ta);
    }

    protected Response killJobTaskAttempt(TaskAttempt ta, UserGroupInformation callerUGI, HttpServletRequest hsr) throws IOException, InterruptedException {
        Preconditions.checkNotNull((Object)ta, (Object)"ta cannot be null");
        String userName = callerUGI.getUserName();
        final TaskAttemptId attemptId = ta.getID();
        try {
            callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<KillTaskAttemptResponse>(){

                @Override
                public KillTaskAttemptResponse run() throws IOException, YarnException {
                    KillTaskAttemptRequestPBImpl req = new KillTaskAttemptRequestPBImpl();
                    req.setTaskAttemptId(attemptId);
                    return AMWebServices.this.service.forceKillTaskAttempt((KillTaskAttemptRequest)req);
                }
            });
        }
        catch (UndeclaredThrowableException ue) {
            if (ue.getCause() instanceof YarnException) {
                YarnException ye = (YarnException)ue.getCause();
                if (ye.getCause() instanceof AccessControlException) {
                    String taId = attemptId.toString();
                    String msg = "Unauthorized attempt to kill task attempt " + taId + " by remote user " + userName;
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)msg).build();
                }
                throw ue;
            }
            throw ue;
        }
        JobTaskAttemptState ret = new JobTaskAttemptState();
        ret.setState(TaskAttemptState.KILLED.toString());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)ret).build();
    }
}

