/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.job.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobACLsManager;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.counters.AbstractCounters;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.jobhistory.JobInfoChangeEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobInitedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobQueueChangeEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobSubmittedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobUnsuccessfulCompletionEvent;
import org.apache.hadoop.mapreduce.lib.chain.ChainMapper;
import org.apache.hadoop.mapreduce.lib.chain.ChainReducer;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.mapreduce.split.SplitMetaInfoReader;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.Phase;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEvent;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEventStatus;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptListener;
import org.apache.hadoop.mapreduce.v2.app.commit.CommitterJobAbortEvent;
import org.apache.hadoop.mapreduce.v2.app.commit.CommitterJobCommitEvent;
import org.apache.hadoop.mapreduce.v2.app.commit.CommitterJobSetupEvent;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.JobStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobAbortCompletedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobCommitFailedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobCounterUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobFinishEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobSetupFailedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobStartEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobTaskAttemptCompletedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobTaskAttemptFetchFailureEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobTaskEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobUpdatedNodesEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptKillEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskRecoverEvent;
import org.apache.hadoop.mapreduce.v2.app.job.impl.MapTaskImpl;
import org.apache.hadoop.mapreduce.v2.app.job.impl.ReduceTaskImpl;
import org.apache.hadoop.mapreduce.v2.app.metrics.MRAppMetrics;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.Clock;

public class JobImpl
implements Job,
EventHandler<JobEvent> {
    private static final TaskAttemptCompletionEvent[] EMPTY_TASK_ATTEMPT_COMPLETION_EVENTS = new TaskAttemptCompletionEvent[0];
    private static final TaskCompletionEvent[] EMPTY_TASK_COMPLETION_EVENTS = new TaskCompletionEvent[0];
    private static final Log LOG = LogFactory.getLog(JobImpl.class);
    private static final double MAX_ALLOWED_FETCH_FAILURES_FRACTION = 0.5;
    private static final int MAX_FETCH_FAILURES_NOTIFICATIONS = 3;
    public static final String JOB_KILLED_DIAG = "Job received Kill while in RUNNING state.";
    private final ApplicationAttemptId applicationAttemptId;
    private final Clock clock;
    private final JobACLsManager aclsManager;
    private final String username;
    private final Map<JobACL, AccessControlList> jobACLs;
    private float setupWeight = 0.05f;
    private float cleanupWeight = 0.05f;
    private float mapWeight = 0.0f;
    private float reduceWeight = 0.0f;
    private final Map<TaskId, JobHistoryParser.TaskInfo> completedTasksFromPreviousRun;
    private final List<AMInfo> amInfos;
    private final Lock readLock;
    private final Lock writeLock;
    private final JobId jobId;
    private final String jobName;
    private final OutputCommitter committer;
    private final boolean newApiCommitter;
    private final JobID oldJobId;
    private final TaskAttemptListener taskAttemptListener;
    private final Object tasksSyncHandle = new Object();
    private final Set<TaskId> mapTasks = new LinkedHashSet<TaskId>();
    private final Set<TaskId> reduceTasks = new LinkedHashSet<TaskId>();
    private final HashMap<NodeId, List<TaskAttemptId>> nodesToSucceededTaskAttempts = new HashMap();
    private final EventHandler eventHandler;
    private final MRAppMetrics metrics;
    private final String userName;
    private String queueName;
    private final long appSubmitTime;
    private final AppContext appContext;
    private boolean lazyTasksCopyNeeded = false;
    volatile Map<TaskId, Task> tasks = new LinkedHashMap<TaskId, Task>();
    private Counters jobCounters = new Counters();
    private Object fullCountersLock = new Object();
    private Counters fullCounters = null;
    private Counters finalMapCounters = null;
    private Counters finalReduceCounters = null;
    public JobConf conf;
    private FileSystem fs;
    private Path remoteJobSubmitDir;
    public Path remoteJobConfFile;
    private JobContext jobContext;
    private int allowedMapFailuresPercent = 0;
    private int allowedReduceFailuresPercent = 0;
    private List<TaskAttemptCompletionEvent> taskAttemptCompletionEvents;
    private List<TaskCompletionEvent> mapAttemptCompletionEvents;
    private List<Integer> taskCompletionIdxToMapCompletionIdx;
    private final List<String> diagnostics = new ArrayList<String>();
    private final Map<TaskId, Integer> successAttemptCompletionEventNoMap = new HashMap<TaskId, Integer>();
    private final Map<TaskAttemptId, Integer> fetchFailuresMapping = new HashMap<TaskAttemptId, Integer>();
    private static final DiagnosticsUpdateTransition DIAGNOSTIC_UPDATE_TRANSITION = new DiagnosticsUpdateTransition();
    private static final InternalErrorTransition INTERNAL_ERROR_TRANSITION = new InternalErrorTransition();
    private static final InternalRebootTransition INTERNAL_REBOOT_TRANSITION = new InternalRebootTransition();
    private static final TaskAttemptCompletedEventTransition TASK_ATTEMPT_COMPLETED_EVENT_TRANSITION = new TaskAttemptCompletedEventTransition();
    private static final CounterUpdateTransition COUNTER_UPDATE_TRANSITION = new CounterUpdateTransition();
    private static final UpdatedNodesTransition UPDATED_NODES_TRANSITION = new UpdatedNodesTransition();
    protected static final StateMachineFactory<JobImpl, JobStateInternal, JobEventType, JobEvent> stateMachineFactory = new StateMachineFactory((Enum)JobStateInternal.NEW).addTransition((Enum)JobStateInternal.NEW, (Enum)JobStateInternal.NEW, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.NEW, (Enum)JobStateInternal.NEW, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.NEW, EnumSet.of(JobStateInternal.INITED, JobStateInternal.FAILED), (Enum)JobEventType.JOB_INIT, (MultipleArcTransition)new InitTransition()).addTransition((Enum)JobStateInternal.NEW, (Enum)JobStateInternal.KILLED, (Enum)JobEventType.JOB_KILL, (SingleArcTransition)new KillNewJobTransition()).addTransition((Enum)JobStateInternal.NEW, (Enum)JobStateInternal.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobStateInternal.NEW, (Enum)JobStateInternal.REBOOT, (Enum)JobEventType.JOB_AM_REBOOT, (SingleArcTransition)INTERNAL_REBOOT_TRANSITION).addTransition((Enum)JobStateInternal.NEW, (Enum)JobStateInternal.NEW, (Enum)JobEventType.JOB_UPDATED_NODES).addTransition((Enum)JobStateInternal.INITED, (Enum)JobStateInternal.INITED, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.INITED, (Enum)JobStateInternal.INITED, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.INITED, (Enum)JobStateInternal.SETUP, (Enum)JobEventType.JOB_START, (SingleArcTransition)new StartTransition()).addTransition((Enum)JobStateInternal.INITED, (Enum)JobStateInternal.KILLED, (Enum)JobEventType.JOB_KILL, (SingleArcTransition)new KillInitedJobTransition()).addTransition((Enum)JobStateInternal.INITED, (Enum)JobStateInternal.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobStateInternal.INITED, (Enum)JobStateInternal.REBOOT, (Enum)JobEventType.JOB_AM_REBOOT, (SingleArcTransition)INTERNAL_REBOOT_TRANSITION).addTransition((Enum)JobStateInternal.INITED, (Enum)JobStateInternal.INITED, (Enum)JobEventType.JOB_UPDATED_NODES).addTransition((Enum)JobStateInternal.SETUP, (Enum)JobStateInternal.SETUP, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.SETUP, (Enum)JobStateInternal.SETUP, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.SETUP, (Enum)JobStateInternal.RUNNING, (Enum)JobEventType.JOB_SETUP_COMPLETED, (SingleArcTransition)new SetupCompletedTransition()).addTransition((Enum)JobStateInternal.SETUP, (Enum)JobStateInternal.FAIL_ABORT, (Enum)JobEventType.JOB_SETUP_FAILED, (SingleArcTransition)new SetupFailedTransition()).addTransition((Enum)JobStateInternal.SETUP, (Enum)JobStateInternal.KILL_ABORT, (Enum)JobEventType.JOB_KILL, (SingleArcTransition)new KilledDuringSetupTransition()).addTransition((Enum)JobStateInternal.SETUP, (Enum)JobStateInternal.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobStateInternal.SETUP, (Enum)JobStateInternal.REBOOT, (Enum)JobEventType.JOB_AM_REBOOT, (SingleArcTransition)INTERNAL_REBOOT_TRANSITION).addTransition((Enum)JobStateInternal.SETUP, (Enum)JobStateInternal.SETUP, (Enum)JobEventType.JOB_UPDATED_NODES).addTransition((Enum)JobStateInternal.RUNNING, (Enum)JobStateInternal.RUNNING, (Enum)JobEventType.JOB_TASK_ATTEMPT_COMPLETED, (SingleArcTransition)TASK_ATTEMPT_COMPLETED_EVENT_TRANSITION).addTransition((Enum)JobStateInternal.RUNNING, EnumSet.of(JobStateInternal.RUNNING, JobStateInternal.COMMITTING, JobStateInternal.FAIL_WAIT, JobStateInternal.FAIL_ABORT), (Enum)JobEventType.JOB_TASK_COMPLETED, (MultipleArcTransition)new TaskCompletedTransition()).addTransition((Enum)JobStateInternal.RUNNING, EnumSet.of(JobStateInternal.RUNNING, JobStateInternal.COMMITTING), (Enum)JobEventType.JOB_COMPLETED, (MultipleArcTransition)new JobNoTasksCompletedTransition()).addTransition((Enum)JobStateInternal.RUNNING, (Enum)JobStateInternal.KILL_WAIT, (Enum)JobEventType.JOB_KILL, (SingleArcTransition)new KillTasksTransition()).addTransition((Enum)JobStateInternal.RUNNING, (Enum)JobStateInternal.RUNNING, (Enum)JobEventType.JOB_UPDATED_NODES, (SingleArcTransition)UPDATED_NODES_TRANSITION).addTransition((Enum)JobStateInternal.RUNNING, (Enum)JobStateInternal.RUNNING, (Enum)JobEventType.JOB_MAP_TASK_RESCHEDULED, (SingleArcTransition)new MapTaskRescheduledTransition()).addTransition((Enum)JobStateInternal.RUNNING, (Enum)JobStateInternal.RUNNING, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.RUNNING, (Enum)JobStateInternal.RUNNING, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.RUNNING, (Enum)JobStateInternal.RUNNING, (Enum)JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE, (SingleArcTransition)new TaskAttemptFetchFailureTransition()).addTransition((Enum)JobStateInternal.RUNNING, (Enum)JobStateInternal.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobStateInternal.RUNNING, (Enum)JobStateInternal.REBOOT, (Enum)JobEventType.JOB_AM_REBOOT, (SingleArcTransition)INTERNAL_REBOOT_TRANSITION).addTransition((Enum)JobStateInternal.KILL_WAIT, EnumSet.of(JobStateInternal.KILL_WAIT, JobStateInternal.KILL_ABORT), (Enum)JobEventType.JOB_TASK_COMPLETED, (MultipleArcTransition)new KillWaitTaskCompletedTransition()).addTransition((Enum)JobStateInternal.KILL_WAIT, (Enum)JobStateInternal.KILL_WAIT, (Enum)JobEventType.JOB_TASK_ATTEMPT_COMPLETED, (SingleArcTransition)TASK_ATTEMPT_COMPLETED_EVENT_TRANSITION).addTransition((Enum)JobStateInternal.KILL_WAIT, (Enum)JobStateInternal.KILL_WAIT, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.KILL_WAIT, (Enum)JobStateInternal.KILL_WAIT, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.KILL_WAIT, (Enum)JobStateInternal.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobStateInternal.KILL_WAIT, (Enum)JobStateInternal.KILL_WAIT, EnumSet.of(JobEventType.JOB_KILL, JobEventType.JOB_UPDATED_NODES, JobEventType.JOB_MAP_TASK_RESCHEDULED, JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE, JobEventType.JOB_AM_REBOOT)).addTransition((Enum)JobStateInternal.COMMITTING, (Enum)JobStateInternal.SUCCEEDED, (Enum)JobEventType.JOB_COMMIT_COMPLETED, (SingleArcTransition)new CommitSucceededTransition()).addTransition((Enum)JobStateInternal.COMMITTING, (Enum)JobStateInternal.FAIL_ABORT, (Enum)JobEventType.JOB_COMMIT_FAILED, (SingleArcTransition)new CommitFailedTransition()).addTransition((Enum)JobStateInternal.COMMITTING, (Enum)JobStateInternal.KILL_ABORT, (Enum)JobEventType.JOB_KILL, (SingleArcTransition)new KilledDuringCommitTransition()).addTransition((Enum)JobStateInternal.COMMITTING, (Enum)JobStateInternal.COMMITTING, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.COMMITTING, (Enum)JobStateInternal.COMMITTING, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.COMMITTING, (Enum)JobStateInternal.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobStateInternal.COMMITTING, (Enum)JobStateInternal.REBOOT, (Enum)JobEventType.JOB_AM_REBOOT, (SingleArcTransition)INTERNAL_REBOOT_TRANSITION).addTransition((Enum)JobStateInternal.COMMITTING, (Enum)JobStateInternal.COMMITTING, EnumSet.of(JobEventType.JOB_UPDATED_NODES, JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE)).addTransition((Enum)JobStateInternal.SUCCEEDED, (Enum)JobStateInternal.SUCCEEDED, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.SUCCEEDED, (Enum)JobStateInternal.SUCCEEDED, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.SUCCEEDED, (Enum)JobStateInternal.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobStateInternal.SUCCEEDED, (Enum)JobStateInternal.SUCCEEDED, EnumSet.of(JobEventType.JOB_KILL, new JobEventType[]{JobEventType.JOB_UPDATED_NODES, JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE, JobEventType.JOB_AM_REBOOT, JobEventType.JOB_TASK_ATTEMPT_COMPLETED, JobEventType.JOB_MAP_TASK_RESCHEDULED})).addTransition((Enum)JobStateInternal.FAIL_WAIT, (Enum)JobStateInternal.FAIL_WAIT, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.FAIL_WAIT, (Enum)JobStateInternal.FAIL_WAIT, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.FAIL_WAIT, EnumSet.of(JobStateInternal.FAIL_WAIT, JobStateInternal.FAIL_ABORT), (Enum)JobEventType.JOB_TASK_COMPLETED, (MultipleArcTransition)new JobFailWaitTransition()).addTransition((Enum)JobStateInternal.FAIL_WAIT, (Enum)JobStateInternal.FAIL_ABORT, (Enum)JobEventType.JOB_FAIL_WAIT_TIMEDOUT, (SingleArcTransition)new JobFailWaitTimedOutTransition()).addTransition((Enum)JobStateInternal.FAIL_WAIT, (Enum)JobStateInternal.KILLED, (Enum)JobEventType.JOB_KILL, (SingleArcTransition)new KilledDuringAbortTransition()).addTransition((Enum)JobStateInternal.FAIL_WAIT, (Enum)JobStateInternal.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobStateInternal.FAIL_WAIT, (Enum)JobStateInternal.FAIL_WAIT, EnumSet.of(JobEventType.JOB_UPDATED_NODES, JobEventType.JOB_TASK_ATTEMPT_COMPLETED, JobEventType.JOB_MAP_TASK_RESCHEDULED, JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE, JobEventType.JOB_AM_REBOOT)).addTransition((Enum)JobStateInternal.FAIL_ABORT, (Enum)JobStateInternal.FAIL_ABORT, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.FAIL_ABORT, (Enum)JobStateInternal.FAIL_ABORT, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.FAIL_ABORT, (Enum)JobStateInternal.FAILED, (Enum)JobEventType.JOB_ABORT_COMPLETED, (SingleArcTransition)new JobAbortCompletedTransition()).addTransition((Enum)JobStateInternal.FAIL_ABORT, (Enum)JobStateInternal.KILLED, (Enum)JobEventType.JOB_KILL, (SingleArcTransition)new KilledDuringAbortTransition()).addTransition((Enum)JobStateInternal.FAIL_ABORT, (Enum)JobStateInternal.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobStateInternal.FAIL_ABORT, (Enum)JobStateInternal.FAIL_ABORT, EnumSet.of(JobEventType.JOB_UPDATED_NODES, new JobEventType[]{JobEventType.JOB_TASK_COMPLETED, JobEventType.JOB_TASK_ATTEMPT_COMPLETED, JobEventType.JOB_MAP_TASK_RESCHEDULED, JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE, JobEventType.JOB_COMMIT_COMPLETED, JobEventType.JOB_COMMIT_FAILED, JobEventType.JOB_AM_REBOOT, JobEventType.JOB_FAIL_WAIT_TIMEDOUT})).addTransition((Enum)JobStateInternal.KILL_ABORT, (Enum)JobStateInternal.KILL_ABORT, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.KILL_ABORT, (Enum)JobStateInternal.KILL_ABORT, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.KILL_ABORT, (Enum)JobStateInternal.KILLED, (Enum)JobEventType.JOB_ABORT_COMPLETED, (SingleArcTransition)new JobAbortCompletedTransition()).addTransition((Enum)JobStateInternal.KILL_ABORT, (Enum)JobStateInternal.KILLED, (Enum)JobEventType.JOB_KILL, (SingleArcTransition)new KilledDuringAbortTransition()).addTransition((Enum)JobStateInternal.KILL_ABORT, (Enum)JobStateInternal.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobStateInternal.KILL_ABORT, (Enum)JobStateInternal.KILL_ABORT, EnumSet.of(JobEventType.JOB_UPDATED_NODES, new JobEventType[]{JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE, JobEventType.JOB_SETUP_COMPLETED, JobEventType.JOB_SETUP_FAILED, JobEventType.JOB_COMMIT_COMPLETED, JobEventType.JOB_COMMIT_FAILED, JobEventType.JOB_AM_REBOOT})).addTransition((Enum)JobStateInternal.FAILED, (Enum)JobStateInternal.FAILED, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.FAILED, (Enum)JobStateInternal.FAILED, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.FAILED, (Enum)JobStateInternal.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobStateInternal.FAILED, (Enum)JobStateInternal.FAILED, EnumSet.of(JobEventType.JOB_KILL, new JobEventType[]{JobEventType.JOB_UPDATED_NODES, JobEventType.JOB_TASK_COMPLETED, JobEventType.JOB_TASK_ATTEMPT_COMPLETED, JobEventType.JOB_MAP_TASK_RESCHEDULED, JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE, JobEventType.JOB_SETUP_COMPLETED, JobEventType.JOB_SETUP_FAILED, JobEventType.JOB_COMMIT_COMPLETED, JobEventType.JOB_COMMIT_FAILED, JobEventType.JOB_ABORT_COMPLETED, JobEventType.JOB_AM_REBOOT})).addTransition((Enum)JobStateInternal.KILLED, (Enum)JobStateInternal.KILLED, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.KILLED, (Enum)JobStateInternal.KILLED, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.KILLED, (Enum)JobStateInternal.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobStateInternal.KILLED, (Enum)JobStateInternal.KILLED, EnumSet.of(JobEventType.JOB_KILL, new JobEventType[]{JobEventType.JOB_START, JobEventType.JOB_UPDATED_NODES, JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE, JobEventType.JOB_SETUP_COMPLETED, JobEventType.JOB_SETUP_FAILED, JobEventType.JOB_COMMIT_COMPLETED, JobEventType.JOB_COMMIT_FAILED, JobEventType.JOB_ABORT_COMPLETED, JobEventType.JOB_AM_REBOOT})).addTransition((Enum)JobStateInternal.ERROR, (Enum)JobStateInternal.ERROR, EnumSet.of(JobEventType.JOB_INIT, new JobEventType[]{JobEventType.JOB_KILL, JobEventType.JOB_TASK_COMPLETED, JobEventType.JOB_TASK_ATTEMPT_COMPLETED, JobEventType.JOB_MAP_TASK_RESCHEDULED, JobEventType.JOB_DIAGNOSTIC_UPDATE, JobEventType.JOB_UPDATED_NODES, JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE, JobEventType.JOB_SETUP_COMPLETED, JobEventType.JOB_SETUP_FAILED, JobEventType.JOB_COMMIT_COMPLETED, JobEventType.JOB_COMMIT_FAILED, JobEventType.JOB_ABORT_COMPLETED, JobEventType.INTERNAL_ERROR, JobEventType.JOB_AM_REBOOT})).addTransition((Enum)JobStateInternal.ERROR, (Enum)JobStateInternal.ERROR, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobStateInternal.REBOOT, (Enum)JobStateInternal.REBOOT, EnumSet.of(JobEventType.JOB_INIT, new JobEventType[]{JobEventType.JOB_KILL, JobEventType.JOB_TASK_COMPLETED, JobEventType.JOB_TASK_ATTEMPT_COMPLETED, JobEventType.JOB_MAP_TASK_RESCHEDULED, JobEventType.JOB_DIAGNOSTIC_UPDATE, JobEventType.JOB_UPDATED_NODES, JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE, JobEventType.JOB_SETUP_COMPLETED, JobEventType.JOB_SETUP_FAILED, JobEventType.JOB_COMMIT_COMPLETED, JobEventType.JOB_COMMIT_FAILED, JobEventType.JOB_ABORT_COMPLETED, JobEventType.INTERNAL_ERROR, JobEventType.JOB_AM_REBOOT})).addTransition((Enum)JobStateInternal.REBOOT, (Enum)JobStateInternal.REBOOT, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).installTopology();
    private final StateMachine<JobStateInternal, JobEventType, JobEvent> stateMachine;
    private int numMapTasks;
    private int numReduceTasks;
    private int completedTaskCount = 0;
    private int succeededMapTaskCount = 0;
    private int succeededReduceTaskCount = 0;
    private int failedMapTaskCount = 0;
    private int failedReduceTaskCount = 0;
    private int killedMapTaskCount = 0;
    private int killedReduceTaskCount = 0;
    private long startTime;
    private long finishTime;
    private float setupProgress;
    private float mapProgress;
    private float reduceProgress;
    private float cleanupProgress;
    private boolean isUber = false;
    private Credentials jobCredentials;
    private Token<JobTokenIdentifier> jobToken;
    private JobTokenSecretManager jobTokenSecretManager;
    private JobStateInternal forcedState = null;
    private ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
    private ScheduledFuture failWaitTriggerScheduledFuture;
    private JobState lastNonFinalState = JobState.NEW;

    public JobImpl(JobId jobId, ApplicationAttemptId applicationAttemptId, Configuration conf, EventHandler eventHandler, TaskAttemptListener taskAttemptListener, JobTokenSecretManager jobTokenSecretManager, Credentials jobCredentials, Clock clock, Map<TaskId, JobHistoryParser.TaskInfo> completedTasksFromPreviousRun, MRAppMetrics metrics, OutputCommitter committer, boolean newApiCommitter, String userName, long appSubmitTime, List<AMInfo> amInfos, AppContext appContext, JobStateInternal forcedState, String forcedDiagnostic) {
        this.applicationAttemptId = applicationAttemptId;
        this.jobId = jobId;
        this.jobName = conf.get("mapreduce.job.name", "<missing job name>");
        this.conf = new JobConf(conf);
        this.metrics = metrics;
        this.clock = clock;
        this.completedTasksFromPreviousRun = completedTasksFromPreviousRun;
        this.amInfos = amInfos;
        this.appContext = appContext;
        this.userName = userName;
        this.queueName = conf.get("mapreduce.job.queuename", "default");
        this.appSubmitTime = appSubmitTime;
        this.oldJobId = TypeConverter.fromYarn((JobId)jobId);
        this.committer = committer;
        this.newApiCommitter = newApiCommitter;
        this.taskAttemptListener = taskAttemptListener;
        this.eventHandler = eventHandler;
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
        this.jobCredentials = jobCredentials;
        this.jobTokenSecretManager = jobTokenSecretManager;
        this.aclsManager = new JobACLsManager(conf);
        this.username = System.getProperty("user.name");
        this.jobACLs = this.aclsManager.constructJobACLs(conf);
        this.stateMachine = stateMachineFactory.make((Object)this);
        this.forcedState = forcedState;
        if (forcedDiagnostic != null) {
            this.diagnostics.add(forcedDiagnostic);
        }
    }

    protected StateMachine<JobStateInternal, JobEventType, JobEvent> getStateMachine() {
        return this.stateMachine;
    }

    @Override
    public JobId getID() {
        return this.jobId;
    }

    EventHandler getEventHandler() {
        return this.eventHandler;
    }

    JobContext getJobContext() {
        return this.jobContext;
    }

    @Override
    public boolean checkAccess(UserGroupInformation callerUGI, JobACL jobOperation) {
        AccessControlList jobACL = this.jobACLs.get(jobOperation);
        if (jobACL == null) {
            return true;
        }
        return this.aclsManager.checkAccess(callerUGI, jobOperation, this.username, jobACL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task getTask(TaskId taskID) {
        this.readLock.lock();
        try {
            Task task = this.tasks.get(taskID);
            return task;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCompletedMaps() {
        this.readLock.lock();
        try {
            int n = this.succeededMapTaskCount + this.failedMapTaskCount + this.killedMapTaskCount;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCompletedReduces() {
        this.readLock.lock();
        try {
            int n = this.succeededReduceTaskCount + this.failedReduceTaskCount + this.killedReduceTaskCount;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isUber() {
        return this.isUber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Counters getAllCounters() {
        this.readLock.lock();
        try {
            JobStateInternal state = this.getInternalState();
            if (state == JobStateInternal.ERROR || state == JobStateInternal.FAILED || state == JobStateInternal.KILLED || state == JobStateInternal.SUCCEEDED) {
                this.mayBeConstructFinalFullCounters();
                Counters counters = this.fullCounters;
                return counters;
            }
            Counters counters = new Counters();
            counters.incrAllCounters((AbstractCounters)this.jobCounters);
            Counters counters2 = JobImpl.incrTaskCounters(counters, this.tasks.values());
            return counters2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public static Counters incrTaskCounters(Counters counters, Collection<Task> tasks) {
        for (Task task : tasks) {
            counters.incrAllCounters((AbstractCounters)task.getCounters());
        }
        return counters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskAttemptCompletionEvent[] getTaskAttemptCompletionEvents(int fromEventId, int maxEvents) {
        TaskAttemptCompletionEvent[] events = EMPTY_TASK_ATTEMPT_COMPLETION_EVENTS;
        this.readLock.lock();
        try {
            if (this.taskAttemptCompletionEvents.size() > fromEventId) {
                int actualMax = Math.min(maxEvents, this.taskAttemptCompletionEvents.size() - fromEventId);
                events = this.taskAttemptCompletionEvents.subList(fromEventId, actualMax + fromEventId).toArray(events);
            }
            TaskAttemptCompletionEvent[] taskAttemptCompletionEventArray = events;
            return taskAttemptCompletionEventArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskCompletionEvent[] getMapAttemptCompletionEvents(int startIndex, int maxEvents) {
        TaskCompletionEvent[] events = EMPTY_TASK_COMPLETION_EVENTS;
        this.readLock.lock();
        try {
            if (this.mapAttemptCompletionEvents.size() > startIndex) {
                int actualMax = Math.min(maxEvents, this.mapAttemptCompletionEvents.size() - startIndex);
                events = this.mapAttemptCompletionEvents.subList(startIndex, actualMax + startIndex).toArray(events);
            }
            TaskCompletionEvent[] taskCompletionEventArray = events;
            return taskCompletionEventArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getDiagnostics() {
        this.readLock.lock();
        try {
            List<String> list = this.diagnostics;
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobReport getReport() {
        this.readLock.lock();
        try {
            JobReport report;
            JobState state = this.getState();
            String jobFile = this.remoteJobConfFile == null ? "" : this.remoteJobConfFile.toString();
            StringBuilder diagsb = new StringBuilder();
            for (String s : this.getDiagnostics()) {
                diagsb.append(s).append("\n");
            }
            if (this.getInternalState() == JobStateInternal.NEW) {
                JobReport i$ = MRBuilderUtils.newJobReport((JobId)this.jobId, (String)this.jobName, (String)this.username, (JobState)state, (long)this.appSubmitTime, (long)this.startTime, (long)this.finishTime, (float)this.setupProgress, (float)0.0f, (float)0.0f, (float)this.cleanupProgress, (String)jobFile, this.amInfos, (boolean)this.isUber, (String)diagsb.toString());
                return i$;
            }
            this.computeProgress();
            JobReport jobReport = report = MRBuilderUtils.newJobReport((JobId)this.jobId, (String)this.jobName, (String)this.username, (JobState)state, (long)this.appSubmitTime, (long)this.startTime, (long)this.finishTime, (float)this.setupProgress, (float)this.mapProgress, (float)this.reduceProgress, (float)this.cleanupProgress, (String)jobFile, this.amInfos, (boolean)this.isUber, (String)diagsb.toString());
            return jobReport;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getProgress() {
        this.readLock.lock();
        try {
            this.computeProgress();
            float f = this.setupProgress * this.setupWeight + this.cleanupProgress * this.cleanupWeight + this.mapProgress * this.mapWeight + this.reduceProgress * this.reduceWeight;
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeProgress() {
        this.readLock.lock();
        try {
            float mapProgress = 0.0f;
            float reduceProgress = 0.0f;
            for (Task task : this.tasks.values()) {
                if (task.getType() == TaskType.MAP) {
                    mapProgress += task.isFinished() ? 1.0f : task.getProgress();
                    continue;
                }
                reduceProgress += task.isFinished() ? 1.0f : task.getProgress();
            }
            if (this.numMapTasks != 0) {
                mapProgress /= (float)this.numMapTasks;
            }
            if (this.numReduceTasks != 0) {
                reduceProgress /= (float)this.numReduceTasks;
            }
            this.mapProgress = mapProgress;
            this.reduceProgress = reduceProgress;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<TaskId, Task> getTasks() {
        Object object = this.tasksSyncHandle;
        synchronized (object) {
            this.lazyTasksCopyNeeded = true;
            return Collections.unmodifiableMap(this.tasks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<TaskId, Task> getTasks(TaskType taskType) {
        Map<TaskId, Task> localTasksCopy = this.tasks;
        HashMap<TaskId, Task> result = new HashMap<TaskId, Task>();
        Set<TaskId> tasksOfGivenType = null;
        this.readLock.lock();
        try {
            tasksOfGivenType = TaskType.MAP == taskType ? this.mapTasks : this.reduceTasks;
            for (TaskId taskID : tasksOfGivenType) {
                result.put(taskID, localTasksCopy.get(taskID));
            }
            HashMap<TaskId, Task> hashMap = result;
            return hashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobState getState() {
        this.readLock.lock();
        try {
            JobState state = this.getExternalState(this.getInternalState());
            if (!(this.appContext.hasSuccessfullyUnregistered() || state != JobState.SUCCEEDED && state != JobState.FAILED && state != JobState.KILLED && state != JobState.ERROR)) {
                JobState jobState = this.lastNonFinalState;
                return jobState;
            }
            JobState jobState = state;
            return jobState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected void scheduleTasks(Set<TaskId> taskIDs, boolean recoverTaskOutput) {
        for (TaskId taskID : taskIDs) {
            JobHistoryParser.TaskInfo taskInfo = this.completedTasksFromPreviousRun.remove(taskID);
            if (taskInfo != null) {
                this.eventHandler.handle((Event)new TaskRecoverEvent(taskID, taskInfo, this.committer, recoverTaskOutput));
                continue;
            }
            this.eventHandler.handle((Event)new TaskEvent(taskID, TaskEventType.T_SCHEDULE));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(JobEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing " + event.getJobId() + " of type " + event.getType()));
        }
        try {
            this.writeLock.lock();
            JobStateInternal oldState = this.getInternalState();
            try {
                this.getStateMachine().doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)"Can't handle this event at current state", (Throwable)e);
                this.addDiagnostic("Invalid event " + event.getType() + " on Job " + this.jobId);
                this.eventHandler.handle((Event)new JobEvent(this.jobId, JobEventType.INTERNAL_ERROR));
            }
            if (oldState != this.getInternalState()) {
                LOG.info((Object)(this.jobId + "Job Transitioned from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getInternalState())));
                this.rememberLastNonFinalState(oldState);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void rememberLastNonFinalState(JobStateInternal stateInternal) {
        JobState state = this.getExternalState(stateInternal);
        if (state != JobState.SUCCEEDED && state != JobState.FAILED && state != JobState.KILLED && state != JobState.ERROR) {
            this.lastNonFinalState = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public JobStateInternal getInternalState() {
        this.readLock.lock();
        try {
            if (this.forcedState != null) {
                JobStateInternal jobStateInternal = this.forcedState;
                return jobStateInternal;
            }
            JobStateInternal jobStateInternal = (JobStateInternal)this.getStateMachine().getCurrentState();
            return jobStateInternal;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private JobState getExternalState(JobStateInternal smState) {
        switch (smState) {
            case KILL_WAIT: 
            case KILL_ABORT: {
                return JobState.KILLED;
            }
            case SETUP: 
            case COMMITTING: {
                return JobState.RUNNING;
            }
            case FAIL_WAIT: 
            case FAIL_ABORT: {
                return JobState.FAILED;
            }
            case REBOOT: {
                if (this.appContext.isLastAMRetry()) {
                    return JobState.ERROR;
                }
                return JobState.RUNNING;
            }
        }
        return JobState.valueOf((String)smState.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTask(Task task) {
        Object object = this.tasksSyncHandle;
        synchronized (object) {
            if (this.lazyTasksCopyNeeded) {
                LinkedHashMap<TaskId, Task> newTasks = new LinkedHashMap<TaskId, Task>();
                newTasks.putAll(this.tasks);
                this.tasks = newTasks;
                this.lazyTasksCopyNeeded = false;
            }
        }
        this.tasks.put(task.getID(), task);
        if (task.getType() == TaskType.MAP) {
            this.mapTasks.add(task.getID());
        } else if (task.getType() == TaskType.REDUCE) {
            this.reduceTasks.add(task.getID());
        }
        this.metrics.waitingTask(task);
    }

    void setFinishTime() {
        this.finishTime = this.clock.getTime();
    }

    void logJobHistoryFinishedEvent() {
        this.setFinishTime();
        JobFinishedEvent jfe = JobImpl.createJobFinishedEvent(this);
        LOG.info((Object)"Calling handler for JobFinishedEvent ");
        this.getEventHandler().handle((Event)new JobHistoryEvent(this.jobId, (HistoryEvent)jfe));
    }

    protected FileSystem getFileSystem(Configuration conf) throws IOException {
        return FileSystem.get((Configuration)conf);
    }

    protected JobStateInternal checkReadyForCommit() {
        JobStateInternal currentState = this.getInternalState();
        if (this.completedTaskCount == this.tasks.size() && currentState == JobStateInternal.RUNNING) {
            this.eventHandler.handle((Event)new CommitterJobCommitEvent(this.jobId, this.getJobContext()));
            return JobStateInternal.COMMITTING;
        }
        return this.getInternalState();
    }

    JobStateInternal finished(JobStateInternal finalState) {
        if (this.getInternalState() == JobStateInternal.RUNNING) {
            this.metrics.endRunningJob(this);
        }
        if (this.finishTime == 0L) {
            this.setFinishTime();
        }
        this.eventHandler.handle((Event)new JobFinishEvent(this.jobId));
        switch (finalState) {
            case KILLED: {
                this.metrics.killedJob(this);
                break;
            }
            case REBOOT: 
            case ERROR: 
            case FAILED: {
                this.metrics.failedJob(this);
                break;
            }
            case SUCCEEDED: {
                this.metrics.completedJob(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal job state: " + (Object)((Object)finalState));
            }
        }
        return finalState;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public void setQueueName(String queueName) {
        this.queueName = queueName;
        JobQueueChangeEvent jqce = new JobQueueChangeEvent(this.oldJobId, queueName);
        this.eventHandler.handle((Event)new JobHistoryEvent(this.jobId, (HistoryEvent)jqce));
    }

    @Override
    public Path getConfFile() {
        return this.remoteJobConfFile;
    }

    @Override
    public String getName() {
        return this.jobName;
    }

    @Override
    public int getTotalMaps() {
        return this.mapTasks.size();
    }

    @Override
    public int getTotalReduces() {
        return this.reduceTasks.size();
    }

    @Override
    public Map<JobACL, AccessControlList> getJobACLs() {
        return Collections.unmodifiableMap(this.jobACLs);
    }

    @Override
    public List<AMInfo> getAMInfos() {
        return this.amInfos;
    }

    private void makeUberDecision(long dataInputLength) {
        int sysMaxMaps = this.conf.getInt("mapreduce.job.ubertask.maxmaps", 9);
        int sysMaxReduces = this.conf.getInt("mapreduce.job.ubertask.maxreduces", 1);
        long sysMaxBytes = this.conf.getLong("mapreduce.job.ubertask.maxbytes", this.fs.getDefaultBlockSize(this.remoteJobSubmitDir));
        long sysMemSizeForUberSlot = this.conf.getInt("yarn.app.mapreduce.am.resource.mb", 1536);
        long sysCPUSizeForUberSlot = this.conf.getInt("yarn.app.mapreduce.am.resource.cpu-vcores", 1);
        boolean uberEnabled = this.conf.getBoolean("mapreduce.job.ubertask.enable", false);
        boolean smallNumMapTasks = this.numMapTasks <= sysMaxMaps;
        boolean smallNumReduceTasks = this.numReduceTasks <= sysMaxReduces;
        boolean smallInput = dataInputLength <= sysMaxBytes;
        boolean smallMemory = Math.max(this.conf.getLong("mapreduce.map.memory.mb", 0L), this.conf.getLong("mapreduce.reduce.memory.mb", 0L)) <= sysMemSizeForUberSlot || sysMemSizeForUberSlot == -1L;
        boolean smallCpu = (long)Math.max(this.conf.getInt("mapreduce.map.cpu.vcores", 1), this.conf.getInt("mapreduce.reduce.cpu.vcores", 1)) <= sysCPUSizeForUberSlot;
        boolean notChainJob = !this.isChainJob((Configuration)this.conf);
        boolean bl = this.isUber = uberEnabled && smallNumMapTasks && smallNumReduceTasks && smallInput && smallMemory && smallCpu && notChainJob;
        if (this.isUber) {
            LOG.info((Object)("Uberizing job " + this.jobId + ": " + this.numMapTasks + "m+" + this.numReduceTasks + "r tasks (" + dataInputLength + " input bytes) will run sequentially on single node."));
            this.conf.setFloat("mapreduce.job.reduce.slowstart.completedmaps", 1.0f);
            this.conf.setInt("mapreduce.map.maxattempts", 1);
            this.conf.setInt("mapreduce.reduce.maxattempts", 1);
            this.conf.setBoolean("mapreduce.map.speculative", false);
            this.conf.setBoolean("mapreduce.reduce.speculative", false);
        } else {
            StringBuilder msg = new StringBuilder();
            msg.append("Not uberizing ").append(this.jobId).append(" because:");
            if (!uberEnabled) {
                msg.append(" not enabled;");
            }
            if (!smallNumMapTasks) {
                msg.append(" too many maps;");
            }
            if (!smallNumReduceTasks) {
                msg.append(" too many reduces;");
            }
            if (!smallInput) {
                msg.append(" too much input;");
            }
            if (!smallMemory) {
                msg.append(" too much RAM;");
            }
            if (!notChainJob) {
                msg.append(" chainjob;");
            }
            LOG.info((Object)msg.toString());
        }
    }

    private boolean isChainJob(Configuration conf) {
        boolean isChainJob = false;
        try {
            Class<?> mapClass;
            String mapClassName = conf.get("mapreduce.job.map.class");
            if (mapClassName != null && ChainMapper.class.isAssignableFrom(mapClass = Class.forName(mapClassName))) {
                isChainJob = true;
            }
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        try {
            Class<?> reduceClass;
            String reduceClassName = conf.get("mapreduce.job.reduce.class");
            if (reduceClassName != null && ChainReducer.class.isAssignableFrom(reduceClass = Class.forName(reduceClassName))) {
                isChainJob = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return isChainJob;
    }

    private void actOnUnusableNode(NodeId nodeId, NodeState nodeState) {
        List<TaskAttemptId> taskAttemptIdList = this.nodesToSucceededTaskAttempts.get(nodeId);
        if (taskAttemptIdList != null) {
            String mesg = "TaskAttempt killed because it ran on unusable node " + nodeId;
            for (TaskAttemptId id : taskAttemptIdList) {
                if (TaskType.MAP != id.getTaskId().getTaskType()) continue;
                LOG.info((Object)(mesg + ". AttemptId:" + id));
                this.eventHandler.handle((Event)new TaskAttemptKillEvent(id, mesg));
            }
        }
    }

    private static String getWorkflowAdjacencies(Configuration conf) {
        int prefixLen = "mapreduce.workflow.adjacency.".length();
        Map adjacencies = conf.getValByRegex("^mapreduce\\.workflow\\.adjacency\\..+");
        if (adjacencies.isEmpty()) {
            return "";
        }
        int size = 0;
        for (Map.Entry entry : adjacencies.entrySet()) {
            int keyLen = ((String)entry.getKey()).length();
            size += keyLen - prefixLen;
            size += ((String)entry.getValue()).length() + 6;
        }
        StringBuilder sb = new StringBuilder(size);
        for (Map.Entry entry : adjacencies.entrySet()) {
            int keyLen = ((String)entry.getKey()).length();
            sb.append("\"");
            sb.append(JobImpl.escapeString(((String)entry.getKey()).substring(prefixLen, keyLen)));
            sb.append("\"=\"");
            sb.append(JobImpl.escapeString((String)entry.getValue()));
            sb.append("\" ");
        }
        return sb.toString();
    }

    public static String escapeString(String data) {
        return StringUtils.escapeString((String)data, (char)'\\', (char[])new char[]{'\"', '=', '.'});
    }

    private void unsuccessfulFinish(JobStateInternal finalState) {
        if (this.finishTime == 0L) {
            this.setFinishTime();
        }
        this.cleanupProgress = 1.0f;
        JobUnsuccessfulCompletionEvent unsuccessfulJobEvent = new JobUnsuccessfulCompletionEvent(this.oldJobId, this.finishTime, this.succeededMapTaskCount, this.succeededReduceTaskCount, finalState.toString(), this.diagnostics);
        this.eventHandler.handle((Event)new JobHistoryEvent(this.jobId, (HistoryEvent)unsuccessfulJobEvent));
        this.finished(finalState);
    }

    private static JobFinishedEvent createJobFinishedEvent(JobImpl job) {
        job.mayBeConstructFinalFullCounters();
        JobFinishedEvent jfe = new JobFinishedEvent(job.oldJobId, job.finishTime, job.succeededMapTaskCount, job.succeededReduceTaskCount, job.failedMapTaskCount, job.failedReduceTaskCount, job.finalMapCounters, job.finalReduceCounters, job.fullCounters);
        return jfe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mayBeConstructFinalFullCounters() {
        Object object = this.fullCountersLock;
        synchronized (object) {
            if (this.fullCounters != null) {
                return;
            }
            this.constructFinalFullcounters();
        }
    }

    @InterfaceAudience.Private
    public void constructFinalFullcounters() {
        this.fullCounters = new Counters();
        this.finalMapCounters = new Counters();
        this.finalReduceCounters = new Counters();
        this.fullCounters.incrAllCounters((AbstractCounters)this.jobCounters);
        for (Task t : this.tasks.values()) {
            Counters counters = t.getCounters();
            switch (t.getType()) {
                case MAP: {
                    this.finalMapCounters.incrAllCounters((AbstractCounters)counters);
                    break;
                }
                case REDUCE: {
                    this.finalReduceCounters.incrAllCounters((AbstractCounters)counters);
                    break;
                }
                default: {
                    throw new IllegalStateException("Task type neither map nor reduce: " + t.getType());
                }
            }
            this.fullCounters.incrAllCounters((AbstractCounters)counters);
        }
    }

    protected void addDiagnostic(String diag) {
        this.diagnostics.add(diag);
    }

    @Override
    public Configuration loadConfFile() throws IOException {
        Path confPath = this.getConfFile();
        FileContext fc = FileContext.getFileContext((URI)confPath.toUri(), (Configuration)this.conf);
        Configuration jobConf = new Configuration(false);
        jobConf.addResource((InputStream)fc.open(confPath), confPath.toString());
        return jobConf;
    }

    private static class InternalRebootTransition
    extends InternalTerminationTransition {
        public InternalRebootTransition() {
            super(JobStateInternal.REBOOT, JobStateInternal.ERROR.toString());
        }
    }

    private static class InternalErrorTransition
    extends InternalTerminationTransition {
        public InternalErrorTransition() {
            super(JobStateInternal.ERROR, JobStateInternal.ERROR.toString());
        }
    }

    private static class InternalTerminationTransition
    implements SingleArcTransition<JobImpl, JobEvent> {
        JobStateInternal terminationState = null;
        String jobHistoryString = null;

        public InternalTerminationTransition(JobStateInternal stateInternal, String jobHistoryString) {
            this.terminationState = stateInternal;
            this.jobHistoryString = jobHistoryString;
        }

        public void transition(JobImpl job, JobEvent event) {
            job.setFinishTime();
            JobUnsuccessfulCompletionEvent failedEvent = new JobUnsuccessfulCompletionEvent(job.oldJobId, job.finishTime, 0, 0, this.jobHistoryString, (Iterable)job.diagnostics);
            job.eventHandler.handle((Event)new JobHistoryEvent(job.jobId, (HistoryEvent)failedEvent));
            job.finished(this.terminationState);
        }
    }

    private static class UpdatedNodesTransition
    implements SingleArcTransition<JobImpl, JobEvent> {
        private UpdatedNodesTransition() {
        }

        public void transition(JobImpl job, JobEvent event) {
            JobUpdatedNodesEvent updateEvent = (JobUpdatedNodesEvent)event;
            for (NodeReport nr : updateEvent.getUpdatedNodes()) {
                NodeState nodeState = nr.getNodeState();
                if (!nodeState.isUnusable()) continue;
                job.actOnUnusableNode(nr.getNodeId(), nodeState);
            }
        }
    }

    private static class CounterUpdateTransition
    implements SingleArcTransition<JobImpl, JobEvent> {
        private CounterUpdateTransition() {
        }

        public void transition(JobImpl job, JobEvent event) {
            JobCounterUpdateEvent jce = (JobCounterUpdateEvent)event;
            for (JobCounterUpdateEvent.CounterIncrementalUpdate ci : jce.getCounterUpdates()) {
                job.jobCounters.findCounter(ci.getCounterKey()).increment(ci.getIncrementValue());
            }
        }
    }

    private static class DiagnosticsUpdateTransition
    implements SingleArcTransition<JobImpl, JobEvent> {
        private DiagnosticsUpdateTransition() {
        }

        public void transition(JobImpl job, JobEvent event) {
            job.addDiagnostic(((JobDiagnosticsUpdateEvent)event).getDiagnosticUpdate());
        }
    }

    private static class KillWaitTaskCompletedTransition
    extends TaskCompletedTransition {
        private KillWaitTaskCompletedTransition() {
        }

        @Override
        protected JobStateInternal checkJobAfterTaskCompletion(JobImpl job) {
            if (job.completedTaskCount == job.tasks.size()) {
                job.setFinishTime();
                job.eventHandler.handle((Event)new CommitterJobAbortEvent(job.jobId, job.jobContext, JobStatus.State.KILLED));
                return JobStateInternal.KILL_ABORT;
            }
            return job.getInternalState();
        }
    }

    private static class MapTaskRescheduledTransition
    implements SingleArcTransition<JobImpl, JobEvent> {
        private MapTaskRescheduledTransition() {
        }

        public void transition(JobImpl job, JobEvent event) {
            job.completedTaskCount--;
            job.succeededMapTaskCount--;
        }
    }

    private static class KilledDuringAbortTransition
    implements SingleArcTransition<JobImpl, JobEvent> {
        private KilledDuringAbortTransition() {
        }

        public void transition(JobImpl job, JobEvent event) {
            job.unsuccessfulFinish(JobStateInternal.KILLED);
        }
    }

    private static class KilledDuringCommitTransition
    implements SingleArcTransition<JobImpl, JobEvent> {
        private KilledDuringCommitTransition() {
        }

        public void transition(JobImpl job, JobEvent event) {
            job.setFinishTime();
            job.eventHandler.handle((Event)new CommitterJobAbortEvent(job.jobId, job.jobContext, JobStatus.State.KILLED));
        }
    }

    private static class CommitFailedTransition
    implements SingleArcTransition<JobImpl, JobEvent> {
        private CommitFailedTransition() {
        }

        public void transition(JobImpl job, JobEvent event) {
            JobCommitFailedEvent jcfe = (JobCommitFailedEvent)event;
            job.addDiagnostic("Job commit failed: " + jcfe.getMessage());
            job.eventHandler.handle((Event)new CommitterJobAbortEvent(job.jobId, job.jobContext, JobStatus.State.FAILED));
        }
    }

    private static class CommitSucceededTransition
    implements SingleArcTransition<JobImpl, JobEvent> {
        private CommitSucceededTransition() {
        }

        public void transition(JobImpl job, JobEvent event) {
            job.logJobHistoryFinishedEvent();
            job.finished(JobStateInternal.SUCCEEDED);
        }
    }

    private static class JobNoTasksCompletedTransition
    implements MultipleArcTransition<JobImpl, JobEvent, JobStateInternal> {
        private JobNoTasksCompletedTransition() {
        }

        public JobStateInternal transition(JobImpl job, JobEvent event) {
            return job.checkReadyForCommit();
        }
    }

    private static class TaskCompletedTransition
    implements MultipleArcTransition<JobImpl, JobEvent, JobStateInternal> {
        private TaskCompletedTransition() {
        }

        public JobStateInternal transition(JobImpl job, JobEvent event) {
            job.completedTaskCount++;
            LOG.info((Object)("Num completed Tasks: " + job.completedTaskCount));
            JobTaskEvent taskEvent = (JobTaskEvent)event;
            Task task = job.tasks.get(taskEvent.getTaskID());
            if (taskEvent.getState() == TaskState.SUCCEEDED) {
                this.taskSucceeded(job, task);
            } else if (taskEvent.getState() == TaskState.FAILED) {
                this.taskFailed(job, task);
            } else if (taskEvent.getState() == TaskState.KILLED) {
                this.taskKilled(job, task);
            }
            return this.checkJobAfterTaskCompletion(job);
        }

        protected JobStateInternal checkJobAfterTaskCompletion(JobImpl job) {
            if (job.failedMapTaskCount * 100 > job.allowedMapFailuresPercent * job.numMapTasks || job.failedReduceTaskCount * 100 > job.allowedReduceFailuresPercent * job.numReduceTasks) {
                job.setFinishTime();
                String diagnosticMsg = "Job failed as tasks failed. failedMaps:" + job.failedMapTaskCount + " failedReduces:" + job.failedReduceTaskCount;
                LOG.info((Object)diagnosticMsg);
                job.addDiagnostic(diagnosticMsg);
                boolean allDone = true;
                for (Task task : job.tasks.values()) {
                    if (task.isFinished()) continue;
                    allDone = false;
                    job.eventHandler.handle((Event)new TaskEvent(task.getID(), TaskEventType.T_KILL));
                }
                if (allDone) {
                    job.eventHandler.handle((Event)new CommitterJobAbortEvent(job.jobId, job.jobContext, JobStatus.State.FAILED));
                    return JobStateInternal.FAIL_ABORT;
                }
                job.failWaitTriggerScheduledFuture = job.executor.schedule(new TriggerScheduledFuture(job, new JobEvent(job.getID(), JobEventType.JOB_FAIL_WAIT_TIMEDOUT)), (long)job.conf.getInt("yarn.app.mapreduce.am.job.committer.cancel-timeout", 60000), TimeUnit.MILLISECONDS);
                return JobStateInternal.FAIL_WAIT;
            }
            return job.checkReadyForCommit();
        }

        private void taskSucceeded(JobImpl job, Task task) {
            if (task.getType() == TaskType.MAP) {
                job.succeededMapTaskCount++;
            } else {
                job.succeededReduceTaskCount++;
            }
            job.metrics.completedTask(task);
        }

        private void taskFailed(JobImpl job, Task task) {
            if (task.getType() == TaskType.MAP) {
                job.failedMapTaskCount++;
            } else if (task.getType() == TaskType.REDUCE) {
                job.failedReduceTaskCount++;
            }
            job.addDiagnostic("Task failed " + task.getID());
            job.metrics.failedTask(task);
        }

        private void taskKilled(JobImpl job, Task task) {
            if (task.getType() == TaskType.MAP) {
                job.killedMapTaskCount++;
            } else if (task.getType() == TaskType.REDUCE) {
                job.killedReduceTaskCount++;
            }
            job.metrics.killedTask(task);
        }

        static class TriggerScheduledFuture
        implements Runnable {
            JobEvent toSend;
            JobImpl job;

            TriggerScheduledFuture(JobImpl job, JobEvent toSend) {
                this.toSend = toSend;
                this.job = job;
            }

            @Override
            public void run() {
                LOG.info((Object)("Sending event " + (Object)((Object)this.toSend) + " to " + this.job.getID()));
                this.job.getEventHandler().handle((Event)this.toSend);
            }
        }
    }

    private static class TaskAttemptFetchFailureTransition
    implements SingleArcTransition<JobImpl, JobEvent> {
        private TaskAttemptFetchFailureTransition() {
        }

        public void transition(JobImpl job, JobEvent event) {
            int shufflingReduceTasks = 0;
            block0: for (TaskId taskId : job.reduceTasks) {
                Task task = job.tasks.get(taskId);
                if (!TaskState.RUNNING.equals((Object)task.getState())) continue;
                for (TaskAttempt attempt : task.getAttempts().values()) {
                    if (attempt.getPhase() != Phase.SHUFFLE) continue;
                    ++shufflingReduceTasks;
                    continue block0;
                }
            }
            JobTaskAttemptFetchFailureEvent fetchfailureEvent = (JobTaskAttemptFetchFailureEvent)event;
            for (TaskAttemptId mapId : fetchfailureEvent.getMaps()) {
                boolean isMapFaulty;
                Integer fetchFailures = (Integer)job.fetchFailuresMapping.get(mapId);
                fetchFailures = fetchFailures == null ? 1 : fetchFailures + 1;
                job.fetchFailuresMapping.put(mapId, fetchFailures);
                float failureRate = shufflingReduceTasks == 0 ? 1.0f : (float)fetchFailures.intValue() / (float)shufflingReduceTasks;
                boolean bl = isMapFaulty = (double)failureRate >= 0.5;
                if (fetchFailures < 3 || !isMapFaulty) continue;
                LOG.info((Object)("Too many fetch-failures for output of task attempt: " + mapId + " ... raising fetch failure to map"));
                job.eventHandler.handle((Event)new TaskAttemptEvent(mapId, TaskAttemptEventType.TA_TOO_MANY_FETCH_FAILURE));
                job.fetchFailuresMapping.remove(mapId);
            }
        }
    }

    private static class TaskAttemptCompletedEventTransition
    implements SingleArcTransition<JobImpl, JobEvent> {
        private TaskAttemptCompletedEventTransition() {
        }

        public void transition(JobImpl job, JobEvent event) {
            TaskAttemptCompletionEvent tce = ((JobTaskAttemptCompletedEvent)event).getCompletionEvent();
            tce.setEventId(job.taskAttemptCompletionEvents.size());
            job.taskAttemptCompletionEvents.add(tce);
            int mapEventIdx = -1;
            if (TaskType.MAP.equals((Object)tce.getAttemptId().getTaskId().getTaskType())) {
                mapEventIdx = job.mapAttemptCompletionEvents.size();
                job.mapAttemptCompletionEvents.add(TypeConverter.fromYarn((TaskAttemptCompletionEvent)tce));
            }
            job.taskCompletionIdxToMapCompletionIdx.add(mapEventIdx);
            TaskAttemptId attemptId = tce.getAttemptId();
            TaskId taskId = attemptId.getTaskId();
            Integer successEventNo = (Integer)job.successAttemptCompletionEventNoMap.remove(taskId);
            if (successEventNo != null) {
                TaskAttemptCompletionEvent successEvent = (TaskAttemptCompletionEvent)job.taskAttemptCompletionEvents.get(successEventNo);
                successEvent.setStatus(TaskAttemptCompletionEventStatus.OBSOLETE);
                int mapCompletionIdx = (Integer)job.taskCompletionIdxToMapCompletionIdx.get(successEventNo);
                if (mapCompletionIdx >= 0) {
                    TaskCompletionEvent mapEvent = (TaskCompletionEvent)job.mapAttemptCompletionEvents.get(mapCompletionIdx);
                    job.mapAttemptCompletionEvents.set(mapCompletionIdx, new TaskCompletionEvent(mapEvent.getEventId(), mapEvent.getTaskAttemptId(), mapEvent.idWithinJob(), mapEvent.isMapTask(), TaskCompletionEvent.Status.OBSOLETE, mapEvent.getTaskTrackerHttp()));
                }
            }
            if (TaskAttemptCompletionEventStatus.SUCCEEDED.equals((Object)tce.getStatus())) {
                job.successAttemptCompletionEventNoMap.put(taskId, tce.getEventId());
                Task task = job.tasks.get(taskId);
                TaskAttempt attempt = task.getAttempt(attemptId);
                NodeId nodeId = attempt.getNodeId();
                assert (nodeId != null);
                ArrayList<TaskAttemptId> taskAttemptIdList = (ArrayList<TaskAttemptId>)job.nodesToSucceededTaskAttempts.get(nodeId);
                if (taskAttemptIdList == null) {
                    taskAttemptIdList = new ArrayList<TaskAttemptId>();
                    job.nodesToSucceededTaskAttempts.put(nodeId, taskAttemptIdList);
                }
                taskAttemptIdList.add(attempt.getID());
            }
        }
    }

    private static class KillTasksTransition
    implements SingleArcTransition<JobImpl, JobEvent> {
        private KillTasksTransition() {
        }

        public void transition(JobImpl job, JobEvent event) {
            job.addDiagnostic(JobImpl.JOB_KILLED_DIAG);
            for (Task task : job.tasks.values()) {
                job.eventHandler.handle((Event)new TaskEvent(task.getID(), TaskEventType.T_KILL));
            }
            job.metrics.endRunningJob(job);
        }
    }

    private static class KilledDuringSetupTransition
    implements SingleArcTransition<JobImpl, JobEvent> {
        private KilledDuringSetupTransition() {
        }

        public void transition(JobImpl job, JobEvent event) {
            job.metrics.endRunningJob(job);
            job.addDiagnostic("Job received kill in SETUP state.");
            job.eventHandler.handle((Event)new CommitterJobAbortEvent(job.jobId, job.jobContext, JobStatus.State.KILLED));
        }
    }

    private static class KillInitedJobTransition
    implements SingleArcTransition<JobImpl, JobEvent> {
        private KillInitedJobTransition() {
        }

        public void transition(JobImpl job, JobEvent event) {
            job.addDiagnostic("Job received Kill in INITED state.");
            job.eventHandler.handle((Event)new CommitterJobAbortEvent(job.jobId, job.jobContext, JobStatus.State.KILLED));
        }
    }

    private static class KillNewJobTransition
    implements SingleArcTransition<JobImpl, JobEvent> {
        private KillNewJobTransition() {
        }

        public void transition(JobImpl job, JobEvent event) {
            job.setFinishTime();
            JobUnsuccessfulCompletionEvent failedEvent = new JobUnsuccessfulCompletionEvent(job.oldJobId, job.finishTime, 0, 0, JobStateInternal.KILLED.toString(), (Iterable)job.diagnostics);
            job.eventHandler.handle((Event)new JobHistoryEvent(job.jobId, (HistoryEvent)failedEvent));
            job.finished(JobStateInternal.KILLED);
        }
    }

    private static class JobFailWaitTimedOutTransition
    implements SingleArcTransition<JobImpl, JobEvent> {
        private JobFailWaitTimedOutTransition() {
        }

        public void transition(JobImpl job, JobEvent event) {
            LOG.info((Object)"Timeout expired in FAIL_WAIT waiting for tasks to get killed. Going to fail job anyway");
            job.failWaitTriggerScheduledFuture.cancel(false);
            job.eventHandler.handle((Event)new CommitterJobAbortEvent(job.jobId, job.jobContext, JobStatus.State.FAILED));
        }
    }

    private static class JobFailWaitTransition
    implements MultipleArcTransition<JobImpl, JobEvent, JobStateInternal> {
        private JobFailWaitTransition() {
        }

        public JobStateInternal transition(JobImpl job, JobEvent event) {
            if (!job.failWaitTriggerScheduledFuture.isCancelled()) {
                for (Task task : job.tasks.values()) {
                    if (task.isFinished()) continue;
                    return JobStateInternal.FAIL_WAIT;
                }
            }
            job.failWaitTriggerScheduledFuture.cancel(false);
            job.eventHandler.handle((Event)new CommitterJobAbortEvent(job.jobId, job.jobContext, JobStatus.State.FAILED));
            return JobStateInternal.FAIL_ABORT;
        }
    }

    private static class JobAbortCompletedTransition
    implements SingleArcTransition<JobImpl, JobEvent> {
        private JobAbortCompletedTransition() {
        }

        public void transition(JobImpl job, JobEvent event) {
            JobStateInternal finalState = JobStateInternal.valueOf(((JobAbortCompletedEvent)event).getFinalState().name());
            job.unsuccessfulFinish(finalState);
        }
    }

    public static class StartTransition
    implements SingleArcTransition<JobImpl, JobEvent> {
        public void transition(JobImpl job, JobEvent event) {
            JobStartEvent jse = (JobStartEvent)event;
            if (jse.getRecoveredJobStartTime() != 0L) {
                job.startTime = jse.getRecoveredJobStartTime();
            } else {
                job.startTime = job.clock.getTime();
            }
            JobInitedEvent jie = new JobInitedEvent(job.oldJobId, job.startTime, job.numMapTasks, job.numReduceTasks, job.getState().toString(), job.isUber());
            job.eventHandler.handle((Event)new JobHistoryEvent(job.jobId, (HistoryEvent)jie));
            JobInfoChangeEvent jice = new JobInfoChangeEvent(job.oldJobId, job.appSubmitTime, job.startTime);
            job.eventHandler.handle((Event)new JobHistoryEvent(job.jobId, (HistoryEvent)jice));
            job.metrics.runningJob(job);
            job.eventHandler.handle((Event)new CommitterJobSetupEvent(job.jobId, job.jobContext));
        }
    }

    private static class SetupFailedTransition
    implements SingleArcTransition<JobImpl, JobEvent> {
        private SetupFailedTransition() {
        }

        public void transition(JobImpl job, JobEvent event) {
            job.metrics.endRunningJob(job);
            job.addDiagnostic("Job setup failed : " + ((JobSetupFailedEvent)event).getMessage());
            job.eventHandler.handle((Event)new CommitterJobAbortEvent(job.jobId, job.jobContext, JobStatus.State.FAILED));
        }
    }

    private static class SetupCompletedTransition
    implements SingleArcTransition<JobImpl, JobEvent> {
        private SetupCompletedTransition() {
        }

        public void transition(JobImpl job, JobEvent event) {
            job.setupProgress = 1.0f;
            job.scheduleTasks(job.mapTasks, job.numReduceTasks == 0);
            job.scheduleTasks(job.reduceTasks, true);
            if (job.numReduceTasks == 0 && job.numMapTasks == 0) {
                job.eventHandler.handle((Event)new JobEvent(job.jobId, JobEventType.JOB_COMPLETED));
            }
        }
    }

    public static class InitTransition
    implements MultipleArcTransition<JobImpl, JobEvent, JobStateInternal> {
        public JobStateInternal transition(JobImpl job, JobEvent event) {
            job.metrics.submittedJob(job);
            job.metrics.preparingJob(job);
            try {
                this.setup(job);
                job.fs = job.getFileSystem((Configuration)job.conf);
                JobSubmittedEvent jse = new JobSubmittedEvent(job.oldJobId, job.conf.get("mapreduce.job.name", "test"), job.conf.get("mapreduce.job.user.name", "mapred"), job.appSubmitTime, job.remoteJobConfFile.toString(), job.jobACLs, job.queueName, job.conf.get("mapreduce.workflow.id", ""), job.conf.get("mapreduce.workflow.name", ""), job.conf.get("mapreduce.workflow.node.name", ""), JobImpl.getWorkflowAdjacencies((Configuration)job.conf), job.conf.get("mapreduce.workflow.tags", ""));
                job.eventHandler.handle((Event)new JobHistoryEvent(job.jobId, (HistoryEvent)jse));
                JobSplit.TaskSplitMetaInfo[] taskSplitMetaInfo = this.createSplits(job, job.jobId);
                job.numMapTasks = taskSplitMetaInfo.length;
                job.numReduceTasks = job.conf.getInt("mapreduce.job.reduces", 0);
                if (job.numMapTasks == 0 && job.numReduceTasks == 0) {
                    job.addDiagnostic("No of maps and reduces are 0 " + job.jobId);
                } else if (job.numMapTasks == 0) {
                    job.reduceWeight = 0.9f;
                } else if (job.numReduceTasks == 0) {
                    job.mapWeight = 0.9f;
                } else {
                    job.mapWeight = (job.reduceWeight = 0.45f);
                }
                this.checkTaskLimits();
                if (job.newApiCommitter) {
                    job.jobContext = (JobContext)new org.apache.hadoop.mapreduce.task.JobContextImpl((Configuration)job.conf, job.oldJobId);
                } else {
                    job.jobContext = (JobContext)new JobContextImpl(job.conf, job.oldJobId);
                }
                long inputLength = 0L;
                for (int i = 0; i < job.numMapTasks; ++i) {
                    inputLength += taskSplitMetaInfo[i].getInputDataLength();
                }
                job.makeUberDecision(inputLength);
                job.taskAttemptCompletionEvents = new ArrayList(job.numMapTasks + job.numReduceTasks + 10);
                job.mapAttemptCompletionEvents = new ArrayList(job.numMapTasks + 10);
                job.taskCompletionIdxToMapCompletionIdx = new ArrayList(job.numMapTasks + job.numReduceTasks + 10);
                job.allowedMapFailuresPercent = job.conf.getInt("mapreduce.map.failures.maxpercent", 0);
                job.allowedReduceFailuresPercent = job.conf.getInt("mapreduce.reduce.failures.maxpercent", 0);
                this.createMapTasks(job, inputLength, taskSplitMetaInfo);
                this.createReduceTasks(job);
                job.metrics.endPreparingJob(job);
                return JobStateInternal.INITED;
            }
            catch (IOException e) {
                LOG.warn((Object)"Job init failed", (Throwable)e);
                job.metrics.endPreparingJob(job);
                job.addDiagnostic("Job init failed : " + StringUtils.stringifyException((Throwable)e));
                job.eventHandler.handle((Event)new CommitterJobAbortEvent(job.jobId, job.jobContext, JobStatus.State.FAILED));
                return JobStateInternal.FAILED;
            }
        }

        protected void setup(JobImpl job) throws IOException {
            String oldJobIDString = job.oldJobId.toString();
            String user = UserGroupInformation.getCurrentUser().getShortUserName();
            Path path = MRApps.getStagingAreaDir((Configuration)job.conf, (String)user);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("startJobs: parent=" + path + " child=" + oldJobIDString));
            }
            job.remoteJobSubmitDir = FileSystem.get((Configuration)job.conf).makeQualified(new Path(path, oldJobIDString));
            job.remoteJobConfFile = new Path(job.remoteJobSubmitDir, "job.xml");
            JobTokenIdentifier identifier = new JobTokenIdentifier(new Text(oldJobIDString));
            job.jobToken = new Token((TokenIdentifier)identifier, (SecretManager)job.jobTokenSecretManager);
            job.jobToken.setService(identifier.getJobId());
            job.jobTokenSecretManager.addTokenForJob(oldJobIDString, job.jobToken);
            LOG.info((Object)("Adding job token for " + oldJobIDString + " to jobTokenSecretManager"));
            if (TokenCache.getShuffleSecretKey((Credentials)job.jobCredentials) == null) {
                LOG.warn((Object)"Shuffle secret key missing from job credentials. Using job token secret as shuffle secret.");
                TokenCache.setShuffleSecretKey((byte[])job.jobToken.getPassword(), (Credentials)job.jobCredentials);
            }
        }

        private void createMapTasks(JobImpl job, long inputLength, JobSplit.TaskSplitMetaInfo[] splits) {
            for (int i = 0; i < job.numMapTasks; ++i) {
                MapTaskImpl task = new MapTaskImpl(job.jobId, i, job.eventHandler, job.remoteJobConfFile, job.conf, splits[i], job.taskAttemptListener, (Token<JobTokenIdentifier>)job.jobToken, job.jobCredentials, job.clock, job.applicationAttemptId.getAttemptId(), job.metrics, job.appContext);
                job.addTask(task);
            }
            LOG.info((Object)("Input size for job " + job.jobId + " = " + inputLength + ". Number of splits = " + splits.length));
        }

        private void createReduceTasks(JobImpl job) {
            for (int i = 0; i < job.numReduceTasks; ++i) {
                ReduceTaskImpl task = new ReduceTaskImpl(job.jobId, i, job.eventHandler, job.remoteJobConfFile, job.conf, job.numMapTasks, job.taskAttemptListener, (Token<JobTokenIdentifier>)job.jobToken, job.jobCredentials, job.clock, job.applicationAttemptId.getAttemptId(), job.metrics, job.appContext);
                job.addTask(task);
            }
            LOG.info((Object)("Number of reduces for job " + job.jobId + " = " + job.numReduceTasks));
        }

        protected JobSplit.TaskSplitMetaInfo[] createSplits(JobImpl job, JobId jobId) {
            JobSplit.TaskSplitMetaInfo[] allTaskSplitMetaInfo;
            try {
                allTaskSplitMetaInfo = SplitMetaInfoReader.readSplitMetaInfo((JobID)job.oldJobId, (FileSystem)job.fs, (Configuration)job.conf, (Path)job.remoteJobSubmitDir);
            }
            catch (IOException e) {
                throw new YarnRuntimeException((Throwable)e);
            }
            return allTaskSplitMetaInfo;
        }

        private void checkTaskLimits() {
        }
    }
}

