/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import com.google.inject.Inject;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.AMAttemptInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.JobInfo;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

public class JobBlock
extends HtmlBlock {
    final AppContext appContext;

    @Inject
    JobBlock(AppContext appctx) {
        this.appContext = appctx;
    }

    protected void render(HtmlBlock.Block html) {
        String jid = this.$("job.id");
        if (jid.isEmpty()) {
            html.p()._(new Object[]{"Sorry, can't do anything without a JobID."})._();
            return;
        }
        JobId jobID = MRApps.toJobID((String)jid);
        Job job = this.appContext.getJob(jobID);
        if (job == null) {
            html.p()._(new Object[]{"Sorry, ", jid, " not found."})._();
            return;
        }
        List<AMInfo> amInfos = job.getAMInfos();
        String amString = amInfos.size() == 1 ? "ApplicationMaster" : "ApplicationMasters";
        JobInfo jinfo = new JobInfo(job, true);
        this.info("Job Overview")._("Job Name:", (Object)jinfo.getName())._("State:", (Object)jinfo.getState())._("Uberized:", (Object)jinfo.isUberized())._("Started:", (Object)new Date(jinfo.getStartTime()))._("Elapsed:", (Object)StringUtils.formatTime((long)jinfo.getElapsedTime()));
        Hamlet.DIV div = html._(InfoBlock.class).div(".info-wrap.ui-widget-content.ui-corner-bottom");
        Hamlet.TABLE table = div.table("#job");
        ((Hamlet.TABLE)table.tr().th(amString)._()).tr().th(".ui-state-default", "Attempt Number").th(".ui-state-default", "Start Time").th(".ui-state-default", "Node").th(".ui-state-default", "Logs")._();
        for (AMInfo amInfo : amInfos) {
            AMAttemptInfo attempt = new AMAttemptInfo(amInfo, jinfo.getId(), jinfo.getUserName());
            ((Hamlet.TR)((Hamlet.TR)table.tr().td(String.valueOf(attempt.getAttemptId())).td(new Date(attempt.getStartTime()).toString()).td().a(".nodelink", this.url(new String[]{HttpConfig.getSchemePrefix(), attempt.getNodeHttpAddress()}), attempt.getNodeHttpAddress())._()).td().a(".logslink", this.url(new String[]{attempt.getLogsLink()}), "logs")._())._();
        }
        table._();
        div._();
        ((Hamlet.DIV)((Hamlet.TABLE)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TABLE)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TABLE)((Hamlet.DIV)((Hamlet.TABLE)((Hamlet.TR)((Hamlet.TD)((Hamlet.DIV)((Hamlet.TR)((Hamlet.TABLE)((Hamlet.TR)((Hamlet.TD)((Hamlet.DIV)((Hamlet.TR)((Hamlet.TABLE)html.div(".info-wrap.ui-widget-content.ui-corner-bottom").table("#job").tr().th(".ui-state-default", "Task Type").th(".ui-state-default", "Progress").th(".ui-state-default", "Total").th(".ui-state-default", "Pending").th(".ui-state-default", "Running").th(".ui-state-default", "Complete")._()).tr(".odd").th().a(this.url(new String[]{"tasks", jid, "m"}), "Map")._()).td().div(".ui-progressbar.ui-widget.ui-widget-content.ui-corner-all").$title(StringHelper.join((Object[])new Object[]{jinfo.getMapProgressPercent(), Character.valueOf('%')})).div(".ui-progressbar-value.ui-widget-header.ui-corner-left").$style(StringHelper.join((Object[])new Object[]{"width:", jinfo.getMapProgressPercent(), Character.valueOf('%')}))._())._())._()).td(String.valueOf(jinfo.getMapsTotal())).td(String.valueOf(jinfo.getMapsPending())).td(String.valueOf(jinfo.getMapsRunning())).td(String.valueOf(jinfo.getMapsCompleted()))._()).tr(".even").th().a(this.url(new String[]{"tasks", jid, "r"}), "Reduce")._()).td().div(".ui-progressbar.ui-widget.ui-widget-content.ui-corner-all").$title(StringHelper.join((Object[])new Object[]{jinfo.getReduceProgressPercent(), Character.valueOf('%')})).div(".ui-progressbar-value.ui-widget-header.ui-corner-left").$style(StringHelper.join((Object[])new Object[]{"width:", jinfo.getReduceProgressPercent(), Character.valueOf('%')}))._())._())._()).td(String.valueOf(jinfo.getReducesTotal())).td(String.valueOf(jinfo.getReducesPending())).td(String.valueOf(jinfo.getReducesRunning())).td(String.valueOf(jinfo.getReducesCompleted()))._())._()).table("#job").tr().th(".ui-state-default", "Attempt Type").th(".ui-state-default", "New").th(".ui-state-default", "Running").th(".ui-state-default", "Failed").th(".ui-state-default", "Killed").th(".ui-state-default", "Successful")._()).tr(".odd").th("Maps").td().a(this.url(new String[]{"attempts", jid, "m", MRApps.TaskAttemptStateUI.NEW.toString()}), String.valueOf(jinfo.getNewMapAttempts()))._()).td().a(this.url(new String[]{"attempts", jid, "m", MRApps.TaskAttemptStateUI.RUNNING.toString()}), String.valueOf(jinfo.getRunningMapAttempts()))._()).td().a(this.url(new String[]{"attempts", jid, "m", MRApps.TaskAttemptStateUI.FAILED.toString()}), String.valueOf(jinfo.getFailedMapAttempts()))._()).td().a(this.url(new String[]{"attempts", jid, "m", MRApps.TaskAttemptStateUI.KILLED.toString()}), String.valueOf(jinfo.getKilledMapAttempts()))._()).td().a(this.url(new String[]{"attempts", jid, "m", MRApps.TaskAttemptStateUI.SUCCESSFUL.toString()}), String.valueOf(jinfo.getSuccessfulMapAttempts()))._())._()).tr(".even").th("Reduces").td().a(this.url(new String[]{"attempts", jid, "r", MRApps.TaskAttemptStateUI.NEW.toString()}), String.valueOf(jinfo.getNewReduceAttempts()))._()).td().a(this.url(new String[]{"attempts", jid, "r", MRApps.TaskAttemptStateUI.RUNNING.toString()}), String.valueOf(jinfo.getRunningReduceAttempts()))._()).td().a(this.url(new String[]{"attempts", jid, "r", MRApps.TaskAttemptStateUI.FAILED.toString()}), String.valueOf(jinfo.getFailedReduceAttempts()))._()).td().a(this.url(new String[]{"attempts", jid, "r", MRApps.TaskAttemptStateUI.KILLED.toString()}), String.valueOf(jinfo.getKilledReduceAttempts()))._()).td().a(this.url(new String[]{"attempts", jid, "r", MRApps.TaskAttemptStateUI.SUCCESSFUL.toString()}), String.valueOf(jinfo.getSuccessfulReduceAttempts()))._())._())._())._();
    }
}

