/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.MRAppMaster;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.commit.CommitterEvent;
import org.apache.hadoop.mapreduce.v2.app.commit.CommitterEventHandler;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocator;
import org.apache.hadoop.mapreduce.v2.app.rm.RMHeartbeatHandler;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.event.EventHandler;
import org.junit.Assert;
import org.mockito.Mockito;

class MRAppMasterTest
extends MRAppMaster {
    Path stagingDirPath;
    private Configuration conf;
    private boolean overrideInit;
    private boolean overrideStart;
    ContainerAllocator mockContainerAllocator;
    CommitterEventHandler mockCommitterEventHandler;
    RMHeartbeatHandler mockRMHeartbeatHandler;

    public MRAppMasterTest(ApplicationAttemptId applicationAttemptId, ContainerId containerId, String host, int port, int httpPort, long submitTime) {
        this(applicationAttemptId, containerId, host, port, httpPort, submitTime, true, true);
    }

    public MRAppMasterTest(ApplicationAttemptId applicationAttemptId, ContainerId containerId, String host, int port, int httpPort, long submitTime, boolean overrideInit, boolean overrideStart) {
        super(applicationAttemptId, containerId, host, port, httpPort, submitTime);
        this.overrideInit = overrideInit;
        this.overrideStart = overrideStart;
        this.mockContainerAllocator = (ContainerAllocator)Mockito.mock(ContainerAllocator.class);
        this.mockCommitterEventHandler = (CommitterEventHandler)Mockito.mock(CommitterEventHandler.class);
        this.mockRMHeartbeatHandler = (RMHeartbeatHandler)Mockito.mock(RMHeartbeatHandler.class);
    }

    public void init(Configuration conf) {
        if (!this.overrideInit) {
            super.init(conf);
        }
        this.conf = conf;
    }

    protected void downloadTokensAndSetupUGI(Configuration conf) {
        try {
            this.currentUser = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new YarnException((Throwable)e);
        }
    }

    protected ContainerAllocator createContainerAllocator(ClientService clientService, AppContext context) {
        return this.mockContainerAllocator;
    }

    protected EventHandler<CommitterEvent> createCommitterEventHandler(AppContext context, OutputCommitter committer) {
        return this.mockCommitterEventHandler;
    }

    protected RMHeartbeatHandler getRMHeartbeatHandler() {
        return this.mockRMHeartbeatHandler;
    }

    public void start() {
        if (this.overrideStart) {
            try {
                String user = UserGroupInformation.getCurrentUser().getShortUserName();
                this.stagingDirPath = MRApps.getStagingAreaDir((Configuration)this.conf, (String)user);
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
        } else {
            super.start();
        }
    }
}

