/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.rm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerRequestEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.RMCommunicator;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.AMResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.exceptions.YarnRemoteException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.util.BuilderUtils;

public abstract class RMContainerRequestor
extends RMCommunicator {
    private static final Log LOG = LogFactory.getLog(RMContainerRequestor.class);
    static final String ANY = "*";
    private int lastResponseID;
    private Resource availableResources;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private final Map<Priority, Map<String, Map<Resource, ResourceRequest>>> remoteRequestsTable = new TreeMap<Priority, Map<String, Map<Resource, ResourceRequest>>>();
    private final Set<ResourceRequest> ask = new TreeSet<ResourceRequest>((Comparator<ResourceRequest>)new BuilderUtils.ResourceRequestComparator());
    private final Set<ContainerId> release = new TreeSet<ContainerId>();
    private boolean nodeBlacklistingEnabled;
    private int blacklistDisablePercent;
    private AtomicBoolean ignoreBlacklisting = new AtomicBoolean(false);
    private int blacklistedNodeCount = 0;
    private int lastClusterNmCount = 0;
    private int clusterNmCount = 0;
    private int maxTaskFailuresPerNode;
    private final Map<String, Integer> nodeFailures = new HashMap<String, Integer>();
    private final Set<String> blacklistedNodes = Collections.newSetFromMap(new ConcurrentHashMap());

    public RMContainerRequestor(ClientService clientService, AppContext context) {
        super(clientService, context);
    }

    @Override
    public void init(Configuration conf) {
        super.init(conf);
        this.nodeBlacklistingEnabled = conf.getBoolean("yarn.app.mapreduce.am.job.node-blacklisting.enable", true);
        LOG.info((Object)("nodeBlacklistingEnabled:" + this.nodeBlacklistingEnabled));
        this.maxTaskFailuresPerNode = conf.getInt("mapreduce.job.maxtaskfailures.per.tracker", 3);
        this.blacklistDisablePercent = conf.getInt("yarn.app.mapreduce.am.job.node-blacklisting.ignore-threshold-node-percent", 33);
        LOG.info((Object)("maxTaskFailuresPerNode is " + this.maxTaskFailuresPerNode));
        if (this.blacklistDisablePercent < -1 || this.blacklistDisablePercent > 100) {
            throw new YarnException("Invalid blacklistDisablePercent: " + this.blacklistDisablePercent + ". Should be an integer between 0 and 100 or -1 to disabled");
        }
        LOG.info((Object)("blacklistDisablePercent is " + this.blacklistDisablePercent));
    }

    protected AMResponse makeRemoteRequest() throws YarnRemoteException {
        AllocateRequest allocateRequest = BuilderUtils.newAllocateRequest((ApplicationAttemptId)this.applicationAttemptId, (int)this.lastResponseID, (float)super.getApplicationProgress(), new ArrayList<ResourceRequest>(this.ask), new ArrayList<ContainerId>(this.release));
        AllocateResponse allocateResponse = this.scheduler.allocate(allocateRequest);
        AMResponse response = allocateResponse.getAMResponse();
        this.lastResponseID = response.getResponseId();
        this.availableResources = response.getAvailableResources();
        this.lastClusterNmCount = this.clusterNmCount;
        this.clusterNmCount = allocateResponse.getNumClusterNodes();
        if (this.ask.size() > 0 || this.release.size() > 0) {
            LOG.info((Object)("getResources() for " + this.applicationId + ":" + " ask=" + this.ask.size() + " release= " + this.release.size() + " newContainers=" + response.getAllocatedContainers().size() + " finishedContainers=" + response.getCompletedContainersStatuses().size() + " resourcelimit=" + this.availableResources + " knownNMs=" + this.clusterNmCount));
        }
        this.ask.clear();
        this.release.clear();
        return response;
    }

    protected void computeIgnoreBlacklisting() {
        if (!this.nodeBlacklistingEnabled) {
            return;
        }
        if (this.blacklistDisablePercent != -1 && (this.blacklistedNodeCount != this.blacklistedNodes.size() || this.clusterNmCount != this.lastClusterNmCount)) {
            this.blacklistedNodeCount = this.blacklistedNodes.size();
            if (this.clusterNmCount == 0) {
                LOG.info((Object)"KnownNode Count at 0. Not computing ignoreBlacklisting");
                return;
            }
            int val = (int)((float)this.blacklistedNodes.size() / (float)this.clusterNmCount * 100.0f);
            if (val >= this.blacklistDisablePercent) {
                if (this.ignoreBlacklisting.compareAndSet(false, true)) {
                    LOG.info((Object)("Ignore blacklisting set to true. Known: " + this.clusterNmCount + ", Blacklisted: " + this.blacklistedNodeCount + ", " + val + "%"));
                }
            } else if (this.ignoreBlacklisting.compareAndSet(true, false)) {
                LOG.info((Object)("Ignore blacklisting set to false. Known: " + this.clusterNmCount + ", Blacklisted: " + this.blacklistedNodeCount + ", " + val + "%"));
            }
        }
    }

    protected void containerFailedOnHost(String hostName) {
        if (!this.nodeBlacklistingEnabled) {
            return;
        }
        if (this.blacklistedNodes.contains(hostName)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Host " + hostName + " is already blacklisted."));
            }
            return;
        }
        Integer failures = this.nodeFailures.remove(hostName);
        Integer n = failures = failures == null ? Integer.valueOf(0) : failures;
        Integer n2 = failures = Integer.valueOf(failures + 1);
        LOG.info((Object)(failures + " failures on node " + hostName));
        if (failures >= this.maxTaskFailuresPerNode) {
            this.blacklistedNodes.add(hostName);
            LOG.info((Object)("Blacklisted host " + hostName));
            for (Map<String, Map<Resource, ResourceRequest>> remoteRequests : this.remoteRequestsTable.values()) {
                boolean foundAll = true;
                Map<Resource, ResourceRequest> reqMap = remoteRequests.get(hostName);
                if (reqMap == null) continue;
                for (ResourceRequest req : reqMap.values()) {
                    if (this.ask.remove(req)) continue;
                    foundAll = false;
                    ResourceRequest zeroedRequest = BuilderUtils.newResourceRequest((ResourceRequest)req);
                    zeroedRequest.setNumContainers(0);
                    this.addResourceRequestToAsk(zeroedRequest);
                }
                if (!foundAll) continue;
                remoteRequests.remove(hostName);
            }
        } else {
            this.nodeFailures.put(hostName, failures);
        }
    }

    protected Resource getAvailableResources() {
        return this.availableResources;
    }

    protected void addContainerReq(ContainerRequest req) {
        for (String host : req.hosts) {
            if (this.isNodeBlacklisted(host)) continue;
            this.addResourceRequest(req.priority, host, req.capability);
        }
        for (String rack : req.racks) {
            this.addResourceRequest(req.priority, rack, req.capability);
        }
        this.addResourceRequest(req.priority, ANY, req.capability);
    }

    protected void decContainerReq(ContainerRequest req) {
        for (String hostName : req.hosts) {
            this.decResourceRequest(req.priority, hostName, req.capability);
        }
        for (String rack : req.racks) {
            this.decResourceRequest(req.priority, rack, req.capability);
        }
        this.decResourceRequest(req.priority, ANY, req.capability);
    }

    private void addResourceRequest(Priority priority, String resourceName, Resource capability) {
        ResourceRequest remoteRequest;
        Map<Resource, ResourceRequest> reqMap;
        Map<String, Map<Resource, ResourceRequest>> remoteRequests = this.remoteRequestsTable.get(priority);
        if (remoteRequests == null) {
            remoteRequests = new HashMap<String, Map<Resource, ResourceRequest>>();
            this.remoteRequestsTable.put(priority, remoteRequests);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Added priority=" + priority));
            }
        }
        if ((reqMap = remoteRequests.get(resourceName)) == null) {
            reqMap = new HashMap<Resource, ResourceRequest>();
            remoteRequests.put(resourceName, reqMap);
        }
        if ((remoteRequest = reqMap.get(capability)) == null) {
            remoteRequest = (ResourceRequest)this.recordFactory.newRecordInstance(ResourceRequest.class);
            remoteRequest.setPriority(priority);
            remoteRequest.setHostName(resourceName);
            remoteRequest.setCapability(capability);
            remoteRequest.setNumContainers(0);
            reqMap.put(capability, remoteRequest);
        }
        remoteRequest.setNumContainers(remoteRequest.getNumContainers() + 1);
        this.addResourceRequestToAsk(remoteRequest);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addResourceRequest: applicationId=" + this.applicationId.getId() + " priority=" + priority.getPriority() + " resourceName=" + resourceName + " numContainers=" + remoteRequest.getNumContainers() + " #asks=" + this.ask.size()));
        }
    }

    private void decResourceRequest(Priority priority, String resourceName, Resource capability) {
        Map<String, Map<Resource, ResourceRequest>> remoteRequests = this.remoteRequestsTable.get(priority);
        Map<Resource, ResourceRequest> reqMap = remoteRequests.get(resourceName);
        if (reqMap == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Not decrementing resource as " + resourceName + " is not present in request table"));
            }
            return;
        }
        ResourceRequest remoteRequest = reqMap.get(capability);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("BEFORE decResourceRequest: applicationId=" + this.applicationId.getId() + " priority=" + priority.getPriority() + " resourceName=" + resourceName + " numContainers=" + remoteRequest.getNumContainers() + " #asks=" + this.ask.size()));
        }
        if (remoteRequest.getNumContainers() > 0) {
            remoteRequest.setNumContainers(remoteRequest.getNumContainers() - 1);
        }
        if (remoteRequest.getNumContainers() == 0) {
            reqMap.remove(capability);
            if (reqMap.size() == 0) {
                remoteRequests.remove(resourceName);
            }
            if (remoteRequests.size() == 0) {
                this.remoteRequestsTable.remove(priority);
            }
        }
        this.addResourceRequestToAsk(remoteRequest);
        if (LOG.isDebugEnabled()) {
            LOG.info((Object)("AFTER decResourceRequest: applicationId=" + this.applicationId.getId() + " priority=" + priority.getPriority() + " resourceName=" + resourceName + " numContainers=" + remoteRequest.getNumContainers() + " #asks=" + this.ask.size()));
        }
    }

    private void addResourceRequestToAsk(ResourceRequest remoteRequest) {
        if (this.ask.contains(remoteRequest)) {
            this.ask.remove(remoteRequest);
        }
        this.ask.add(remoteRequest);
    }

    protected void release(ContainerId containerId) {
        this.release.add(containerId);
    }

    protected boolean isNodeBlacklisted(String hostname) {
        if (!this.nodeBlacklistingEnabled || this.ignoreBlacklisting.get()) {
            return false;
        }
        return this.blacklistedNodes.contains(hostname);
    }

    protected ContainerRequest getFilteredContainerRequest(ContainerRequest orig) {
        ArrayList<String> newHosts = new ArrayList<String>();
        for (String host : orig.hosts) {
            if (this.isNodeBlacklisted(host)) continue;
            newHosts.add(host);
        }
        String[] hosts = newHosts.toArray(new String[newHosts.size()]);
        ContainerRequest newReq = new ContainerRequest(orig.attemptID, orig.capability, hosts, orig.racks, orig.priority);
        return newReq;
    }

    static class ContainerRequest {
        final TaskAttemptId attemptID;
        final Resource capability;
        final String[] hosts;
        final String[] racks;
        final Priority priority;

        public ContainerRequest(ContainerRequestEvent event, Priority priority) {
            this(event.getAttemptID(), event.getCapability(), event.getHosts(), event.getRacks(), priority);
        }

        public ContainerRequest(TaskAttemptId attemptID, Resource capability, String[] hosts, String[] racks, Priority priority) {
            this.attemptID = attemptID;
            this.capability = capability;
            this.hosts = hosts;
            this.racks = racks;
            this.priority = priority;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("AttemptId[").append(this.attemptID).append("]");
            sb.append("Capability[").append(this.capability).append("]");
            sb.append("Priority[").append(this.priority).append("]");
            return sb.toString();
        }
    }
}

