/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.job.impl;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.jobhistory.TaskFailedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskFinishedEvent;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.v2.api.records.Avataar;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEvent;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEventStatus;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptListener;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.TaskStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobTaskAttemptCompletedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEventType;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TaskAttemptImpl;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TaskImpl;
import org.apache.hadoop.mapreduce.v2.app.metrics.MRAppMetrics;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringInterner;
import org.apache.hadoop.yarn.Clock;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class TaskImpl
implements Task,
EventHandler<TaskEvent> {
    private static final Log LOG = LogFactory.getLog(TaskImpl.class);
    protected final JobConf conf;
    protected final Path jobFile;
    protected final int partition;
    protected final TaskAttemptListener taskAttemptListener;
    protected final EventHandler eventHandler;
    private final TaskId taskId;
    private Map<TaskAttemptId, TaskAttempt> attempts;
    private final int maxAttempts;
    protected final Clock clock;
    private final Lock readLock;
    private final Lock writeLock;
    private final MRAppMetrics metrics;
    protected final AppContext appContext;
    private long scheduledTime;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    protected boolean encryptedShuffle;
    protected Credentials credentials;
    protected Token<JobTokenIdentifier> jobToken;
    private TaskAttemptId commitAttempt;
    private TaskAttemptId successfulAttempt;
    private final Set<TaskAttemptId> failedAttempts;
    private final Set<TaskAttemptId> finishedAttempts;
    private final Set<TaskAttemptId> inProgressAttempts;
    private boolean historyTaskStartGenerated = false;
    private static final SingleArcTransition<TaskImpl, TaskEvent> ATTEMPT_KILLED_TRANSITION = new AttemptKilledTransition(null);
    private static final SingleArcTransition<TaskImpl, TaskEvent> KILL_TRANSITION = new KillTransition(null);
    private static final StateMachineFactory<TaskImpl, TaskStateInternal, TaskEventType, TaskEvent> stateMachineFactory = new StateMachineFactory((Enum)TaskStateInternal.NEW).addTransition((Enum)TaskStateInternal.NEW, (Enum)TaskStateInternal.SCHEDULED, (Enum)TaskEventType.T_SCHEDULE, (SingleArcTransition)new InitialScheduleTransition(null)).addTransition((Enum)TaskStateInternal.NEW, (Enum)TaskStateInternal.KILLED, (Enum)TaskEventType.T_KILL, (SingleArcTransition)new KillNewTransition(null)).addTransition((Enum)TaskStateInternal.SCHEDULED, (Enum)TaskStateInternal.RUNNING, (Enum)TaskEventType.T_ATTEMPT_LAUNCHED, (SingleArcTransition)new LaunchTransition()).addTransition((Enum)TaskStateInternal.SCHEDULED, (Enum)TaskStateInternal.KILL_WAIT, (Enum)TaskEventType.T_KILL, KILL_TRANSITION).addTransition((Enum)TaskStateInternal.SCHEDULED, (Enum)TaskStateInternal.SCHEDULED, (Enum)TaskEventType.T_ATTEMPT_KILLED, ATTEMPT_KILLED_TRANSITION).addTransition((Enum)TaskStateInternal.SCHEDULED, EnumSet.of(TaskStateInternal.SCHEDULED, TaskStateInternal.FAILED), (Enum)TaskEventType.T_ATTEMPT_FAILED, (MultipleArcTransition)new AttemptFailedTransition(null)).addTransition((Enum)TaskStateInternal.RUNNING, (Enum)TaskStateInternal.RUNNING, (Enum)TaskEventType.T_ATTEMPT_LAUNCHED).addTransition((Enum)TaskStateInternal.RUNNING, (Enum)TaskStateInternal.RUNNING, (Enum)TaskEventType.T_ATTEMPT_COMMIT_PENDING, (SingleArcTransition)new AttemptCommitPendingTransition(null)).addTransition((Enum)TaskStateInternal.RUNNING, (Enum)TaskStateInternal.RUNNING, (Enum)TaskEventType.T_ADD_SPEC_ATTEMPT, (SingleArcTransition)new RedundantScheduleTransition(null)).addTransition((Enum)TaskStateInternal.RUNNING, (Enum)TaskStateInternal.SUCCEEDED, (Enum)TaskEventType.T_ATTEMPT_SUCCEEDED, (SingleArcTransition)new AttemptSucceededTransition(null)).addTransition((Enum)TaskStateInternal.RUNNING, (Enum)TaskStateInternal.RUNNING, (Enum)TaskEventType.T_ATTEMPT_KILLED, ATTEMPT_KILLED_TRANSITION).addTransition((Enum)TaskStateInternal.RUNNING, EnumSet.of(TaskStateInternal.RUNNING, TaskStateInternal.FAILED), (Enum)TaskEventType.T_ATTEMPT_FAILED, (MultipleArcTransition)new AttemptFailedTransition(null)).addTransition((Enum)TaskStateInternal.RUNNING, (Enum)TaskStateInternal.KILL_WAIT, (Enum)TaskEventType.T_KILL, KILL_TRANSITION).addTransition((Enum)TaskStateInternal.KILL_WAIT, EnumSet.of(TaskStateInternal.KILL_WAIT, TaskStateInternal.KILLED), (Enum)TaskEventType.T_ATTEMPT_KILLED, (MultipleArcTransition)new KillWaitAttemptKilledTransition()).addTransition((Enum)TaskStateInternal.KILL_WAIT, EnumSet.of(TaskStateInternal.KILL_WAIT, TaskStateInternal.KILLED), (Enum)TaskEventType.T_ATTEMPT_SUCCEEDED, (MultipleArcTransition)new KillWaitAttemptSucceededTransition()).addTransition((Enum)TaskStateInternal.KILL_WAIT, EnumSet.of(TaskStateInternal.KILL_WAIT, TaskStateInternal.KILLED), (Enum)TaskEventType.T_ATTEMPT_FAILED, (MultipleArcTransition)new KillWaitAttemptFailedTransition()).addTransition((Enum)TaskStateInternal.KILL_WAIT, (Enum)TaskStateInternal.KILL_WAIT, EnumSet.of(TaskEventType.T_KILL, TaskEventType.T_ATTEMPT_LAUNCHED, TaskEventType.T_ATTEMPT_COMMIT_PENDING, TaskEventType.T_ADD_SPEC_ATTEMPT)).addTransition((Enum)TaskStateInternal.SUCCEEDED, EnumSet.of(TaskStateInternal.SCHEDULED, TaskStateInternal.SUCCEEDED, TaskStateInternal.FAILED), (Enum)TaskEventType.T_ATTEMPT_FAILED, (MultipleArcTransition)new RetroactiveFailureTransition(null)).addTransition((Enum)TaskStateInternal.SUCCEEDED, EnumSet.of(TaskStateInternal.SCHEDULED, TaskStateInternal.SUCCEEDED), (Enum)TaskEventType.T_ATTEMPT_KILLED, (MultipleArcTransition)new RetroactiveKilledTransition(null)).addTransition((Enum)TaskStateInternal.SUCCEEDED, (Enum)TaskStateInternal.SUCCEEDED, (Enum)TaskEventType.T_ATTEMPT_SUCCEEDED, (SingleArcTransition)new AttemptSucceededAtSucceededTransition(null)).addTransition((Enum)TaskStateInternal.SUCCEEDED, (Enum)TaskStateInternal.SUCCEEDED, EnumSet.of(TaskEventType.T_ADD_SPEC_ATTEMPT, TaskEventType.T_ATTEMPT_COMMIT_PENDING, TaskEventType.T_ATTEMPT_LAUNCHED, TaskEventType.T_KILL)).addTransition((Enum)TaskStateInternal.FAILED, (Enum)TaskStateInternal.FAILED, EnumSet.of(TaskEventType.T_KILL, new TaskEventType[]{TaskEventType.T_ADD_SPEC_ATTEMPT, TaskEventType.T_ATTEMPT_COMMIT_PENDING, TaskEventType.T_ATTEMPT_FAILED, TaskEventType.T_ATTEMPT_KILLED, TaskEventType.T_ATTEMPT_LAUNCHED, TaskEventType.T_ATTEMPT_SUCCEEDED})).addTransition((Enum)TaskStateInternal.KILLED, (Enum)TaskStateInternal.KILLED, EnumSet.of(TaskEventType.T_KILL, TaskEventType.T_ADD_SPEC_ATTEMPT)).installTopology();
    private final StateMachine<TaskStateInternal, TaskEventType, TaskEvent> stateMachine;
    protected int nextAttemptNumber = 0;
    private List<JobHistoryParser.TaskAttemptInfo> taskAttemptsFromPreviousGeneration = new ArrayList();
    private static final RecoverdAttemptsComparator RECOVERED_ATTEMPTS_COMPARATOR = new RecoverdAttemptsComparator(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskState getState() {
        this.readLock.lock();
        try {
            TaskState taskState = TaskImpl.getExternalState((TaskStateInternal)this.getInternalState());
            return taskState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public TaskImpl(JobId jobId, TaskType taskType, int partition, EventHandler eventHandler, Path remoteJobConfFile, JobConf conf, TaskAttemptListener taskAttemptListener, Token<JobTokenIdentifier> jobToken, Credentials credentials, Clock clock, Map<TaskId, JobHistoryParser.TaskInfo> completedTasksFromPreviousRun, int startCount, MRAppMetrics metrics, AppContext appContext) {
        this.conf = conf;
        this.clock = clock;
        this.jobFile = remoteJobConfFile;
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
        this.attempts = Collections.emptyMap();
        this.finishedAttempts = new HashSet(2);
        this.failedAttempts = new HashSet(2);
        this.inProgressAttempts = new HashSet(2);
        this.maxAttempts = this.getMaxAttempts();
        this.taskId = MRBuilderUtils.newTaskId((JobId)jobId, (int)partition, (TaskType)taskType);
        this.partition = partition;
        this.taskAttemptListener = taskAttemptListener;
        this.eventHandler = eventHandler;
        this.credentials = credentials;
        this.jobToken = jobToken;
        this.metrics = metrics;
        this.appContext = appContext;
        this.encryptedShuffle = conf.getBoolean("mapreduce.shuffle.ssl.enabled", false);
        if (completedTasksFromPreviousRun != null && completedTasksFromPreviousRun.containsKey(this.taskId)) {
            LOG.info((Object)("Task is from previous run " + this.taskId));
            JobHistoryParser.TaskInfo taskInfo = completedTasksFromPreviousRun.get(this.taskId);
            Map allAttempts = taskInfo.getAllTaskAttempts();
            this.taskAttemptsFromPreviousGeneration = new ArrayList();
            this.taskAttemptsFromPreviousGeneration.addAll(allAttempts.values());
            Collections.sort(this.taskAttemptsFromPreviousGeneration, RECOVERED_ATTEMPTS_COMPARATOR);
        }
        this.nextAttemptNumber = this.taskAttemptsFromPreviousGeneration.isEmpty() ? (startCount - 1) * 1000 : ((JobHistoryParser.TaskAttemptInfo)this.taskAttemptsFromPreviousGeneration.remove(0)).getAttemptId().getId();
        this.stateMachine = stateMachineFactory.make((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<TaskAttemptId, TaskAttempt> getAttempts() {
        this.readLock.lock();
        try {
            if (this.attempts.size() <= 1) {
                Map map = this.attempts;
                return map;
            }
            LinkedHashMap<TaskAttemptId, TaskAttempt> result = new LinkedHashMap<TaskAttemptId, TaskAttempt>();
            result.putAll(this.attempts);
            LinkedHashMap<TaskAttemptId, TaskAttempt> linkedHashMap = result;
            return linkedHashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskAttempt getAttempt(TaskAttemptId attemptID) {
        this.readLock.lock();
        try {
            TaskAttempt taskAttempt = (TaskAttempt)this.attempts.get(attemptID);
            return taskAttempt;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public TaskId getID() {
        return this.taskId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinished() {
        this.readLock.lock();
        try {
            boolean bl = this.getInternalState() == TaskStateInternal.SUCCEEDED || this.getInternalState() == TaskStateInternal.FAILED || this.getInternalState() == TaskStateInternal.KILLED;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskReport getReport() {
        TaskReport report = (TaskReport)this.recordFactory.newRecordInstance(TaskReport.class);
        this.readLock.lock();
        try {
            report.setTaskId(this.taskId);
            report.setStartTime(this.getLaunchTime());
            report.setFinishTime(this.getFinishTime());
            report.setTaskState(this.getState());
            report.setProgress(this.getProgress());
            for (TaskAttempt attempt : this.attempts.values()) {
                if (!TaskAttemptState.RUNNING.equals((Object)attempt.getState())) continue;
                report.addRunningAttempt(attempt.getID());
            }
            report.setSuccessfulAttempt(this.successfulAttempt);
            for (TaskAttempt att : this.attempts.values()) {
                String prefix = "AttemptID:" + att.getID() + " Info:";
                for (String cs : att.getDiagnostics()) {
                    report.addDiagnostics(prefix + cs);
                }
            }
            report.setCounters(TypeConverter.toYarn((Counters)this.getCounters()));
            TaskReport taskReport = report;
            return taskReport;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Counters getCounters() {
        Counters counters = null;
        this.readLock.lock();
        try {
            TaskAttempt bestAttempt = this.selectBestAttempt();
            counters = bestAttempt != null ? bestAttempt.getCounters() : TaskAttemptImpl.EMPTY_COUNTERS;
            Counters counters2 = counters;
            return counters2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getProgress() {
        this.readLock.lock();
        try {
            TaskAttempt bestAttempt = this.selectBestAttempt();
            if (bestAttempt == null) {
                float f = 0.0f;
                return f;
            }
            float f = bestAttempt.getProgress();
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public TaskStateInternal getInternalState() {
        this.readLock.lock();
        try {
            TaskStateInternal taskStateInternal = (TaskStateInternal)this.stateMachine.getCurrentState();
            return taskStateInternal;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private static TaskState getExternalState(TaskStateInternal smState) {
        if (smState == TaskStateInternal.KILL_WAIT) {
            return TaskState.KILLED;
        }
        return TaskState.valueOf((String)smState.name());
    }

    private long getLaunchTime() {
        long taskLaunchTime = 0L;
        boolean launchTimeSet = false;
        for (TaskAttempt at : this.attempts.values()) {
            long attemptLaunchTime = at.getLaunchTime();
            if (attemptLaunchTime != 0L && !launchTimeSet) {
                launchTimeSet = true;
                taskLaunchTime = attemptLaunchTime;
                continue;
            }
            if (attemptLaunchTime == 0L || taskLaunchTime <= attemptLaunchTime) continue;
            taskLaunchTime = attemptLaunchTime;
        }
        if (!launchTimeSet) {
            return this.scheduledTime;
        }
        return taskLaunchTime;
    }

    private long getFinishTime() {
        if (!this.isFinished()) {
            return 0L;
        }
        long finishTime = 0L;
        for (TaskAttempt at : this.attempts.values()) {
            if (finishTime >= at.getFinishTime()) continue;
            finishTime = at.getFinishTime();
        }
        return finishTime;
    }

    private long getFinishTime(TaskAttemptId taId) {
        if (taId == null) {
            return this.clock.getTime();
        }
        long finishTime = 0L;
        for (TaskAttempt at : this.attempts.values()) {
            if (!at.getID().equals((Object)taId)) continue;
            return at.getFinishTime();
        }
        return finishTime;
    }

    private TaskStateInternal finished(TaskStateInternal finalState) {
        if (this.getInternalState() == TaskStateInternal.RUNNING) {
            this.metrics.endRunningTask((Task)this);
        }
        return finalState;
    }

    private TaskAttempt selectBestAttempt() {
        if (this.successfulAttempt != null) {
            return (TaskAttempt)this.attempts.get(this.successfulAttempt);
        }
        float progress = 0.0f;
        TaskAttempt result = null;
        block3: for (TaskAttempt at : this.attempts.values()) {
            float attemptProgress;
            switch (1.$SwitchMap$org$apache$hadoop$mapreduce$v2$api$records$TaskAttemptState[at.getState().ordinal()]) {
                case 1: 
                case 2: {
                    continue block3;
                }
            }
            if (result == null) {
                result = at;
            }
            if (!((attemptProgress = at.getProgress()) > progress)) continue;
            result = at;
            progress = attemptProgress;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canCommit(TaskAttemptId taskAttemptID) {
        this.readLock.lock();
        boolean canCommit = false;
        try {
            if (this.commitAttempt != null) {
                canCommit = taskAttemptID.equals((Object)this.commitAttempt);
                LOG.info((Object)("Result of canCommit for " + taskAttemptID + ":" + canCommit));
            }
        }
        finally {
            this.readLock.unlock();
        }
        return canCommit;
    }

    protected abstract TaskAttemptImpl createAttempt();

    protected abstract int getMaxAttempts();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TaskAttempt getSuccessfulAttempt() {
        this.readLock.lock();
        try {
            if (null == this.successfulAttempt) {
                TaskAttempt taskAttempt = null;
                return taskAttempt;
            }
            TaskAttempt taskAttempt = (TaskAttempt)this.attempts.get(this.successfulAttempt);
            return taskAttempt;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void addAndScheduleAttempt(Avataar avataar) {
        TaskAttemptImpl attempt = this.createAttempt();
        attempt.setAvataar(avataar);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Created attempt " + attempt.getID()));
        }
        switch (this.attempts.size()) {
            case 0: {
                this.attempts = Collections.singletonMap(attempt.getID(), attempt);
                break;
            }
            case 1: {
                LinkedHashMap newAttempts = new LinkedHashMap(this.maxAttempts);
                newAttempts.putAll(this.attempts);
                this.attempts = newAttempts;
                this.attempts.put(attempt.getID(), attempt);
                break;
            }
            default: {
                this.attempts.put(attempt.getID(), attempt);
            }
        }
        this.nextAttemptNumber = this.taskAttemptsFromPreviousGeneration.isEmpty() ? ++this.nextAttemptNumber : ((JobHistoryParser.TaskAttemptInfo)this.taskAttemptsFromPreviousGeneration.remove(0)).getAttemptId().getId();
        this.inProgressAttempts.add(attempt.getID());
        if (this.failedAttempts.size() > 0) {
            this.eventHandler.handle((Event)new TaskAttemptEvent(attempt.getID(), TaskAttemptEventType.TA_RESCHEDULE));
        } else {
            this.eventHandler.handle((Event)new TaskAttemptEvent(attempt.getID(), TaskAttemptEventType.TA_SCHEDULE));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(TaskEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing " + event.getTaskID() + " of type " + event.getType()));
        }
        try {
            this.writeLock.lock();
            TaskStateInternal oldState = this.getInternalState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)("Can't handle this event at current state for " + this.taskId), (Throwable)e);
                this.internalError((TaskEventType)event.getType());
            }
            if (oldState != this.getInternalState()) {
                LOG.info((Object)(this.taskId + " Task Transitioned from " + oldState + " to " + this.getInternalState()));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void internalError(TaskEventType type) {
        LOG.error((Object)("Invalid event " + type + " on Task " + this.taskId));
        this.eventHandler.handle((Event)new JobDiagnosticsUpdateEvent(this.taskId.getJobId(), "Invalid event " + type + " on Task " + this.taskId));
        this.eventHandler.handle((Event)new JobEvent(this.taskId.getJobId(), JobEventType.INTERNAL_ERROR));
    }

    private void handleTaskAttemptCompletion(TaskAttemptId attemptId, TaskAttemptCompletionEventStatus status) {
        TaskAttempt attempt = (TaskAttempt)this.attempts.get(attemptId);
        if (attempt.getNodeHttpAddress() != null) {
            TaskAttemptCompletionEvent tce = (TaskAttemptCompletionEvent)this.recordFactory.newRecordInstance(TaskAttemptCompletionEvent.class);
            tce.setEventId(-1);
            String scheme = this.encryptedShuffle ? "https://" : "http://";
            tce.setMapOutputServerAddress(StringInterner.weakIntern((String)(scheme + attempt.getNodeHttpAddress().split(":")[0] + ":" + attempt.getShufflePort())));
            tce.setStatus(status);
            tce.setAttemptId(attempt.getID());
            int runTime = 0;
            if (attempt.getFinishTime() != 0L && attempt.getLaunchTime() != 0L) {
                runTime = (int)(attempt.getFinishTime() - attempt.getLaunchTime());
            }
            tce.setAttemptRunTime(runTime);
            this.eventHandler.handle((Event)new JobTaskAttemptCompletedEvent(tce));
        }
    }

    private static TaskFinishedEvent createTaskFinishedEvent(TaskImpl task, TaskStateInternal taskState) {
        TaskFinishedEvent tfe = new TaskFinishedEvent((TaskID)TypeConverter.fromYarn((TaskId)task.taskId), (TaskAttemptID)TypeConverter.fromYarn((TaskAttemptId)task.successfulAttempt), task.getFinishTime(task.successfulAttempt), TypeConverter.fromYarn((TaskType)task.taskId.getTaskType()), taskState.toString(), task.getCounters());
        return tfe;
    }

    private static TaskFailedEvent createTaskFailedEvent(TaskImpl task, List<String> diag, TaskStateInternal taskState, TaskAttemptId taId) {
        StringBuilder errorSb = new StringBuilder();
        if (diag != null) {
            for (String d : diag) {
                errorSb.append(", ").append(d);
            }
        }
        TaskFailedEvent taskFailedEvent = new TaskFailedEvent((TaskID)TypeConverter.fromYarn((TaskId)task.taskId), task.getFinishTime(taId), TypeConverter.fromYarn((TaskType)task.getType()), errorSb.toString(), taskState.toString(), (TaskAttemptID)(taId == null ? null : TypeConverter.fromYarn((TaskAttemptId)taId)), task.getCounters());
        return taskFailedEvent;
    }

    private static void unSucceed(TaskImpl task) {
        task.commitAttempt = null;
        task.successfulAttempt = null;
    }

    protected String getSplitsAsString() {
        return "";
    }

    private void killUnfinishedAttempt(TaskAttempt attempt, String logMsg) {
        if (attempt != null && !attempt.isFinished()) {
            this.eventHandler.handle((Event)new TaskAttemptEvent(attempt.getID(), TaskAttemptEventType.TA_KILL));
        }
    }

    static /* synthetic */ void access$1200(TaskImpl x0, Avataar x1) {
        x0.addAndScheduleAttempt(x1);
    }

    static /* synthetic */ long access$1302(TaskImpl x0, long x1) {
        x0.scheduledTime = x1;
        return x0.scheduledTime;
    }

    static /* synthetic */ TaskId access$1400(TaskImpl x0) {
        return x0.taskId;
    }

    static /* synthetic */ long access$1500(TaskImpl x0) {
        return x0.getLaunchTime();
    }

    static /* synthetic */ boolean access$1602(TaskImpl x0, boolean x1) {
        x0.historyTaskStartGenerated = x1;
        return x0.historyTaskStartGenerated;
    }

    static /* synthetic */ Log access$1700() {
        return LOG;
    }

    static /* synthetic */ TaskAttemptId access$1800(TaskImpl x0) {
        return x0.commitAttempt;
    }

    static /* synthetic */ TaskAttemptId access$1802(TaskImpl x0, TaskAttemptId x1) {
        x0.commitAttempt = x1;
        return x0.commitAttempt;
    }

    static /* synthetic */ void access$1900(TaskImpl x0, TaskAttemptId x1, TaskAttemptCompletionEventStatus x2) {
        x0.handleTaskAttemptCompletion(x1, x2);
    }

    static /* synthetic */ Set access$2000(TaskImpl x0) {
        return x0.finishedAttempts;
    }

    static /* synthetic */ Set access$2100(TaskImpl x0) {
        return x0.inProgressAttempts;
    }

    static /* synthetic */ TaskAttemptId access$2202(TaskImpl x0, TaskAttemptId x1) {
        x0.successfulAttempt = x1;
        return x0.successfulAttempt;
    }

    static /* synthetic */ TaskAttemptId access$2200(TaskImpl x0) {
        return x0.successfulAttempt;
    }

    static /* synthetic */ boolean access$1600(TaskImpl x0) {
        return x0.historyTaskStartGenerated;
    }

    static /* synthetic */ TaskFinishedEvent access$2300(TaskImpl x0, TaskStateInternal x1) {
        return TaskImpl.createTaskFinishedEvent((TaskImpl)x0, (TaskStateInternal)x1);
    }

    static /* synthetic */ Map access$2400(TaskImpl x0) {
        return x0.attempts;
    }

    static /* synthetic */ TaskStateInternal access$2500(TaskImpl x0, TaskStateInternal x1) {
        return x0.finished(x1);
    }

    static /* synthetic */ TaskFailedEvent access$2600(TaskImpl x0, List x1, TaskStateInternal x2, TaskAttemptId x3) {
        return TaskImpl.createTaskFailedEvent((TaskImpl)x0, (List)x1, (TaskStateInternal)x2, (TaskAttemptId)x3);
    }

    static /* synthetic */ TaskState access$2700(TaskStateInternal x0) {
        return TaskImpl.getExternalState((TaskStateInternal)x0);
    }

    static /* synthetic */ Set access$2800(TaskImpl x0) {
        return x0.failedAttempts;
    }

    static /* synthetic */ int access$2900(TaskImpl x0) {
        return x0.maxAttempts;
    }

    static /* synthetic */ void access$3000(TaskImpl x0, TaskAttempt x1, String x2) {
        x0.killUnfinishedAttempt(x1, x2);
    }

    static /* synthetic */ void access$3100(TaskImpl x0) {
        TaskImpl.unSucceed((TaskImpl)x0);
    }

    static /* synthetic */ MRAppMetrics access$3200(TaskImpl x0) {
        return x0.metrics;
    }
}

