/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.app.MRAppMaster;
import org.apache.hadoop.mapreduce.v2.app.MRAppMasterTest;
import org.apache.hadoop.mapreduce.v2.app.job.JobStateInternal;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestMRAppMaster {
    private static final Log LOG = LogFactory.getLog(TestMRAppMaster.class);
    static String stagingDir = "staging/";

    @BeforeClass
    public static void setup() {
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
        File dir = new File(stagingDir);
        stagingDir = dir.getAbsolutePath();
    }

    @Before
    public void cleanup() throws IOException {
        File dir = new File(stagingDir);
        if (dir.exists()) {
            FileUtils.deleteDirectory((File)dir);
        }
        dir.mkdirs();
    }

    @Test
    public void testMRAppMasterForDifferentUser() throws IOException, InterruptedException {
        String applicationAttemptIdStr = "appattempt_1317529182569_0004_000001";
        String containerIdStr = "container_1317529182569_0004_000001_1";
        String userName = "TestAppMasterUser";
        ApplicationAttemptId applicationAttemptId = ConverterUtils.toApplicationAttemptId((String)applicationAttemptIdStr);
        ContainerId containerId = ConverterUtils.toContainerId((String)containerIdStr);
        MRAppMasterTest appMaster = new MRAppMasterTest(applicationAttemptId, containerId, "host", -1, -1, System.currentTimeMillis());
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        MRAppMaster.initAndStartAppMaster((MRAppMaster)appMaster, (YarnConfiguration)conf, (String)userName);
        Assert.assertEquals((Object)(stagingDir + "/" + userName + "/" + ".staging"), (Object)appMaster.stagingDirPath.toString());
    }

    @Test
    public void testMRAppMasterMidLock() throws IOException, InterruptedException {
        String applicationAttemptIdStr = "appattempt_1317529182569_0004_000002";
        String containerIdStr = "container_1317529182569_0004_000002_1";
        String userName = "TestAppMasterUser";
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        ApplicationAttemptId applicationAttemptId = ConverterUtils.toApplicationAttemptId((String)applicationAttemptIdStr);
        JobId jobId = TypeConverter.toYarn((JobID)TypeConverter.fromYarn((ApplicationId)applicationAttemptId.getApplicationId()));
        Path start = MRApps.getStartJobCommitFile((Configuration)conf, (String)userName, (JobId)jobId);
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.create(start).close();
        ContainerId containerId = ConverterUtils.toContainerId((String)containerIdStr);
        MRAppMasterTest appMaster = new MRAppMasterTest(applicationAttemptId, containerId, "host", -1, -1, System.currentTimeMillis(), false);
        boolean caught = false;
        try {
            MRAppMaster.initAndStartAppMaster((MRAppMaster)appMaster, (YarnConfiguration)conf, (String)userName);
        }
        catch (IOException e) {
            LOG.info((Object)"Caught expected Exception", (Throwable)e);
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        Assert.assertTrue((boolean)appMaster.errorHappenedShutDown);
        Assert.assertEquals((Object)JobStateInternal.ERROR, (Object)appMaster.forcedState);
        appMaster.stop();
    }

    @Test
    public void testMRAppMasterSuccessLock() throws IOException, InterruptedException {
        String applicationAttemptIdStr = "appattempt_1317529182569_0004_000002";
        String containerIdStr = "container_1317529182569_0004_000002_1";
        String userName = "TestAppMasterUser";
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        ApplicationAttemptId applicationAttemptId = ConverterUtils.toApplicationAttemptId((String)applicationAttemptIdStr);
        JobId jobId = TypeConverter.toYarn((JobID)TypeConverter.fromYarn((ApplicationId)applicationAttemptId.getApplicationId()));
        Path start = MRApps.getStartJobCommitFile((Configuration)conf, (String)userName, (JobId)jobId);
        Path end = MRApps.getEndJobCommitSuccessFile((Configuration)conf, (String)userName, (JobId)jobId);
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.create(start).close();
        fs.create(end).close();
        ContainerId containerId = ConverterUtils.toContainerId((String)containerIdStr);
        MRAppMasterTest appMaster = new MRAppMasterTest(applicationAttemptId, containerId, "host", -1, -1, System.currentTimeMillis(), false);
        boolean caught = false;
        try {
            MRAppMaster.initAndStartAppMaster((MRAppMaster)appMaster, (YarnConfiguration)conf, (String)userName);
        }
        catch (IOException e) {
            LOG.info((Object)"Caught expected Exception", (Throwable)e);
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        Assert.assertTrue((boolean)appMaster.errorHappenedShutDown);
        Assert.assertEquals((Object)JobStateInternal.SUCCEEDED, (Object)appMaster.forcedState);
        appMaster.stop();
    }

    @Test
    public void testMRAppMasterFailLock() throws IOException, InterruptedException {
        String applicationAttemptIdStr = "appattempt_1317529182569_0004_000002";
        String containerIdStr = "container_1317529182569_0004_000002_1";
        String userName = "TestAppMasterUser";
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        ApplicationAttemptId applicationAttemptId = ConverterUtils.toApplicationAttemptId((String)applicationAttemptIdStr);
        JobId jobId = TypeConverter.toYarn((JobID)TypeConverter.fromYarn((ApplicationId)applicationAttemptId.getApplicationId()));
        Path start = MRApps.getStartJobCommitFile((Configuration)conf, (String)userName, (JobId)jobId);
        Path end = MRApps.getEndJobCommitFailureFile((Configuration)conf, (String)userName, (JobId)jobId);
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.create(start).close();
        fs.create(end).close();
        ContainerId containerId = ConverterUtils.toContainerId((String)containerIdStr);
        MRAppMasterTest appMaster = new MRAppMasterTest(applicationAttemptId, containerId, "host", -1, -1, System.currentTimeMillis(), false);
        boolean caught = false;
        try {
            MRAppMaster.initAndStartAppMaster((MRAppMaster)appMaster, (YarnConfiguration)conf, (String)userName);
        }
        catch (IOException e) {
            LOG.info((Object)"Caught expected Exception", (Throwable)e);
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        Assert.assertTrue((boolean)appMaster.errorHappenedShutDown);
        Assert.assertEquals((Object)JobStateInternal.FAILED, (Object)appMaster.forcedState);
        appMaster.stop();
    }

    @Test
    public void testMRAppMasterMissingStaging() throws IOException, InterruptedException {
        String applicationAttemptIdStr = "appattempt_1317529182569_0004_000002";
        String containerIdStr = "container_1317529182569_0004_000002_1";
        String userName = "TestAppMasterUser";
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.app.mapreduce.am.staging-dir", stagingDir);
        ApplicationAttemptId applicationAttemptId = ConverterUtils.toApplicationAttemptId((String)applicationAttemptIdStr);
        File dir = new File(stagingDir);
        if (dir.exists()) {
            FileUtils.deleteDirectory((File)dir);
        }
        ContainerId containerId = ConverterUtils.toContainerId((String)containerIdStr);
        MRAppMasterTest appMaster = new MRAppMasterTest(applicationAttemptId, containerId, "host", -1, -1, System.currentTimeMillis(), false);
        boolean caught = false;
        try {
            MRAppMaster.initAndStartAppMaster((MRAppMaster)appMaster, (YarnConfiguration)conf, (String)userName);
        }
        catch (IOException e) {
            LOG.info((Object)"Caught expected Exception", (Throwable)e);
            caught = true;
        }
        Assert.assertTrue((boolean)caught);
        Assert.assertTrue((boolean)appMaster.errorHappenedShutDown);
        Assert.assertEquals((Object)JobStateInternal.ERROR, (Object)appMaster.forcedState);
        appMaster.stop();
    }
}

