/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.rm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.NormalizedResourceEvent;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobUpdatedNodesEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptKillEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocator;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocatorEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerFailedEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerRequestEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.RMContainerAllocator;
import org.apache.hadoop.mapreduce.v2.app.rm.RMContainerRequestor;
import org.apache.hadoop.util.StringInterner;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.api.records.AMResponse;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.util.RackResolver;

/*
 * Exception performing whole class analysis ignored.
 */
public class RMContainerAllocator
extends RMContainerRequestor
implements ContainerAllocator {
    static final Log LOG = LogFactory.getLog(RMContainerAllocator.class);
    public static final float DEFAULT_COMPLETED_MAPS_PERCENT_FOR_REDUCE_SLOWSTART = 0.05f;
    private static final Priority PRIORITY_FAST_FAIL_MAP = (Priority)RecordFactoryProvider.getRecordFactory(null).newRecordInstance(Priority.class);
    private static final Priority PRIORITY_REDUCE;
    private static final Priority PRIORITY_MAP;
    private Thread eventHandlingThread;
    private final AtomicBoolean stopped;
    private final LinkedList<RMContainerRequestor.ContainerRequest> pendingReduces = new LinkedList();
    private final AssignedRequests assignedRequests = new AssignedRequests(this, null);
    private final ScheduledRequests scheduledRequests = new ScheduledRequests(this, null);
    private int containersAllocated = 0;
    private int containersReleased = 0;
    private int hostLocalAssigned = 0;
    private int rackLocalAssigned = 0;
    private int lastCompletedTasks = 0;
    private boolean recalculateReduceSchedule = false;
    private int mapResourceReqt;
    private int reduceResourceReqt;
    private boolean reduceStarted = false;
    private float maxReduceRampupLimit = 0.0f;
    private float maxReducePreemptionLimit = 0.0f;
    private float reduceSlowStart = 0.0f;
    private long retryInterval;
    private long retrystartTime;
    BlockingQueue<ContainerAllocatorEvent> eventQueue = new LinkedBlockingQueue();
    private ScheduleStats scheduleStats = new ScheduleStats(this, null);

    public RMContainerAllocator(ClientService clientService, AppContext context) {
        super(clientService, context);
        this.stopped = new AtomicBoolean(false);
    }

    public void init(Configuration conf) {
        super.init(conf);
        this.reduceSlowStart = conf.getFloat("mapreduce.job.reduce.slowstart.completedmaps", 0.05f);
        this.maxReduceRampupLimit = conf.getFloat("yarn.app.mapreduce.am.job.reduce.rampup.limit", 0.5f);
        this.maxReducePreemptionLimit = conf.getFloat("yarn.app.mapreduce.am.job.reduce.preemption.limit", 0.5f);
        RackResolver.init((Configuration)conf);
        this.retryInterval = this.getConfig().getLong("yarn.app.mapreduce.am.scheduler.connection.wait.interval-ms", 360000L);
        this.retrystartTime = System.currentTimeMillis();
    }

    public void start() {
        this.eventHandlingThread = new /* Unavailable Anonymous Inner Class!! */;
        this.eventHandlingThread.start();
        super.start();
    }

    protected synchronized void heartbeat() throws Exception {
        int completedMaps;
        int completedTasks;
        this.scheduleStats.updateAndLogIfChanged("Before Scheduling: ");
        List allocatedContainers = this.getResources();
        if (allocatedContainers.size() > 0) {
            ScheduledRequests.access$400((ScheduledRequests)this.scheduledRequests, (List)allocatedContainers);
        }
        if (this.lastCompletedTasks != (completedTasks = (completedMaps = this.getJob().getCompletedMaps()) + this.getJob().getCompletedReduces())) {
            this.lastCompletedTasks = completedTasks;
            this.recalculateReduceSchedule = true;
        }
        if (this.recalculateReduceSchedule) {
            this.preemptReducesIfNeeded();
            this.scheduleReduces(this.getJob().getTotalMaps(), completedMaps, ScheduledRequests.access$500((ScheduledRequests)this.scheduledRequests).size(), ScheduledRequests.access$600((ScheduledRequests)this.scheduledRequests).size(), AssignedRequests.access$700((AssignedRequests)this.assignedRequests).size(), AssignedRequests.access$800((AssignedRequests)this.assignedRequests).size(), this.mapResourceReqt, this.reduceResourceReqt, this.pendingReduces.size(), this.maxReduceRampupLimit, this.reduceSlowStart);
            this.recalculateReduceSchedule = false;
        }
        this.scheduleStats.updateAndLogIfChanged("After Scheduling: ");
    }

    public void stop() {
        if (this.stopped.getAndSet(true)) {
            return;
        }
        this.eventHandlingThread.interrupt();
        super.stop();
        this.scheduleStats.log("Final Stats: ");
    }

    public boolean getIsReduceStarted() {
        return this.reduceStarted;
    }

    public void setIsReduceStarted(boolean reduceStarted) {
        this.reduceStarted = reduceStarted;
    }

    public void handle(ContainerAllocatorEvent event) {
        int remCapacity;
        int qSize = this.eventQueue.size();
        if (qSize != 0 && qSize % 1000 == 0) {
            LOG.info((Object)("Size of event-queue in RMContainerAllocator is " + qSize));
        }
        if ((remCapacity = this.eventQueue.remainingCapacity()) < 1000) {
            LOG.warn((Object)("Very low remaining capacity in the event-queue of RMContainerAllocator: " + remCapacity));
        }
        try {
            this.eventQueue.put(event);
        }
        catch (InterruptedException e) {
            throw new YarnException((Throwable)e);
        }
    }

    protected synchronized void handleEvent(ContainerAllocatorEvent event) {
        this.recalculateReduceSchedule = true;
        if (event.getType() == ContainerAllocator.EventType.CONTAINER_REQ) {
            ContainerRequestEvent reqEvent = (ContainerRequestEvent)event;
            JobId jobId = this.getJob().getID();
            int supportedMaxContainerCapability = this.getMaxContainerCapability().getMemory();
            if (reqEvent.getAttemptID().getTaskId().getTaskType().equals((Object)org.apache.hadoop.mapreduce.v2.api.records.TaskType.MAP)) {
                if (this.mapResourceReqt == 0) {
                    this.mapResourceReqt = reqEvent.getCapability().getMemory();
                    int minSlotMemSize = this.getMinContainerCapability().getMemory();
                    this.mapResourceReqt = (int)Math.ceil((float)this.mapResourceReqt / (float)minSlotMemSize) * minSlotMemSize;
                    this.eventHandler.handle((Event)new JobHistoryEvent(jobId, (HistoryEvent)new NormalizedResourceEvent(TaskType.MAP, this.mapResourceReqt)));
                    LOG.info((Object)("mapResourceReqt:" + this.mapResourceReqt));
                    if (this.mapResourceReqt > supportedMaxContainerCapability) {
                        String diagMsg = "MAP capability required is more than the supported max container capability in the cluster. Killing the Job. mapResourceReqt: " + this.mapResourceReqt + " maxContainerCapability:" + supportedMaxContainerCapability;
                        LOG.info((Object)diagMsg);
                        this.eventHandler.handle((Event)new JobDiagnosticsUpdateEvent(jobId, diagMsg));
                        this.eventHandler.handle((Event)new JobEvent(jobId, JobEventType.JOB_KILL));
                    }
                }
                reqEvent.getCapability().setMemory(this.mapResourceReqt);
                this.scheduledRequests.addMap(reqEvent);
            } else {
                if (this.reduceResourceReqt == 0) {
                    this.reduceResourceReqt = reqEvent.getCapability().getMemory();
                    int minSlotMemSize = this.getMinContainerCapability().getMemory();
                    this.reduceResourceReqt = (int)Math.ceil((float)this.reduceResourceReqt / (float)minSlotMemSize) * minSlotMemSize;
                    this.eventHandler.handle((Event)new JobHistoryEvent(jobId, (HistoryEvent)new NormalizedResourceEvent(TaskType.REDUCE, this.reduceResourceReqt)));
                    LOG.info((Object)("reduceResourceReqt:" + this.reduceResourceReqt));
                    if (this.reduceResourceReqt > supportedMaxContainerCapability) {
                        String diagMsg = "REDUCE capability required is more than the supported max container capability in the cluster. Killing the Job. reduceResourceReqt: " + this.reduceResourceReqt + " maxContainerCapability:" + supportedMaxContainerCapability;
                        LOG.info((Object)diagMsg);
                        this.eventHandler.handle((Event)new JobDiagnosticsUpdateEvent(jobId, diagMsg));
                        this.eventHandler.handle((Event)new JobEvent(jobId, JobEventType.JOB_KILL));
                    }
                }
                reqEvent.getCapability().setMemory(this.reduceResourceReqt);
                if (reqEvent.getEarlierAttemptFailed()) {
                    this.pendingReduces.addFirst(new RMContainerRequestor.ContainerRequest(reqEvent, PRIORITY_REDUCE));
                } else {
                    this.pendingReduces.add(new RMContainerRequestor.ContainerRequest(reqEvent, PRIORITY_REDUCE));
                }
            }
        } else if (event.getType() == ContainerAllocator.EventType.CONTAINER_DEALLOCATE) {
            ContainerId containerId;
            LOG.info((Object)("Processing the event " + event.toString()));
            TaskAttemptId aId = event.getAttemptID();
            boolean removed = this.scheduledRequests.remove(aId);
            if (!removed && (containerId = this.assignedRequests.get(aId)) != null) {
                removed = true;
                this.assignedRequests.remove(aId);
                ++this.containersReleased;
                this.release(containerId);
            }
            if (!removed) {
                LOG.error((Object)("Could not deallocate container for task attemptId " + aId));
            }
        } else if (event.getType() == ContainerAllocator.EventType.CONTAINER_FAILED) {
            ContainerFailedEvent fEv = (ContainerFailedEvent)event;
            String host = RMContainerAllocator.getHost((String)fEv.getContMgrAddress());
            this.containerFailedOnHost(host);
        }
    }

    private static String getHost(String contMgrAddress) {
        String host = contMgrAddress;
        String[] hostport = host.split(":");
        if (hostport.length == 2) {
            host = hostport[0];
        }
        return host;
    }

    private void preemptReducesIfNeeded() {
        int memLimit;
        int availableMemForMap;
        if (this.reduceResourceReqt == 0) {
            return;
        }
        if (ScheduledRequests.access$500((ScheduledRequests)this.scheduledRequests).size() > 0 && (availableMemForMap = (memLimit = this.getMemLimit()) - (AssignedRequests.access$800((AssignedRequests)this.assignedRequests).size() - AssignedRequests.access$900((AssignedRequests)this.assignedRequests).size()) * this.reduceResourceReqt) < this.mapResourceReqt) {
            LOG.info((Object)("Ramping down all scheduled reduces:" + ScheduledRequests.access$600((ScheduledRequests)this.scheduledRequests).size()));
            for (RMContainerRequestor.ContainerRequest req : ScheduledRequests.access$600((ScheduledRequests)this.scheduledRequests).values()) {
                this.pendingReduces.add(req);
            }
            ScheduledRequests.access$600((ScheduledRequests)this.scheduledRequests).clear();
            int premeptionLimit = Math.max(this.mapResourceReqt, (int)(this.maxReducePreemptionLimit * (float)memLimit));
            int preemptMem = Math.min(ScheduledRequests.access$500((ScheduledRequests)this.scheduledRequests).size() * this.mapResourceReqt, premeptionLimit);
            int toPreempt = (int)Math.ceil((float)preemptMem / (float)this.reduceResourceReqt);
            toPreempt = Math.min(toPreempt, AssignedRequests.access$800((AssignedRequests)this.assignedRequests).size());
            LOG.info((Object)("Going to preempt " + toPreempt));
            this.assignedRequests.preemptReduce(toPreempt);
        }
    }

    @InterfaceAudience.Private
    public void scheduleReduces(int totalMaps, int completedMaps, int scheduledMaps, int scheduledReduces, int assignedMaps, int assignedReduces, int mapResourceReqt, int reduceResourceReqt, int numPendingReduces, float maxReduceRampupLimit, float reduceSlowStart) {
        int idealReduceMemLimit;
        if (numPendingReduces == 0) {
            return;
        }
        int headRoom = this.getAvailableResources() != null ? this.getAvailableResources().getMemory() : 0;
        LOG.info((Object)("Recalculating schedule, headroom=" + headRoom));
        if (!this.getIsReduceStarted()) {
            int completedMapsForReduceSlowstart = (int)Math.ceil(reduceSlowStart * (float)totalMaps);
            if (completedMaps < completedMapsForReduceSlowstart) {
                LOG.info((Object)("Reduce slow start threshold not met. completedMapsForReduceSlowstart " + completedMapsForReduceSlowstart));
                return;
            }
            LOG.info((Object)"Reduce slow start threshold reached. Scheduling reduces.");
            this.setIsReduceStarted(true);
        }
        if (scheduledMaps == 0 && numPendingReduces > 0) {
            LOG.info((Object)("All maps assigned. Ramping up all remaining reduces:" + numPendingReduces));
            this.scheduleAllReduces();
            return;
        }
        float completedMapPercent = 0.0f;
        completedMapPercent = totalMaps != 0 ? (float)completedMaps / (float)totalMaps : 1.0f;
        int netScheduledMapMem = (scheduledMaps + assignedMaps) * mapResourceReqt;
        int netScheduledReduceMem = (scheduledReduces + assignedReduces) * reduceResourceReqt;
        int finalMapMemLimit = 0;
        int finalReduceMemLimit = 0;
        int totalMemLimit = this.getMemLimit();
        int idealMapMemLimit = totalMemLimit - (idealReduceMemLimit = Math.min((int)(completedMapPercent * (float)totalMemLimit), (int)(maxReduceRampupLimit * (float)totalMemLimit)));
        if (idealMapMemLimit > netScheduledMapMem) {
            int unusedMapMemLimit = idealMapMemLimit - netScheduledMapMem;
            finalReduceMemLimit = idealReduceMemLimit + unusedMapMemLimit;
            finalMapMemLimit = totalMemLimit - finalReduceMemLimit;
        } else {
            finalMapMemLimit = idealMapMemLimit;
            finalReduceMemLimit = idealReduceMemLimit;
        }
        LOG.info((Object)("completedMapPercent " + completedMapPercent + " totalMemLimit:" + totalMemLimit + " finalMapMemLimit:" + finalMapMemLimit + " finalReduceMemLimit:" + finalReduceMemLimit + " netScheduledMapMem:" + netScheduledMapMem + " netScheduledReduceMem:" + netScheduledReduceMem));
        int rampUp = (finalReduceMemLimit - netScheduledReduceMem) / reduceResourceReqt;
        if (rampUp > 0) {
            rampUp = Math.min(rampUp, numPendingReduces);
            LOG.info((Object)("Ramping up " + rampUp));
            this.rampUpReduces(rampUp);
        } else if (rampUp < 0) {
            int rampDown = -1 * rampUp;
            rampDown = Math.min(rampDown, scheduledReduces);
            LOG.info((Object)("Ramping down " + rampDown));
            this.rampDownReduces(rampDown);
        }
    }

    @InterfaceAudience.Private
    public void scheduleAllReduces() {
        for (RMContainerRequestor.ContainerRequest req : this.pendingReduces) {
            this.scheduledRequests.addReduce(req);
        }
        this.pendingReduces.clear();
    }

    @InterfaceAudience.Private
    public void rampUpReduces(int rampUp) {
        for (int i = 0; i < rampUp; ++i) {
            RMContainerRequestor.ContainerRequest request = (RMContainerRequestor.ContainerRequest)this.pendingReduces.removeFirst();
            this.scheduledRequests.addReduce(request);
        }
    }

    @InterfaceAudience.Private
    public void rampDownReduces(int rampDown) {
        for (int i = 0; i < rampDown; ++i) {
            RMContainerRequestor.ContainerRequest request = this.scheduledRequests.removeReduce();
            this.pendingReduces.add(request);
        }
    }

    private List<Container> getResources() throws Exception {
        AMResponse response;
        int headRoom = this.getAvailableResources() != null ? this.getAvailableResources().getMemory() : 0;
        try {
            response = this.makeRemoteRequest();
            this.retrystartTime = System.currentTimeMillis();
        }
        catch (Exception e) {
            if (System.currentTimeMillis() - this.retrystartTime >= this.retryInterval) {
                LOG.error((Object)("Could not contact RM after " + this.retryInterval + " milliseconds."));
                this.eventHandler.handle((Event)new JobEvent(this.getJob().getID(), JobEventType.INTERNAL_ERROR));
                throw new YarnException("Could not contact RM after " + this.retryInterval + " milliseconds.");
            }
            throw e;
        }
        if (response.getReboot()) {
            this.eventHandler.handle((Event)new JobEvent(this.getJob().getID(), JobEventType.INTERNAL_ERROR));
            throw new YarnException("Resource Manager doesn't recognize AttemptId: " + this.getContext().getApplicationID());
        }
        int newHeadRoom = this.getAvailableResources() != null ? this.getAvailableResources().getMemory() : 0;
        List newContainers = response.getAllocatedContainers();
        List finishedContainers = response.getCompletedContainersStatuses();
        if (newContainers.size() + finishedContainers.size() > 0 || headRoom != newHeadRoom) {
            this.recalculateReduceSchedule = true;
            if (LOG.isDebugEnabled() && headRoom != newHeadRoom) {
                LOG.debug((Object)("headroom=" + newHeadRoom));
            }
        }
        if (LOG.isDebugEnabled()) {
            for (Container cont : newContainers) {
                LOG.debug((Object)("Received new Container :" + cont));
            }
        }
        this.computeIgnoreBlacklisting();
        this.handleUpdatedNodes(response);
        for (Container cont : finishedContainers) {
            LOG.info((Object)("Received completed container " + cont.getContainerId()));
            TaskAttemptId attemptID = this.assignedRequests.get(cont.getContainerId());
            if (attemptID == null) {
                LOG.error((Object)("Container complete event for unknown container id " + cont.getContainerId()));
                continue;
            }
            this.assignedRequests.remove(attemptID);
            this.eventHandler.handle((Event)new TaskAttemptEvent(attemptID, TaskAttemptEventType.TA_CONTAINER_COMPLETED));
            String diagnostics = StringInterner.weakIntern((String)cont.getDiagnostics());
            this.eventHandler.handle((Event)new TaskAttemptDiagnosticsUpdateEvent(attemptID, diagnostics));
        }
        return newContainers;
    }

    private void handleUpdatedNodes(AMResponse response) {
        List updatedNodes = response.getUpdatedNodes();
        if (!updatedNodes.isEmpty()) {
            this.eventHandler.handle((Event)new JobUpdatedNodesEvent(this.getJob().getID(), updatedNodes));
            HashSet<NodeId> unusableNodes = new HashSet<NodeId>();
            for (NodeReport nr : updatedNodes) {
                NodeState nodeState = nr.getNodeState();
                if (!nodeState.isUnusable()) continue;
                unusableNodes.add(nr.getNodeId());
            }
            for (int i = 0; i < 2; ++i) {
                LinkedHashMap taskSet = i == 0 ? AssignedRequests.access$700((AssignedRequests)this.assignedRequests) : AssignedRequests.access$800((AssignedRequests)this.assignedRequests);
                for (Map.Entry entry : ((HashMap)taskSet).entrySet()) {
                    TaskAttemptId tid = (TaskAttemptId)entry.getKey();
                    NodeId taskAttemptNodeId = ((Container)entry.getValue()).getNodeId();
                    if (!unusableNodes.contains(taskAttemptNodeId)) continue;
                    LOG.info((Object)("Killing taskAttempt:" + tid + " because it is running on unusable node:" + taskAttemptNodeId));
                    this.eventHandler.handle((Event)new TaskAttemptKillEvent(tid, "TaskAttempt killed because it ran on unusable node" + taskAttemptNodeId));
                }
            }
        }
    }

    @InterfaceAudience.Private
    public int getMemLimit() {
        int headRoom = this.getAvailableResources() != null ? this.getAvailableResources().getMemory() : 0;
        return headRoom + AssignedRequests.access$700((AssignedRequests)this.assignedRequests).size() * this.mapResourceReqt + AssignedRequests.access$800((AssignedRequests)this.assignedRequests).size() * this.reduceResourceReqt;
    }

    static /* synthetic */ AtomicBoolean access$300(RMContainerAllocator x0) {
        return x0.stopped;
    }

    static /* synthetic */ Priority access$1000() {
        return PRIORITY_FAST_FAIL_MAP;
    }

    static /* synthetic */ Priority access$1100() {
        return PRIORITY_MAP;
    }

    static /* synthetic */ int access$1212(RMContainerAllocator x0, int x1) {
        return x0.containersAllocated += x1;
    }

    static /* synthetic */ int access$1300(RMContainerAllocator x0) {
        return x0.mapResourceReqt;
    }

    static /* synthetic */ Priority access$1400() {
        return PRIORITY_REDUCE;
    }

    static /* synthetic */ int access$1500(RMContainerAllocator x0) {
        return x0.reduceResourceReqt;
    }

    static /* synthetic */ AssignedRequests access$1600(RMContainerAllocator x0) {
        return x0.assignedRequests;
    }

    static /* synthetic */ int access$1708(RMContainerAllocator x0) {
        return x0.containersReleased++;
    }

    static /* synthetic */ int access$1808(RMContainerAllocator x0) {
        return x0.hostLocalAssigned++;
    }

    static /* synthetic */ int access$1908(RMContainerAllocator x0) {
        return x0.rackLocalAssigned++;
    }

    static /* synthetic */ LinkedList access$2000(RMContainerAllocator x0) {
        return x0.pendingReduces;
    }

    static /* synthetic */ ScheduledRequests access$2100(RMContainerAllocator x0) {
        return x0.scheduledRequests;
    }

    static /* synthetic */ int access$1200(RMContainerAllocator x0) {
        return x0.containersAllocated;
    }

    static /* synthetic */ int access$1700(RMContainerAllocator x0) {
        return x0.containersReleased;
    }

    static /* synthetic */ int access$1800(RMContainerAllocator x0) {
        return x0.hostLocalAssigned;
    }

    static /* synthetic */ int access$1900(RMContainerAllocator x0) {
        return x0.rackLocalAssigned;
    }

    static {
        PRIORITY_FAST_FAIL_MAP.setPriority(5);
        PRIORITY_REDUCE = (Priority)RecordFactoryProvider.getRecordFactory(null).newRecordInstance(Priority.class);
        PRIORITY_REDUCE.setPriority(10);
        PRIORITY_MAP = (Priority)RecordFactoryProvider.getRecordFactory(null).newRecordInstance(Priority.class);
        PRIORITY_MAP.setPriority(20);
    }
}

