/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.rm;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.NormalizedResourceEvent;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocator;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocatorEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerFailedEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerRequestEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.RMContainerAllocator;
import org.apache.hadoop.mapreduce.v2.app.rm.RMContainerRequestor;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.api.records.AMResponse;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.util.RackResolver;

/*
 * Exception performing whole class analysis ignored.
 */
public class RMContainerAllocator
extends RMContainerRequestor
implements ContainerAllocator {
    static final Log LOG = LogFactory.getLog(RMContainerAllocator.class);
    public static final float DEFAULT_COMPLETED_MAPS_PERCENT_FOR_REDUCE_SLOWSTART = 0.05f;
    private static final Priority PRIORITY_FAST_FAIL_MAP = (Priority)RecordFactoryProvider.getRecordFactory(null).newRecordInstance(Priority.class);
    private static final Priority PRIORITY_REDUCE;
    private static final Priority PRIORITY_MAP;
    private Thread eventHandlingThread;
    private volatile boolean stopEventHandling;
    private final LinkedList<RMContainerRequestor.ContainerRequest> pendingReduces = new LinkedList();
    private final AssignedRequests assignedRequests = new AssignedRequests(this, null);
    private final ScheduledRequests scheduledRequests = new ScheduledRequests(this, null);
    private int containersAllocated = 0;
    private int containersReleased = 0;
    private int hostLocalAssigned = 0;
    private int rackLocalAssigned = 0;
    private boolean recalculateReduceSchedule = false;
    private int mapResourceReqt;
    private int reduceResourceReqt;
    private boolean reduceStarted = false;
    private float maxReduceRampupLimit = 0.0f;
    private float maxReducePreemptionLimit = 0.0f;
    private float reduceSlowStart = 0.0f;
    private long retryInterval;
    private long retrystartTime;
    BlockingQueue<ContainerAllocatorEvent> eventQueue = new LinkedBlockingQueue();

    public RMContainerAllocator(ClientService clientService, AppContext context) {
        super(clientService, context);
    }

    public void init(Configuration conf) {
        super.init(conf);
        this.reduceSlowStart = conf.getFloat("mapreduce.job.reduce.slowstart.completedmaps", 0.05f);
        this.maxReduceRampupLimit = conf.getFloat("yarn.app.mapreduce.am.job.reduce.rampup.limit", 0.5f);
        this.maxReducePreemptionLimit = conf.getFloat("yarn.app.mapreduce.am.job.reduce.preemption.limit", 0.5f);
        RackResolver.init((Configuration)conf);
        this.retryInterval = this.getConfig().getLong("yarn.app.mapreduce.am.scheduler.connection.wait.interval-ms", 360000L);
        this.retrystartTime = System.currentTimeMillis();
    }

    public void start() {
        this.eventHandlingThread = new /* Unavailable Anonymous Inner Class!! */;
        this.eventHandlingThread.start();
        super.start();
    }

    protected synchronized void heartbeat() throws Exception {
        LOG.info((Object)("Before Scheduling: " + this.getStat()));
        List allocatedContainers = this.getResources();
        LOG.info((Object)("After Scheduling: " + this.getStat()));
        if (allocatedContainers.size() > 0) {
            LOG.info((Object)("Before Assign: " + this.getStat()));
            ScheduledRequests.access$300((ScheduledRequests)this.scheduledRequests, (List)allocatedContainers);
            LOG.info((Object)("After Assign: " + this.getStat()));
        }
        if (this.recalculateReduceSchedule) {
            this.preemptReducesIfNeeded();
            this.scheduleReduces(this.getJob().getTotalMaps(), this.getJob().getCompletedMaps(), ScheduledRequests.access$400((ScheduledRequests)this.scheduledRequests).size(), ScheduledRequests.access$500((ScheduledRequests)this.scheduledRequests).size(), AssignedRequests.access$600((AssignedRequests)this.assignedRequests).size(), AssignedRequests.access$700((AssignedRequests)this.assignedRequests).size(), this.mapResourceReqt, this.reduceResourceReqt, this.pendingReduces.size(), this.maxReduceRampupLimit, this.reduceSlowStart);
            this.recalculateReduceSchedule = false;
        }
    }

    public void stop() {
        this.stopEventHandling = true;
        this.eventHandlingThread.interrupt();
        super.stop();
        LOG.info((Object)("Final Stats: " + this.getStat()));
    }

    public boolean getIsReduceStarted() {
        return this.reduceStarted;
    }

    public void setIsReduceStarted(boolean reduceStarted) {
        this.reduceStarted = reduceStarted;
    }

    public void handle(ContainerAllocatorEvent event) {
        int remCapacity;
        int qSize = this.eventQueue.size();
        if (qSize != 0 && qSize % 1000 == 0) {
            LOG.info((Object)("Size of event-queue in RMContainerAllocator is " + qSize));
        }
        if ((remCapacity = this.eventQueue.remainingCapacity()) < 1000) {
            LOG.warn((Object)("Very low remaining capacity in the event-queue of RMContainerAllocator: " + remCapacity));
        }
        try {
            this.eventQueue.put(event);
        }
        catch (InterruptedException e) {
            throw new YarnException((Throwable)e);
        }
    }

    protected synchronized void handleEvent(ContainerAllocatorEvent event) {
        this.recalculateReduceSchedule = true;
        if (event.getType() == ContainerAllocator.EventType.CONTAINER_REQ) {
            ContainerRequestEvent reqEvent = (ContainerRequestEvent)event;
            JobId jobId = this.getJob().getID();
            int supportedMaxContainerCapability = this.getMaxContainerCapability().getMemory();
            if (reqEvent.getAttemptID().getTaskId().getTaskType().equals((Object)org.apache.hadoop.mapreduce.v2.api.records.TaskType.MAP)) {
                if (this.mapResourceReqt == 0) {
                    this.mapResourceReqt = reqEvent.getCapability().getMemory();
                    int minSlotMemSize = this.getMinContainerCapability().getMemory();
                    this.mapResourceReqt = (int)Math.ceil((float)this.mapResourceReqt / (float)minSlotMemSize) * minSlotMemSize;
                    this.eventHandler.handle((Event)new JobHistoryEvent(jobId, (HistoryEvent)new NormalizedResourceEvent(TaskType.MAP, this.mapResourceReqt)));
                    LOG.info((Object)("mapResourceReqt:" + this.mapResourceReqt));
                    if (this.mapResourceReqt > supportedMaxContainerCapability) {
                        String diagMsg = "MAP capability required is more than the supported max container capability in the cluster. Killing the Job. mapResourceReqt: " + this.mapResourceReqt + " maxContainerCapability:" + supportedMaxContainerCapability;
                        LOG.info((Object)diagMsg);
                        this.eventHandler.handle((Event)new JobDiagnosticsUpdateEvent(jobId, diagMsg));
                        this.eventHandler.handle((Event)new JobEvent(jobId, JobEventType.JOB_KILL));
                    }
                }
                reqEvent.getCapability().setMemory(this.mapResourceReqt);
                this.scheduledRequests.addMap(reqEvent);
            } else {
                if (this.reduceResourceReqt == 0) {
                    this.reduceResourceReqt = reqEvent.getCapability().getMemory();
                    int minSlotMemSize = this.getMinContainerCapability().getMemory();
                    this.reduceResourceReqt = (int)Math.ceil((float)this.reduceResourceReqt / (float)minSlotMemSize) * minSlotMemSize;
                    this.eventHandler.handle((Event)new JobHistoryEvent(jobId, (HistoryEvent)new NormalizedResourceEvent(TaskType.REDUCE, this.reduceResourceReqt)));
                    LOG.info((Object)("reduceResourceReqt:" + this.reduceResourceReqt));
                    if (this.reduceResourceReqt > supportedMaxContainerCapability) {
                        String diagMsg = "REDUCE capability required is more than the supported max container capability in the cluster. Killing the Job. reduceResourceReqt: " + this.reduceResourceReqt + " maxContainerCapability:" + supportedMaxContainerCapability;
                        LOG.info((Object)diagMsg);
                        this.eventHandler.handle((Event)new JobDiagnosticsUpdateEvent(jobId, diagMsg));
                        this.eventHandler.handle((Event)new JobEvent(jobId, JobEventType.JOB_KILL));
                    }
                }
                reqEvent.getCapability().setMemory(this.reduceResourceReqt);
                if (reqEvent.getEarlierAttemptFailed()) {
                    this.pendingReduces.addFirst(new RMContainerRequestor.ContainerRequest(reqEvent, PRIORITY_REDUCE));
                } else {
                    this.pendingReduces.add(new RMContainerRequestor.ContainerRequest(reqEvent, PRIORITY_REDUCE));
                }
            }
        } else if (event.getType() == ContainerAllocator.EventType.CONTAINER_DEALLOCATE) {
            ContainerId containerId;
            LOG.info((Object)("Processing the event " + event.toString()));
            TaskAttemptId aId = event.getAttemptID();
            boolean removed = this.scheduledRequests.remove(aId);
            if (!removed && (containerId = this.assignedRequests.get(aId)) != null) {
                removed = true;
                this.assignedRequests.remove(aId);
                ++this.containersReleased;
                this.release(containerId);
            }
            if (!removed) {
                LOG.error((Object)("Could not deallocate container for task attemptId " + aId));
            }
        } else if (event.getType() == ContainerAllocator.EventType.CONTAINER_FAILED) {
            ContainerFailedEvent fEv = (ContainerFailedEvent)event;
            String host = RMContainerAllocator.getHost((String)fEv.getContMgrAddress());
            this.containerFailedOnHost(host);
        }
    }

    private static String getHost(String contMgrAddress) {
        String host = contMgrAddress;
        String[] hostport = host.split(":");
        if (hostport.length == 2) {
            host = hostport[0];
        }
        return host;
    }

    private void preemptReducesIfNeeded() {
        int memLimit;
        int availableMemForMap;
        if (this.reduceResourceReqt == 0) {
            return;
        }
        if (ScheduledRequests.access$400((ScheduledRequests)this.scheduledRequests).size() > 0 && (availableMemForMap = (memLimit = this.getMemLimit()) - (AssignedRequests.access$700((AssignedRequests)this.assignedRequests).size() - AssignedRequests.access$800((AssignedRequests)this.assignedRequests).size()) * this.reduceResourceReqt) < this.mapResourceReqt) {
            LOG.info((Object)("Ramping down all scheduled reduces:" + ScheduledRequests.access$500((ScheduledRequests)this.scheduledRequests).size()));
            for (RMContainerRequestor.ContainerRequest req : ScheduledRequests.access$500((ScheduledRequests)this.scheduledRequests).values()) {
                this.pendingReduces.add(req);
            }
            ScheduledRequests.access$500((ScheduledRequests)this.scheduledRequests).clear();
            int premeptionLimit = Math.max(this.mapResourceReqt, (int)(this.maxReducePreemptionLimit * (float)memLimit));
            int preemptMem = Math.min(ScheduledRequests.access$400((ScheduledRequests)this.scheduledRequests).size() * this.mapResourceReqt, premeptionLimit);
            int toPreempt = (int)Math.ceil((float)preemptMem / (float)this.reduceResourceReqt);
            toPreempt = Math.min(toPreempt, AssignedRequests.access$700((AssignedRequests)this.assignedRequests).size());
            LOG.info((Object)("Going to preempt " + toPreempt));
            this.assignedRequests.preemptReduce(toPreempt);
        }
    }

    @InterfaceAudience.Private
    public void scheduleReduces(int totalMaps, int completedMaps, int scheduledMaps, int scheduledReduces, int assignedMaps, int assignedReduces, int mapResourceReqt, int reduceResourceReqt, int numPendingReduces, float maxReduceRampupLimit, float reduceSlowStart) {
        int idealReduceMemLimit;
        if (numPendingReduces == 0) {
            return;
        }
        LOG.info((Object)"Recalculating schedule...");
        if (scheduledMaps == 0 && numPendingReduces > 0) {
            LOG.info((Object)("All maps assigned. Ramping up all remaining reduces:" + numPendingReduces));
            this.scheduleAllReduces();
            return;
        }
        if (!this.getIsReduceStarted()) {
            int completedMapsForReduceSlowstart = (int)Math.ceil(reduceSlowStart * (float)totalMaps);
            if (completedMaps < completedMapsForReduceSlowstart) {
                LOG.info((Object)("Reduce slow start threshold not met. completedMapsForReduceSlowstart " + completedMapsForReduceSlowstart));
                return;
            }
            LOG.info((Object)"Reduce slow start threshold reached. Scheduling reduces.");
            this.setIsReduceStarted(true);
        }
        float completedMapPercent = 0.0f;
        completedMapPercent = totalMaps != 0 ? (float)completedMaps / (float)totalMaps : 1.0f;
        int netScheduledMapMem = (scheduledMaps + assignedMaps) * mapResourceReqt;
        int netScheduledReduceMem = (scheduledReduces + assignedReduces) * reduceResourceReqt;
        int finalMapMemLimit = 0;
        int finalReduceMemLimit = 0;
        int totalMemLimit = this.getMemLimit();
        int idealMapMemLimit = totalMemLimit - (idealReduceMemLimit = Math.min((int)(completedMapPercent * (float)totalMemLimit), (int)(maxReduceRampupLimit * (float)totalMemLimit)));
        if (idealMapMemLimit > netScheduledMapMem) {
            int unusedMapMemLimit = idealMapMemLimit - netScheduledMapMem;
            finalReduceMemLimit = idealReduceMemLimit + unusedMapMemLimit;
            finalMapMemLimit = totalMemLimit - finalReduceMemLimit;
        } else {
            finalMapMemLimit = idealMapMemLimit;
            finalReduceMemLimit = idealReduceMemLimit;
        }
        LOG.info((Object)("completedMapPercent " + completedMapPercent + " totalMemLimit:" + totalMemLimit + " finalMapMemLimit:" + finalMapMemLimit + " finalReduceMemLimit:" + finalReduceMemLimit + " netScheduledMapMem:" + netScheduledMapMem + " netScheduledReduceMem:" + netScheduledReduceMem));
        int rampUp = (finalReduceMemLimit - netScheduledReduceMem) / reduceResourceReqt;
        if (rampUp > 0) {
            rampUp = Math.min(rampUp, numPendingReduces);
            LOG.info((Object)("Ramping up " + rampUp));
            this.rampUpReduces(rampUp);
        } else if (rampUp < 0) {
            int rampDown = -1 * rampUp;
            rampDown = Math.min(rampDown, scheduledReduces);
            LOG.info((Object)("Ramping down " + rampDown));
            this.rampDownReduces(rampDown);
        }
    }

    private void scheduleAllReduces() {
        for (RMContainerRequestor.ContainerRequest req : this.pendingReduces) {
            this.scheduledRequests.addReduce(req);
        }
        this.pendingReduces.clear();
    }

    @InterfaceAudience.Private
    public void rampUpReduces(int rampUp) {
        for (int i = 0; i < rampUp; ++i) {
            RMContainerRequestor.ContainerRequest request = (RMContainerRequestor.ContainerRequest)this.pendingReduces.removeFirst();
            this.scheduledRequests.addReduce(request);
        }
    }

    @InterfaceAudience.Private
    public void rampDownReduces(int rampDown) {
        for (int i = 0; i < rampDown; ++i) {
            RMContainerRequestor.ContainerRequest request = this.scheduledRequests.removeReduce();
            this.pendingReduces.add(request);
        }
    }

    private synchronized String getStat() {
        return "PendingReduces:" + this.pendingReduces.size() + " ScheduledMaps:" + ScheduledRequests.access$400((ScheduledRequests)this.scheduledRequests).size() + " ScheduledReduces:" + ScheduledRequests.access$500((ScheduledRequests)this.scheduledRequests).size() + " AssignedMaps:" + AssignedRequests.access$600((AssignedRequests)this.assignedRequests).size() + " AssignedReduces:" + AssignedRequests.access$700((AssignedRequests)this.assignedRequests).size() + " completedMaps:" + this.getJob().getCompletedMaps() + " completedReduces:" + this.getJob().getCompletedReduces() + " containersAllocated:" + this.containersAllocated + " containersReleased:" + this.containersReleased + " hostLocalAssigned:" + this.hostLocalAssigned + " rackLocalAssigned:" + this.rackLocalAssigned + " availableResources(headroom):" + this.getAvailableResources();
    }

    private List<Container> getResources() throws Exception {
        AMResponse response;
        int headRoom = this.getAvailableResources() != null ? this.getAvailableResources().getMemory() : 0;
        try {
            response = this.makeRemoteRequest();
            this.retrystartTime = System.currentTimeMillis();
        }
        catch (Exception e) {
            if (System.currentTimeMillis() - this.retrystartTime >= this.retryInterval) {
                LOG.error((Object)("Could not contact RM after " + this.retryInterval + " milliseconds."));
                this.eventHandler.handle((Event)new JobEvent(this.getJob().getID(), JobEventType.INTERNAL_ERROR));
                throw new YarnException("Could not contact RM after " + this.retryInterval + " milliseconds.");
            }
            throw e;
        }
        if (response.getReboot()) {
            this.eventHandler.handle((Event)new JobEvent(this.getJob().getID(), JobEventType.INTERNAL_ERROR));
            throw new YarnException("Resource Manager doesn't recognize AttemptId: " + this.getContext().getApplicationID());
        }
        int newHeadRoom = this.getAvailableResources() != null ? this.getAvailableResources().getMemory() : 0;
        List newContainers = response.getAllocatedContainers();
        List finishedContainers = response.getCompletedContainersStatuses();
        if (newContainers.size() + finishedContainers.size() > 0 || headRoom != newHeadRoom) {
            this.recalculateReduceSchedule = true;
        }
        if (LOG.isDebugEnabled()) {
            for (Container cont : newContainers) {
                LOG.debug((Object)("Received new Container :" + cont));
            }
        }
        this.computeIgnoreBlacklisting();
        for (Container cont : finishedContainers) {
            LOG.info((Object)("Received completed container " + cont.getContainerId()));
            TaskAttemptId attemptID = this.assignedRequests.get(cont.getContainerId());
            if (attemptID == null) {
                LOG.error((Object)("Container complete event for unknown container id " + cont.getContainerId()));
                continue;
            }
            this.assignedRequests.remove(attemptID);
            this.eventHandler.handle((Event)new TaskAttemptEvent(attemptID, TaskAttemptEventType.TA_CONTAINER_COMPLETED));
            String diagnostics = cont.getDiagnostics();
            this.eventHandler.handle((Event)new TaskAttemptDiagnosticsUpdateEvent(attemptID, diagnostics));
        }
        return newContainers;
    }

    @InterfaceAudience.Private
    public int getMemLimit() {
        int headRoom = this.getAvailableResources() != null ? this.getAvailableResources().getMemory() : 0;
        return headRoom + AssignedRequests.access$600((AssignedRequests)this.assignedRequests).size() * this.mapResourceReqt + AssignedRequests.access$700((AssignedRequests)this.assignedRequests).size() * this.reduceResourceReqt;
    }

    static /* synthetic */ boolean access$200(RMContainerAllocator x0) {
        return x0.stopEventHandling;
    }

    static /* synthetic */ Priority access$900() {
        return PRIORITY_FAST_FAIL_MAP;
    }

    static /* synthetic */ Priority access$1000() {
        return PRIORITY_MAP;
    }

    static /* synthetic */ int access$1112(RMContainerAllocator x0, int x1) {
        return x0.containersAllocated += x1;
    }

    static /* synthetic */ int access$1200(RMContainerAllocator x0) {
        return x0.mapResourceReqt;
    }

    static /* synthetic */ Priority access$1300() {
        return PRIORITY_REDUCE;
    }

    static /* synthetic */ int access$1400(RMContainerAllocator x0) {
        return x0.reduceResourceReqt;
    }

    static /* synthetic */ AssignedRequests access$1500(RMContainerAllocator x0) {
        return x0.assignedRequests;
    }

    static /* synthetic */ int access$1608(RMContainerAllocator x0) {
        return x0.containersReleased++;
    }

    static /* synthetic */ int access$1708(RMContainerAllocator x0) {
        return x0.hostLocalAssigned++;
    }

    static /* synthetic */ int access$1808(RMContainerAllocator x0) {
        return x0.rackLocalAssigned++;
    }

    static {
        PRIORITY_FAST_FAIL_MAP.setPriority(5);
        PRIORITY_REDUCE = (Priority)RecordFactoryProvider.getRecordFactory(null).newRecordInstance(Priority.class);
        PRIORITY_REDUCE.setPriority(10);
        PRIORITY_MAP = (Priority)RecordFactoryProvider.getRecordFactory(null).newRecordInstance(Priority.class);
        PRIORITY_MAP.setPriority(20);
    }
}

