/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.launcher;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncher;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncherEvent;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncherImpl;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.api.ContainerManager;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerToken;
import org.apache.hadoop.yarn.api.records.DelegationToken;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.service.AbstractService;
import org.apache.hadoop.yarn.util.ProtoUtils;

public class ContainerLauncherImpl
extends AbstractService
implements ContainerLauncher {
    static final Log LOG = LogFactory.getLog(ContainerLauncherImpl.class);
    private ConcurrentHashMap<ContainerId, Container> containers = new ConcurrentHashMap();
    private AppContext context;
    protected ThreadPoolExecutor launcherPool;
    protected static final int INITIAL_POOL_SIZE = 10;
    private int limitOnPoolSize;
    private Thread eventHandlingThread;
    protected BlockingQueue<ContainerLauncherEvent> eventQueue = new LinkedBlockingQueue();
    YarnRPC rpc;
    Set<String> allNodes = new HashSet();

    private Container getContainer(ContainerId id) {
        Container old;
        Container c = (Container)this.containers.get(id);
        if (c == null && (old = this.containers.putIfAbsent(id, c = new Container(this))) != null) {
            c = old;
        }
        return c;
    }

    private void removeContainerIfDone(ContainerId id) {
        Container c = (Container)this.containers.get(id);
        if (c != null && c.isCompletelyDone()) {
            this.containers.remove(id);
        }
    }

    public ContainerLauncherImpl(AppContext context) {
        super(ContainerLauncherImpl.class.getName());
        this.context = context;
    }

    public synchronized void init(Configuration config) {
        Configuration conf = new Configuration(config);
        conf.setInt("ipc.client.connection.maxidletime", 0);
        this.limitOnPoolSize = conf.getInt("yarn.app.mapreduce.am.containerlauncher.thread-count-limit", 500);
        LOG.info((Object)("Upper limit on the thread pool size is " + this.limitOnPoolSize));
        this.rpc = this.createYarnRPC(conf);
        super.init(conf);
    }

    protected YarnRPC createYarnRPC(Configuration conf) {
        return YarnRPC.create((Configuration)conf);
    }

    public void start() {
        ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat("ContainerLauncher #%d").setDaemon(true).build();
        this.launcherPool = new ThreadPoolExecutor(10, Integer.MAX_VALUE, 1L, TimeUnit.HOURS, new LinkedBlockingQueue<Runnable>(), tf);
        this.eventHandlingThread = new /* Unavailable Anonymous Inner Class!! */;
        this.eventHandlingThread.setName("ContainerLauncher Event Handler");
        this.eventHandlingThread.start();
        super.start();
    }

    public void stop() {
        this.eventHandlingThread.interrupt();
        this.launcherPool.shutdownNow();
        super.stop();
    }

    protected EventProcessor createEventProcessor(ContainerLauncherEvent event) {
        return new EventProcessor(this, event);
    }

    protected ContainerManager getCMProxy(ContainerId containerID, String containerManagerBindAddr, ContainerToken containerToken) throws IOException {
        InetSocketAddress cmAddr = NetUtils.createSocketAddr((String)containerManagerBindAddr);
        UserGroupInformation user = UserGroupInformation.getCurrentUser();
        if (UserGroupInformation.isSecurityEnabled()) {
            Token token = ProtoUtils.convertFromProtoFormat((DelegationToken)containerToken, (InetSocketAddress)cmAddr);
            user = UserGroupInformation.createRemoteUser((String)containerID.toString());
            user.addToken(token);
        }
        ContainerManager proxy = (ContainerManager)user.doAs((PrivilegedAction)new /* Unavailable Anonymous Inner Class!! */);
        return proxy;
    }

    void sendContainerLaunchFailedMsg(TaskAttemptId taskAttemptID, String message) {
        LOG.error((Object)message);
        this.context.getEventHandler().handle((Event)new TaskAttemptDiagnosticsUpdateEvent(taskAttemptID, message));
        this.context.getEventHandler().handle((Event)new TaskAttemptEvent(taskAttemptID, TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED));
    }

    public void handle(ContainerLauncherEvent event) {
        try {
            this.eventQueue.put(event);
            this.allNodes.add(event.getContainerMgrAddress());
        }
        catch (InterruptedException e) {
            throw new YarnException((Throwable)e);
        }
    }

    static /* synthetic */ AppContext access$000(ContainerLauncherImpl x0) {
        return x0.context;
    }

    static /* synthetic */ int access$100(ContainerLauncherImpl x0) {
        return x0.limitOnPoolSize;
    }

    static /* synthetic */ Container access$200(ContainerLauncherImpl x0, ContainerId x1) {
        return x0.getContainer(x1);
    }

    static /* synthetic */ void access$300(ContainerLauncherImpl x0, ContainerId x1) {
        x0.removeContainerIfDone(x1);
    }
}

