/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.job.impl;

import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.impl.JobImpl;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TestJobImpl;
import org.apache.hadoop.mapreduce.v2.app.metrics.MRAppMetrics;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.Records;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestJobImpl {
    @Test
    public void testJobNoTasksTransition() {
        JobImpl.JobNoTasksCompletedTransition trans = new JobImpl.JobNoTasksCompletedTransition();
        JobImpl mockJob = (JobImpl)Mockito.mock(JobImpl.class);
        Task mockTask = (Task)Mockito.mock(Task.class);
        HashMap<TaskId, Task> tasks = new HashMap<TaskId, Task>();
        tasks.put(mockTask.getID(), mockTask);
        mockJob.tasks = tasks;
        Mockito.when((Object)mockJob.getState()).thenReturn((Object)JobState.ERROR);
        JobEvent mockJobEvent = (JobEvent)Mockito.mock(JobEvent.class);
        JobState state = trans.transition(mockJob, mockJobEvent);
        Assert.assertEquals((String)"Incorrect state returned from JobNoTasksCompletedTransition", (Object)JobState.ERROR, (Object)state);
    }

    @Test
    public void testCommitJobFailsJob() {
        JobImpl mockJob = (JobImpl)Mockito.mock(JobImpl.class);
        mockJob.tasks = new HashMap();
        OutputCommitter mockCommitter = (OutputCommitter)Mockito.mock(OutputCommitter.class);
        EventHandler mockEventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        JobContext mockJobContext = (JobContext)Mockito.mock(JobContext.class);
        Mockito.when((Object)mockJob.getCommitter()).thenReturn((Object)mockCommitter);
        Mockito.when((Object)mockJob.getEventHandler()).thenReturn((Object)mockEventHandler);
        Mockito.when((Object)mockJob.getJobContext()).thenReturn((Object)mockJobContext);
        ((JobImpl)Mockito.doNothing().when((Object)mockJob)).setFinishTime();
        ((JobImpl)Mockito.doNothing().when((Object)mockJob)).logJobHistoryFinishedEvent();
        Mockito.when((Object)mockJob.finished(JobState.KILLED)).thenReturn((Object)JobState.KILLED);
        Mockito.when((Object)mockJob.finished(JobState.FAILED)).thenReturn((Object)JobState.FAILED);
        Mockito.when((Object)mockJob.finished(JobState.SUCCEEDED)).thenReturn((Object)JobState.SUCCEEDED);
        try {
            ((OutputCommitter)Mockito.doThrow((Throwable)new IOException()).when((Object)mockCommitter)).commitJob((JobContext)Matchers.any(JobContext.class));
        }
        catch (IOException e) {
            // empty catch block
        }
        ((EventHandler)Mockito.doNothing().when((Object)mockEventHandler)).handle((Event)Matchers.any(JobHistoryEvent.class));
        Assert.assertNotNull((String)"checkJobCompleteSuccess incorrectly returns null for successful job", (Object)JobImpl.checkJobCompleteSuccess((JobImpl)mockJob));
        Assert.assertEquals((String)"checkJobCompleteSuccess returns incorrect state", (Object)JobState.FAILED, (Object)JobImpl.checkJobCompleteSuccess((JobImpl)mockJob));
    }

    @Test
    public void testCheckJobCompleteSuccess() {
        JobImpl mockJob = (JobImpl)Mockito.mock(JobImpl.class);
        mockJob.tasks = new HashMap();
        OutputCommitter mockCommitter = (OutputCommitter)Mockito.mock(OutputCommitter.class);
        EventHandler mockEventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        JobContext mockJobContext = (JobContext)Mockito.mock(JobContext.class);
        Mockito.when((Object)mockJob.getCommitter()).thenReturn((Object)mockCommitter);
        Mockito.when((Object)mockJob.getEventHandler()).thenReturn((Object)mockEventHandler);
        Mockito.when((Object)mockJob.getJobContext()).thenReturn((Object)mockJobContext);
        ((JobImpl)Mockito.doNothing().when((Object)mockJob)).setFinishTime();
        ((JobImpl)Mockito.doNothing().when((Object)mockJob)).logJobHistoryFinishedEvent();
        Mockito.when((Object)mockJob.finished((JobState)Matchers.any(JobState.class))).thenReturn((Object)JobState.SUCCEEDED);
        try {
            ((OutputCommitter)Mockito.doNothing().when((Object)mockCommitter)).commitJob((JobContext)Matchers.any(JobContext.class));
        }
        catch (IOException e) {
            // empty catch block
        }
        ((EventHandler)Mockito.doNothing().when((Object)mockEventHandler)).handle((Event)Matchers.any(JobHistoryEvent.class));
        Assert.assertNotNull((String)"checkJobCompleteSuccess incorrectly returns null for successful job", (Object)JobImpl.checkJobCompleteSuccess((JobImpl)mockJob));
        Assert.assertEquals((String)"checkJobCompleteSuccess returns incorrect state", (Object)JobState.SUCCEEDED, (Object)JobImpl.checkJobCompleteSuccess((JobImpl)mockJob));
    }

    @Test
    public void testCheckJobCompleteSuccessFailed() {
        JobImpl mockJob = (JobImpl)Mockito.mock(JobImpl.class);
        Task mockTask = (Task)Mockito.mock(Task.class);
        HashMap<TaskId, Task> tasks = new HashMap<TaskId, Task>();
        tasks.put(mockTask.getID(), mockTask);
        mockJob.tasks = tasks;
        try {
            OutputCommitter mockCommitter = (OutputCommitter)Mockito.mock(OutputCommitter.class);
            EventHandler mockEventHandler = (EventHandler)Mockito.mock(EventHandler.class);
            ((OutputCommitter)Mockito.doNothing().when((Object)mockCommitter)).commitJob((JobContext)Matchers.any(JobContext.class));
            ((EventHandler)Mockito.doNothing().when((Object)mockEventHandler)).handle((Event)Matchers.any(JobHistoryEvent.class));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Assert.assertNull((String)"checkJobCompleteSuccess incorrectly returns not-null for unsuccessful job", (Object)JobImpl.checkJobCompleteSuccess((JobImpl)mockJob));
    }

    public static void main(String[] args) throws Exception {
        TestJobImpl t = new TestJobImpl();
        t.testJobNoTasksTransition();
        t.testCheckJobCompleteSuccess();
        t.testCheckJobCompleteSuccessFailed();
        t.testCheckAccess();
    }

    @Test
    public void testCheckAccess() {
        String user1 = System.getProperty("user.name");
        String user2 = user1 + "1234";
        UserGroupInformation ugi1 = UserGroupInformation.createRemoteUser((String)user1);
        UserGroupInformation ugi2 = UserGroupInformation.createRemoteUser((String)user2);
        JobID jobID = JobID.forName((String)"job_1234567890000_0001");
        JobId jobId = TypeConverter.toYarn((JobID)jobID);
        Configuration conf1 = new Configuration();
        conf1.setBoolean("mapreduce.cluster.acls.enabled", true);
        conf1.set("mapreduce.job.acl-view-job", "");
        JobImpl job1 = new JobImpl(jobId, null, conf1, null, null, null, null, null, null, null, null, true, null, 0L, null, null);
        Assert.assertTrue((boolean)job1.checkAccess(ugi1, JobACL.VIEW_JOB));
        Assert.assertFalse((boolean)job1.checkAccess(ugi2, JobACL.VIEW_JOB));
        Configuration conf2 = new Configuration();
        conf2.setBoolean("mapreduce.cluster.acls.enabled", true);
        conf2.set("mapreduce.job.acl-view-job", user2);
        JobImpl job2 = new JobImpl(jobId, null, conf2, null, null, null, null, null, null, null, null, true, null, 0L, null, null);
        Assert.assertTrue((boolean)job2.checkAccess(ugi1, JobACL.VIEW_JOB));
        Assert.assertTrue((boolean)job2.checkAccess(ugi2, JobACL.VIEW_JOB));
        Configuration conf3 = new Configuration();
        conf3.setBoolean("mapreduce.cluster.acls.enabled", true);
        conf3.set("mapreduce.job.acl-view-job", "*");
        JobImpl job3 = new JobImpl(jobId, null, conf3, null, null, null, null, null, null, null, null, true, null, 0L, null, null);
        Assert.assertTrue((boolean)job3.checkAccess(ugi1, JobACL.VIEW_JOB));
        Assert.assertTrue((boolean)job3.checkAccess(ugi2, JobACL.VIEW_JOB));
        Configuration conf4 = new Configuration();
        conf4.setBoolean("mapreduce.cluster.acls.enabled", false);
        conf4.set("mapreduce.job.acl-view-job", "");
        JobImpl job4 = new JobImpl(jobId, null, conf4, null, null, null, null, null, null, null, null, true, null, 0L, null, null);
        Assert.assertTrue((boolean)job4.checkAccess(ugi1, JobACL.VIEW_JOB));
        Assert.assertTrue((boolean)job4.checkAccess(ugi2, JobACL.VIEW_JOB));
        Configuration conf5 = new Configuration();
        conf5.setBoolean("mapreduce.cluster.acls.enabled", true);
        conf5.set("mapreduce.job.acl-view-job", "");
        JobImpl job5 = new JobImpl(jobId, null, conf5, null, null, null, null, null, null, null, null, true, null, 0L, null, null);
        Assert.assertTrue((boolean)job5.checkAccess(ugi1, null));
        Assert.assertTrue((boolean)job5.checkAccess(ugi2, null));
    }

    @Test
    public void testUberDecision() throws Exception {
        Configuration conf = new Configuration();
        boolean isUber = this.testUberDecision(conf);
        Assert.assertFalse((boolean)isUber);
        conf = new Configuration();
        conf.setBoolean("mapreduce.job.ubertask.enable", true);
        isUber = this.testUberDecision(conf);
        Assert.assertTrue((boolean)isUber);
        conf = new Configuration();
        conf.setBoolean("mapreduce.job.ubertask.enable", true);
        conf.setInt("mapreduce.job.ubertask.maxreduces", 0);
        conf.setInt("mapreduce.job.reduces", 1);
        isUber = this.testUberDecision(conf);
        Assert.assertFalse((boolean)isUber);
        conf = new Configuration();
        conf.setBoolean("mapreduce.job.ubertask.enable", true);
        conf.setInt("mapreduce.job.ubertask.maxreduces", 1);
        conf.setInt("mapreduce.job.reduces", 1);
        isUber = this.testUberDecision(conf);
        Assert.assertTrue((boolean)isUber);
        conf = new Configuration();
        conf.setBoolean("mapreduce.job.ubertask.enable", true);
        conf.setInt("mapreduce.job.ubertask.maxmaps", 1);
        isUber = this.testUberDecision(conf);
        Assert.assertFalse((boolean)isUber);
    }

    private boolean testUberDecision(Configuration conf) {
        JobID jobID = JobID.forName((String)"job_1234567890000_0001");
        JobId jobId = TypeConverter.toYarn((JobID)jobID);
        MRAppMetrics mrAppMetrics = MRAppMetrics.create();
        JobImpl job = new JobImpl(jobId, (ApplicationAttemptId)Records.newRecord(ApplicationAttemptId.class), conf, (EventHandler)Mockito.mock(EventHandler.class), null, (JobTokenSecretManager)Mockito.mock(JobTokenSecretManager.class), null, null, null, mrAppMetrics, (OutputCommitter)Mockito.mock(OutputCommitter.class), true, null, 0L, null, null);
        JobImpl.InitTransition initTransition = this.getInitTransition();
        JobEvent mockJobEvent = (JobEvent)Mockito.mock(JobEvent.class);
        initTransition.transition(job, mockJobEvent);
        boolean isUber = job.isUber();
        return isUber;
    }

    private JobImpl.InitTransition getInitTransition() {
        1 initTransition = new /* Unavailable Anonymous Inner Class!! */;
        return initTransition;
    }
}

