/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.job.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobACLsManager;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.counters.AbstractCounters;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.jobhistory.JobUnsuccessfulCompletionEvent;
import org.apache.hadoop.mapreduce.lib.chain.ChainMapper;
import org.apache.hadoop.mapreduce.lib.chain.ChainReducer;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEvent;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptListener;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobFinishEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEventType;
import org.apache.hadoop.mapreduce.v2.app.job.impl.JobImpl;
import org.apache.hadoop.mapreduce.v2.app.metrics.MRAppMetrics;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.Clock;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class JobImpl
implements Job,
EventHandler<JobEvent> {
    private static final TaskAttemptCompletionEvent[] EMPTY_TASK_ATTEMPT_COMPLETION_EVENTS = new TaskAttemptCompletionEvent[0];
    private static final Log LOG = LogFactory.getLog(JobImpl.class);
    private static final double MAX_ALLOWED_FETCH_FAILURES_FRACTION = 0.5;
    private static final int MAX_FETCH_FAILURES_NOTIFICATIONS = 3;
    private final ApplicationAttemptId applicationAttemptId;
    private final Clock clock;
    private final JobACLsManager aclsManager;
    private final String username;
    private final OutputCommitter committer;
    private final Map<JobACL, AccessControlList> jobACLs;
    private float setupWeight = 0.05f;
    private float cleanupWeight = 0.05f;
    private float mapWeight = 0.0f;
    private float reduceWeight = 0.0f;
    private final Map<TaskId, JobHistoryParser.TaskInfo> completedTasksFromPreviousRun;
    private final List<AMInfo> amInfos;
    private final Lock readLock;
    private final Lock writeLock;
    private final JobId jobId;
    private final String jobName;
    private final boolean newApiCommitter;
    private final JobID oldJobId;
    private final TaskAttemptListener taskAttemptListener;
    private final Object tasksSyncHandle = new Object();
    private final Set<TaskId> mapTasks = new LinkedHashSet();
    private final Set<TaskId> reduceTasks = new LinkedHashSet();
    private final EventHandler eventHandler;
    private final MRAppMetrics metrics;
    private final String userName;
    private final String queueName;
    private final long appSubmitTime;
    private final AppContext appContext;
    private boolean lazyTasksCopyNeeded = false;
    volatile Map<TaskId, Task> tasks = new LinkedHashMap();
    private Counters jobCounters = new Counters();
    private Object fullCountersLock = new Object();
    private Counters fullCounters = null;
    private Counters finalMapCounters = null;
    private Counters finalReduceCounters = null;
    public JobConf conf;
    private FileSystem fs;
    private Path remoteJobSubmitDir;
    public Path remoteJobConfFile;
    private JobContext jobContext;
    private int allowedMapFailuresPercent = 0;
    private int allowedReduceFailuresPercent = 0;
    private List<TaskAttemptCompletionEvent> taskAttemptCompletionEvents;
    private final List<String> diagnostics = new ArrayList();
    private final Map<TaskId, Integer> successAttemptCompletionEventNoMap = new HashMap();
    private final Map<TaskAttemptId, Integer> fetchFailuresMapping = new HashMap();
    private static final DiagnosticsUpdateTransition DIAGNOSTIC_UPDATE_TRANSITION = new DiagnosticsUpdateTransition(null);
    private static final InternalErrorTransition INTERNAL_ERROR_TRANSITION = new InternalErrorTransition(null);
    private static final TaskAttemptCompletedEventTransition TASK_ATTEMPT_COMPLETED_EVENT_TRANSITION = new TaskAttemptCompletedEventTransition(null);
    private static final CounterUpdateTransition COUNTER_UPDATE_TRANSITION = new CounterUpdateTransition(null);
    protected static final StateMachineFactory<JobImpl, JobState, JobEventType, JobEvent> stateMachineFactory = new StateMachineFactory((Enum)JobState.NEW).addTransition((Enum)JobState.NEW, (Enum)JobState.NEW, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobState.NEW, (Enum)JobState.NEW, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobState.NEW, EnumSet.of(JobState.INITED, JobState.FAILED), (Enum)JobEventType.JOB_INIT, (MultipleArcTransition)new InitTransition()).addTransition((Enum)JobState.NEW, (Enum)JobState.KILLED, (Enum)JobEventType.JOB_KILL, (SingleArcTransition)new KillNewJobTransition(null)).addTransition((Enum)JobState.NEW, (Enum)JobState.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobState.INITED, (Enum)JobState.INITED, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobState.INITED, (Enum)JobState.INITED, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobState.INITED, (Enum)JobState.RUNNING, (Enum)JobEventType.JOB_START, (SingleArcTransition)new StartTransition()).addTransition((Enum)JobState.INITED, (Enum)JobState.KILLED, (Enum)JobEventType.JOB_KILL, (SingleArcTransition)new KillInitedJobTransition(null)).addTransition((Enum)JobState.INITED, (Enum)JobState.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobState.RUNNING, (Enum)JobState.RUNNING, (Enum)JobEventType.JOB_TASK_ATTEMPT_COMPLETED, (SingleArcTransition)TASK_ATTEMPT_COMPLETED_EVENT_TRANSITION).addTransition((Enum)JobState.RUNNING, EnumSet.of(JobState.RUNNING, JobState.SUCCEEDED, JobState.FAILED), (Enum)JobEventType.JOB_TASK_COMPLETED, (MultipleArcTransition)new TaskCompletedTransition(null)).addTransition((Enum)JobState.RUNNING, EnumSet.of(JobState.RUNNING, JobState.SUCCEEDED, JobState.FAILED), (Enum)JobEventType.JOB_COMPLETED, (MultipleArcTransition)new JobNoTasksCompletedTransition()).addTransition((Enum)JobState.RUNNING, (Enum)JobState.KILL_WAIT, (Enum)JobEventType.JOB_KILL, (SingleArcTransition)new KillTasksTransition(null)).addTransition((Enum)JobState.RUNNING, (Enum)JobState.RUNNING, (Enum)JobEventType.JOB_MAP_TASK_RESCHEDULED, (SingleArcTransition)new MapTaskRescheduledTransition(null)).addTransition((Enum)JobState.RUNNING, (Enum)JobState.RUNNING, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobState.RUNNING, (Enum)JobState.RUNNING, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobState.RUNNING, (Enum)JobState.RUNNING, (Enum)JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE, (SingleArcTransition)new TaskAttemptFetchFailureTransition(null)).addTransition((Enum)JobState.RUNNING, (Enum)JobState.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobState.KILL_WAIT, EnumSet.of(JobState.KILL_WAIT, JobState.KILLED), (Enum)JobEventType.JOB_TASK_COMPLETED, (MultipleArcTransition)new KillWaitTaskCompletedTransition(null)).addTransition((Enum)JobState.KILL_WAIT, (Enum)JobState.KILL_WAIT, (Enum)JobEventType.JOB_TASK_ATTEMPT_COMPLETED, (SingleArcTransition)TASK_ATTEMPT_COMPLETED_EVENT_TRANSITION).addTransition((Enum)JobState.KILL_WAIT, (Enum)JobState.KILL_WAIT, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobState.KILL_WAIT, (Enum)JobState.KILL_WAIT, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobState.KILL_WAIT, (Enum)JobState.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobState.KILL_WAIT, (Enum)JobState.KILL_WAIT, EnumSet.of(JobEventType.JOB_KILL, JobEventType.JOB_MAP_TASK_RESCHEDULED, JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE)).addTransition((Enum)JobState.SUCCEEDED, (Enum)JobState.SUCCEEDED, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobState.SUCCEEDED, (Enum)JobState.SUCCEEDED, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobState.SUCCEEDED, (Enum)JobState.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobState.SUCCEEDED, (Enum)JobState.SUCCEEDED, EnumSet.of(JobEventType.JOB_KILL, JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE)).addTransition((Enum)JobState.FAILED, (Enum)JobState.FAILED, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobState.FAILED, (Enum)JobState.FAILED, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobState.FAILED, (Enum)JobState.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobState.FAILED, (Enum)JobState.FAILED, EnumSet.of(JobEventType.JOB_KILL, JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE)).addTransition((Enum)JobState.KILLED, (Enum)JobState.KILLED, (Enum)JobEventType.JOB_DIAGNOSTIC_UPDATE, (SingleArcTransition)DIAGNOSTIC_UPDATE_TRANSITION).addTransition((Enum)JobState.KILLED, (Enum)JobState.KILLED, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).addTransition((Enum)JobState.KILLED, (Enum)JobState.ERROR, (Enum)JobEventType.INTERNAL_ERROR, (SingleArcTransition)INTERNAL_ERROR_TRANSITION).addTransition((Enum)JobState.KILLED, (Enum)JobState.KILLED, EnumSet.of(JobEventType.JOB_KILL, JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE)).addTransition((Enum)JobState.ERROR, (Enum)JobState.ERROR, EnumSet.of(JobEventType.JOB_INIT, new JobEventType[]{JobEventType.JOB_KILL, JobEventType.JOB_TASK_COMPLETED, JobEventType.JOB_TASK_ATTEMPT_COMPLETED, JobEventType.JOB_MAP_TASK_RESCHEDULED, JobEventType.JOB_DIAGNOSTIC_UPDATE, JobEventType.JOB_TASK_ATTEMPT_FETCH_FAILURE, JobEventType.INTERNAL_ERROR})).addTransition((Enum)JobState.ERROR, (Enum)JobState.ERROR, (Enum)JobEventType.JOB_COUNTER_UPDATE, (SingleArcTransition)COUNTER_UPDATE_TRANSITION).installTopology();
    private final StateMachine<JobState, JobEventType, JobEvent> stateMachine;
    private int numMapTasks;
    private int numReduceTasks;
    private int completedTaskCount = 0;
    private int succeededMapTaskCount = 0;
    private int succeededReduceTaskCount = 0;
    private int failedMapTaskCount = 0;
    private int failedReduceTaskCount = 0;
    private int killedMapTaskCount = 0;
    private int killedReduceTaskCount = 0;
    private long startTime;
    private long finishTime;
    private float setupProgress;
    private float mapProgress;
    private float reduceProgress;
    private float cleanupProgress;
    private boolean isUber = false;
    private Credentials fsTokens;
    private Token<JobTokenIdentifier> jobToken;
    private JobTokenSecretManager jobTokenSecretManager;

    public JobImpl(JobId jobId, ApplicationAttemptId applicationAttemptId, Configuration conf, EventHandler eventHandler, TaskAttemptListener taskAttemptListener, JobTokenSecretManager jobTokenSecretManager, Credentials fsTokenCredentials, Clock clock, Map<TaskId, JobHistoryParser.TaskInfo> completedTasksFromPreviousRun, MRAppMetrics metrics, OutputCommitter committer, boolean newApiCommitter, String userName, long appSubmitTime, List<AMInfo> amInfos, AppContext appContext) {
        this.applicationAttemptId = applicationAttemptId;
        this.jobId = jobId;
        this.jobName = conf.get("mapreduce.job.name", "<missing job name>");
        this.conf = new JobConf(conf);
        this.metrics = metrics;
        this.clock = clock;
        this.completedTasksFromPreviousRun = completedTasksFromPreviousRun;
        this.amInfos = amInfos;
        this.appContext = appContext;
        this.userName = userName;
        this.queueName = conf.get("mapreduce.job.queuename", "default");
        this.appSubmitTime = appSubmitTime;
        this.oldJobId = TypeConverter.fromYarn((JobId)jobId);
        this.newApiCommitter = newApiCommitter;
        this.taskAttemptListener = taskAttemptListener;
        this.eventHandler = eventHandler;
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
        this.fsTokens = fsTokenCredentials;
        this.jobTokenSecretManager = jobTokenSecretManager;
        this.committer = committer;
        this.aclsManager = new JobACLsManager(conf);
        this.username = System.getProperty("user.name");
        this.jobACLs = this.aclsManager.constructJobACLs(conf);
        this.stateMachine = stateMachineFactory.make((Object)this);
    }

    protected StateMachine<JobState, JobEventType, JobEvent> getStateMachine() {
        return this.stateMachine;
    }

    public JobId getID() {
        return this.jobId;
    }

    OutputCommitter getCommitter() {
        return this.committer;
    }

    EventHandler getEventHandler() {
        return this.eventHandler;
    }

    JobContext getJobContext() {
        return this.jobContext;
    }

    public boolean checkAccess(UserGroupInformation callerUGI, JobACL jobOperation) {
        AccessControlList jobACL = (AccessControlList)this.jobACLs.get(jobOperation);
        if (jobACL == null) {
            return true;
        }
        return this.aclsManager.checkAccess(callerUGI, jobOperation, this.username, jobACL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task getTask(TaskId taskID) {
        this.readLock.lock();
        try {
            Task task = (Task)this.tasks.get(taskID);
            return task;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCompletedMaps() {
        this.readLock.lock();
        try {
            int n = this.succeededMapTaskCount + this.failedMapTaskCount + this.killedMapTaskCount;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCompletedReduces() {
        this.readLock.lock();
        try {
            int n = this.succeededReduceTaskCount + this.failedReduceTaskCount + this.killedReduceTaskCount;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isUber() {
        return this.isUber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Counters getAllCounters() {
        this.readLock.lock();
        try {
            JobState state = this.getState();
            if (state == JobState.ERROR || state == JobState.FAILED || state == JobState.KILLED || state == JobState.SUCCEEDED) {
                this.mayBeConstructFinalFullCounters();
                Counters counters = this.fullCounters;
                return counters;
            }
            Counters counters = new Counters();
            counters.incrAllCounters((AbstractCounters)this.jobCounters);
            Counters counters2 = JobImpl.incrTaskCounters((Counters)counters, this.tasks.values());
            return counters2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public static Counters incrTaskCounters(Counters counters, Collection<Task> tasks) {
        for (Task task : tasks) {
            counters.incrAllCounters((AbstractCounters)task.getCounters());
        }
        return counters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskAttemptCompletionEvent[] getTaskAttemptCompletionEvents(int fromEventId, int maxEvents) {
        TaskAttemptCompletionEvent[] events = EMPTY_TASK_ATTEMPT_COMPLETION_EVENTS;
        this.readLock.lock();
        try {
            if (this.taskAttemptCompletionEvents.size() > fromEventId) {
                int actualMax = Math.min(maxEvents, this.taskAttemptCompletionEvents.size() - fromEventId);
                events = this.taskAttemptCompletionEvents.subList(fromEventId, actualMax + fromEventId).toArray(events);
            }
            TaskAttemptCompletionEvent[] taskAttemptCompletionEventArray = events;
            return taskAttemptCompletionEventArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDiagnostics() {
        this.readLock.lock();
        try {
            List list = this.diagnostics;
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobReport getReport() {
        this.readLock.lock();
        try {
            String jobFile;
            JobState state = this.getState();
            String string = jobFile = this.remoteJobConfFile == null ? "" : this.remoteJobConfFile.toString();
            if (this.getState() == JobState.NEW) {
                JobReport jobReport = MRBuilderUtils.newJobReport((JobId)this.jobId, (String)this.jobName, (String)this.username, (JobState)state, (long)this.appSubmitTime, (long)this.startTime, (long)this.finishTime, (float)this.setupProgress, (float)0.0f, (float)0.0f, (float)this.cleanupProgress, (String)jobFile, (List)this.amInfos, (boolean)this.isUber);
                return jobReport;
            }
            this.computeProgress();
            JobReport jobReport = MRBuilderUtils.newJobReport((JobId)this.jobId, (String)this.jobName, (String)this.username, (JobState)state, (long)this.appSubmitTime, (long)this.startTime, (long)this.finishTime, (float)this.setupProgress, (float)this.mapProgress, (float)this.reduceProgress, (float)this.cleanupProgress, (String)jobFile, (List)this.amInfos, (boolean)this.isUber);
            return jobReport;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getProgress() {
        this.readLock.lock();
        try {
            this.computeProgress();
            float f = this.setupProgress * this.setupWeight + this.cleanupProgress * this.cleanupWeight + this.mapProgress * this.mapWeight + this.reduceProgress * this.reduceWeight;
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeProgress() {
        this.readLock.lock();
        try {
            float mapProgress = 0.0f;
            float reduceProgress = 0.0f;
            for (Task task : this.tasks.values()) {
                if (task.getType() == TaskType.MAP) {
                    mapProgress += task.getProgress();
                    continue;
                }
                reduceProgress += task.getProgress();
            }
            if (this.numMapTasks != 0) {
                mapProgress /= (float)this.numMapTasks;
            }
            if (this.numReduceTasks != 0) {
                reduceProgress /= (float)this.numReduceTasks;
            }
            this.mapProgress = mapProgress;
            this.reduceProgress = reduceProgress;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<TaskId, Task> getTasks() {
        Object object = this.tasksSyncHandle;
        synchronized (object) {
            this.lazyTasksCopyNeeded = true;
            return Collections.unmodifiableMap(this.tasks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<TaskId, Task> getTasks(TaskType taskType) {
        Map localTasksCopy = this.tasks;
        HashMap<TaskId, Task> result = new HashMap<TaskId, Task>();
        Set tasksOfGivenType = null;
        this.readLock.lock();
        try {
            tasksOfGivenType = TaskType.MAP == taskType ? this.mapTasks : this.reduceTasks;
            for (TaskId taskID : tasksOfGivenType) {
                result.put(taskID, (Task)localTasksCopy.get(taskID));
            }
            HashMap<TaskId, Task> hashMap = result;
            return hashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobState getState() {
        this.readLock.lock();
        try {
            JobState jobState = (JobState)this.getStateMachine().getCurrentState();
            return jobState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected void scheduleTasks(Set<TaskId> taskIDs) {
        for (TaskId taskID : taskIDs) {
            this.eventHandler.handle((Event)new TaskEvent(taskID, TaskEventType.T_SCHEDULE));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(JobEvent event) {
        LOG.debug((Object)("Processing " + event.getJobId() + " of type " + event.getType()));
        try {
            this.writeLock.lock();
            JobState oldState = this.getState();
            try {
                this.getStateMachine().doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)"Can't handle this event at current state", (Throwable)e);
                this.addDiagnostic("Invalid event " + event.getType() + " on Job " + this.jobId);
                this.eventHandler.handle((Event)new JobEvent(this.jobId, JobEventType.INTERNAL_ERROR));
            }
            if (oldState != this.getState()) {
                LOG.info((Object)(this.jobId + "Job Transitioned from " + oldState + " to " + this.getState()));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTask(Task task) {
        Object object = this.tasksSyncHandle;
        synchronized (object) {
            if (this.lazyTasksCopyNeeded) {
                LinkedHashMap newTasks = new LinkedHashMap();
                newTasks.putAll(this.tasks);
                this.tasks = newTasks;
                this.lazyTasksCopyNeeded = false;
            }
        }
        this.tasks.put(task.getID(), task);
        if (task.getType() == TaskType.MAP) {
            this.mapTasks.add(task.getID());
        } else if (task.getType() == TaskType.REDUCE) {
            this.reduceTasks.add(task.getID());
        }
        this.metrics.waitingTask(task);
    }

    void setFinishTime() {
        this.finishTime = this.clock.getTime();
    }

    void logJobHistoryFinishedEvent() {
        this.setFinishTime();
        JobFinishedEvent jfe = JobImpl.createJobFinishedEvent((JobImpl)this);
        LOG.info((Object)"Calling handler for JobFinishedEvent ");
        this.getEventHandler().handle((Event)new JobHistoryEvent(this.jobId, (HistoryEvent)jfe));
    }

    protected FileSystem getFileSystem(Configuration conf) throws IOException {
        return FileSystem.get((Configuration)conf);
    }

    static JobState checkJobCompleteSuccess(JobImpl job) {
        if (job.completedTaskCount == job.tasks.size()) {
            try {
                job.getCommitter().commitJob(job.getJobContext());
            }
            catch (IOException e) {
                LOG.error((Object)"Could not do commit for Job", (Throwable)e);
                job.logJobHistoryFinishedEvent();
                return job.finished(JobState.FAILED);
            }
            job.logJobHistoryFinishedEvent();
            return job.finished(JobState.SUCCEEDED);
        }
        return null;
    }

    JobState finished(JobState finalState) {
        if (this.getState() == JobState.RUNNING) {
            this.metrics.endRunningJob((Job)this);
        }
        if (this.finishTime == 0L) {
            this.setFinishTime();
        }
        this.eventHandler.handle((Event)new JobFinishEvent(this.jobId));
        switch (1.$SwitchMap$org$apache$hadoop$mapreduce$v2$api$records$JobState[finalState.ordinal()]) {
            case 1: {
                this.metrics.killedJob((Job)this);
                break;
            }
            case 2: {
                this.metrics.failedJob((Job)this);
                break;
            }
            case 3: {
                this.metrics.completedJob((Job)this);
            }
        }
        return finalState;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public Path getConfFile() {
        return this.remoteJobConfFile;
    }

    public String getName() {
        return this.jobName;
    }

    public int getTotalMaps() {
        return this.mapTasks.size();
    }

    public int getTotalReduces() {
        return this.reduceTasks.size();
    }

    public Map<JobACL, AccessControlList> getJobACLs() {
        return Collections.unmodifiableMap(this.jobACLs);
    }

    public List<AMInfo> getAMInfos() {
        return this.amInfos;
    }

    private void makeUberDecision(long dataInputLength) {
        int sysMaxMaps = this.conf.getInt("mapreduce.job.ubertask.maxmaps", 9);
        int sysMaxReduces = this.conf.getInt("mapreduce.job.ubertask.maxreduces", 1);
        boolean isValidUberMaxReduces = sysMaxReduces == 0 || sysMaxReduces == 1;
        long sysMaxBytes = this.conf.getLong("mapreduce.job.ubertask.maxbytes", this.fs.getDefaultBlockSize(this.remoteJobSubmitDir));
        long sysMemSizeForUberSlot = this.conf.getInt("yarn.app.mapreduce.am.resource.mb", 1536);
        boolean uberEnabled = this.conf.getBoolean("mapreduce.job.ubertask.enable", false);
        boolean smallNumMapTasks = this.numMapTasks <= sysMaxMaps;
        boolean smallNumReduceTasks = this.numReduceTasks <= sysMaxReduces;
        boolean smallInput = dataInputLength <= sysMaxBytes;
        boolean smallMemory = Math.max(this.conf.getLong("mapreduce.map.memory.mb", 0L), this.conf.getLong("mapreduce.reduce.memory.mb", 0L)) <= sysMemSizeForUberSlot || sysMemSizeForUberSlot == -1L;
        boolean notChainJob = !this.isChainJob((Configuration)this.conf);
        boolean bl = this.isUber = uberEnabled && smallNumMapTasks && smallNumReduceTasks && smallInput && smallMemory && notChainJob && isValidUberMaxReduces;
        if (this.isUber) {
            LOG.info((Object)("Uberizing job " + this.jobId + ": " + this.numMapTasks + "m+" + this.numReduceTasks + "r tasks (" + dataInputLength + " input bytes) will run sequentially on single node."));
            this.conf.setFloat("mapreduce.job.reduce.slowstart.completedmaps", 1.0f);
            this.conf.setInt("mapreduce.map.maxattempts", 1);
            this.conf.setInt("mapreduce.reduce.maxattempts", 1);
            this.conf.setBoolean("mapreduce.map.speculative", false);
            this.conf.setBoolean("mapreduce.reduce.speculative", false);
        } else {
            StringBuilder msg = new StringBuilder();
            msg.append("Not uberizing ").append(this.jobId).append(" because:");
            if (!uberEnabled) {
                msg.append(" not enabled;");
            }
            if (!smallNumMapTasks) {
                msg.append(" too many maps;");
            }
            if (!smallNumReduceTasks) {
                msg.append(" too many reduces;");
            }
            if (!smallInput) {
                msg.append(" too much input;");
            }
            if (!smallMemory) {
                msg.append(" too much RAM;");
            }
            if (!notChainJob) {
                msg.append(" chainjob;");
            }
            if (!isValidUberMaxReduces) {
                msg.append(" not supported uber max reduces");
            }
            LOG.info((Object)msg.toString());
        }
    }

    private boolean isChainJob(Configuration conf) {
        boolean isChainJob = false;
        try {
            Class<?> mapClass;
            String mapClassName = conf.get("mapreduce.job.map.class");
            if (mapClassName != null && ChainMapper.class.isAssignableFrom(mapClass = Class.forName(mapClassName))) {
                isChainJob = true;
            }
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        try {
            Class<?> reduceClass;
            String reduceClassName = conf.get("mapreduce.job.reduce.class");
            if (reduceClassName != null && ChainReducer.class.isAssignableFrom(reduceClass = Class.forName(reduceClassName))) {
                isChainJob = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return isChainJob;
    }

    private void abortJob(JobStatus.State finalState) {
        try {
            this.committer.abortJob(this.jobContext, finalState);
        }
        catch (IOException e) {
            LOG.warn((Object)"Could not abortJob", (Throwable)e);
        }
        if (this.finishTime == 0L) {
            this.setFinishTime();
        }
        this.cleanupProgress = 1.0f;
        JobUnsuccessfulCompletionEvent unsuccessfulJobEvent = new JobUnsuccessfulCompletionEvent(this.oldJobId, this.finishTime, this.succeededMapTaskCount, this.succeededReduceTaskCount, finalState.toString());
        this.eventHandler.handle((Event)new JobHistoryEvent(this.jobId, (HistoryEvent)unsuccessfulJobEvent));
    }

    private static JobFinishedEvent createJobFinishedEvent(JobImpl job) {
        job.mayBeConstructFinalFullCounters();
        JobFinishedEvent jfe = new JobFinishedEvent(job.oldJobId, job.finishTime, job.succeededMapTaskCount, job.succeededReduceTaskCount, job.failedMapTaskCount, job.failedReduceTaskCount, job.finalMapCounters, job.finalReduceCounters, job.fullCounters);
        return jfe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mayBeConstructFinalFullCounters() {
        Object object = this.fullCountersLock;
        synchronized (object) {
            if (this.fullCounters != null) {
                return;
            }
            this.constructFinalFullcounters();
        }
    }

    @InterfaceAudience.Private
    public void constructFinalFullcounters() {
        this.fullCounters = new Counters();
        this.finalMapCounters = new Counters();
        this.finalReduceCounters = new Counters();
        this.fullCounters.incrAllCounters((AbstractCounters)this.jobCounters);
        for (Task t : this.tasks.values()) {
            Counters counters = t.getCounters();
            switch (1.$SwitchMap$org$apache$hadoop$mapreduce$v2$api$records$TaskType[t.getType().ordinal()]) {
                case 1: {
                    this.finalMapCounters.incrAllCounters((AbstractCounters)counters);
                    break;
                }
                case 2: {
                    this.finalReduceCounters.incrAllCounters((AbstractCounters)counters);
                }
            }
            this.fullCounters.incrAllCounters((AbstractCounters)counters);
        }
    }

    private void addDiagnostic(String diag) {
        this.diagnostics.add(diag);
    }

    public Configuration loadConfFile() throws IOException {
        Path confPath = this.getConfFile();
        FileContext fc = FileContext.getFileContext((URI)confPath.toUri(), (Configuration)this.conf);
        Configuration jobConf = new Configuration(false);
        jobConf.addResource((InputStream)fc.open(confPath));
        return jobConf;
    }

    static /* synthetic */ MRAppMetrics access$1100(JobImpl x0) {
        return x0.metrics;
    }

    static /* synthetic */ FileSystem access$1202(JobImpl x0, FileSystem x1) {
        x0.fs = x1;
        return x0.fs;
    }

    static /* synthetic */ JobID access$1300(JobImpl x0) {
        return x0.oldJobId;
    }

    static /* synthetic */ long access$1400(JobImpl x0) {
        return x0.appSubmitTime;
    }

    static /* synthetic */ Map access$1500(JobImpl x0) {
        return x0.jobACLs;
    }

    static /* synthetic */ String access$1600(JobImpl x0) {
        return x0.queueName;
    }

    static /* synthetic */ JobId access$1700(JobImpl x0) {
        return x0.jobId;
    }

    static /* synthetic */ EventHandler access$1800(JobImpl x0) {
        return x0.eventHandler;
    }

    static /* synthetic */ int access$1902(JobImpl x0, int x1) {
        x0.numMapTasks = x1;
        return x0.numMapTasks;
    }

    static /* synthetic */ int access$2002(JobImpl x0, int x1) {
        x0.numReduceTasks = x1;
        return x0.numReduceTasks;
    }

    static /* synthetic */ int access$1900(JobImpl x0) {
        return x0.numMapTasks;
    }

    static /* synthetic */ int access$2000(JobImpl x0) {
        return x0.numReduceTasks;
    }

    static /* synthetic */ void access$2100(JobImpl x0, String x1) {
        x0.addDiagnostic(x1);
    }

    static /* synthetic */ float access$2202(JobImpl x0, float x1) {
        x0.reduceWeight = x1;
        return x0.reduceWeight;
    }

    static /* synthetic */ float access$2302(JobImpl x0, float x1) {
        x0.mapWeight = x1;
        return x0.mapWeight;
    }

    static /* synthetic */ boolean access$2400(JobImpl x0) {
        return x0.newApiCommitter;
    }

    static /* synthetic */ JobContext access$2502(JobImpl x0, JobContext x1) {
        x0.jobContext = x1;
        return x0.jobContext;
    }

    static /* synthetic */ void access$2600(JobImpl x0, long x1) {
        x0.makeUberDecision(x1);
    }

    static /* synthetic */ List access$2702(JobImpl x0, List x1) {
        x0.taskAttemptCompletionEvents = x1;
        return x0.taskAttemptCompletionEvents;
    }

    static /* synthetic */ int access$2802(JobImpl x0, int x1) {
        x0.allowedMapFailuresPercent = x1;
        return x0.allowedMapFailuresPercent;
    }

    static /* synthetic */ int access$2902(JobImpl x0, int x1) {
        x0.allowedReduceFailuresPercent = x1;
        return x0.allowedReduceFailuresPercent;
    }

    static /* synthetic */ JobContext access$2500(JobImpl x0) {
        return x0.jobContext;
    }

    static /* synthetic */ OutputCommitter access$3000(JobImpl x0) {
        return x0.committer;
    }

    static /* synthetic */ float access$3102(JobImpl x0, float x1) {
        x0.setupProgress = x1;
        return x0.setupProgress;
    }

    static /* synthetic */ Log access$3200() {
        return LOG;
    }

    static /* synthetic */ void access$3300(JobImpl x0, JobStatus.State x1) {
        x0.abortJob(x1);
    }

    static /* synthetic */ Path access$3402(JobImpl x0, Path x1) {
        x0.remoteJobSubmitDir = x1;
        return x0.remoteJobSubmitDir;
    }

    static /* synthetic */ Path access$3400(JobImpl x0) {
        return x0.remoteJobSubmitDir;
    }

    static /* synthetic */ Token access$3502(JobImpl x0, Token x1) {
        x0.jobToken = x1;
        return x0.jobToken;
    }

    static /* synthetic */ JobTokenSecretManager access$3600(JobImpl x0) {
        return x0.jobTokenSecretManager;
    }

    static /* synthetic */ Token access$3500(JobImpl x0) {
        return x0.jobToken;
    }

    static /* synthetic */ Credentials access$3700(JobImpl x0) {
        return x0.fsTokens;
    }

    static /* synthetic */ TaskAttemptListener access$3800(JobImpl x0) {
        return x0.taskAttemptListener;
    }

    static /* synthetic */ Clock access$3900(JobImpl x0) {
        return x0.clock;
    }

    static /* synthetic */ Map access$4000(JobImpl x0) {
        return x0.completedTasksFromPreviousRun;
    }

    static /* synthetic */ ApplicationAttemptId access$4100(JobImpl x0) {
        return x0.applicationAttemptId;
    }

    static /* synthetic */ AppContext access$4200(JobImpl x0) {
        return x0.appContext;
    }

    static /* synthetic */ FileSystem access$1200(JobImpl x0) {
        return x0.fs;
    }

    static /* synthetic */ long access$4302(JobImpl x0, long x1) {
        x0.startTime = x1;
        return x0.startTime;
    }

    static /* synthetic */ Set access$4400(JobImpl x0) {
        return x0.mapTasks;
    }

    static /* synthetic */ Set access$4500(JobImpl x0) {
        return x0.reduceTasks;
    }

    static /* synthetic */ long access$4300(JobImpl x0) {
        return x0.startTime;
    }

    static /* synthetic */ long access$4600(JobImpl x0) {
        return x0.finishTime;
    }

    static /* synthetic */ List access$2700(JobImpl x0) {
        return x0.taskAttemptCompletionEvents;
    }

    static /* synthetic */ Map access$4700(JobImpl x0) {
        return x0.successAttemptCompletionEventNoMap;
    }

    static /* synthetic */ Map access$4800(JobImpl x0) {
        return x0.fetchFailuresMapping;
    }

    static /* synthetic */ int access$4908(JobImpl x0) {
        return x0.completedTaskCount++;
    }

    static /* synthetic */ int access$4900(JobImpl x0) {
        return x0.completedTaskCount;
    }

    static /* synthetic */ int access$5000(JobImpl x0) {
        return x0.failedMapTaskCount;
    }

    static /* synthetic */ int access$2800(JobImpl x0) {
        return x0.allowedMapFailuresPercent;
    }

    static /* synthetic */ int access$5100(JobImpl x0) {
        return x0.failedReduceTaskCount;
    }

    static /* synthetic */ int access$2900(JobImpl x0) {
        return x0.allowedReduceFailuresPercent;
    }

    static /* synthetic */ int access$5208(JobImpl x0) {
        return x0.succeededMapTaskCount++;
    }

    static /* synthetic */ int access$5308(JobImpl x0) {
        return x0.succeededReduceTaskCount++;
    }

    static /* synthetic */ int access$5008(JobImpl x0) {
        return x0.failedMapTaskCount++;
    }

    static /* synthetic */ int access$5108(JobImpl x0) {
        return x0.failedReduceTaskCount++;
    }

    static /* synthetic */ int access$5408(JobImpl x0) {
        return x0.killedMapTaskCount++;
    }

    static /* synthetic */ int access$5508(JobImpl x0) {
        return x0.killedReduceTaskCount++;
    }

    static /* synthetic */ int access$4910(JobImpl x0) {
        return x0.completedTaskCount--;
    }

    static /* synthetic */ int access$5210(JobImpl x0) {
        return x0.succeededMapTaskCount--;
    }

    static /* synthetic */ Counters access$5600(JobImpl x0) {
        return x0.jobCounters;
    }
}

