/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.client;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.api.MRClientProtocol;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.FailTaskAttemptRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.FailTaskAttemptResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetCountersRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetCountersResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDiagnosticsRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDiagnosticsResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetJobReportRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetJobReportResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptCompletionEventsRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptCompletionEventsResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptReportRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptReportResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportsRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportsResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillJobRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillJobResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskAttemptRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskAttemptResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskResponse;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEventType;
import org.apache.hadoop.mapreduce.v2.app.security.authorize.MRAMPolicyProvider;
import org.apache.hadoop.mapreduce.v2.app.webapp.AMWebApp;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnRemoteException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.client.ClientToAMSecretManager;
import org.apache.hadoop.yarn.security.client.ClientTokenIdentifier;
import org.apache.hadoop.yarn.service.AbstractService;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebApps;

public class MRClientService
extends AbstractService
implements ClientService {
    static final Log LOG = LogFactory.getLog(MRClientService.class);
    private MRClientProtocol protocolHandler;
    private Server server;
    private WebApp webApp;
    private InetSocketAddress bindAddress;
    private AppContext appContext;

    public MRClientService(AppContext appContext) {
        super("MRClientService");
        this.appContext = appContext;
        this.protocolHandler = new MRClientProtocolHandler();
    }

    public void start() {
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress address = new InetSocketAddress(0);
        ClientToAMSecretManager secretManager = null;
        if (UserGroupInformation.isSecurityEnabled()) {
            secretManager = new ClientToAMSecretManager();
            String secretKeyStr = System.getenv("AppClientTokenEnv");
            byte[] bytes = Base64.decodeBase64((String)secretKeyStr);
            ClientTokenIdentifier identifier = new ClientTokenIdentifier(this.appContext.getApplicationID());
            secretManager.setMasterKey(identifier, bytes);
        }
        this.server = rpc.getServer(MRClientProtocol.class, (Object)this.protocolHandler, address, conf, (SecretManager)secretManager, conf.getInt("yarn.app.mapreduce.am.job.client.thread-count", 1), "yarn.app.mapreduce.am.job.client.port-range");
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.refreshServiceAcls(conf, new MRAMPolicyProvider());
        }
        this.server.start();
        this.bindAddress = NetUtils.getConnectAddress((Server)this.server);
        LOG.info((Object)("Instantiated MRClientService at " + this.bindAddress));
        try {
            this.webApp = WebApps.$for((String)"mapreduce", AppContext.class, (Object)this.appContext, (String)"ws").with(conf).start((WebApp)new AMWebApp());
        }
        catch (Exception e) {
            LOG.error((Object)"Webapps failed to start. Ignoring for now:", (Throwable)e);
        }
        super.start();
    }

    void refreshServiceAcls(Configuration configuration, PolicyProvider policyProvider) {
        this.server.refreshServiceAcl(configuration, policyProvider);
    }

    public void stop() {
        this.server.stop();
        if (this.webApp != null) {
            this.webApp.stop();
        }
        super.stop();
    }

    @Override
    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    @Override
    public int getHttpPort() {
        return this.webApp.port();
    }

    class MRClientProtocolHandler
    implements MRClientProtocol {
        private RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        private final Object getTaskReportsLock = new Object();

        MRClientProtocolHandler() {
        }

        public InetSocketAddress getConnectAddress() {
            return MRClientService.this.getBindAddress();
        }

        private Job verifyAndGetJob(JobId jobID, boolean modifyAccess) throws YarnRemoteException {
            Job job = MRClientService.this.appContext.getJob(jobID);
            if (job == null) {
                throw RPCUtil.getRemoteException((String)("Unknown job " + jobID));
            }
            return job;
        }

        private Task verifyAndGetTask(TaskId taskID, boolean modifyAccess) throws YarnRemoteException {
            Task task = this.verifyAndGetJob(taskID.getJobId(), modifyAccess).getTask(taskID);
            if (task == null) {
                throw RPCUtil.getRemoteException((String)("Unknown Task " + taskID));
            }
            return task;
        }

        private TaskAttempt verifyAndGetAttempt(TaskAttemptId attemptID, boolean modifyAccess) throws YarnRemoteException {
            TaskAttempt attempt = this.verifyAndGetTask(attemptID.getTaskId(), modifyAccess).getAttempt(attemptID);
            if (attempt == null) {
                throw RPCUtil.getRemoteException((String)("Unknown TaskAttempt " + attemptID));
            }
            return attempt;
        }

        public GetCountersResponse getCounters(GetCountersRequest request) throws YarnRemoteException {
            JobId jobId = request.getJobId();
            Job job = this.verifyAndGetJob(jobId, false);
            GetCountersResponse response = (GetCountersResponse)this.recordFactory.newRecordInstance(GetCountersResponse.class);
            response.setCounters(TypeConverter.toYarn((Counters)job.getAllCounters()));
            return response;
        }

        public GetJobReportResponse getJobReport(GetJobReportRequest request) throws YarnRemoteException {
            JobId jobId = request.getJobId();
            Job job = this.verifyAndGetJob(jobId, false);
            GetJobReportResponse response = (GetJobReportResponse)this.recordFactory.newRecordInstance(GetJobReportResponse.class);
            response.setJobReport(job.getReport());
            return response;
        }

        public GetTaskAttemptReportResponse getTaskAttemptReport(GetTaskAttemptReportRequest request) throws YarnRemoteException {
            TaskAttemptId taskAttemptId = request.getTaskAttemptId();
            GetTaskAttemptReportResponse response = (GetTaskAttemptReportResponse)this.recordFactory.newRecordInstance(GetTaskAttemptReportResponse.class);
            response.setTaskAttemptReport(this.verifyAndGetAttempt(taskAttemptId, false).getReport());
            return response;
        }

        public GetTaskReportResponse getTaskReport(GetTaskReportRequest request) throws YarnRemoteException {
            TaskId taskId = request.getTaskId();
            GetTaskReportResponse response = (GetTaskReportResponse)this.recordFactory.newRecordInstance(GetTaskReportResponse.class);
            response.setTaskReport(this.verifyAndGetTask(taskId, false).getReport());
            return response;
        }

        public GetTaskAttemptCompletionEventsResponse getTaskAttemptCompletionEvents(GetTaskAttemptCompletionEventsRequest request) throws YarnRemoteException {
            JobId jobId = request.getJobId();
            int fromEventId = request.getFromEventId();
            int maxEvents = request.getMaxEvents();
            Job job = this.verifyAndGetJob(jobId, false);
            GetTaskAttemptCompletionEventsResponse response = (GetTaskAttemptCompletionEventsResponse)this.recordFactory.newRecordInstance(GetTaskAttemptCompletionEventsResponse.class);
            response.addAllCompletionEvents(Arrays.asList(job.getTaskAttemptCompletionEvents(fromEventId, maxEvents)));
            return response;
        }

        public KillJobResponse killJob(KillJobRequest request) throws YarnRemoteException {
            JobId jobId = request.getJobId();
            String message = "Kill Job received from client " + jobId;
            LOG.info((Object)message);
            this.verifyAndGetJob(jobId, true);
            MRClientService.this.appContext.getEventHandler().handle((Event)new JobDiagnosticsUpdateEvent(jobId, message));
            MRClientService.this.appContext.getEventHandler().handle((Event)new JobEvent(jobId, JobEventType.JOB_KILL));
            KillJobResponse response = (KillJobResponse)this.recordFactory.newRecordInstance(KillJobResponse.class);
            return response;
        }

        public KillTaskResponse killTask(KillTaskRequest request) throws YarnRemoteException {
            TaskId taskId = request.getTaskId();
            String message = "Kill task received from client " + taskId;
            LOG.info((Object)message);
            this.verifyAndGetTask(taskId, true);
            MRClientService.this.appContext.getEventHandler().handle((Event)new TaskEvent(taskId, TaskEventType.T_KILL));
            KillTaskResponse response = (KillTaskResponse)this.recordFactory.newRecordInstance(KillTaskResponse.class);
            return response;
        }

        public KillTaskAttemptResponse killTaskAttempt(KillTaskAttemptRequest request) throws YarnRemoteException {
            TaskAttemptId taskAttemptId = request.getTaskAttemptId();
            String message = "Kill task attempt received from client " + taskAttemptId;
            LOG.info((Object)message);
            this.verifyAndGetAttempt(taskAttemptId, true);
            MRClientService.this.appContext.getEventHandler().handle((Event)new TaskAttemptDiagnosticsUpdateEvent(taskAttemptId, message));
            MRClientService.this.appContext.getEventHandler().handle((Event)new TaskAttemptEvent(taskAttemptId, TaskAttemptEventType.TA_KILL));
            KillTaskAttemptResponse response = (KillTaskAttemptResponse)this.recordFactory.newRecordInstance(KillTaskAttemptResponse.class);
            return response;
        }

        public GetDiagnosticsResponse getDiagnostics(GetDiagnosticsRequest request) throws YarnRemoteException {
            TaskAttemptId taskAttemptId = request.getTaskAttemptId();
            GetDiagnosticsResponse response = (GetDiagnosticsResponse)this.recordFactory.newRecordInstance(GetDiagnosticsResponse.class);
            response.addAllDiagnostics(this.verifyAndGetAttempt(taskAttemptId, false).getDiagnostics());
            return response;
        }

        public FailTaskAttemptResponse failTaskAttempt(FailTaskAttemptRequest request) throws YarnRemoteException {
            TaskAttemptId taskAttemptId = request.getTaskAttemptId();
            String message = "Fail task attempt received from client " + taskAttemptId;
            LOG.info((Object)message);
            this.verifyAndGetAttempt(taskAttemptId, true);
            MRClientService.this.appContext.getEventHandler().handle((Event)new TaskAttemptDiagnosticsUpdateEvent(taskAttemptId, message));
            MRClientService.this.appContext.getEventHandler().handle((Event)new TaskAttemptEvent(taskAttemptId, TaskAttemptEventType.TA_FAILMSG));
            FailTaskAttemptResponse response = (FailTaskAttemptResponse)this.recordFactory.newRecordInstance(FailTaskAttemptResponse.class);
            return response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GetTaskReportsResponse getTaskReports(GetTaskReportsRequest request) throws YarnRemoteException {
            JobId jobId = request.getJobId();
            TaskType taskType = request.getTaskType();
            GetTaskReportsResponse response = (GetTaskReportsResponse)this.recordFactory.newRecordInstance(GetTaskReportsResponse.class);
            Job job = this.verifyAndGetJob(jobId, false);
            Collection<Task> tasks = job.getTasks(taskType).values();
            LOG.info((Object)("Getting task report for " + taskType + "   " + jobId + ". Report-size will be " + tasks.size()));
            Object object = this.getTaskReportsLock;
            synchronized (object) {
                for (Task task : tasks) {
                    response.addTaskReport(task.getReport());
                }
            }
            return response;
        }

        public GetDelegationTokenResponse getDelegationToken(GetDelegationTokenRequest request) throws YarnRemoteException {
            throw RPCUtil.getRemoteException((String)"MR AM not authorized to issue delegation token");
        }
    }
}

