/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.v2.api.MRClientProtocol;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.FailTaskAttemptRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetCountersRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDiagnosticsRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetJobReportRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptCompletionEventsRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptReportRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportsRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillJobRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskAttemptRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskRequest;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.Phase;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.MRApp;
import org.apache.hadoop.mapreduce.v2.app.TestMRClientService;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptStatusUpdateEvent;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnRemoteException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.junit.Assert;
import org.junit.Test;

public class TestMRClientService {
    private static RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    @Test
    public void test() throws Exception {
        MRAppWithClientService app = new MRAppWithClientService(this, 1, 0, false);
        Configuration conf = new Configuration();
        Job job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        junit.framework.Assert.assertEquals((String)"Num tasks not correct", (int)1, (int)job.getTasks().size());
        Iterator it = job.getTasks().values().iterator();
        Task task = (Task)it.next();
        app.waitForState(task, TaskState.RUNNING);
        TaskAttempt attempt = (TaskAttempt)task.getAttempts().values().iterator().next();
        app.waitForState(attempt, TaskAttemptState.RUNNING);
        String diagnostic1 = "Diagnostic1";
        String diagnostic2 = "Diagnostic2";
        app.getContext().getEventHandler().handle((Event)new TaskAttemptDiagnosticsUpdateEvent(attempt.getID(), diagnostic1));
        TaskAttemptStatusUpdateEvent.TaskAttemptStatus taskAttemptStatus = new TaskAttemptStatusUpdateEvent.TaskAttemptStatus();
        taskAttemptStatus.id = attempt.getID();
        taskAttemptStatus.progress = 0.5f;
        taskAttemptStatus.stateString = "RUNNING";
        taskAttemptStatus.taskState = TaskAttemptState.RUNNING;
        taskAttemptStatus.phase = Phase.MAP;
        taskAttemptStatus.outputSize = 3L;
        app.getContext().getEventHandler().handle((Event)new TaskAttemptStatusUpdateEvent(attempt.getID(), taskAttemptStatus));
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        MRClientProtocol proxy = (MRClientProtocol)rpc.getProxy(MRClientProtocol.class, app.clientService.getBindAddress(), conf);
        GetCountersRequest gcRequest = (GetCountersRequest)recordFactory.newRecordInstance(GetCountersRequest.class);
        gcRequest.setJobId(job.getID());
        junit.framework.Assert.assertNotNull((String)"Counters is null", (Object)proxy.getCounters(gcRequest).getCounters());
        GetJobReportRequest gjrRequest = (GetJobReportRequest)recordFactory.newRecordInstance(GetJobReportRequest.class);
        gjrRequest.setJobId(job.getID());
        JobReport jr = proxy.getJobReport(gjrRequest).getJobReport();
        this.verifyJobReport(jr);
        GetTaskAttemptCompletionEventsRequest gtaceRequest = (GetTaskAttemptCompletionEventsRequest)recordFactory.newRecordInstance(GetTaskAttemptCompletionEventsRequest.class);
        gtaceRequest.setJobId(job.getID());
        gtaceRequest.setFromEventId(0);
        gtaceRequest.setMaxEvents(10);
        junit.framework.Assert.assertNotNull((String)"TaskCompletionEvents is null", (Object)proxy.getTaskAttemptCompletionEvents(gtaceRequest).getCompletionEventList());
        GetDiagnosticsRequest gdRequest = (GetDiagnosticsRequest)recordFactory.newRecordInstance(GetDiagnosticsRequest.class);
        gdRequest.setTaskAttemptId(attempt.getID());
        junit.framework.Assert.assertNotNull((String)"Diagnostics is null", (Object)proxy.getDiagnostics(gdRequest).getDiagnosticsList());
        GetTaskAttemptReportRequest gtarRequest = (GetTaskAttemptReportRequest)recordFactory.newRecordInstance(GetTaskAttemptReportRequest.class);
        gtarRequest.setTaskAttemptId(attempt.getID());
        TaskAttemptReport tar = proxy.getTaskAttemptReport(gtarRequest).getTaskAttemptReport();
        this.verifyTaskAttemptReport(tar);
        GetTaskReportRequest gtrRequest = (GetTaskReportRequest)recordFactory.newRecordInstance(GetTaskReportRequest.class);
        gtrRequest.setTaskId(task.getID());
        junit.framework.Assert.assertNotNull((String)"TaskReport is null", (Object)proxy.getTaskReport(gtrRequest).getTaskReport());
        GetTaskReportsRequest gtreportsRequest = (GetTaskReportsRequest)recordFactory.newRecordInstance(GetTaskReportsRequest.class);
        gtreportsRequest.setJobId(job.getID());
        gtreportsRequest.setTaskType(TaskType.MAP);
        junit.framework.Assert.assertNotNull((String)"TaskReports for map is null", (Object)proxy.getTaskReports(gtreportsRequest).getTaskReportList());
        gtreportsRequest = (GetTaskReportsRequest)recordFactory.newRecordInstance(GetTaskReportsRequest.class);
        gtreportsRequest.setJobId(job.getID());
        gtreportsRequest.setTaskType(TaskType.REDUCE);
        junit.framework.Assert.assertNotNull((String)"TaskReports for reduce is null", (Object)proxy.getTaskReports(gtreportsRequest).getTaskReportList());
        List diag = proxy.getDiagnostics(gdRequest).getDiagnosticsList();
        junit.framework.Assert.assertEquals((String)"Num diagnostics not correct", (int)1, (int)diag.size());
        junit.framework.Assert.assertEquals((String)"Diag 1 not correct", (String)diagnostic1, (String)((String)diag.get(0)).toString());
        TaskReport taskReport = proxy.getTaskReport(gtrRequest).getTaskReport();
        junit.framework.Assert.assertEquals((String)"Num diagnostics not correct", (int)1, (int)taskReport.getDiagnosticsCount());
        app.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(((TaskAttempt)task.getAttempts().values().iterator().next()).getID(), TaskAttemptEventType.TA_DONE));
        app.waitForState(job, JobState.SUCCEEDED);
    }

    @Test
    public void testViewAclOnlyCannotModify() throws Exception {
        MRAppWithClientService app = new MRAppWithClientService(this, 1, 0, false);
        Configuration conf = new Configuration();
        conf.setBoolean("mapreduce.cluster.acls.enabled", true);
        conf.set("mapreduce.job.acl-view-job", "viewonlyuser");
        Job job = app.submit(conf);
        app.waitForState(job, JobState.RUNNING);
        junit.framework.Assert.assertEquals((String)"Num tasks not correct", (int)1, (int)job.getTasks().size());
        Iterator it = job.getTasks().values().iterator();
        Task task = (Task)it.next();
        app.waitForState(task, TaskState.RUNNING);
        TaskAttempt attempt = (TaskAttempt)task.getAttempts().values().iterator().next();
        app.waitForState(attempt, TaskAttemptState.RUNNING);
        UserGroupInformation viewOnlyUser = UserGroupInformation.createUserForTesting((String)"viewonlyuser", (String[])new String[0]);
        junit.framework.Assert.assertTrue((String)"viewonlyuser cannot view job", (boolean)job.checkAccess(viewOnlyUser, JobACL.VIEW_JOB));
        junit.framework.Assert.assertFalse((String)"viewonlyuser can modify job", (boolean)job.checkAccess(viewOnlyUser, JobACL.MODIFY_JOB));
        MRClientProtocol client = (MRClientProtocol)viewOnlyUser.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        KillJobRequest killJobRequest = (KillJobRequest)recordFactory.newRecordInstance(KillJobRequest.class);
        killJobRequest.setJobId(app.getJobId());
        try {
            client.killJob(killJobRequest);
            Assert.fail((String)"viewonlyuser killed job");
        }
        catch (YarnRemoteException e) {
            junit.framework.Assert.assertTrue((boolean)e.getMessage().contains("User viewonlyuser cannot"));
        }
        KillTaskRequest killTaskRequest = (KillTaskRequest)recordFactory.newRecordInstance(KillTaskRequest.class);
        killTaskRequest.setTaskId(task.getID());
        try {
            client.killTask(killTaskRequest);
            Assert.fail((String)"viewonlyuser killed task");
        }
        catch (YarnRemoteException e) {
            junit.framework.Assert.assertTrue((boolean)e.getMessage().contains("User viewonlyuser cannot"));
        }
        KillTaskAttemptRequest killTaskAttemptRequest = (KillTaskAttemptRequest)recordFactory.newRecordInstance(KillTaskAttemptRequest.class);
        killTaskAttemptRequest.setTaskAttemptId(attempt.getID());
        try {
            client.killTaskAttempt(killTaskAttemptRequest);
            Assert.fail((String)"viewonlyuser killed task attempt");
        }
        catch (YarnRemoteException e) {
            junit.framework.Assert.assertTrue((boolean)e.getMessage().contains("User viewonlyuser cannot"));
        }
        FailTaskAttemptRequest failTaskAttemptRequest = (FailTaskAttemptRequest)recordFactory.newRecordInstance(FailTaskAttemptRequest.class);
        failTaskAttemptRequest.setTaskAttemptId(attempt.getID());
        try {
            client.failTaskAttempt(failTaskAttemptRequest);
            Assert.fail((String)"viewonlyuser killed task attempt");
        }
        catch (YarnRemoteException e) {
            junit.framework.Assert.assertTrue((boolean)e.getMessage().contains("User viewonlyuser cannot"));
        }
    }

    private void verifyJobReport(JobReport jr) {
        junit.framework.Assert.assertNotNull((String)"JobReport is null", (Object)jr);
        List amInfos = jr.getAMInfos();
        junit.framework.Assert.assertEquals((int)1, (int)amInfos.size());
        junit.framework.Assert.assertEquals((Object)JobState.RUNNING, (Object)jr.getJobState());
        AMInfo amInfo = (AMInfo)amInfos.get(0);
        junit.framework.Assert.assertEquals((String)MRApp.NM_HOST, (String)amInfo.getNodeManagerHost());
        junit.framework.Assert.assertEquals((int)MRApp.NM_PORT, (int)amInfo.getNodeManagerPort());
        junit.framework.Assert.assertEquals((int)MRApp.NM_HTTP_PORT, (int)amInfo.getNodeManagerHttpPort());
        junit.framework.Assert.assertEquals((int)1, (int)amInfo.getAppAttemptId().getAttemptId());
        junit.framework.Assert.assertEquals((int)1, (int)amInfo.getContainerId().getApplicationAttemptId().getAttemptId());
        junit.framework.Assert.assertTrue((amInfo.getStartTime() > 0L ? 1 : 0) != 0);
        junit.framework.Assert.assertEquals((boolean)false, (boolean)jr.isUber());
    }

    private void verifyTaskAttemptReport(TaskAttemptReport tar) {
        junit.framework.Assert.assertEquals((Object)TaskAttemptState.RUNNING, (Object)tar.getTaskAttemptState());
        junit.framework.Assert.assertNotNull((String)"TaskAttemptReport is null", (Object)tar);
        junit.framework.Assert.assertEquals((String)MRApp.NM_HOST, (String)tar.getNodeManagerHost());
        junit.framework.Assert.assertEquals((int)MRApp.NM_PORT, (int)tar.getNodeManagerPort());
        junit.framework.Assert.assertEquals((int)MRApp.NM_HTTP_PORT, (int)tar.getNodeManagerHttpPort());
        junit.framework.Assert.assertEquals((int)1, (int)tar.getContainerId().getApplicationAttemptId().getAttemptId());
    }

    public static void main(String[] args) throws Exception {
        TestMRClientService t = new TestMRClientService();
        t.test();
    }
}

